/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import com.bc.ceres.glevel.support.DefaultMultiLevelSource;
import com.bc.ceres.glevel.support.GenericMultiLevelSource;
import com.bc.ceres.jai.operator.InterpretationType;
import com.bc.ceres.jai.operator.ReinterpretDescriptor;
import com.bc.ceres.jai.operator.ScalingType;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.prefs.BackingStoreException;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.ROI;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.DataNode;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Pointing;
import org.esa.snap.core.datamodel.PointingFactory;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.ProductNodeListenerAdapter;
import org.esa.snap.core.datamodel.ProductVisitor;
import org.esa.snap.core.datamodel.Scaling;
import org.esa.snap.core.datamodel.SceneTransformProvider;
import org.esa.snap.core.datamodel.Stx;
import org.esa.snap.core.datamodel.StxFactory;
import org.esa.snap.core.datamodel.TimeCoding;
import org.esa.snap.core.datamodel.TransectProfileData;
import org.esa.snap.core.datamodel.TransectProfileDataBuilder;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.transform.MathTransform2D;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.ObjectUtils;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.jai.SingleBandedSampleModel;
import org.esa.snap.core.util.math.Histogram;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.core.util.math.Quantizer;
import org.esa.snap.core.util.math.Range;
import org.esa.snap.runtime.Config;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.NoninvertibleTransformException;

public abstract class RasterDataNode
extends DataNode
implements Scaling,
SceneTransformProvider {
    public static final String PROPERTY_NAME_IMAGE_INFO = "imageInfo";
    public static final String PROPERTY_NAME_LOG_10_SCALED = "log10Scaled";
    public static final String PROPERTY_NAME_SCALING_FACTOR = "scalingFactor";
    public static final String PROPERTY_NAME_SCALING_OFFSET = "scalingOffset";
    public static final String PROPERTY_NAME_NO_DATA_VALUE = "noDataValue";
    public static final String PROPERTY_NAME_NO_DATA_VALUE_USED = "noDataValueUsed";
    public static final String PROPERTY_NAME_VALID_PIXEL_EXPRESSION = "validPixelExpression";
    public static final String PROPERTY_NAME_GEO_CODING = "geoCoding";
    public static final String PROPERTY_NAME_TIME_CODING = "timeCoding";
    public static final String PROPERTY_NAME_STX = "stx";
    public static final String PROPERTY_NAME_ANCILLARY_VARIABLES = "ancillaryVariables";
    public static final String PROPERTY_NAME_ANCILLARY_RELATIONS = "ancillaryRelations";
    public static final String PROPERTY_NAME_IMAGE_TO_MODEL_TRANSFORM = "imageToModelTransform";
    public static final String PROPERTY_NAME_MODEL_TO_SCENE_TRANSFORM = "modelToSceneTransform";
    public static final String PROPERTY_NAME_SCENE_TO_MODEL_TRANSFORM = "sceneToModelTransform";
    private static final int READ_BUFFER_MAX_SIZE = 0x800000;
    public static final String NO_DATA_TEXT = "NaN";
    public static final String INVALID_POS_TEXT = "Invalid pos.";
    public static final String IO_ERROR_TEXT = "I/O error";
    private double scalingFactor;
    private double scalingOffset;
    private boolean log10Scaled;
    private boolean scalingApplied;
    private boolean noDataValueUsed;
    private ProductData noData;
    private double geophysicalNoDataValue;
    private String validPixelExpression;
    private GeoCoding geoCoding;
    private TimeCoding timeCoding;
    private AffineTransform imageToModelTransform;
    private MathTransform2D modelToSceneTransform;
    private MathTransform2D sceneToModelTransform;
    private Stx stx;
    private ImageInfo imageInfo;
    private final ProductNodeGroup<Mask> overlayMasks;
    private Pointing pointing;
    private MultiLevelImage sourceImage;
    private MultiLevelImage geophysicalImage;
    private MultiLevelImage validMaskImage;
    private ROI validMaskROI;
    private ProductNodeGroup<RasterDataNode> ancillaryVariables;
    private String[] ancillaryRelations;
    private AncillaryBandRemover ancillaryBandRemover;

    protected RasterDataNode(String name, int dataType, long numElems) {
        super(name, dataType, numElems);
        if (dataType != 10 && dataType != 11 && dataType != 12 && dataType != 20 && dataType != 21 && dataType != 22 && dataType != 30 && dataType != 31) {
            throw new IllegalArgumentException("dataType is invalid");
        }
        this.scalingFactor = 1.0;
        this.scalingOffset = 0.0;
        this.log10Scaled = false;
        this.scalingApplied = false;
        this.noData = null;
        this.noDataValueUsed = false;
        this.geophysicalNoDataValue = 0.0;
        this.validPixelExpression = null;
        this.imageToModelTransform = null;
        this.modelToSceneTransform = MathTransform2D.IDENTITY;
        this.sceneToModelTransform = MathTransform2D.IDENTITY;
        this.overlayMasks = new ProductNodeGroup(this, "overlayMasks", false);
    }

    public abstract int getRasterWidth();

    public abstract int getRasterHeight();

    public Dimension getRasterSize() {
        return new Dimension(this.getRasterWidth(), this.getRasterHeight());
    }

    @Override
    public void setModified(boolean modified) {
        boolean oldState = this.isModified();
        if (oldState != modified) {
            if (!modified && this.overlayMasks != null) {
                this.overlayMasks.setModified(false);
            }
            super.setModified(modified);
        }
    }

    public AffineTransform getImageToModelTransform() {
        if (this.isSourceImageSet()) {
            return this.getSourceImage().getModel().getImageToModelTransform(0);
        }
        if (this.imageToModelTransform != null) {
            return new AffineTransform(this.imageToModelTransform);
        }
        Product product = this.getProduct();
        if (product != null) {
            CoordinateReferenceSystem sceneCRS = product.getSceneCRS();
            GeoCoding sceneGeoCoding = product.getSceneGeoCoding();
            GeoCoding rasterGeoCoding = this.getGeoCoding();
            CoordinateReferenceSystem appropriateSceneCRS = Product.findModelCRS(rasterGeoCoding);
            if (sceneCRS.equals(appropriateSceneCRS)) {
                return Product.findImageToModelTransform(rasterGeoCoding);
            }
            if (sceneGeoCoding == null && rasterGeoCoding == null) {
                return new AffineTransform();
            }
        }
        return new AffineTransform();
    }

    public void setImageToModelTransform(AffineTransform imageToModelTransform) {
        Assert.notNull((Object)imageToModelTransform, (String)PROPERTY_NAME_IMAGE_TO_MODEL_TRANSFORM);
        AffineTransform imageToModelTransformOld = this.getImageToModelTransform();
        if (!imageToModelTransformOld.equals(imageToModelTransform)) {
            if (this.isSourceImageSet()) {
                throw new IllegalStateException("sourceImage already set, imageToModelTransform is now read-only");
            }
            this.imageToModelTransform = new AffineTransform(imageToModelTransform);
            this.fireProductNodeChanged(PROPERTY_NAME_IMAGE_TO_MODEL_TRANSFORM, imageToModelTransformOld, imageToModelTransform);
        }
    }

    @Override
    public MathTransform2D getModelToSceneTransform() {
        if (this.modelToSceneTransform == MathTransform2D.IDENTITY && this.sceneToModelTransform != MathTransform2D.IDENTITY) {
            try {
                return this.sceneToModelTransform.inverse();
            }
            catch (NoninvertibleTransformException e) {
                return MathTransform2D.NULL;
            }
        }
        return this.modelToSceneTransform;
    }

    public void setModelToSceneTransform(MathTransform2D modelToSceneTransform) {
        Assert.notNull((Object)modelToSceneTransform, (String)PROPERTY_NAME_MODEL_TO_SCENE_TRANSFORM);
        MathTransform2D oldTransform = this.modelToSceneTransform;
        this.modelToSceneTransform = modelToSceneTransform;
        this.fireProductNodeChanged(PROPERTY_NAME_MODEL_TO_SCENE_TRANSFORM, oldTransform, this.modelToSceneTransform);
    }

    @Override
    public MathTransform2D getSceneToModelTransform() {
        if (this.sceneToModelTransform == MathTransform2D.IDENTITY && this.modelToSceneTransform != MathTransform2D.IDENTITY) {
            try {
                return this.modelToSceneTransform.inverse();
            }
            catch (NoninvertibleTransformException e) {
                return MathTransform2D.NULL;
            }
        }
        return this.sceneToModelTransform;
    }

    public void setSceneToModelTransform(MathTransform2D sceneToModelTransform) {
        Assert.notNull((Object)sceneToModelTransform, (String)PROPERTY_NAME_SCENE_TO_MODEL_TRANSFORM);
        MathTransform2D oldTransform = this.sceneToModelTransform;
        this.sceneToModelTransform = sceneToModelTransform;
        this.fireProductNodeChanged(PROPERTY_NAME_SCENE_TO_MODEL_TRANSFORM, oldTransform, this.sceneToModelTransform);
    }

    public GeoCoding getGeoCoding() {
        Product product;
        if (this.geoCoding == null && (product = this.getProduct()) != null) {
            return product.getSceneGeoCoding();
        }
        return this.geoCoding;
    }

    public void setGeoCoding(GeoCoding geoCoding) {
        if (!ObjectUtils.equalObjects(geoCoding, this.geoCoding)) {
            Product product;
            this.geoCoding = geoCoding;
            if (this.geoCoding != null && (product = this.getProduct()) != null && product.getSceneGeoCoding() == null && product.getSceneRasterSize().equals(this.getRasterSize())) {
                product.setSceneGeoCoding(this.geoCoding);
            }
            this.fireProductNodeChanged(PROPERTY_NAME_GEO_CODING);
        }
    }

    public TimeCoding getTimeCoding() {
        return this.timeCoding;
    }

    public void setTimeCoding(TimeCoding timeCoding) {
        if (!ObjectUtils.equalObjects(timeCoding, this.timeCoding)) {
            TimeCoding oldValue = this.timeCoding;
            this.timeCoding = timeCoding;
            this.fireProductNodeChanged(PROPERTY_NAME_TIME_CODING, oldValue, timeCoding);
        }
    }

    protected Pointing createPointing() {
        if (this.getGeoCoding() == null || this.getProduct() == null) {
            return null;
        }
        PointingFactory factory = this.getProduct().getPointingFactory();
        if (factory == null) {
            return null;
        }
        return factory.createPointing(this);
    }

    public Pointing getPointing() {
        if (this.pointing == null || this.pointing.getGeoCoding() == this.getGeoCoding()) {
            this.pointing = this.createPointing();
        }
        return this.pointing;
    }

    public boolean canBeOrthorectified() {
        Pointing pointing = this.getPointing();
        return pointing != null && pointing.canGetViewDir();
    }

    @Override
    public boolean isFloatingPointType() {
        return this.scalingApplied || super.isFloatingPointType();
    }

    public int getGeophysicalDataType() {
        return ImageManager.getProductDataType(ReinterpretDescriptor.getTargetDataType((int)ImageManager.getDataBufferType(this.getDataType()), (double)this.getScalingFactor(), (double)this.getScalingOffset(), (ScalingType)this.getScalingType(), (InterpretationType)this.getInterpretationType()));
    }

    public final double getScalingFactor() {
        return this.scalingFactor;
    }

    public final void setScalingFactor(double scalingFactor) {
        if (this.scalingFactor != scalingFactor) {
            this.scalingFactor = scalingFactor;
            this.setScalingApplied();
            this.resetGeophysicalImage();
            this.fireProductNodeChanged(PROPERTY_NAME_SCALING_FACTOR);
            this.setGeophysicalNoDataValue();
            this.resetValidMask();
            this.setModified(true);
        }
    }

    public final double getScalingOffset() {
        return this.scalingOffset;
    }

    public final void setScalingOffset(double scalingOffset) {
        if (this.scalingOffset != scalingOffset) {
            this.scalingOffset = scalingOffset;
            this.setScalingApplied();
            this.resetGeophysicalImage();
            this.fireProductNodeChanged(PROPERTY_NAME_SCALING_OFFSET);
            this.setGeophysicalNoDataValue();
            this.resetValidMask();
            this.setModified(true);
        }
    }

    public final boolean isLog10Scaled() {
        return this.log10Scaled;
    }

    public final void setLog10Scaled(boolean log10Scaled) {
        if (this.log10Scaled != log10Scaled) {
            this.log10Scaled = log10Scaled;
            this.setScalingApplied();
            this.resetGeophysicalImage();
            this.setGeophysicalNoDataValue();
            this.resetValidMask();
            this.fireProductNodeChanged(PROPERTY_NAME_LOG_10_SCALED);
            this.setModified(true);
        }
    }

    public final boolean isScalingApplied() {
        return this.scalingApplied;
    }

    public static boolean isValidMaskProperty(String propertyName) {
        return PROPERTY_NAME_NO_DATA_VALUE.equals(propertyName) || PROPERTY_NAME_NO_DATA_VALUE_USED.equals(propertyName) || PROPERTY_NAME_VALID_PIXEL_EXPRESSION.equals(propertyName) || "data".equals(propertyName);
    }

    public boolean isNoDataValueSet() {
        return this.noData != null;
    }

    public void clearNoDataValue() {
        this.noData = null;
        this.setGeophysicalNoDataValue();
    }

    public boolean isNoDataValueUsed() {
        return this.noDataValueUsed;
    }

    public void setNoDataValueUsed(boolean noDataValueUsed) {
        if (this.noDataValueUsed != noDataValueUsed) {
            this.noDataValueUsed = noDataValueUsed;
            this.resetValidMask();
            this.setModified(true);
            this.fireProductNodeChanged(PROPERTY_NAME_NO_DATA_VALUE_USED);
            this.fireProductNodeDataChanged();
        }
    }

    public double getNoDataValue() {
        return this.isNoDataValueSet() ? this.noData.getElemDouble() : 0.0;
    }

    public void setNoDataValue(double noDataValue) {
        if (this.noData == null || this.getNoDataValue() != noDataValue) {
            if (this.noData == null) {
                this.noData = this.createCompatibleProductData(1);
            }
            this.noData.setElemDouble(noDataValue);
            this.setGeophysicalNoDataValue();
            if (this.isNoDataValueUsed()) {
                this.resetValidMask();
            }
            this.setModified(true);
            this.fireProductNodeChanged(PROPERTY_NAME_NO_DATA_VALUE);
            if (this.isNoDataValueUsed()) {
                this.fireProductNodeDataChanged();
            }
        }
    }

    public double getGeophysicalNoDataValue() {
        return this.geophysicalNoDataValue;
    }

    public void setGeophysicalNoDataValue(double noDataValue) {
        this.setNoDataValue(this.scaleInverse(noDataValue));
    }

    public String getValidPixelExpression() {
        return this.validPixelExpression;
    }

    public void setValidPixelExpression(String validPixelExpression) {
        if (!ObjectUtils.equalObjects(this.validPixelExpression, validPixelExpression)) {
            this.validPixelExpression = validPixelExpression;
            this.resetValidMask();
            this.setModified(true);
            this.fireProductNodeChanged(PROPERTY_NAME_VALID_PIXEL_EXPRESSION);
            this.fireProductNodeDataChanged();
        }
    }

    public boolean isValidMaskUsed() {
        return this.isValidPixelExpressionSet() || this.isNoDataValueUsed();
    }

    public void resetValidMask() {
        this.validMaskROI = null;
        this.validMaskImage = null;
        this.stx = null;
    }

    public String getValidMaskExpression() {
        Object dataMaskExpression = null;
        if (this.isValidPixelExpressionSet()) {
            String dataMaskExpression2;
            dataMaskExpression = this.getValidPixelExpression();
            if (this.isNoDataValueUsed() && !(dataMaskExpression2 = this.createValidMaskExpressionForNoDataValue()).equals(dataMaskExpression)) {
                dataMaskExpression = "(" + (String)dataMaskExpression + ") && " + dataMaskExpression2;
            }
        } else if (this.isNoDataValueUsed()) {
            dataMaskExpression = this.createValidMaskExpressionForNoDataValue();
        }
        return dataMaskExpression;
    }

    private String createValidMaskExpressionForNoDataValue() {
        String ref = BandArithmetic.createExternalName(this.getName());
        double noDataValue = this.getGeophysicalNoDataValue();
        if (Double.isNaN(noDataValue)) {
            return "!nan(" + ref + ")";
        }
        if (Double.isInfinite(noDataValue)) {
            return "!inf(" + ref + ")";
        }
        if (ProductData.isIntType(this.getDataType())) {
            double rawNoDataValue = this.getNoDataValue();
            String rawSymbol = this.getName() + ".raw";
            String extName = BandArithmetic.createExternalName(rawSymbol);
            return extName + " != " + rawNoDataValue;
        }
        return "fneq(" + ref + "," + noDataValue + ")";
    }

    @Override
    public void updateExpression(String oldExternalName, String newExternalName) {
        if (this.validPixelExpression == null) {
            return;
        }
        String expression = StringUtils.replaceWord(this.validPixelExpression, oldExternalName, newExternalName);
        if (!this.validPixelExpression.equals(expression)) {
            this.validPixelExpression = expression;
            this.setModified(true);
        }
        super.updateExpression(oldExternalName, newExternalName);
    }

    public boolean hasRasterData() {
        return this.getRasterData() != null;
    }

    public ProductData getRasterData() {
        return this.getData();
    }

    public void setRasterData(ProductData rasterData) {
        ProductData oldData = this.getData();
        if (oldData != rasterData) {
            if (rasterData != null) {
                if (rasterData.getType() != this.getDataType()) {
                    throw new IllegalArgumentException("rasterData.getType() != getDataType()");
                }
                if (rasterData.getNumElems() != this.getRasterWidth() * this.getRasterHeight()) {
                    throw new IllegalArgumentException("rasterData.getNumElems() != getRasterWidth() * getRasterHeight()");
                }
            }
            this.setData(rasterData);
        }
    }

    public void loadRasterData() throws IOException {
        this.loadRasterData(ProgressMonitor.NULL);
    }

    public void loadRasterData(ProgressMonitor pm) throws IOException {
    }

    public void unloadRasterData() {
    }

    public void removeCachedImageData() {
        if (this.isSourceImageSet()) {
            this.getSourceImage().reset();
        }
        if (this.isGeophysicalImageSet()) {
            this.getGeophysicalImage().reset();
        }
        if (this.isValidMaskImageSet()) {
            this.getValidMaskImage().reset();
        }
    }

    @Override
    public void dispose() {
        if (this.imageInfo != null) {
            this.imageInfo.dispose();
            this.imageInfo = null;
        }
        if (this.sourceImage != null) {
            this.sourceImage.dispose();
            this.sourceImage = null;
        }
        if (this.validMaskROI != null) {
            this.validMaskROI = null;
        }
        if (this.validMaskImage != null) {
            this.validMaskImage.dispose();
            this.validMaskImage = null;
        }
        if (this.geophysicalImage != null && this.geophysicalImage != this.sourceImage) {
            this.geophysicalImage.dispose();
            this.geophysicalImage = null;
        }
        this.overlayMasks.removeAll();
        this.overlayMasks.clearRemovedList();
        if (this.ancillaryVariables != null) {
            this.ancillaryVariables.removeAll();
            this.ancillaryVariables.clearRemovedList();
        }
        super.dispose();
    }

    public boolean isPixelValid(int x, int y) {
        if (!this.isValidMaskUsed()) {
            return true;
        }
        MultiLevelImage image = this.getValidMaskImage();
        if (image != null) {
            int ty;
            int tx = image.XToTileX(x);
            Raster tile = image.getTile(tx, ty = image.YToTileY(y));
            return tile != null && tile.getSample(x, y, 0) != 0;
        }
        return true;
    }

    public int getSampleInt(int x, int y) {
        MultiLevelImage image = this.getGeophysicalImage();
        int tx = image.XToTileX(x);
        int ty = image.YToTileY(y);
        Raster tile = image.getTile(tx, ty);
        return tile.getSample(x, y, 0);
    }

    public float getSampleFloat(int x, int y) {
        MultiLevelImage image = this.getGeophysicalImage();
        int tx = image.XToTileX(x);
        int ty = image.YToTileY(y);
        Raster tile = image.getTile(tx, ty);
        return tile.getSampleFloat(x, y, 0);
    }

    public boolean isPixelValid(int pixelIndex) {
        if (!this.isValidMaskUsed()) {
            return true;
        }
        int y = pixelIndex / this.getRasterWidth();
        int x = pixelIndex - y * this.getRasterWidth();
        return this.isPixelValid(x, y);
    }

    public boolean isPixelValid(int x, int y, ROI roi) {
        return this.isPixelValid(x, y) && (roi == null || roi.contains(x, y));
    }

    public abstract int getPixelInt(int var1, int var2);

    public abstract float getPixelFloat(int var1, int var2);

    public abstract double getPixelDouble(int var1, int var2);

    public abstract void setPixelInt(int var1, int var2, int var3);

    public abstract void setPixelFloat(int var1, int var2, float var3);

    public abstract void setPixelDouble(int var1, int var2, double var3);

    public int[] getPixels(int x, int y, int w, int h, int[] pixels) {
        return this.getPixels(x, y, w, h, pixels, ProgressMonitor.NULL);
    }

    public abstract int[] getPixels(int var1, int var2, int var3, int var4, int[] var5, ProgressMonitor var6);

    public float[] getPixels(int x, int y, int w, int h, float[] pixels) {
        return this.getPixels(x, y, w, h, pixels, ProgressMonitor.NULL);
    }

    public abstract float[] getPixels(int var1, int var2, int var3, int var4, float[] var5, ProgressMonitor var6);

    public abstract double[] getPixels(int var1, int var2, int var3, int var4, double[] var5, ProgressMonitor var6);

    public abstract void setPixels(int var1, int var2, int var3, int var4, int[] var5);

    public abstract void setPixels(int var1, int var2, int var3, int var4, float[] var5);

    public abstract void setPixels(int var1, int var2, int var3, int var4, double[] var5);

    public int[] readPixels(int x, int y, int w, int h, int[] pixels) throws IOException {
        return this.readPixels(x, y, w, h, pixels, ProgressMonitor.NULL);
    }

    public abstract int[] readPixels(int var1, int var2, int var3, int var4, int[] var5, ProgressMonitor var6) throws IOException;

    public float[] readPixels(int x, int y, int w, int h, float[] pixels) throws IOException {
        return this.readPixels(x, y, w, h, pixels, ProgressMonitor.NULL);
    }

    public abstract float[] readPixels(int var1, int var2, int var3, int var4, float[] var5, ProgressMonitor var6) throws IOException;

    public double[] readPixels(int x, int y, int w, int h, double[] pixels) throws IOException {
        return this.readPixels(x, y, w, h, pixels, ProgressMonitor.NULL);
    }

    public abstract double[] readPixels(int var1, int var2, int var3, int var4, double[] var5, ProgressMonitor var6) throws IOException;

    public void writePixels(int x, int y, int w, int h, int[] pixels) throws IOException {
        this.writePixels(x, y, w, h, pixels, ProgressMonitor.NULL);
    }

    public abstract void writePixels(int var1, int var2, int var3, int var4, int[] var5, ProgressMonitor var6) throws IOException;

    public synchronized void writePixels(int x, int y, int w, int h, float[] pixels) throws IOException {
        this.writePixels(x, y, w, h, pixels, ProgressMonitor.NULL);
    }

    public abstract void writePixels(int var1, int var2, int var3, int var4, float[] var5, ProgressMonitor var6) throws IOException;

    public void writePixels(int x, int y, int w, int h, double[] pixels) throws IOException {
        this.writePixels(x, y, w, h, pixels, ProgressMonitor.NULL);
    }

    public abstract void writePixels(int var1, int var2, int var3, int var4, double[] var5, ProgressMonitor var6) throws IOException;

    public boolean[] readValidMask(int x, int y, int w, int h, boolean[] validMask) throws IOException {
        if (validMask == null) {
            validMask = new boolean[w * h];
        }
        if (this.isValidMaskUsed()) {
            int index = 0;
            ROI roi = this.getValidMaskROI();
            for (int yi = y; yi < y + h; ++yi) {
                for (int xi = x; xi < x + w; ++xi) {
                    validMask[index] = roi.contains(xi, yi);
                    ++index;
                }
            }
        } else {
            Arrays.fill(validMask, true);
        }
        return validMask;
    }

    public void readRasterDataFully() throws IOException {
        this.readRasterDataFully(ProgressMonitor.NULL);
    }

    public abstract void readRasterDataFully(ProgressMonitor var1) throws IOException;

    public void readRasterData(int offsetX, int offsetY, int width, int height, ProductData rasterData) throws IOException {
        this.readRasterData(offsetX, offsetY, width, height, rasterData, ProgressMonitor.NULL);
    }

    public abstract void readRasterData(int var1, int var2, int var3, int var4, ProductData var5, ProgressMonitor var6) throws IOException;

    public void writeRasterDataFully() throws IOException {
        this.writeRasterDataFully(ProgressMonitor.NULL);
    }

    public abstract void writeRasterDataFully(ProgressMonitor var1) throws IOException;

    public void writeRasterData(int offsetX, int offsetY, int width, int height, ProductData rasterData) throws IOException {
        this.writeRasterData(offsetX, offsetY, width, height, rasterData, ProgressMonitor.NULL);
    }

    public abstract void writeRasterData(int var1, int var2, int var3, int var4, ProductData var5, ProgressMonitor var6) throws IOException;

    public ProductData createCompatibleRasterData() {
        return this.createCompatibleRasterData(this.getRasterWidth(), this.getRasterHeight());
    }

    public ProductData createCompatibleSceneRasterData() {
        return this.createCompatibleRasterData(this.getRasterWidth(), this.getRasterHeight());
    }

    public ProductData createCompatibleRasterData(int width, int height) {
        return this.createCompatibleProductData(width * height);
    }

    public boolean isCompatibleRasterData(ProductData rasterData, int w, int h) {
        return rasterData != null && rasterData.getType() == this.getDataType() && rasterData.getNumElems() == w * h;
    }

    public void checkCompatibleRasterData(ProductData rasterData, int w, int h) {
        if (!this.isCompatibleRasterData(rasterData, w, h)) {
            throw new IllegalArgumentException("invalid raster data buffer for '" + this.getName() + "'");
        }
    }

    public boolean hasIntPixels() {
        return ProductData.isIntType(this.getDataType());
    }

    public TransectProfileData createTransectProfileData(Shape shape) throws IOException {
        return new TransectProfileDataBuilder().raster(this).path(shape).build();
    }

    @Override
    public abstract void acceptVisitor(ProductVisitor var1);

    public ImageInfo getImageInfo() {
        return this.imageInfo;
    }

    public void setImageInfo(ImageInfo imageInfo) {
        this.setImageInfo(imageInfo, true);
    }

    protected void setImageInfo(ImageInfo imageInfo, boolean change) {
        if (this.imageInfo != imageInfo) {
            this.imageInfo = imageInfo;
            if (change) {
                this.fireImageInfoChanged();
            }
        }
    }

    public void fireImageInfoChanged() {
        this.fireProductNodeChanged(PROPERTY_NAME_IMAGE_INFO);
        this.setModified(true);
    }

    public final ImageInfo getImageInfo(ProgressMonitor pm) {
        return this.getImageInfo(null, pm);
    }

    public final synchronized ImageInfo getImageInfo(double[] histoSkipAreas, ProgressMonitor pm) {
        ImageInfo imageInfo = this.getImageInfo();
        if (imageInfo == null) {
            imageInfo = this.createDefaultImageInfo(histoSkipAreas, pm);
            this.setImageInfo(imageInfo, false);
        }
        return imageInfo;
    }

    public synchronized ImageInfo createDefaultImageInfo(double[] histoSkipAreas, ProgressMonitor pm) {
        Stx stx = this.getStx(false, pm);
        Histogram histogram = new Histogram(stx.getHistogramBins(), stx.getMinimum(), stx.getMaximum());
        return this.createDefaultImageInfo(histoSkipAreas, histogram);
    }

    public final ImageInfo createDefaultImageInfo(double[] histoSkipAreas, Histogram histogram) {
        double max;
        double min;
        ImageInfo customPalette = this.loadCustomColorPalette(histogram);
        if (customPalette != null) {
            return customPalette;
        }
        Range range = histoSkipAreas != null ? histogram.findRange(histoSkipAreas[0], histoSkipAreas[1], true, false) : histogram.findRange(0.01, 0.04, true, false);
        if (range.getMin() != range.getMax()) {
            min = range.getMin();
            max = range.getMax();
        } else {
            min = histogram.getMin();
            max = histogram.getMax();
        }
        double center = this.scale(0.5 * (this.scaleInverse(min) + this.scaleInverse(max)));
        ColorPaletteDef gradationCurve = new ColorPaletteDef(min, center, max);
        return new ImageInfo(gradationCurve);
    }

    private ImageInfo loadCustomColorPalette(Histogram histogram) {
        String[] keys;
        String unit = this.getUnit();
        if (unit == null) {
            return null;
        }
        String prefix = SystemUtils.getApplicationContextId() + ".color-palette.unit.";
        try {
            keys = Config.instance().listKeys(prefix);
        }
        catch (BackingStoreException e) {
            SystemUtils.LOG.severe(String.format("Unable to load configuration '%s': %s", Config.instance().name(), e.getMessage()));
            return null;
        }
        String name = null;
        for (String key : keys) {
            String unitKey = key.replace(prefix, "");
            if (!unit.contains(unitKey)) continue;
            name = Config.instance().preferences().get(key, null);
            break;
        }
        if (name != null) {
            try {
                return RasterDataNode.loadColorPalette(histogram, name);
            }
            catch (IOException e) {
                SystemUtils.LOG.severe(String.format("Unable to load custom color palette '%s': %s", name, e.toString()));
            }
        }
        return null;
    }

    private static ImageInfo loadColorPalette(Histogram histogram, String paletteFileName) throws IOException {
        Path filePath = SystemUtils.getAuxDataPath().resolve("color_palettes").resolve(paletteFileName);
        ColorPaletteDef colorPaletteDef = ColorPaletteDef.loadColorPaletteDef(filePath.toFile());
        ImageInfo info = new ImageInfo(colorPaletteDef);
        Range autoStretchRange = histogram.findRangeFor95Percent();
        info.setColorPaletteDef(colorPaletteDef, autoStretchRange.getMin(), autoStretchRange.getMax(), colorPaletteDef.isAutoDistribute());
        return info;
    }

    public ProductNodeGroup<Mask> getOverlayMaskGroup() {
        return this.overlayMasks;
    }

    public BufferedImage createColorIndexedImage(ProgressMonitor pm) throws IOException {
        return ProductUtils.createColorIndexedImage(this, pm);
    }

    public BufferedImage createRgbImage(ProgressMonitor pm) throws IOException {
        BufferedImage rgbImage;
        if (this.imageInfo != null) {
            return ProductUtils.createRgbImage(new RasterDataNode[]{this}, this.imageInfo, pm);
        }
        pm.beginTask("Creating image", 4);
        try {
            this.imageInfo = this.createDefaultImageInfo(null, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
            rgbImage = ProductUtils.createRgbImage(new RasterDataNode[]{this}, this.imageInfo, SubProgressMonitor.create((ProgressMonitor)pm, (int)3));
        }
        finally {
            pm.done();
        }
        return rgbImage;
    }

    public byte[] quantizeRasterData(double newMin, double newMax, double gamma, ProgressMonitor pm) throws IOException {
        byte[] colorIndexes = new byte[this.getRasterWidth() * this.getRasterHeight()];
        this.quantizeRasterData(newMin, newMax, gamma, colorIndexes, 0, 1, pm);
        return colorIndexes;
    }

    public void quantizeRasterData(double newMin, double newMax, double gamma, byte[] samples, int offset, int stride, ProgressMonitor pm) throws IOException {
        ProductData sceneRasterData = this.getRasterData();
        double rawMin = this.scaleInverse(newMin);
        double rawMax = this.scaleInverse(newMax);
        byte[] gammaCurve = null;
        if (gamma != 0.0 && gamma != 1.0) {
            gammaCurve = MathUtils.createGammaCurve(gamma, new byte[256]);
        }
        if (sceneRasterData != null) {
            RasterDataNode.quantizeRasterData(sceneRasterData, rawMin, rawMax, samples, offset, stride, gammaCurve, pm);
        } else {
            this.quantizeRasterDataFromFile(rawMin, rawMax, samples, offset, stride, gammaCurve, pm);
        }
    }

    private void quantizeRasterDataFromFile(double rawMin, double rawMax, byte[] samples, int offset, int stride, byte[] gammaCurve, ProgressMonitor pm) throws IOException {
        this.processRasterData("Quantizing raster '" + this.getDisplayName() + "'", (buffer, y0, numLines, pm1) -> {
            int pos = y0 * this.getRasterWidth() * stride;
            RasterDataNode.quantizeRasterData(buffer, rawMin, rawMax, samples, pos + offset, stride, gammaCurve, pm1);
        }, pm);
    }

    private static ProductData recycleOrCreateBuffer(int dataType, int buffersize, ProductData readBuffer) {
        if (readBuffer == null || readBuffer.getNumElems() != buffersize) {
            readBuffer = ProductData.createInstance(dataType, buffersize);
        }
        return readBuffer;
    }

    @Override
    public final double scale(double v) {
        v = v * this.scalingFactor + this.scalingOffset;
        if (this.log10Scaled) {
            v = Math.pow(10.0, v);
        }
        return v;
    }

    @Override
    public final double scaleInverse(double v) {
        if (this.log10Scaled) {
            v = Math.log10(v);
        }
        return (v - this.scalingOffset) / this.scalingFactor;
    }

    private void setScalingApplied() {
        this.scalingApplied = this.getScalingFactor() != 1.0 || this.getScalingOffset() != 0.0 || this.isLog10Scaled();
    }

    public String getPixelString(int x, int y) {
        if (!this.isPixelWithinImageBounds(x, y)) {
            return INVALID_POS_TEXT;
        }
        if (this.hasRasterData()) {
            if (this.isPixelValid(x, y)) {
                int geophysicalDataType = this.getGeophysicalDataType();
                if (geophysicalDataType == 31) {
                    double pixel = this.getPixelDouble(x, y);
                    return Double.toString(pixel);
                }
                if (geophysicalDataType == 30) {
                    float pixel = this.getPixelFloat(x, y);
                    return Float.toString(pixel);
                }
                int pixel = this.getPixelInt(x, y);
                return Integer.toString(pixel);
            }
            return NO_DATA_TEXT;
        }
        try {
            boolean pixelValid = this.readValidMask(x, y, 1, 1, new boolean[1])[0];
            if (pixelValid) {
                int geophysicalDataType = this.getGeophysicalDataType();
                if (geophysicalDataType == 31) {
                    double pixel = this.readPixels(x, y, 1, 1, new double[1])[0];
                    return String.format("%.10f", pixel);
                }
                if (geophysicalDataType == 30) {
                    float pixel = this.readPixels(x, y, 1, 1, new float[1])[0];
                    return String.format("%.5f", Float.valueOf(pixel));
                }
                int pixel = this.readPixels(x, y, 1, 1, new int[1])[0];
                return String.valueOf(pixel);
            }
            return NO_DATA_TEXT;
        }
        catch (IOException e) {
            return IO_ERROR_TEXT;
        }
    }

    public boolean isPixelWithinImageBounds(int x, int y) {
        return x >= 0 && y >= 0 && x < this.getRasterWidth() && y < this.getRasterHeight();
    }

    private boolean isValidPixelExpressionSet() {
        return this.getValidPixelExpression() != null && !this.getValidPixelExpression().trim().isEmpty();
    }

    private int getReadBufferLineCount() {
        int sizePerLine = this.getRasterWidth() * ProductData.getElemSize(this.getDataType());
        int bufferLineCount = 0x800000 / sizePerLine;
        if (bufferLineCount == 0) {
            bufferLineCount = 1;
        }
        return bufferLineCount;
    }

    private static void quantizeRasterData(ProductData sceneRasterData, double rawMin, double rawMax, byte[] samples, int offset, int stride, byte[] resampleLUT, ProgressMonitor pm) {
        Quantizer.quantizeGeneric(sceneRasterData.getElems(), sceneRasterData.isUnsigned(), rawMin, rawMax, samples, offset, stride, pm);
        if (resampleLUT != null && resampleLUT.length == 256) {
            for (int i = 0; i < samples.length; ++i) {
                samples[i] = resampleLUT[samples[i] & 0xFF];
            }
        }
    }

    private void setGeophysicalNoDataValue() {
        this.geophysicalNoDataValue = this.scale(this.getNoDataValue());
    }

    public boolean isSourceImageSet() {
        return this.sourceImage != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiLevelImage getSourceImage() {
        if (!this.isSourceImageSet()) {
            RasterDataNode rasterDataNode = this;
            synchronized (rasterDataNode) {
                if (!this.isSourceImageSet()) {
                    this.sourceImage = this.toMultiLevelImage(this.createSourceImage());
                }
            }
        }
        return this.sourceImage;
    }

    protected abstract RenderedImage createSourceImage();

    public synchronized void setSourceImage(RenderedImage sourceImage) {
        if (sourceImage != null) {
            this.setSourceImage(this.toMultiLevelImage(sourceImage));
        } else {
            this.setSourceImage((MultiLevelImage)null);
        }
    }

    public synchronized void setSourceImage(MultiLevelImage sourceImage) {
        MultiLevelImage oldValue = this.sourceImage;
        if (oldValue != sourceImage) {
            this.sourceImage = sourceImage;
            this.resetGeophysicalImage();
            this.fireProductNodeChanged("sourceImage", oldValue, sourceImage);
        }
    }

    public boolean isGeophysicalImageSet() {
        return this.geophysicalImage != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiLevelImage getGeophysicalImage() {
        if (this.geophysicalImage == null) {
            RasterDataNode rasterDataNode = this;
            synchronized (rasterDataNode) {
                if (this.geophysicalImage == null) {
                    this.geophysicalImage = this.isScalingApplied() || this.getDataType() == 10 || this.getDataType() == 22 ? this.createGeophysicalImage() : this.getSourceImage();
                }
            }
        }
        return this.geophysicalImage;
    }

    public MultiLevelModel getMultiLevelModel() {
        if (this.isSourceImageSet()) {
            return this.getSourceImage().getModel();
        }
        return this.createMultiLevelModel();
    }

    public MultiLevelModel createMultiLevelModel() {
        Product product;
        int w = this.getRasterWidth();
        int h = this.getRasterHeight();
        AffineTransform i2mTransform = this.getImageToModelTransform();
        if (i2mTransform == null) {
            i2mTransform = new AffineTransform();
        }
        if ((product = this.getProduct()) != null && product.getNumResolutionsMax() > 0) {
            return new DefaultMultiLevelModel(product.getNumResolutionsMax(), i2mTransform, w, h);
        }
        return new DefaultMultiLevelModel(i2mTransform, w, h);
    }

    private MultiLevelImage createGeophysicalImage() {
        return new DefaultMultiLevelImage((MultiLevelSource)new GenericMultiLevelSource((MultiLevelSource)this.getSourceImage()){

            protected RenderedImage createImage(RenderedImage[] sourceImages, int level) {
                RenderedImage source = sourceImages[0];
                double factor = RasterDataNode.this.getScalingFactor();
                double offset = RasterDataNode.this.getScalingOffset();
                ScalingType scalingType = RasterDataNode.this.getScalingType();
                InterpretationType interpretationType = RasterDataNode.this.getInterpretationType();
                int sourceDataType = source.getSampleModel().getDataType();
                int targetDataType = ReinterpretDescriptor.getTargetDataType((int)sourceDataType, (double)factor, (double)offset, (ScalingType)scalingType, (InterpretationType)interpretationType);
                SingleBandedSampleModel sampleModel = new SingleBandedSampleModel(targetDataType, source.getSampleModel().getWidth(), source.getSampleModel().getHeight());
                ImageLayout imageLayout = ReinterpretDescriptor.createTargetImageLayout((RenderedImage)source, (SampleModel)((Object)sampleModel));
                return ReinterpretDescriptor.create((RenderedImage)source, (double)factor, (double)offset, (ScalingType)scalingType, (InterpretationType)interpretationType, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout));
            }
        });
    }

    private ScalingType getScalingType() {
        return this.isLog10Scaled() ? ReinterpretDescriptor.EXPONENTIAL : ReinterpretDescriptor.LINEAR;
    }

    private InterpretationType getInterpretationType() {
        switch (this.getDataType()) {
            case 10: {
                return ReinterpretDescriptor.INTERPRET_BYTE_SIGNED;
            }
            case 22: {
                return ReinterpretDescriptor.INTERPRET_INT_UNSIGNED;
            }
        }
        return ReinterpretDescriptor.AWT;
    }

    private void resetGeophysicalImage() {
        if (this.geophysicalImage != null) {
            this.geophysicalImage.dispose();
            this.geophysicalImage = null;
        }
    }

    public boolean isValidMaskImageSet() {
        return this.validMaskImage != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiLevelImage getValidMaskImage() {
        if (!this.isValidMaskImageSet() && this.isValidMaskUsed()) {
            RasterDataNode rasterDataNode = this;
            synchronized (rasterDataNode) {
                if (!this.isValidMaskImageSet() && this.isValidMaskUsed()) {
                    this.validMaskImage = this.getProduct().getMaskImage(this.getValidMaskExpression(), this);
                }
            }
        }
        return this.validMaskImage;
    }

    public synchronized boolean isStxSet() {
        return this.stx != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ROI getValidMaskROI() {
        if (this.validMaskROI == null) {
            RasterDataNode rasterDataNode = this;
            synchronized (rasterDataNode) {
                if (this.validMaskROI == null) {
                    this.validMaskROI = new ROI((RenderedImage)this.getValidMaskImage());
                }
            }
        }
        return this.validMaskROI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stx getStx() {
        if (this.stx == null) {
            RasterDataNode rasterDataNode = this;
            synchronized (rasterDataNode) {
                if (this.stx == null) {
                    this.getStx(false, ProgressMonitor.NULL);
                }
            }
        }
        return this.stx;
    }

    public synchronized Stx getStx(boolean accurate, ProgressMonitor pm) {
        if (this.stx == null || this.stx.getResolutionLevel() > 0 && accurate) {
            if (accurate) {
                this.setStx(this.computeStxImpl(0, pm));
            } else {
                int levelCount = this.getSourceImage().getModel().getLevelCount();
                int statisticsLevel = ImageManager.getInstance().getStatisticsLevel(this, levelCount);
                this.setStx(this.computeStxImpl(statisticsLevel, pm));
            }
        }
        return this.stx;
    }

    public synchronized void setStx(Stx stx) {
        Stx oldValue = this.stx;
        if (oldValue != stx) {
            this.stx = stx;
            this.fireProductNodeChanged(PROPERTY_NAME_STX, oldValue, stx);
        }
    }

    protected Stx computeStxImpl(int level, ProgressMonitor pm) {
        return new StxFactory().withResolutionLevel(level).create(this, pm);
    }

    public Shape getValidShape() {
        return this.validMaskImage != null ? this.validMaskImage.getImageShape(0) : null;
    }

    public RasterDataNode getAncillaryVariable(String ... relations) {
        RasterDataNode[] variables = this.getAncillaryVariables(relations);
        return variables.length > 0 ? variables[0] : null;
    }

    public RasterDataNode[] getAncillaryVariables(String ... relations) {
        if (this.ancillaryVariables == null) {
            return new RasterDataNode[0];
        }
        if (relations.length == 0) {
            return (RasterDataNode[])this.ancillaryVariables.toArray(new RasterDataNode[this.ancillaryVariables.getNodeCount()]);
        }
        this.assertRelationsAreAllNoneNull(relations);
        ArrayList<RasterDataNode> rasterDataNodes = new ArrayList<RasterDataNode>();
        for (RasterDataNode ancillaryVariable : (RasterDataNode[])this.ancillaryVariables.toArray(new RasterDataNode[this.ancillaryVariables.getNodeCount()])) {
            String[] ancillaryRelations = ancillaryVariable.getAncillaryRelations();
            if (ancillaryRelations == null) {
                ancillaryRelations = new String[]{};
            }
            for (String relation1 : relations) {
                if (!RasterDataNode.equalAncillaryRelations(relation1, ancillaryRelations) || rasterDataNodes.contains(ancillaryVariable)) continue;
                rasterDataNodes.add(ancillaryVariable);
            }
        }
        return rasterDataNodes.toArray(new RasterDataNode[0]);
    }

    private static boolean equalAncillaryRelations(String relation1, String ... relations2) {
        if (relations2.length == 0) {
            return relation1.equalsIgnoreCase("uncertainty");
        }
        for (String relation2 : relations2) {
            if (!relation1.equalsIgnoreCase(relation2)) continue;
            return true;
        }
        return false;
    }

    public void addAncillaryVariable(RasterDataNode variable, String ... relations) {
        boolean change = false;
        if (this.ancillaryVariables == null) {
            this.ancillaryVariables = new ProductNodeGroup(this, PROPERTY_NAME_ANCILLARY_VARIABLES, false);
        }
        if (!this.ancillaryVariables.contains(variable)) {
            change = this.ancillaryVariables.add(variable);
        }
        if (relations.length > 0) {
            this.assertRelationsAreAllNoneNull(relations);
            for (String relation : relations) {
                if (RasterDataNode.equalAncillaryRelations(relation, variable.getAncillaryRelations())) continue;
                change = true;
            }
            variable.setAncillaryRelations(StringUtils.addArrays(variable.getAncillaryRelations(), relations));
        }
        if (change) {
            this.fireProductNodeChanged(PROPERTY_NAME_ANCILLARY_VARIABLES, this.ancillaryVariables, this.ancillaryVariables);
        }
        Product product = this.getProduct();
        if (this.ancillaryVariables.getNodeCount() > 0 && this.ancillaryBandRemover == null && product != null) {
            this.ancillaryBandRemover = new AncillaryBandRemover();
            product.addProductNodeListener(this.ancillaryBandRemover);
        }
    }

    public void removeAncillaryVariable(RasterDataNode variable) {
        if (this.ancillaryVariables != null && this.ancillaryVariables.remove(variable)) {
            this.fireProductNodeChanged(PROPERTY_NAME_ANCILLARY_VARIABLES, this.ancillaryVariables, this.ancillaryVariables);
        }
    }

    public String[] getAncillaryRelations() {
        return this.ancillaryRelations != null ? (String[])this.ancillaryRelations.clone() : new String[]{};
    }

    public void setAncillaryRelations(String ... relations) {
        this.assertRelationsAreAllNoneNull(relations);
        String[] oldValue = this.getAncillaryRelations();
        this.ancillaryRelations = relations;
        if (!ObjectUtils.equalObjects(oldValue, this.ancillaryRelations)) {
            this.fireProductNodeChanged(PROPERTY_NAME_ANCILLARY_RELATIONS, oldValue, this.getAncillaryRelations());
        }
    }

    private void assertRelationsAreAllNoneNull(String[] relations) {
        for (int i = 0; i < relations.length; ++i) {
            Assert.argument((relations[i] != null ? 1 : 0) != 0, (String)("relations has null element at index " + i));
        }
    }

    private MultiLevelImage toMultiLevelImage(RenderedImage sourceImage) {
        MultiLevelImage mli;
        if (sourceImage instanceof MultiLevelImage) {
            mli = (MultiLevelImage)sourceImage;
        } else {
            MultiLevelModel model = this.createMultiLevelModel();
            mli = new DefaultMultiLevelImage((MultiLevelSource)new DefaultMultiLevelSource(sourceImage, model));
        }
        return mli;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRasterData(String message, RasterDataProcessor processor, ProgressMonitor pm) throws IOException {
        Debug.trace("RasterDataNode.processRasterData: " + message);
        int readBufferLineCount = this.getReadBufferLineCount();
        ProductData readBuffer = null;
        int width = this.getRasterWidth();
        int height = this.getRasterHeight();
        int numReadsMax = height / readBufferLineCount;
        if (numReadsMax * readBufferLineCount < height) {
            ++numReadsMax;
        }
        Debug.trace(String.format("RasterDataNode.processRasterData: numReadsMax=%d, readBufferLineCount=%d", numReadsMax, readBufferLineCount));
        pm.beginTask(message, numReadsMax * 2);
        try {
            for (int i = 0; i < numReadsMax; ++i) {
                int y0 = i * readBufferLineCount;
                int restheight = height - y0;
                int linesToRead = Math.min(restheight, readBufferLineCount);
                readBuffer = RasterDataNode.recycleOrCreateBuffer(this.getDataType(), width * linesToRead, readBuffer);
                this.readRasterData(0, y0, width, linesToRead, readBuffer, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
                processor.processRasterDataBuffer(readBuffer, y0, linesToRead, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
                if (!pm.isCanceled()) continue;
                break;
            }
        }
        finally {
            pm.done();
        }
        Debug.trace("RasterDataNode.processRasterData: done");
    }

    private class AncillaryBandRemover
    extends ProductNodeListenerAdapter {
        private AncillaryBandRemover() {
        }

        @Override
        public void nodeRemoved(ProductNodeEvent event) {
            if (RasterDataNode.this.ancillaryVariables != null && event.getGroup() != RasterDataNode.this.ancillaryVariables && event.getSourceNode() instanceof RasterDataNode) {
                RasterDataNode.this.ancillaryVariables.remove((RasterDataNode)event.getSourceNode());
            }
        }
    }

    public static interface RasterDataProcessor {
        public void processRasterDataBuffer(ProductData var1, int var2, int var3, ProgressMonitor var4) throws IOException;
    }
}

