/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import com.bc.ceres.binding.PropertyContainer;
import org.esa.snap.core.dataio.persistence.Container;
import org.esa.snap.core.dataio.persistence.Property;
import org.esa.snap.core.datamodel.AbstractMaskPersistenceConverter;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;

public class RangeTypeMaskPersistenceConverter
extends AbstractMaskPersistenceConverter {
    public static final String ID_VERSION_1 = "RT_MASK:1";

    @Override
    public String getID() {
        return ID_VERSION_1;
    }

    @Override
    protected Mask.ImageType createImageType() {
        return Mask.RangeType.INSTANCE;
    }

    @Override
    protected void configureMask(Mask mask, Container root, Product product) {
        double minimum = root.getProperty("minimum").getValueDouble();
        double maximum = root.getProperty("maximum").getValueDouble();
        String raster = root.getProperty("rasterName").getValueString();
        PropertyContainer imageConfig = mask.getImageConfig();
        imageConfig.setValue("minimum", (Object)minimum);
        imageConfig.setValue("maximum", (Object)maximum);
        imageConfig.setValue("rasterName", (Object)raster);
    }

    @Override
    protected void configureContainer(Container root, Mask mask) {
        PropertyContainer config = mask.getImageConfig();
        Object minValue = config.getValue("minimum");
        Object maxValue = config.getValue("maximum");
        Object rasterValue = config.getValue("rasterName");
        root.add(new Property<Object>("minimum", minValue));
        root.add(new Property<Object>("maximum", maxValue));
        root.add(new Property<Object>("rasterName", rasterValue));
    }
}

