/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import java.util.Map;
import java.util.TreeMap;
import javax.media.jai.UnpackedImageData;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.StxOp;
import org.esa.snap.core.util.math.DoubleList;

public class QualitativeStxOp
extends StxOp {
    public static final String NO_MAJORITY_CLASS = "";
    private final Map<String, Integer> membersPerClass = new TreeMap<String, Integer>();
    private int totalNumClassMembers = 0;
    private String majorityClass = "";
    private String secondMajorityClass = "";
    private ClassCounter classCounter;

    public QualitativeStxOp() {
        super("Qualitative");
    }

    public int getNumberOfMembers(String className) {
        if (this.membersPerClass.containsKey(className)) {
            return this.membersPerClass.get(className);
        }
        return 0;
    }

    public String getMajorityClass() {
        if (this.majorityClass.equals(NO_MAJORITY_CLASS)) {
            this.determineMajorityClass();
        }
        return this.majorityClass;
    }

    public String getSecondMajorityClass() {
        if (this.majorityClass.equals(NO_MAJORITY_CLASS)) {
            this.determineMajorityClass();
        }
        return this.secondMajorityClass;
    }

    private void determineMajorityClass() {
        int maxNumClassMembers = 0;
        int secondMaxNumClassMembers = 0;
        for (Map.Entry<String, Integer> entry : this.membersPerClass.entrySet()) {
            if (entry.getValue() > maxNumClassMembers) {
                this.secondMajorityClass = this.majorityClass;
                secondMaxNumClassMembers = maxNumClassMembers;
                this.majorityClass = entry.getKey();
                maxNumClassMembers = entry.getValue();
                continue;
            }
            if (entry.getValue() <= secondMaxNumClassMembers) continue;
            this.secondMajorityClass = entry.getKey();
            secondMaxNumClassMembers = entry.getValue();
        }
    }

    public int getTotalNumClassMembers() {
        return this.totalNumClassMembers;
    }

    public String[] getClassNames() {
        return this.membersPerClass.keySet().toArray(new String[0]);
    }

    public void determineClassCounterType(Band band) {
        this.classCounter = band.isIndexBand() ? new IndexCodingClassCounter(band.getIndexCoding()) : (band.isFlagBand() ? new FlagCodingClassCounter(band.getFlagCoding()) : new DefaultClassCounter());
    }

    @Override
    public void accumulateData(UnpackedImageData dataPixels, UnpackedImageData maskPixels) {
        DoubleList values = QualitativeStxOp.asDoubleList(dataPixels);
        int dataPixelStride = dataPixels.pixelStride;
        int dataLineStride = dataPixels.lineStride;
        int dataBandOffset = dataPixels.bandOffsets[0];
        byte[] mask = null;
        int maskPixelStride = 0;
        int maskLineStride = 0;
        int maskBandOffset = 0;
        if (maskPixels != null) {
            mask = maskPixels.getByteData(0);
            maskPixelStride = maskPixels.pixelStride;
            maskLineStride = maskPixels.lineStride;
            maskBandOffset = maskPixels.bandOffsets[0];
        }
        int width = dataPixels.rect.width;
        int height = dataPixels.rect.height;
        int dataLineOffset = dataBandOffset;
        int maskLineOffset = maskBandOffset;
        for (int y = 0; y < height; ++y) {
            int dataPixelOffset = dataLineOffset;
            int maskPixelOffset = maskLineOffset;
            for (int x = 0; x < width; ++x) {
                if (mask == null || mask[maskPixelOffset] != 0) {
                    int value = (int)values.getDouble(dataPixelOffset);
                    this.classCounter.count(value);
                    ++this.totalNumClassMembers;
                }
                dataPixelOffset += dataPixelStride;
                maskPixelOffset += maskPixelStride;
            }
            dataLineOffset += dataLineStride;
            maskLineOffset += maskLineStride;
        }
    }

    private void putIntValue(int value) {
        String key = Integer.toString(value);
        if (!this.membersPerClass.containsKey(key)) {
            this.membersPerClass.put(key, 1);
        } else {
            this.membersPerClass.put(key, this.membersPerClass.get(key) + 1);
        }
    }

    private class DefaultClassCounter
    implements ClassCounter {
        private DefaultClassCounter() {
        }

        @Override
        public void count(int value) {
            QualitativeStxOp.this.putIntValue(value);
        }
    }

    private class FlagCodingClassCounter
    implements ClassCounter {
        private final FlagCoding flagCoding;
        private final String[] flagNames;
        private final int numAttributes;
        private final int[] flagValues;

        FlagCodingClassCounter(FlagCoding flagCoding) {
            this.flagCoding = flagCoding;
            this.flagNames = flagCoding.getFlagNames();
            this.numAttributes = flagCoding.getNumAttributes();
            this.flagValues = new int[this.numAttributes];
            for (int i = 0; i < this.numAttributes; ++i) {
                this.flagValues[i] = flagCoding.getFlagMask(this.flagNames[i]);
            }
        }

        @Override
        public void count(int value) {
            for (int i = 0; i < this.numAttributes; ++i) {
                if ((value & this.flagValues[i]) == 0) continue;
                String flagName = this.flagNames[i];
                if (!QualitativeStxOp.this.membersPerClass.containsKey(flagName)) {
                    QualitativeStxOp.this.membersPerClass.put(flagName, 1);
                    continue;
                }
                QualitativeStxOp.this.membersPerClass.put(flagName, QualitativeStxOp.this.membersPerClass.get(flagName) + 1);
            }
        }
    }

    private class IndexCodingClassCounter
    implements ClassCounter {
        private final String[] indexNames;
        private final int[] indexValues;
        private final int numAttributes;

        IndexCodingClassCounter(IndexCoding indexCoding) {
            this.indexNames = indexCoding.getIndexNames();
            this.numAttributes = indexCoding.getNumAttributes();
            this.indexValues = new int[this.numAttributes];
            for (int i = 0; i < this.numAttributes; ++i) {
                this.indexValues[i] = indexCoding.getIndexValue(this.indexNames[i]);
            }
        }

        @Override
        public void count(int value) {
            for (int i = 0; i < this.numAttributes; ++i) {
                if (value != this.indexValues[i]) continue;
                String indexName = this.indexNames[i];
                if (!QualitativeStxOp.this.membersPerClass.containsKey(indexName)) {
                    QualitativeStxOp.this.membersPerClass.put(indexName, 1);
                } else {
                    QualitativeStxOp.this.membersPerClass.put(indexName, QualitativeStxOp.this.membersPerClass.get(indexName) + 1);
                }
                return;
            }
            QualitativeStxOp.this.putIntValue(value);
        }
    }

    private static interface ClassCounter {
        public void count(int var1);
    }
}

