/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.param.ParamFormatException;
import org.esa.snap.core.param.ParamParseException;
import org.esa.snap.core.param.ParamValidateException;
import org.esa.snap.core.param.ParamValidator;
import org.esa.snap.core.param.Parameter;
import org.esa.snap.core.util.ObjectUtils;

public class ProductNodeNameValidator
implements ParamValidator {
    public static final String PRODUCT_PROPERTY_KEY = "product";
    private static final String ERR_MSG_NO_NODE_NAME = "Value must be an node name.\n\n A valid node name must not start with a dot. Also a valid\nnode name must not contain any of the following characters\n\\/:*?\"<>|";
    private static final String ERR_MSG_DUPLICATE = "The node name must be unique.\nThis includes 'band names' and 'tie point grid names'.";

    @Override
    public boolean equalValues(Parameter parameter, Object value1, Object value2) {
        return ObjectUtils.equalObjects(value1, value2);
    }

    @Override
    public String format(Parameter parameter, Object value) throws ParamFormatException {
        return value != null ? (String)value : "";
    }

    @Override
    public Object parse(Parameter parameter, String text) throws ParamParseException {
        return text != null ? text : "";
    }

    @Override
    public void validate(Parameter parameter, Object value) throws ParamValidateException {
        String name = (String)value;
        if (!ProductNode.isValidNodeName(name)) {
            throw new ParamValidateException(parameter, ERR_MSG_NO_NODE_NAME);
        }
        Product product = (Product)((Object)parameter.getProperties().getPropertyValue(PRODUCT_PROPERTY_KEY));
        if (product != null && product.containsRasterDataNode(name)) {
            throw new ParamValidateException(parameter, ERR_MSG_DUPLICATE);
        }
    }
}

