/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductSubsetBuilder;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.dataio.ProductWriter;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.DataNode;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.MapGeoCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.PlacemarkGroup;
import org.esa.snap.core.datamodel.PointingFactory;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.datamodel.ProductNodeListenerAdapter;
import org.esa.snap.core.datamodel.ProductVisitor;
import org.esa.snap.core.datamodel.ProductVisitorAdapter;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.Scene;
import org.esa.snap.core.datamodel.SceneFactory;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.TimeCoding;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.datamodel.VirtualBandMultiLevelImage;
import org.esa.snap.core.datamodel.quicklooks.Quicklook;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.dataop.barithm.RasterDataSymbol;
import org.esa.snap.core.dataop.barithm.SingleFlagSymbol;
import org.esa.snap.core.dataop.maptransf.MapProjection;
import org.esa.snap.core.dataop.maptransf.MapTransform;
import org.esa.snap.core.image.ResolutionLevel;
import org.esa.snap.core.image.VirtualBandOpImage;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.core.jexp.Parser;
import org.esa.snap.core.jexp.Term;
import org.esa.snap.core.jexp.WritableNamespace;
import org.esa.snap.core.jexp.impl.ParserImpl;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.ObjectUtils;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.WildcardMatcher;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.runtime.Config;
import org.geotools.feature.FeatureCollection;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultImageCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.datum.DefaultImageDatum;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;

public class Product
extends ProductNode {
    public static final String METADATA_ROOT_NAME = "metadata";
    public static final String HISTORY_ROOT_NAME = "history";
    public static final String PROPERTY_NAME_SCENE_CRS = "sceneCRS";
    public static final String PROPERTY_NAME_SCENE_GEO_CODING = "sceneGeoCoding";
    public static final String PROPERTY_NAME_SCENE_TIME_CODING = "sceneTimeCoding";
    public static final String PROPERTY_NAME_PRODUCT_TYPE = "productType";
    public static final String PROPERTY_NAME_FILE_LOCATION = "fileLocation";
    public static final String GEOMETRY_FEATURE_TYPE_NAME = "org.esa.snap.Geometry";
    public static final ImageCRS DEFAULT_IMAGE_CRS = new DefaultImageCRS("SNAP_IMAGE_CRS", (ImageDatum)new DefaultImageDatum("SNAP_IMAGE_DATUM", PixelInCell.CELL_CORNER), (AffineCS)DefaultCartesianCS.DISPLAY);
    private static final String PIN_GROUP_NAME = "pins";
    private static final String GCP_GROUP_NAME = "ground_control_points";
    private final MetadataElement metadataRoot;
    private final ProductNodeGroup<Band> bandGroup;
    private final ProductNodeGroup<TiePointGrid> tiePointGridGroup;
    private final ProductNodeGroup<VectorDataNode> vectorDataGroup;
    private final ProductNodeGroup<FlagCoding> flagCodingGroup;
    private final ProductNodeGroup<IndexCoding> indexCodingGroup;
    private final ProductNodeGroup<Mask> maskGroup;
    private final ProductNodeGroup<Quicklook> quicklookGroup;
    private final PlacemarkGroup pinGroup;
    private final PlacemarkGroup gcpGroup;
    private final ProductNodeGroup<ProductNodeGroup> groups;
    private CoordinateReferenceSystem sceneCrs;
    private File fileLocation;
    private ProductReader reader;
    private ProductWriter writer;
    private TimeCoding sceneTimeCoding;
    private GeoCoding sceneGeoCoding;
    private List<ProductNodeListener> listeners;
    private String productType;
    private Dimension sceneRasterSize;
    private ProductData.UTC startTime;
    private ProductData.UTC endTime;
    private int refNo;
    private String refStr;
    private ProductManager productManager;
    private PointingFactory pointingFactory;
    private String quicklookBandName;
    private Dimension preferredTileSize;
    private AutoGrouping autoGrouping;
    private Map<String, WeakReference<MultiLevelImage>> maskCache;
    private int numResolutionsMax;

    public Product(String name, String type, int sceneRasterWidth, int sceneRasterHeight) {
        this(name, type, sceneRasterWidth, sceneRasterHeight, null);
    }

    public Product(String name, String type, int sceneRasterWidth, int sceneRasterHeight, ProductReader reader) {
        this(name, type, new Dimension(sceneRasterWidth, sceneRasterHeight), reader);
    }

    public Product(String name, String type) {
        this(name, type, null);
    }

    public Product(String name, String type, ProductReader reader) {
        this(name, type, null, reader);
    }

    private Product(String name, String type, Dimension sceneRasterSize, ProductReader reader) {
        super(name);
        Guardian.assertNotNullOrEmpty("type", type);
        this.productType = type;
        this.reader = reader;
        this.sceneRasterSize = sceneRasterSize;
        this.metadataRoot = new MetadataElement(METADATA_ROOT_NAME);
        this.metadataRoot.setOwner(this);
        this.bandGroup = new ProductNodeGroup(this, "bands", true);
        this.tiePointGridGroup = new ProductNodeGroup(this, "tie_point_grids", true);
        this.vectorDataGroup = new VectorDataNodeProductNodeGroup();
        this.indexCodingGroup = new ProductNodeGroup(this, "index_codings", true);
        this.flagCodingGroup = new ProductNodeGroup(this, "flag_codings", true);
        this.maskGroup = new ProductNodeGroup(this, "masks", true);
        this.quicklookGroup = new ProductNodeGroup(this, "quicklooks", true);
        this.pinGroup = this.createPinGroup();
        this.gcpGroup = this.createGcpGroup();
        this.groups = new ProductNodeGroup(this, "groups", false);
        this.groups.add(this.bandGroup);
        this.groups.add(this.quicklookGroup);
        this.groups.add(this.tiePointGridGroup);
        this.groups.add(this.vectorDataGroup);
        this.groups.add(this.indexCodingGroup);
        this.groups.add(this.flagCodingGroup);
        this.groups.add(this.maskGroup);
        this.groups.add(this.pinGroup);
        this.groups.add(this.gcpGroup);
        this.setModified(false);
        this.addProductNodeListener(new ProductNodeListenerAdapter(){

            @Override
            public void nodeAdded(ProductNodeEvent event) {
                if (event.getGroup() == Product.this.vectorDataGroup) {
                    Product.this.handleVectorDataNodeAdded(event);
                } else if (event.getGroup() == Product.this.maskGroup) {
                    Product.this.handleMaskAdded(event);
                }
            }

            @Override
            public void nodeRemoved(ProductNodeEvent event) {
                if (event.getGroup() == Product.this.vectorDataGroup) {
                    Product.this.handleVectorDataNodeRemoved(event);
                } else if (event.getGroup() == Product.this.maskGroup) {
                    Product.this.handleMaskRemoved(event);
                }
            }

            @Override
            public void nodeChanged(ProductNodeEvent event) {
                if ("name".equals(event.getPropertyName())) {
                    Product.this.handleNameChange(event);
                } else if (Product.PROPERTY_NAME_SCENE_GEO_CODING.equals(event.getPropertyName())) {
                    Product.this.handleSceneGeoCodingChange();
                } else if ("featureCollection".equals(event.getPropertyName())) {
                    Product.this.handleFeatureCollectionChange(event);
                }
            }
        });
    }

    public static AffineTransform findImageToModelTransform(GeoCoding geoCoding) {
        MathTransform image2Map;
        if (geoCoding != null && (image2Map = geoCoding.getImageToMapTransform()) instanceof AffineTransform) {
            return new AffineTransform((AffineTransform)image2Map);
        }
        return new AffineTransform();
    }

    public static CoordinateReferenceSystem findModelCRS(GeoCoding geoCoding) {
        if (geoCoding != null) {
            MathTransform image2Map = geoCoding.getImageToMapTransform();
            if (image2Map instanceof AffineTransform) {
                return geoCoding.getMapCRS();
            }
            return geoCoding.getImageCRS();
        }
        return DEFAULT_IMAGE_CRS;
    }

    private static boolean equalsLatLon(GeoPos pos1, GeoPos pos2, float eps) {
        return Product.equalsOrNaN(pos1.lat, pos2.lat, eps) && Product.equalsOrNaN(pos1.lon, pos2.lon, eps);
    }

    private static boolean equalsOrNaN(double v1, double v2, float eps) {
        return MathUtils.equalValues(v1, v2, (double)eps) || Double.isNaN(v1) && Double.isNaN(v2);
    }

    static void fireEvent(ProductNodeEvent event, ProductNodeListener[] productNodeListeners) {
        for (ProductNodeListener listener : productNodeListeners) {
            Product.fireEvent(event, listener);
        }
    }

    static void fireEvent(ProductNodeEvent event, ProductNodeListener listener) {
        if (listener == null) {
            return;
        }
        switch (event.getType()) {
            case 0: {
                listener.nodeChanged(event);
                break;
            }
            case 3: {
                listener.nodeDataChanged(event);
                break;
            }
            case 1: {
                listener.nodeAdded(event);
                break;
            }
            case 2: {
                listener.nodeRemoved(event);
                break;
            }
            case 4: {
                listener.nodeDisposing(event);
            }
        }
    }

    private static boolean isFlagSymbol(String symbolName) {
        return symbolName.indexOf(46) != -1;
    }

    public CoordinateReferenceSystem getSceneCRS() {
        if (this.sceneCrs != null) {
            return this.sceneCrs;
        }
        return Product.findModelCRS(this.getSceneGeoCoding());
    }

    public void setSceneCRS(CoordinateReferenceSystem sceneCRS) {
        Assert.notNull((Object)sceneCRS);
        CoordinateReferenceSystem modelCrsOld = this.sceneCrs;
        if (!ObjectUtils.equalObjects(this.sceneCrs, sceneCRS)) {
            this.sceneCrs = sceneCRS;
            if (modelCrsOld != null) {
                this.fireNodeChanged(this, PROPERTY_NAME_SCENE_CRS, modelCrsOld, this.sceneCrs);
            }
        }
    }

    public boolean isSceneCrsASharedModelCrs() {
        return this.isSceneCrsEqualToModelCrsOf(this.getBandGroup()) && this.isSceneCrsEqualToModelCrsOf(this.getTiePointGridGroup()) && this.isSceneCrsEqualToModelCrsOf(this.getMaskGroup());
    }

    public boolean isSceneCrsEqualToModelCrsOf(RasterDataNode rasterDataNode) {
        GeoCoding imageGeoCoding;
        GeoCoding sceneGeoCoding = this.getSceneGeoCoding();
        if (sceneGeoCoding == (imageGeoCoding = rasterDataNode.getGeoCoding())) {
            return true;
        }
        CoordinateReferenceSystem sceneCRS = this.getSceneCRS();
        CoordinateReferenceSystem modelCRS = Product.findModelCRS(imageGeoCoding);
        return CRS.equalsIgnoreMetadata((Object)sceneCRS, (Object)modelCRS);
    }

    private synchronized boolean isSceneCrsEqualToModelCrsOf(ProductNodeGroup<? extends RasterDataNode> group) {
        int nodeCount = group.getNodeCount();
        for (int i = 0; i < nodeCount; ++i) {
            if (this.isSceneCrsEqualToModelCrsOf(group.get(i))) continue;
            return false;
        }
        return true;
    }

    public File getFileLocation() {
        return this.fileLocation;
    }

    public void setFileLocation(File fileLocation) {
        if (!ObjectUtils.equalObjects(this.fileLocation, fileLocation)) {
            File oldValue = this.fileLocation;
            this.fileLocation = fileLocation;
            this.fireNodeChanged(this, PROPERTY_NAME_FILE_LOCATION, oldValue, fileLocation);
        }
    }

    @Override
    public void setOwner(ProductNode owner) {
        throw new IllegalStateException("a product can not have an owner");
    }

    public String getProductType() {
        return this.productType;
    }

    public void setProductType(String productType) {
        Guardian.assertNotNullOrEmpty(PROPERTY_NAME_PRODUCT_TYPE, productType);
        if (!ObjectUtils.equalObjects(this.productType, productType)) {
            String oldType = this.productType;
            this.productType = productType;
            this.fireProductNodeChanged(PROPERTY_NAME_PRODUCT_TYPE, oldType, productType);
            this.setModified(true);
        }
    }

    @Override
    public ProductReader getProductReader() {
        return this.reader;
    }

    public void setProductReader(ProductReader reader) {
        Guardian.assertNotNull("ProductReader", reader);
        this.reader = reader;
    }

    @Override
    public ProductWriter getProductWriter() {
        return this.writer;
    }

    public void setProductWriter(ProductWriter writer) {
        this.writer = writer;
    }

    public void writeHeader(Object output) throws IOException {
        Guardian.assertNotNull("output", output);
        Guardian.assertNotNull("writer", this.writer);
        this.writer.writeProductNodes(this, output);
    }

    public void closeProductReader() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    public void closeProductWriter() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
            this.writer = null;
        }
    }

    public void closeIO() throws IOException {
        IOException eI = null;
        try {
            this.closeProductReader();
        }
        catch (IOException e) {
            eI = e;
        }
        IOException eO = null;
        try {
            this.closeProductWriter();
        }
        catch (IOException e) {
            eO = e;
        }
        if (eI != null) {
            throw eI;
        }
        if (eO != null) {
            throw eO;
        }
    }

    @Override
    public void dispose() {
        this.fireEvent(this, 4, null);
        try {
            this.closeIO();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.reader = null;
        this.writer = null;
        this.metadataRoot.dispose();
        this.bandGroup.dispose();
        this.tiePointGridGroup.dispose();
        this.flagCodingGroup.dispose();
        this.indexCodingGroup.dispose();
        this.maskGroup.dispose();
        this.quicklookGroup.dispose();
        this.vectorDataGroup.dispose();
        this.pointingFactory = null;
        this.productManager = null;
        if (this.sceneGeoCoding != null) {
            this.sceneGeoCoding.dispose();
            this.sceneGeoCoding = null;
        }
        if (this.maskCache != null) {
            Collection<WeakReference<MultiLevelImage>> values = this.maskCache.values();
            for (WeakReference<MultiLevelImage> value : values) {
                MultiLevelImage maskImage = (MultiLevelImage)value.get();
                if (maskImage == null) continue;
                maskImage.reset();
            }
            this.maskCache.clear();
            this.maskCache = null;
        }
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
        this.fileLocation = null;
    }

    public TimeCoding getSceneTimeCoding() {
        return this.sceneTimeCoding;
    }

    public void setSceneTimeCoding(TimeCoding sceneTimeCoding) {
        if (!ObjectUtils.equalObjects(sceneTimeCoding, this.sceneTimeCoding)) {
            TimeCoding oldValue = this.sceneTimeCoding;
            this.sceneTimeCoding = sceneTimeCoding;
            this.fireNodeChanged(this, PROPERTY_NAME_SCENE_TIME_CODING, oldValue, sceneTimeCoding);
        }
    }

    public PointingFactory getPointingFactory() {
        return this.pointingFactory;
    }

    public void setPointingFactory(PointingFactory pointingFactory) {
        this.pointingFactory = pointingFactory;
    }

    public GeoCoding getSceneGeoCoding() {
        return this.sceneGeoCoding;
    }

    public void setSceneGeoCoding(GeoCoding sceneGeoCoding) {
        if (!ObjectUtils.equalObjects(this.sceneGeoCoding, sceneGeoCoding)) {
            this.sceneGeoCoding = sceneGeoCoding;
            this.fireProductNodeChanged(PROPERTY_NAME_SCENE_GEO_CODING);
            this.setModified(true);
        }
    }

    public boolean isUsingSingleGeoCoding() {
        GeoCoding geoCoding = this.getSceneGeoCoding();
        if (geoCoding == null) {
            return false;
        }
        List<RasterDataNode> rasterDataNodes = this.getRasterDataNodes();
        for (RasterDataNode rasterDataNode : rasterDataNodes) {
            if (geoCoding == rasterDataNode.getGeoCoding()) continue;
            return false;
        }
        return true;
    }

    public boolean transferGeoCodingTo(Product destProduct, ProductSubsetDef subsetDef) {
        Scene srcScene = SceneFactory.createScene(this);
        if (srcScene == null) {
            return false;
        }
        Scene destScene = SceneFactory.createScene(destProduct);
        return destScene != null && srcScene.transferGeoCodingTo(destScene, subsetDef);
    }

    public final int getSceneRasterWidth() {
        return this.getSceneRasterSize().width;
    }

    public final int getSceneRasterHeight() {
        return this.getSceneRasterSize().height;
    }

    public boolean isMultiSize() {
        List<RasterDataNode> rasterDataNodes = this.getRasterDataNodes();
        return !ProductUtils.areRastersEqualInSize(rasterDataNodes.toArray(new RasterDataNode[rasterDataNodes.size()]));
    }

    public final Dimension getSceneRasterSize() {
        if (this.sceneRasterSize != null) {
            return this.sceneRasterSize;
        }
        if (!this.initSceneProperties()) {
            throw new IllegalStateException("scene raster size not set and no reference band found to derive it from");
        }
        return this.sceneRasterSize;
    }

    public ProductData.UTC getStartTime() {
        return this.startTime;
    }

    public void setStartTime(ProductData.UTC startTime) {
        ProductData.UTC old = this.startTime;
        if (!ObjectUtils.equalObjects(old, startTime)) {
            this.startTime = startTime;
            this.setModified(true);
            this.fireProductNodeChanged("startTime", old, this.startTime);
        }
    }

    public ProductData.UTC getEndTime() {
        return this.endTime;
    }

    public void setEndTime(ProductData.UTC endTime) {
        ProductData.UTC old = this.endTime;
        if (!ObjectUtils.equalObjects(old, endTime)) {
            this.endTime = endTime;
            this.setModified(true);
            this.fireProductNodeChanged("endTime", old, this.endTime);
        }
    }

    public MetadataElement getMetadataRoot() {
        return this.metadataRoot;
    }

    public ProductNodeGroup<ProductNodeGroup> getGroups() {
        return this.groups;
    }

    public ProductNodeGroup getGroup(String name) {
        return this.groups.get(name);
    }

    public ProductNodeGroup<TiePointGrid> getTiePointGridGroup() {
        return this.tiePointGridGroup;
    }

    public void addTiePointGrid(TiePointGrid tiePointGrid) {
        if (this.containsRasterDataNode(tiePointGrid.getName())) {
            throw new IllegalArgumentException("The Product '" + this.getName() + "' already contains a tie-point grid with the name '" + tiePointGrid.getName() + "'.");
        }
        this.tiePointGridGroup.add(tiePointGrid);
    }

    public boolean removeTiePointGrid(TiePointGrid tiePointGrid) {
        return this.tiePointGridGroup.remove(tiePointGrid);
    }

    public int getNumTiePointGrids() {
        return this.tiePointGridGroup.getNodeCount();
    }

    public TiePointGrid getTiePointGridAt(int index) {
        return this.tiePointGridGroup.get(index);
    }

    public String[] getTiePointGridNames() {
        return this.tiePointGridGroup.getNodeNames();
    }

    public TiePointGrid[] getTiePointGrids() {
        TiePointGrid[] tiePointGrids = new TiePointGrid[this.getNumTiePointGrids()];
        for (int i = 0; i < tiePointGrids.length; ++i) {
            tiePointGrids[i] = this.getTiePointGridAt(i);
        }
        return tiePointGrids;
    }

    public TiePointGrid getTiePointGrid(String name) {
        Guardian.assertNotNullOrEmpty("name", name);
        return this.tiePointGridGroup.get(name);
    }

    public boolean containsTiePointGrid(String name) {
        Guardian.assertNotNullOrEmpty("name", name);
        return this.tiePointGridGroup.contains(name);
    }

    public ProductNodeGroup<Band> getBandGroup() {
        return this.bandGroup;
    }

    public void addBand(Band band) {
        Assert.notNull((Object)band, (String)"band");
        Assert.argument((!this.containsRasterDataNode(band.getName()) ? 1 : 0) != 0, (String)("The Product '" + this.getName() + "' already contains a band with the name '" + band.getName() + "'."));
        this.bandGroup.add(band);
    }

    public Band addBand(String bandName, int dataType) {
        Band band = new Band(bandName, dataType, this.getSceneRasterWidth(), this.getSceneRasterHeight());
        this.addBand(band);
        return band;
    }

    public Band addBand(String bandName, String expression) {
        return this.addBand(bandName, expression, 30);
    }

    public Band addBand(String bandName, String expression, int dataType) {
        VirtualBand band = new VirtualBand(bandName, dataType, this.getSceneRasterWidth(), this.getSceneRasterHeight(), expression);
        this.addBand(band);
        return band;
    }

    public boolean removeBand(Band band) {
        return this.bandGroup.remove(band);
    }

    public int getNumBands() {
        return this.bandGroup.getNodeCount();
    }

    public Band getBandAt(int index) {
        return this.bandGroup.get(index);
    }

    public String[] getBandNames() {
        return this.bandGroup.getNodeNames();
    }

    public Band[] getBands() {
        return (Band[])this.bandGroup.toArray(new Band[this.getNumBands()]);
    }

    public Band getBand(String name) {
        Guardian.assertNotNullOrEmpty("name", name);
        return this.bandGroup.get(name);
    }

    public int getBandIndex(String name) {
        Guardian.assertNotNullOrEmpty("name", name);
        return this.bandGroup.indexOf(name);
    }

    public boolean containsBand(String name) {
        Guardian.assertNotNullOrEmpty("name", name);
        return this.bandGroup.contains(name);
    }

    public boolean containsRasterDataNode(String name) {
        return this.containsBand(name) || this.containsTiePointGrid(name) || this.getMaskGroup().contains(name);
    }

    public RasterDataNode getRasterDataNode(String name) {
        RasterDataNode rasterDataNode = this.getBand(name);
        if (rasterDataNode != null) {
            return rasterDataNode;
        }
        rasterDataNode = this.getTiePointGrid(name);
        if (rasterDataNode != null) {
            return rasterDataNode;
        }
        return this.getMaskGroup().get(name);
    }

    public synchronized List<RasterDataNode> getRasterDataNodes() {
        ArrayList<RasterDataNode> rasterDataNodes = new ArrayList<RasterDataNode>(32);
        ProductNodeGroup<Band> bandGroup = this.getBandGroup();
        for (int i = 0; i < bandGroup.getNodeCount(); ++i) {
            rasterDataNodes.add(bandGroup.get(i));
        }
        ProductNodeGroup<Mask> maskGroup = this.getMaskGroup();
        for (int i = 0; i < maskGroup.getNodeCount(); ++i) {
            rasterDataNodes.add(maskGroup.get(i));
        }
        ProductNodeGroup<TiePointGrid> tpgGroup = this.getTiePointGridGroup();
        for (int i = 0; i < tpgGroup.getNodeCount(); ++i) {
            rasterDataNodes.add(tpgGroup.get(i));
        }
        return rasterDataNodes;
    }

    public ProductNodeGroup<Quicklook> getQuicklookGroup() {
        return this.quicklookGroup;
    }

    public Quicklook getDefaultQuicklook() {
        if (this.quicklookGroup.getNodeCount() == 0) {
            boolean wasModified = this.isModified();
            this.quicklookGroup.add(new Quicklook(this, "Quicklook"));
            if (!wasModified) {
                this.setModified(false);
            }
        }
        return this.quicklookGroup.get(0);
    }

    public Quicklook getQuicklook(String name) {
        Guardian.assertNotNullOrEmpty("name", name);
        return this.quicklookGroup.get(name);
    }

    public String getQuicklookBandName() {
        return this.quicklookBandName;
    }

    public void setQuicklookBandName(String quicklookBandName) {
        this.quicklookBandName = quicklookBandName;
    }

    public ProductNodeGroup<Mask> getMaskGroup() {
        return this.maskGroup;
    }

    public ProductNodeGroup<VectorDataNode> getVectorDataGroup() {
        return this.vectorDataGroup;
    }

    public ProductNodeGroup<FlagCoding> getFlagCodingGroup() {
        return this.flagCodingGroup;
    }

    public ProductNodeGroup<IndexCoding> getIndexCodingGroup() {
        return this.indexCodingGroup;
    }

    public boolean containsPixel(double x, double y) {
        return x >= 0.0 && x <= (double)this.getSceneRasterWidth() && y >= 0.0 && y <= (double)this.getSceneRasterHeight();
    }

    public boolean containsPixel(PixelPos pixelPos) {
        return this.containsPixel(pixelPos.x, pixelPos.y);
    }

    private synchronized PlacemarkGroup createGcpGroup() {
        VectorDataNode vectorDataNode = new VectorDataNode(GCP_GROUP_NAME, Placemark.createGcpFeatureType());
        vectorDataNode.setDefaultStyleCss("symbol:plus; stroke:#ff8800; stroke-opacity:0.8; stroke-width:1.0");
        vectorDataNode.setPermanent(true);
        this.vectorDataGroup.add(vectorDataNode);
        return vectorDataNode.getPlacemarkGroup();
    }

    public PlacemarkGroup getGcpGroup() {
        return this.gcpGroup;
    }

    private synchronized PlacemarkGroup createPinGroup() {
        VectorDataNode vectorDataNode = new VectorDataNode(PIN_GROUP_NAME, Placemark.createPinFeatureType());
        vectorDataNode.setDefaultStyleCss("symbol:pin; fill:#0000ff; fill-opacity:0.7; stroke:#ffffff; stroke-opacity:1.0; stroke-width:0.5");
        vectorDataNode.setPermanent(true);
        this.vectorDataGroup.add(vectorDataNode);
        return vectorDataNode.getPlacemarkGroup();
    }

    public synchronized PlacemarkGroup getPinGroup() {
        return this.pinGroup;
    }

    public int getNumResolutionsMax() {
        return this.numResolutionsMax;
    }

    public void setNumResolutionsMax(int numResolutionsMax) {
        this.numResolutionsMax = numResolutionsMax;
    }

    public boolean isCompatibleProduct(Product product, float eps) {
        Guardian.assertNotNull("product", (Object)product);
        if (this == product) {
            return true;
        }
        if (this.getSceneRasterWidth() != product.getSceneRasterWidth()) {
            SystemUtils.LOG.info("raster width " + product.getSceneRasterWidth() + " not equal to " + this.getSceneRasterWidth());
            return false;
        }
        if (this.getSceneRasterHeight() != product.getSceneRasterHeight()) {
            SystemUtils.LOG.info("raster height " + product.getSceneRasterHeight() + " not equal to " + this.getSceneRasterHeight());
            return false;
        }
        if (this.getSceneGeoCoding() == null && product.getSceneGeoCoding() != null) {
            SystemUtils.LOG.info("no geocoding in master but in source");
            return false;
        }
        if (this.getSceneGeoCoding() != null) {
            if (product.getSceneGeoCoding() == null) {
                SystemUtils.LOG.info("no geocoding in source but in master");
                return false;
            }
            PixelPos pixelPos = new PixelPos();
            GeoPos geoPos1 = new GeoPos();
            GeoPos geoPos2 = new GeoPos();
            pixelPos.x = 0.5;
            pixelPos.y = 0.5;
            this.getSceneGeoCoding().getGeoPos(pixelPos, geoPos1);
            product.getSceneGeoCoding().getGeoPos(pixelPos, geoPos2);
            if (!Product.equalsLatLon(geoPos1, geoPos2, eps)) {
                SystemUtils.LOG.info("first scan line left corner " + geoPos2 + " not equal to " + geoPos1);
                return false;
            }
            pixelPos.x = (float)(this.getSceneRasterWidth() - 1) + 0.5f;
            pixelPos.y = 0.5;
            this.getSceneGeoCoding().getGeoPos(pixelPos, geoPos1);
            product.getSceneGeoCoding().getGeoPos(pixelPos, geoPos2);
            if (!Product.equalsLatLon(geoPos1, geoPos2, eps)) {
                SystemUtils.LOG.info("first scan line right corner " + geoPos2 + " not equal to " + geoPos1);
                return false;
            }
            pixelPos.x = 0.5;
            pixelPos.y = (float)(this.getSceneRasterHeight() - 1) + 0.5f;
            this.getSceneGeoCoding().getGeoPos(pixelPos, geoPos1);
            product.getSceneGeoCoding().getGeoPos(pixelPos, geoPos2);
            if (!Product.equalsLatLon(geoPos1, geoPos2, eps)) {
                SystemUtils.LOG.info("last scan line left corner " + geoPos2 + " not equal to " + geoPos1);
                return false;
            }
            pixelPos.x = (float)(this.getSceneRasterWidth() - 1) + 0.5f;
            pixelPos.y = (float)(this.getSceneRasterHeight() - 1) + 0.5f;
            this.getSceneGeoCoding().getGeoPos(pixelPos, geoPos1);
            product.getSceneGeoCoding().getGeoPos(pixelPos, geoPos2);
            if (!Product.equalsLatLon(geoPos1, geoPos2, eps)) {
                SystemUtils.LOG.info("last scan line right corner " + geoPos2 + " not equal to " + geoPos1);
                return false;
            }
        }
        return true;
    }

    public Term parseExpression(String expression) throws ParseException {
        return BandArithmetic.parseExpression(expression, new Product[]{this}, 0);
    }

    public RasterDataNode[] getRefRasterDataNodes(String expression) throws ParseException {
        ProductManager productManager = this.getProductManager();
        RasterDataNode[] nodes = productManager != null ? BandArithmetic.getRefRasters(expression, productManager.getProducts(), productManager.getProductIndex(this)) : BandArithmetic.getRefRasters(expression, this);
        return nodes;
    }

    @Override
    public void acceptVisitor(ProductVisitor visitor) {
        Guardian.assertNotNull("visitor", visitor);
        this.bandGroup.acceptVisitor(visitor);
        this.tiePointGridGroup.acceptVisitor(visitor);
        this.flagCodingGroup.acceptVisitor(visitor);
        this.indexCodingGroup.acceptVisitor(visitor);
        this.vectorDataGroup.acceptVisitor(visitor);
        this.maskGroup.acceptVisitor(visitor);
        this.quicklookGroup.acceptVisitor(visitor);
        this.metadataRoot.acceptVisitor(visitor);
        visitor.visit(this);
    }

    public boolean addProductNodeListener(ProductNodeListener listener) {
        if (listener != null) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<ProductNodeListener>();
            }
            if (!this.listeners.contains(listener)) {
                this.listeners.add(0, listener);
                return true;
            }
        }
        return false;
    }

    public void removeProductNodeListener(ProductNodeListener listener) {
        if (listener != null && this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public ProductNodeListener[] getProductNodeListeners() {
        if (this.listeners == null) {
            return new ProductNodeListener[0];
        }
        return this.listeners.toArray(new ProductNodeListener[this.listeners.size()]);
    }

    protected boolean hasProductNodeListeners() {
        return this.listeners != null && this.listeners.size() > 0;
    }

    protected void fireNodeChanged(ProductNode sourceNode, String propertyName, Object oldValue, Object newValue) {
        this.fireEvent(sourceNode, propertyName, oldValue, newValue);
    }

    protected void fireNodeDataChanged(DataNode sourceNode) {
        this.fireEvent(sourceNode, 3, null);
    }

    protected void fireNodeAdded(ProductNode childNode, ProductNodeGroup nodeGroup) {
        this.fireEvent(childNode, 1, nodeGroup);
    }

    protected void fireNodeRemoved(ProductNode childNode, ProductNodeGroup nodeGroup) {
        this.fireEvent(childNode, 2, nodeGroup);
    }

    private void fireEvent(ProductNode sourceNode, int eventType, ProductNodeGroup nodeGroup) {
        if (this.hasProductNodeListeners()) {
            ProductNodeEvent event = new ProductNodeEvent(sourceNode, eventType, nodeGroup);
            this.fireEvent(event);
        }
    }

    private void fireEvent(ProductNode sourceNode, String propertyName, Object oldValue, Object newValue) {
        if (this.hasProductNodeListeners()) {
            ProductNodeEvent event = new ProductNodeEvent(sourceNode, propertyName, oldValue, newValue);
            this.fireEvent(event);
        }
    }

    private void fireEvent(ProductNodeEvent event) {
        Product.fireEvent(event, this.listeners.toArray(new ProductNodeListener[this.listeners.size()]));
    }

    public int getRefNo() {
        return this.refNo;
    }

    public void setRefNo(int refNo) {
        Guardian.assertWithinRange("refNo", refNo, 1L, Integer.MAX_VALUE);
        if (this.refNo != 0 && this.refNo != refNo) {
            throw new IllegalStateException("this.refNo != 0 && this.refNo != refNo");
        }
        this.refNo = refNo;
        this.refStr = "[" + this.refNo + "]";
    }

    public void resetRefNo() {
        this.refNo = 0;
        this.refStr = null;
    }

    String getRefStr() {
        return this.refStr;
    }

    public ProductManager getProductManager() {
        return this.productManager;
    }

    void setProductManager(ProductManager productManager) {
        this.productManager = productManager;
    }

    public boolean isCompatibleBandArithmeticExpression(String expression) {
        return this.isCompatibleBandArithmeticExpression(expression, null);
    }

    public boolean isCompatibleBandArithmeticExpression(String expression, Parser parser) {
        RasterDataSymbol[] termSymbols;
        Term term;
        Guardian.assertNotNull("expression", expression);
        if (this.containsBand(expression)) {
            return true;
        }
        if (parser == null) {
            parser = this.createBandArithmeticParser();
        }
        try {
            term = parser.parse(expression);
        }
        catch (ParseException e) {
            return false;
        }
        if (term == null) {
            return false;
        }
        if (!BandArithmetic.areRastersEqualInSize(term)) {
            return false;
        }
        for (RasterDataSymbol termSymbol : termSymbols = BandArithmetic.getRefRasterDataSymbols(term)) {
            String symbolName;
            String flagName;
            String[] flagNames;
            RasterDataNode refRaster = termSymbol.getRaster();
            if (refRaster.getProduct() != this) {
                return false;
            }
            if (!(termSymbol instanceof SingleFlagSymbol) || StringUtils.containsIgnoreCase(flagNames = ((Band)refRaster).getFlagCoding().getFlagNames(), flagName = (symbolName = termSymbol.getName()).substring(symbolName.indexOf(46) + 1))) continue;
            return false;
        }
        return true;
    }

    public Parser createBandArithmeticParser() {
        WritableNamespace namespace = this.createBandArithmeticDefaultNamespace();
        return new ParserImpl(namespace, false);
    }

    public WritableNamespace createBandArithmeticDefaultNamespace() {
        return BandArithmetic.createDefaultNamespace(new Product[]{this}, 0);
    }

    public Product createSubset(ProductSubsetDef subsetDef, String name, String desc) throws IOException {
        return ProductSubsetBuilder.createProductSubset(this, subsetDef, name, desc);
    }

    @Override
    public void setModified(boolean modified) {
        boolean oldState = this.isModified();
        if (oldState != modified) {
            super.setModified(modified);
            if (!modified) {
                this.bandGroup.setModified(false);
                this.tiePointGridGroup.setModified(false);
                this.maskGroup.setModified(false);
                this.quicklookGroup.setModified(false);
                this.vectorDataGroup.setModified(false);
                this.flagCodingGroup.setModified(false);
                this.indexCodingGroup.setModified(false);
                this.getMetadataRoot().setModified(false);
            }
        }
    }

    @Override
    public long getRawStorageSize(ProductSubsetDef subsetDef) {
        int i;
        long size = 0L;
        for (i = 0; i < this.getNumBands(); ++i) {
            size += this.getBandAt(i).getRawStorageSize(subsetDef);
        }
        for (i = 0; i < this.getNumTiePointGrids(); ++i) {
            size += this.getTiePointGridAt(i).getRawStorageSize(subsetDef);
        }
        for (i = 0; i < this.getFlagCodingGroup().getNodeCount(); ++i) {
            size += this.getFlagCodingGroup().get(i).getRawStorageSize(subsetDef);
        }
        for (i = 0; i < this.getMaskGroup().getNodeCount(); ++i) {
            size += this.getMaskGroup().get(i).getRawStorageSize(subsetDef);
        }
        for (i = 0; i < this.getQuicklookGroup().getNodeCount(); ++i) {
            size += this.getQuicklookGroup().get(i).getRawStorageSize(subsetDef);
        }
        return size += this.getMetadataRoot().getRawStorageSize(subsetDef);
    }

    public String createPixelInfoString(int pixelX, int pixelY) {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("Product:\t");
        sb.append(this.getName()).append("\n\n");
        sb.append("Image-X:\t");
        sb.append(pixelX);
        sb.append("\tpixel\n");
        sb.append("Image-Y:\t");
        sb.append(pixelY);
        sb.append("\tpixel\n");
        if (this.getSceneGeoCoding() != null) {
            PixelPos pt = new PixelPos((float)pixelX + 0.5f, (float)pixelY + 0.5f);
            Band[] geoPos = this.getSceneGeoCoding().getGeoPos(pt, null);
            sb.append("Longitude:\t");
            sb.append(geoPos.getLonString());
            sb.append("\tdegree\n");
            sb.append("Latitude:\t");
            sb.append(geoPos.getLatString());
            sb.append("\tdegree\n");
            if (this.getSceneGeoCoding() instanceof MapGeoCoding) {
                MapGeoCoding mapGeoCoding = (MapGeoCoding)this.getSceneGeoCoding();
                MapProjection mapProjection = mapGeoCoding.getMapInfo().getMapProjection();
                MapTransform mapTransform = mapProjection.getMapTransform();
                Point2D mapPoint = mapTransform.forward((GeoPos)geoPos, null);
                String mapUnit = mapProjection.getMapUnit();
                sb.append("Map-X:\t");
                sb.append(mapPoint.getX());
                sb.append("\t").append(mapUnit).append("\n");
                sb.append("Map-Y:\t");
                sb.append(mapPoint.getY());
                sb.append("\t").append(mapUnit).append("\n");
            }
        }
        if (pixelX >= 0 && pixelX < this.getSceneRasterWidth() && pixelY >= 0 && pixelY < this.getSceneRasterHeight()) {
            int i;
            sb.append("\n");
            boolean haveSpectralBand = false;
            for (Band band : this.getBands()) {
                if (!((double)band.getSpectralWavelength() > 0.0)) continue;
                haveSpectralBand = true;
                break;
            }
            if (haveSpectralBand) {
                sb.append("BandName\tWavelength\tUnit\tBandwidth\tUnit\tValue\tUnit\tSolar Flux\tUnit\n");
            } else {
                sb.append("BandName\tValue\tUnit\n");
            }
            for (Band band : this.getBands()) {
                sb.append(band.getName());
                sb.append(":\t");
                if ((double)band.getSpectralWavelength() > 0.0) {
                    sb.append(band.getSpectralWavelength());
                    sb.append("\t");
                    sb.append("nm");
                    sb.append("\t");
                    sb.append(band.getSpectralBandwidth());
                    sb.append("\t");
                    sb.append("nm");
                    sb.append("\t");
                } else if (haveSpectralBand) {
                    sb.append("\t");
                    sb.append("\t");
                    sb.append("\t");
                    sb.append("\t");
                }
                sb.append(band.getPixelString(pixelX, pixelY));
                sb.append("\t");
                if (band.getUnit() != null) {
                    sb.append(band.getUnit());
                }
                sb.append("\t");
                float solarFlux = band.getSolarFlux();
                if ((double)solarFlux > 0.0) {
                    sb.append(solarFlux);
                    sb.append("\t");
                    sb.append("mW/(m^2*nm)");
                    sb.append("\t");
                }
                sb.append("\n");
            }
            sb.append("\n");
            for (i = 0; i < this.getNumTiePointGrids(); ++i) {
                TiePointGrid grid = this.getTiePointGridAt(i);
                if (!grid.hasRasterData()) continue;
                sb.append(grid.getName());
                sb.append(":\t");
                sb.append(grid.getPixelString(pixelX, pixelY));
                if (grid.getUnit() != null) {
                    sb.append("\t");
                    sb.append(grid.getUnit());
                }
                sb.append("\n");
            }
            for (i = 0; i < this.getNumBands(); ++i) {
                Band band = this.getBandAt(i);
                FlagCoding flagCoding = band.getFlagCoding();
                if (flagCoding == null) continue;
                boolean ioException = false;
                int[] flags = new int[1];
                if (band.hasRasterData()) {
                    flags[0] = band.getPixelInt(pixelX, pixelY);
                } else {
                    try {
                        band.readPixels(pixelX, pixelY, 1, 1, flags, ProgressMonitor.NULL);
                    }
                    catch (IOException e) {
                        ioException = true;
                    }
                }
                sb.append("\n");
                if (ioException) {
                    sb.append("I/O error");
                    continue;
                }
                for (int j = 0; j < flagCoding.getNumAttributes(); ++j) {
                    MetadataAttribute flagAttr = flagCoding.getAttributeAt(j);
                    int mask = flagAttr.getData().getElemInt();
                    boolean flagSet = (flags[0] & mask) == mask;
                    sb.append(band.getName());
                    sb.append(".");
                    sb.append(flagAttr.getName());
                    sb.append(":\t");
                    sb.append(flagSet ? "true" : "false");
                    sb.append("\n");
                }
            }
        }
        return sb.toString();
    }

    public String createPixelInfoString(int pixelX, int pixelY, RasterDataNode raster) {
        StringBuilder sb = new StringBuilder(1024);
        boolean isMultiSize = this.isMultiSize();
        sb.append("Product:\t");
        sb.append(this.getName()).append("\n\n");
        if (!isMultiSize) {
            sb.append("Image-X:\t");
            sb.append(pixelX);
            sb.append("\tpixel\n");
            sb.append("Image-Y:\t");
            sb.append(pixelY);
            sb.append("\tpixel\n");
        } else {
            sb.append("Image-X." + raster.getName() + ":\t");
            sb.append(pixelX);
            sb.append("\tpixel\n");
            sb.append("Image-Y." + raster.getName() + ":\t");
            sb.append(pixelY);
            sb.append("\tpixel\n");
        }
        PixelPos pixelPosRef = new PixelPos((float)pixelX + 0.5f, (float)pixelY + 0.5f);
        GeoCoding rasterGeocoding = raster.getGeoCoding();
        GeoPos geoPos = null;
        if (rasterGeocoding != null) {
            geoPos = rasterGeocoding.getGeoPos(pixelPosRef, null);
            sb.append("Longitude:\t");
            sb.append(geoPos.getLonString());
            sb.append("\tdegree\n");
            sb.append("Latitude:\t");
            sb.append(geoPos.getLatString());
            sb.append("\tdegree\n");
            if (this.getSceneGeoCoding() instanceof MapGeoCoding) {
                MapGeoCoding mapGeoCoding = (MapGeoCoding)this.getSceneGeoCoding();
                MapProjection mapProjection = mapGeoCoding.getMapInfo().getMapProjection();
                MapTransform mapTransform = mapProjection.getMapTransform();
                Point2D mapPoint = mapTransform.forward(geoPos, null);
                String mapUnit = mapProjection.getMapUnit();
                sb.append("Map-X:\t");
                sb.append(mapPoint.getX());
                sb.append("\t").append(mapUnit).append("\n");
                sb.append("Map-Y:\t");
                sb.append(mapPoint.getY());
                sb.append("\t").append(mapUnit).append("\n");
            }
        }
        if (raster.isPixelWithinImageBounds(pixelX, pixelY)) {
            int i;
            sb.append("\n");
            boolean haveSpectralBand = false;
            for (Band band : this.getBands()) {
                if (!((double)band.getSpectralWavelength() > 0.0)) continue;
                haveSpectralBand = true;
                break;
            }
            if (haveSpectralBand) {
                sb.append("BandName\tWavelength\tUnit\tBandwidth\tUnit\tValue\tUnit\tSolar Flux\tUnit\n");
            } else {
                sb.append("BandName\tValue\tUnit\n");
            }
            for (Band band : this.getBands()) {
                sb.append(band.getName());
                sb.append(":\t");
                if ((double)band.getSpectralWavelength() > 0.0) {
                    sb.append(band.getSpectralWavelength());
                    sb.append("\t");
                    sb.append("nm");
                    sb.append("\t");
                    sb.append(band.getSpectralBandwidth());
                    sb.append("\t");
                    sb.append("nm");
                    sb.append("\t");
                } else if (haveSpectralBand) {
                    sb.append("\t");
                    sb.append("\t");
                    sb.append("\t");
                    sb.append("\t");
                }
                PixelPos pixelForBand = this.getPixelForBand(pixelPosRef, raster, band);
                sb.append(band.getPixelString(MathUtils.floorInt(pixelForBand.getX()), MathUtils.floorInt(pixelForBand.getY())));
                sb.append("\t");
                if (band.getUnit() != null) {
                    sb.append(band.getUnit());
                }
                sb.append("\t");
                float solarFlux = band.getSolarFlux();
                if ((double)solarFlux > 0.0) {
                    sb.append(solarFlux);
                    sb.append("\t");
                    sb.append("mW/(m^2*nm)");
                    sb.append("\t");
                }
                sb.append("\n");
            }
            sb.append("\n");
            for (i = 0; i < this.getNumTiePointGrids(); ++i) {
                TiePointGrid grid = this.getTiePointGridAt(i);
                if (!grid.hasRasterData()) continue;
                sb.append(grid.getName());
                sb.append(":\t");
                PixelPos pixelForGrid = this.getPixelForBand(pixelPosRef, raster, grid);
                sb.append(grid.getPixelString(MathUtils.floorInt(pixelForGrid.getX()), MathUtils.floorInt(pixelForGrid.getY())));
                if (grid.getUnit() != null) {
                    sb.append("\t");
                    sb.append(grid.getUnit());
                }
                sb.append("\n");
            }
            for (i = 0; i < this.getNumBands(); ++i) {
                Band band = this.getBandAt(i);
                FlagCoding flagCoding = band.getFlagCoding();
                if (flagCoding == null) continue;
                boolean ioException = false;
                int[] flags = new int[1];
                PixelPos pixelForBand = this.getPixelForBand(pixelPosRef, raster, band);
                if (band.hasRasterData()) {
                    flags[0] = band.getPixelInt(MathUtils.floorInt(pixelForBand.getX()), MathUtils.floorInt(pixelForBand.getY()));
                } else {
                    try {
                        band.readPixels(MathUtils.floorInt(pixelForBand.getX()), MathUtils.floorInt(pixelForBand.getY()), 1, 1, flags, ProgressMonitor.NULL);
                    }
                    catch (IOException e) {
                        ioException = true;
                    }
                }
                sb.append("\n");
                if (ioException) {
                    sb.append("I/O error");
                    continue;
                }
                for (int j = 0; j < flagCoding.getNumAttributes(); ++j) {
                    MetadataAttribute flagAttr = flagCoding.getAttributeAt(j);
                    int mask = flagAttr.getData().getElemInt();
                    boolean flagSet = (flags[0] & mask) == mask;
                    sb.append(band.getName());
                    sb.append(".");
                    sb.append(flagAttr.getName());
                    sb.append(":\t");
                    sb.append(flagSet ? "true" : "false");
                    sb.append("\n");
                }
            }
        }
        return sb.toString();
    }

    public PixelPos getPixelForBand(PixelPos pixelPosRef, RasterDataNode referenceRaster, RasterDataNode currentRaster) {
        PixelPos pixelForBand;
        boolean hasSameResolution = currentRaster.getImageToModelTransform().equals(referenceRaster.getImageToModelTransform());
        if (hasSameResolution) {
            pixelForBand = pixelPosRef;
        } else {
            try {
                Point2D.Double sourcePixel = new Point2D.Double(pixelPosRef.getX(), pixelPosRef.getY());
                Point2D.Double modelCoord = (Point2D.Double)referenceRaster.getImageToModelTransform().transform(sourcePixel, null);
                Point2D.Double point2DForBand = (Point2D.Double)currentRaster.getImageToModelTransform().createInverse().transform(modelCoord, null);
                pixelForBand = new PixelPos(point2DForBand.x, point2DForBand.y);
            }
            catch (NoninvertibleTransformException ne) {
                GeoCoding rasterGeocoding = referenceRaster.getGeoCoding();
                GeoPos geoPos = rasterGeocoding.getGeoPos(pixelPosRef, null);
                pixelForBand = geoPos != null ? currentRaster.getGeoCoding().getPixelPos(geoPos, null) : new PixelPos(-1.0, -1.0);
            }
        }
        return pixelForBand;
    }

    public ProductNode[] getRemovedChildNodes() {
        ArrayList<ProductNode> removedNodes = new ArrayList<ProductNode>();
        removedNodes.addAll(this.bandGroup.getRemovedNodes());
        removedNodes.addAll(this.flagCodingGroup.getRemovedNodes());
        removedNodes.addAll(this.indexCodingGroup.getRemovedNodes());
        removedNodes.addAll(this.tiePointGridGroup.getRemovedNodes());
        removedNodes.addAll(this.maskGroup.getRemovedNodes());
        removedNodes.addAll(this.quicklookGroup.getRemovedNodes());
        removedNodes.addAll(this.vectorDataGroup.getRemovedNodes());
        return removedNodes.toArray(new ProductNode[removedNodes.size()]);
    }

    public boolean canBeOrthorectified() {
        for (int i = 0; i < this.getNumBands(); ++i) {
            if (this.getBandAt(i).canBeOrthorectified()) continue;
            return false;
        }
        return true;
    }

    private String getSuitableMaskDefDescription(String expr) {
        String description;
        Term.NotB notTerm;
        Term arg;
        Term term;
        if (StringUtils.isNullOrEmpty(expr)) {
            return null;
        }
        try {
            term = BandArithmetic.parseExpression(expr, new Product[]{this}, 0);
        }
        catch (ParseException e) {
            return null;
        }
        if (term instanceof Term.Ref) {
            return this.getSuitableMaskDefDescription((Term.Ref)term);
        }
        if (term instanceof Term.NotB && (arg = (notTerm = (Term.NotB)term).getArgs()[0]) instanceof Term.Ref && (description = this.getSuitableMaskDefDescription((Term.Ref)arg)) != null) {
            return "Not " + description;
        }
        return null;
    }

    private String getSuitableMaskDefDescription(Term.Ref ref) {
        String description = null;
        String symbolName = ref.getSymbol().getName();
        if (Product.isFlagSymbol(symbolName)) {
            MetadataAttribute attribute;
            FlagCoding flagCoding;
            String[] strings = StringUtils.split(symbolName, new char[]{'.'}, true);
            String nodeName = strings[0];
            String flagName = strings[1];
            RasterDataNode rasterDataNode = this.getRasterDataNode(nodeName);
            if (rasterDataNode instanceof Band && (flagCoding = ((Band)rasterDataNode).getFlagCoding()) != null && (attribute = flagCoding.getAttribute(flagName)) != null) {
                description = attribute.getDescription();
            }
        } else {
            RasterDataNode rasterDataNode = this.getRasterDataNode(symbolName);
            if (rasterDataNode != null) {
                description = rasterDataNode.getDescription();
            }
        }
        return description;
    }

    public Dimension getPreferredTileSize() {
        return this.preferredTileSize;
    }

    public void setPreferredTileSize(Dimension preferredTileSize) {
        this.preferredTileSize = preferredTileSize;
    }

    public void setPreferredTileSize(int tileWidth, int tileHeight) {
        this.setPreferredTileSize(new Dimension(tileWidth, tileHeight));
    }

    public String[] getAllFlagNames() {
        ArrayList<CallSite> l = new ArrayList<CallSite>(32);
        for (int i = 0; i < this.getNumBands(); ++i) {
            Band band = this.getBandAt(i);
            if (band.getFlagCoding() == null) continue;
            for (int j = 0; j < band.getFlagCoding().getNumAttributes(); ++j) {
                MetadataAttribute attribute = band.getFlagCoding().getAttributeAt(j);
                l.add((CallSite)((Object)(band.getName() + "." + attribute.getName())));
            }
        }
        String[] flagNames = new String[l.size()];
        for (int i = 0; i < flagNames.length; ++i) {
            flagNames[i] = (String)l.get(i);
        }
        l.clear();
        return flagNames;
    }

    public AutoGrouping getAutoGrouping() {
        return this.autoGrouping;
    }

    public void setAutoGrouping(String pattern) {
        Assert.notNull((Object)pattern, (String)"text");
        this.setAutoGrouping(AutoGroupingImpl.parse(pattern));
    }

    public void setAutoGrouping(AutoGrouping autoGrouping) {
        AutoGrouping old = this.autoGrouping;
        if (!ObjectUtils.equalObjects(old, autoGrouping)) {
            this.autoGrouping = autoGrouping;
            this.fireProductNodeChanged("autoGrouping", old, this.autoGrouping);
        }
    }

    public Mask addMask(String maskName, Mask.ImageType imageType) {
        Mask mask = new Mask(maskName, this.getSceneRasterWidth(), this.getSceneRasterHeight(), imageType);
        this.addMask(mask);
        return mask;
    }

    public Mask addMask(String maskName, String expression, String description, Color color, double transparency) {
        Mask mask;
        RasterDataNode[] refRasters = new RasterDataNode[]{};
        try {
            ProductManager productManager = this.getProductManager();
            Product[] products = new Product[]{this};
            int productIndex = 0;
            if (productManager != null) {
                products = productManager.getProducts();
                productIndex = productManager.getProductIndex(this);
            }
            if (!BandArithmetic.areRastersEqualInSize(products, productIndex, expression)) {
                throw new IllegalArgumentException("Expression must not reference rasters of different sizes");
            }
            refRasters = BandArithmetic.getRefRasters(expression, products, productIndex);
        }
        catch (ParseException e) {
            Logger.getLogger(Product.class.getName()).warning(String.format("Adding invalid expression '%s' to product", expression));
        }
        if (refRasters.length == 0) {
            mask = Mask.BandMathsType.create(maskName, description, this.getSceneRasterWidth(), this.getSceneRasterHeight(), expression, color, transparency);
        } else {
            RasterDataNode refRaster = refRasters[0];
            mask = Mask.BandMathsType.create(maskName, description, refRaster.getRasterWidth(), refRaster.getRasterHeight(), expression, color, transparency);
            mask.setGeoCoding(refRaster.getGeoCoding());
        }
        this.addMask(mask);
        return mask;
    }

    public Mask addMask(String maskName, VectorDataNode vectorDataNode, String description, Color color, double transparency) {
        Mask mask = new Mask(maskName, this.getSceneRasterWidth(), this.getSceneRasterHeight(), Mask.VectorDataType.INSTANCE);
        Mask.VectorDataType.setVectorData(mask, vectorDataNode);
        mask.setDescription(description);
        mask.setImageColor(color);
        mask.setImageTransparency(transparency);
        this.addMask(mask);
        return mask;
    }

    public Mask addMask(String maskName, VectorDataNode vectorDataNode, String description, Color color, double transparency, RasterDataNode prototypeRasterDataNode) {
        Mask mask = new Mask(maskName, prototypeRasterDataNode != null ? prototypeRasterDataNode.getRasterWidth() : this.getSceneRasterWidth(), prototypeRasterDataNode != null ? prototypeRasterDataNode.getRasterHeight() : this.getSceneRasterHeight(), Mask.VectorDataType.INSTANCE);
        Mask.VectorDataType.setVectorData(mask, vectorDataNode);
        mask.setDescription(description);
        mask.setImageColor(color);
        mask.setImageTransparency(transparency);
        if (prototypeRasterDataNode != null) {
            ProductUtils.copyImageGeometry(prototypeRasterDataNode, mask, false);
        }
        this.addMask(mask);
        return mask;
    }

    public void addMask(Mask mask) {
        Assert.argument((!this.containsRasterDataNode(mask.getName()) ? 1 : 0) != 0, (String)String.format("The Product '%s' already contains a raster with the name '%s'.", this.getName(), mask.getName()));
        this.getMaskGroup().add(mask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiLevelImage getMaskImage(String expression, RasterDataNode associatedRaster) {
        Product product = this;
        synchronized (product) {
            if (this.maskCache == null) {
                this.maskCache = new HashMap<String, WeakReference<MultiLevelImage>>();
            }
            WeakReference<MultiLevelImage> maskImageRef = this.maskCache.get(expression);
            MultiLevelImage maskImage = null;
            if (maskImageRef != null) {
                maskImage = (MultiLevelImage)maskImageRef.get();
            }
            if (maskImage == null) {
                maskImage = this.createMaskImage(expression, associatedRaster);
                this.maskCache.put(expression, new WeakReference<MultiLevelImage>(maskImage));
            }
            return maskImage;
        }
    }

    private MultiLevelImage createMaskImage(String expression, RasterDataNode associatedRaster) {
        MultiLevelModel multiLevelModel;
        Dimension tileSize;
        Dimension sourceSize;
        final Term term = VirtualBandOpImage.parseExpression(expression, this);
        if (associatedRaster != null) {
            MultiLevelImage sourceImage = associatedRaster.getSourceImage();
            sourceSize = associatedRaster.getRasterSize();
            tileSize = new Dimension(sourceImage.getTileWidth(), sourceImage.getTileHeight());
            multiLevelModel = sourceImage.getModel();
        } else {
            sourceSize = this.getSceneRasterSize();
            tileSize = this.getPreferredTileSize();
            multiLevelModel = this.createMultiLevelModel();
        }
        AbstractMultiLevelSource multiLevelSource = new AbstractMultiLevelSource(multiLevelModel){

            public RenderedImage createImage(int level) {
                return VirtualBandOpImage.builder(term).mask(true).sourceSize(sourceSize).tileSize(tileSize).level(ResolutionLevel.create(this.getModel(), level)).create();
            }
        };
        return new VirtualBandMultiLevelImage((MultiLevelSource)multiLevelSource, term);
    }

    public MultiLevelModel createMultiLevelModel() {
        int w = this.getSceneRasterWidth();
        int h = this.getSceneRasterHeight();
        AffineTransform i2mTransform = Product.findImageToModelTransform(this.getSceneGeoCoding());
        if (this.getNumResolutionsMax() > 0) {
            return new DefaultMultiLevelModel(this.getNumResolutionsMax(), i2mTransform, w, h);
        }
        return new DefaultMultiLevelModel(i2mTransform, w, h);
    }

    private synchronized boolean initSceneProperties() {
        Comparator maxAreaComparator = (o1, o2) -> {
            long a1 = (long)o1.getRasterWidth() * (long)o1.getRasterHeight();
            long a2 = (long)o2.getRasterWidth() * (long)o2.getRasterHeight();
            return Long.compare(a2, a1);
        };
        Band refBand = Stream.of(this.getBands()).filter(b -> b.getGeoCoding() != null).sorted(maxAreaComparator).findFirst().orElse(null);
        if (refBand == null) {
            refBand = Stream.of(this.getBands()).sorted(maxAreaComparator).findFirst().orElse(null);
        }
        if (refBand != null) {
            if (this.sceneRasterSize == null) {
                this.sceneRasterSize = new Dimension(refBand.getRasterWidth(), refBand.getRasterHeight());
                if (this.sceneGeoCoding == null) {
                    this.sceneGeoCoding = refBand.getGeoCoding();
                }
            }
            return true;
        }
        return false;
    }

    private void handleMaskAdded(ProductNodeEvent event) {
        Mask mask = (Mask)event.getSourceNode();
        if (StringUtils.isNullOrEmpty(mask.getDescription()) && mask.getImageType() == Mask.BandMathsType.INSTANCE) {
            String expression = Mask.BandMathsType.getExpression(mask);
            mask.setDescription(this.getSuitableMaskDefDescription(expression));
        }
    }

    private void handleVectorDataNodeAdded(ProductNodeEvent event) {
        Mask mask;
        VectorDataNode sourceNode = (VectorDataNode)event.getSourceNode();
        if (sourceNode.getFeatureCollection().size() > 0 && (mask = this.getMask(sourceNode)) == null) {
            this.addMask(sourceNode);
        }
    }

    private void handleVectorDataNodeRemoved(ProductNodeEvent event) {
        Mask mask = this.getMask((VectorDataNode)event.getSourceNode());
        if (mask != null) {
            this.getMaskGroup().remove(mask);
        }
    }

    private void handleMaskRemoved(ProductNodeEvent event) {
        TiePointGrid[] tiePointGrids;
        Band[] bands;
        Mask mask = (Mask)event.getSourceNode();
        for (Band band : bands = this.getBands()) {
            band.getOverlayMaskGroup().remove(mask);
        }
        for (TiePointGrid tiePointGrid : tiePointGrids = this.getTiePointGrids()) {
            tiePointGrid.getOverlayMaskGroup().remove(mask);
        }
    }

    private void addMask(VectorDataNode node) {
        this.addMask(node.getName(), node, "Mask derived from geometries in '" + node.getName() + "'", Color.RED, 0.5);
    }

    private void handleFeatureCollectionChange(ProductNodeEvent event) {
        VectorDataNode sourceNode = (VectorDataNode)event.getSourceNode();
        Mask mask = this.getMask(sourceNode);
        if (sourceNode.getFeatureCollection().size() > 0) {
            if (mask == null) {
                this.addMask(sourceNode);
            }
        } else if (mask != null) {
            this.getMaskGroup().remove(mask);
        }
    }

    private Mask getMask(VectorDataNode sourceNode) {
        Mask[] masks;
        for (Mask mask : masks = (Mask[])this.maskGroup.toArray(new Mask[this.maskGroup.getNodeCount()])) {
            if (mask.getImageType() != Mask.VectorDataType.INSTANCE || Mask.VectorDataType.getVectorData(mask) != sourceNode) continue;
            return mask;
        }
        return null;
    }

    private void handleSceneGeoCodingChange() {
        boolean adjustPinGeoPos = Config.instance().preferences().getBoolean("snap.adjustPinGeoPos", true);
        if (adjustPinGeoPos) {
            for (int i = 0; i < this.pinGroup.getNodeCount(); ++i) {
                Placemark pin = (Placemark)((Object)this.pinGroup.get(i));
                PlacemarkDescriptor pinDescriptor = pin.getDescriptor();
                PixelPos pixelPos = pin.getPixelPos();
                GeoPos geoPos = pin.getGeoPos();
                if (pixelPos != null) {
                    geoPos = pinDescriptor.updateGeoPos(this.getSceneGeoCoding(), pixelPos, geoPos);
                }
                pin.setGeoPos(geoPos);
            }
        }
    }

    private void handleNameChange(final ProductNodeEvent event) {
        String oldName = (String)event.getOldValue();
        String newName = event.getSourceNode().getName();
        final String oldExternName = BandArithmetic.createExternalName(oldName);
        final String newExternName = BandArithmetic.createExternalName(newName);
        ProductVisitorAdapter productVisitorAdapter = new ProductVisitorAdapter(){

            @Override
            public void visit(Product product) {
                if (product == event.getSourceNode()) {
                    product.setFileLocation(null);
                }
            }

            @Override
            public void visit(TiePointGrid grid) {
                grid.updateExpression(oldExternName, newExternName);
            }

            @Override
            public void visit(Band band) {
                band.updateExpression(oldExternName, newExternName);
            }

            @Override
            public void visit(Mask mask) {
                mask.updateExpression(oldExternName, newExternName);
            }

            @Override
            public void visit(VirtualBand virtualBand) {
                virtualBand.updateExpression(oldExternName, newExternName);
            }

            @Override
            public void visit(ProductNodeGroup group) {
                group.updateExpression(oldExternName, newExternName);
            }
        };
        this.acceptVisitor(productVisitorAdapter);
    }

    private class VectorDataNodeProductNodeGroup
    extends ProductNodeGroup<VectorDataNode> {
        public VectorDataNodeProductNodeGroup() {
            super(Product.this, "vector_data", true);
        }

        @Override
        public boolean add(VectorDataNode vectorDataNode) {
            Assert.notNull((Object)((Object)vectorDataNode), (String)"node");
            VectorDataNode permanentNode = this.getPermanentNode(vectorDataNode.getName());
            if (permanentNode != null) {
                permanentNode.getFeatureCollection().addAll((FeatureCollection)vectorDataNode.getFeatureCollection());
                return false;
            }
            return super.add(vectorDataNode);
        }

        @Override
        public void add(int index, VectorDataNode vectorDataNode) {
            Assert.notNull((Object)((Object)vectorDataNode), (String)"node");
            VectorDataNode permanentNode = this.getPermanentNode(vectorDataNode.getName());
            if (permanentNode != null) {
                permanentNode.getFeatureCollection().addAll((FeatureCollection)vectorDataNode.getFeatureCollection());
                return;
            }
            super.add(index, vectorDataNode);
        }

        @Override
        public boolean remove(VectorDataNode vectorDataNode) {
            Assert.notNull((Object)((Object)vectorDataNode), (String)"node");
            return !vectorDataNode.isPermanent() && super.remove(vectorDataNode);
        }

        private VectorDataNode getPermanentNode(String nodeName) {
            VectorDataNode node = (VectorDataNode)((Object)this.get(nodeName));
            if (node != null && node.isPermanent()) {
                return node;
            }
            return null;
        }
    }

    private static class WildCardEntry
    implements Entry {
        private final WildcardMatcher wildcardMatcher;

        WildCardEntry(String group) {
            this.wildcardMatcher = new WildcardMatcher(group);
        }

        @Override
        public boolean matches(String name) {
            return this.wildcardMatcher.matches(name);
        }
    }

    private static class EntryImpl
    implements Entry {
        private final String group;

        EntryImpl(String group) {
            this.group = group;
        }

        @Override
        public boolean matches(String name) {
            return name.contains(this.group);
        }
    }

    private static class AutoGroupingPath {
        private final String[] groups;
        private final Entry[] entries;

        AutoGroupingPath(String[] groups) {
            this.groups = groups;
            this.entries = new Entry[groups.length];
            for (int i = 0; i < groups.length; ++i) {
                this.entries[i] = groups[i].contains("*") || groups[i].contains("?") ? new WildCardEntry(groups[i]) : new EntryImpl(groups[i]);
            }
        }

        boolean contains(String name) {
            for (Entry entry : this.entries) {
                if (entry.matches(name)) continue;
                return false;
            }
            return true;
        }

        String[] getInputPath() {
            return this.groups;
        }
    }

    private static class AutoGroupingImpl
    extends AbstractList<String[]>
    implements AutoGrouping {
        private static final String GROUP_SEPARATOR = "/";
        private static final String PATH_SEPARATOR = ":";
        private final AutoGroupingPath[] autoGroupingPaths;
        private final Index[] indexes;

        private AutoGroupingImpl(String[][] inputPaths) {
            this.autoGroupingPaths = new AutoGroupingPath[inputPaths.length];
            this.indexes = new Index[inputPaths.length];
            for (int i = 0; i < inputPaths.length; ++i) {
                AutoGroupingPath autoGroupingPath;
                this.autoGroupingPaths[i] = autoGroupingPath = new AutoGroupingPath(inputPaths[i]);
                this.indexes[i] = new Index(autoGroupingPath, i);
            }
            Arrays.sort(this.indexes, (o1, o2) -> {
                String[] o1InputPath = o1.path.getInputPath();
                String[] o2InputPath = o2.path.getInputPath();
                for (int index = 0; index < o1InputPath.length && index < o2InputPath.length; ++index) {
                    String currentO1InputPathString = o1InputPath[index];
                    String currentO2InputPathString = o2InputPath[index];
                    if (currentO1InputPathString.length() == currentO2InputPathString.length()) continue;
                    return currentO2InputPathString.length() - currentO1InputPathString.length();
                }
                if (o1InputPath.length != o2InputPath.length) {
                    return o2InputPath.length - o1InputPath.length;
                }
                return o2InputPath[0].compareTo(o1InputPath[0]);
            });
        }

        public static AutoGrouping parse(String text) {
            ArrayList<String[]> pathLists = new ArrayList<String[]>();
            if (StringUtils.isNotNullAndNotEmpty(text)) {
                String[] pathTexts;
                for (String pathText : pathTexts = StringUtils.toStringArray(text, PATH_SEPARATOR)) {
                    String[] subPaths = StringUtils.toStringArray(pathText, GROUP_SEPARATOR);
                    ArrayList<String> subPathsList = new ArrayList<String>();
                    for (String subPath : subPaths) {
                        if (!StringUtils.isNotNullAndNotEmpty(subPath)) continue;
                        subPathsList.add(subPath);
                    }
                    if (subPathsList.isEmpty()) continue;
                    pathLists.add(subPathsList.toArray(new String[subPathsList.size()]));
                }
                if (pathLists.isEmpty()) {
                    return null;
                }
                return new AutoGroupingImpl((String[][])pathLists.toArray((T[])new String[pathLists.size()][]));
            }
            return null;
        }

        @Override
        public int indexOf(String name) {
            for (Index index : this.indexes) {
                int i = index.index;
                if (!index.path.contains(name)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public String[] get(int index) {
            return this.autoGroupingPaths[index].getInputPath();
        }

        @Override
        public int size() {
            return this.autoGroupingPaths.length;
        }

        public String format() {
            if (this.autoGroupingPaths.length > 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < this.autoGroupingPaths.length; ++i) {
                    if (i > 0) {
                        sb.append(PATH_SEPARATOR);
                    }
                    String[] path = this.autoGroupingPaths[i].getInputPath();
                    for (int j = 0; j < path.length; ++j) {
                        if (j > 0) {
                            sb.append(GROUP_SEPARATOR);
                        }
                        sb.append(path[j]);
                    }
                }
                return sb.toString();
            }
            return "";
        }

        @Override
        public String toString() {
            return this.format();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof AutoGrouping) {
                AutoGrouping other = (AutoGrouping)o;
                if (other.size() != this.size()) {
                    return false;
                }
                for (int i = 0; i < this.autoGroupingPaths.length; ++i) {
                    String[] path = this.autoGroupingPaths[i].getInputPath();
                    if (ObjectUtils.equalObjects(path, other.get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public int hashCode() {
            int code = 0;
            for (AutoGroupingPath autoGroupingPath : this.autoGroupingPaths) {
                Object[] path = autoGroupingPath.getInputPath();
                code += Arrays.hashCode(path);
            }
            return code;
        }

        private static class Index {
            final int index;
            final AutoGroupingPath path;

            private Index(AutoGroupingPath path, int index) {
                this.path = path;
                this.index = index;
            }
        }
    }

    static interface Entry {
        public boolean matches(String var1);
    }

    public static interface AutoGrouping
    extends List<String[]> {
        public static AutoGrouping parse(String text) {
            return AutoGroupingImpl.parse(text);
        }

        public int indexOf(String var1);
    }
}

