/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PlainFeatureFactory {
    public static final String DEFAULT_TYPE_NAME = "org.esa.snap.Geometry";
    public static final String ATTRIB_NAME_GEOMETRY = "geometry";
    public static final String ATTRIB_NAME_STYLE_CSS = "style_css";

    public static SimpleFeatureType createDefaultFeatureType() {
        return PlainFeatureFactory.createDefaultFeatureType((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    public static SimpleFeatureType createDefaultFeatureType(CoordinateReferenceSystem crs) {
        return PlainFeatureFactory.createPlainFeatureType(DEFAULT_TYPE_NAME, Geometry.class, crs);
    }

    public static SimpleFeatureType createPlainFeatureType(String typeName, Class<? extends Geometry> geometryType, CoordinateReferenceSystem crs) {
        SimpleFeatureTypeBuilder sftb = new SimpleFeatureTypeBuilder();
        AttributeTypeBuilder atb = new AttributeTypeBuilder();
        if (crs != null) {
            atb.setCRS(crs);
        }
        atb.setBinding(geometryType);
        atb.nillable(false);
        sftb.add(atb.buildDescriptor(ATTRIB_NAME_GEOMETRY));
        sftb.setDefaultGeometry(ATTRIB_NAME_GEOMETRY);
        atb.setBinding(String.class);
        atb.nillable(true);
        sftb.add(atb.buildDescriptor(ATTRIB_NAME_STYLE_CSS));
        sftb.setName(typeName);
        return sftb.buildFeatureType();
    }

    public static SimpleFeature createPlainFeature(SimpleFeatureType type, String id, Geometry geometry, String styleCSS) {
        SimpleFeatureBuilder sfb = new SimpleFeatureBuilder(type);
        sfb.set(ATTRIB_NAME_GEOMETRY, (Object)geometry);
        sfb.set(ATTRIB_NAME_STYLE_CSS, (Object)styleCSS);
        return sfb.buildFeature(id);
    }
}

