/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import com.bc.ceres.core.Assert;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.PlacemarkGroup;
import org.esa.snap.core.datamodel.Product;

public class PlacemarkNameFactory {
    private PlacemarkNameFactory() {
    }

    public static String[] createUniqueNameAndLabel(PlacemarkDescriptor placemarkDescriptor, Product product) {
        PlacemarkGroup placemarkGroup = placemarkDescriptor.getPlacemarkGroup(product);
        int pinNumber = placemarkGroup.getNodeCount() + 1;
        String name = PlacemarkNameFactory.createName(placemarkDescriptor, pinNumber);
        while (placemarkGroup.get(name) != null) {
            name = PlacemarkNameFactory.createName(placemarkDescriptor, ++pinNumber);
        }
        String label = PlacemarkNameFactory.createLabel(placemarkDescriptor, pinNumber, true);
        return new String[]{name, label};
    }

    public static String createLabel(PlacemarkDescriptor placemarkDescriptor, int pinNumber, boolean firstLetterIsUpperCase) {
        Assert.argument((placemarkDescriptor.getRoleLabel().length() > 0 ? 1 : 0) != 0, (String)"placemarkDescriptor.getRoleLabel()");
        Object name = placemarkDescriptor.getRoleLabel();
        if (firstLetterIsUpperCase) {
            name = ((String)name).substring(0, 1).toUpperCase() + ((String)name).substring(1);
        }
        return (String)name + " " + pinNumber;
    }

    public static String createName(PlacemarkDescriptor placemarkDescriptor, int pinNumber) {
        return placemarkDescriptor.getRoleName() + "_" + pinNumber;
    }
}

