/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.math.MathUtils;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.util.XRectangle2D;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class ImageGeometry {
    private double referencePixelX;
    private double referencePixelY;
    private double easting;
    private double northing;
    private double orientation;
    private double pixelSizeX;
    private double pixelSizeY;
    private AffineTransform i2m;
    private int width;
    private int height;
    private CoordinateReferenceSystem mapCrs;

    private ImageGeometry() {
    }

    public ImageGeometry(Rectangle bounds, CoordinateReferenceSystem mapCrs, AffineTransform image2map) {
        this.i2m = image2map;
        this.width = bounds.width;
        this.height = bounds.height;
        this.mapCrs = mapCrs;
    }

    public AffineTransform getImage2MapTransform() {
        if (this.i2m != null) {
            return this.i2m;
        }
        return ImageGeometry.createImageToMapTransform(this.referencePixelX, this.referencePixelY, this.easting, this.northing, this.pixelSizeX, this.pixelSizeY, this.orientation);
    }

    public Rectangle getImageRect() {
        return new Rectangle(this.width, this.height);
    }

    public CoordinateReferenceSystem getMapCrs() {
        return this.mapCrs;
    }

    public void changeYAxisDirection() {
        this.pixelSizeY = -this.pixelSizeY;
    }

    public double getReferencePixelX() {
        return this.referencePixelX;
    }

    public double getReferencePixelY() {
        return this.referencePixelY;
    }

    public double getEasting() {
        return this.easting;
    }

    public double getNorthing() {
        return this.northing;
    }

    public double getOrientation() {
        return this.orientation;
    }

    public double getPixelSizeX() {
        return this.pixelSizeX;
    }

    public double getPixelSizeY() {
        return this.pixelSizeY;
    }

    public static Point2D calculateEastingNorthing(Product sourceProduct, CoordinateReferenceSystem targetCrs, double referencePixelX, double referencePixelY, double pixelSizeX, double pixelSizeY) {
        Rectangle2D mapBoundary = ImageGeometry.createMapBoundary(sourceProduct, targetCrs);
        double easting = mapBoundary.getX() + referencePixelX * pixelSizeX;
        double northing = mapBoundary.getY() + mapBoundary.getHeight() - referencePixelY * pixelSizeY;
        return new Point2D.Double(easting, northing);
    }

    public static Rectangle calculateProductSize(Product sourceProduct, CoordinateReferenceSystem targetCrs, double pixelSizeX, double pixelSizeY) {
        Rectangle2D mapBoundary = ImageGeometry.createMapBoundary(sourceProduct, targetCrs);
        double mapW = mapBoundary.getWidth();
        double mapH = mapBoundary.getHeight();
        int width = 1 + (int)Math.floor(mapW / pixelSizeX);
        int height = 1 + (int)Math.floor(mapH / pixelSizeY);
        return new Rectangle(width, height);
    }

    public static ImageGeometry createTargetGeometry(RasterDataNode rasterDataNode, CoordinateReferenceSystem targetCrs, Double pixelSizeX, Double pixelSizeY, Integer width, Integer height, Double orientation, Double easting, Double northing, Double referencePixelX, Double referencePixelY) {
        return ImageGeometry.createTargetGeometry(ImageGeometry.createMapBoundary(rasterDataNode, targetCrs), rasterDataNode.getRasterWidth(), rasterDataNode.getRasterHeight(), targetCrs, pixelSizeX, pixelSizeY, width, height, orientation, easting, northing, referencePixelX, referencePixelY);
    }

    public static ImageGeometry createTargetGeometry(Product sourceProduct, CoordinateReferenceSystem targetCrs, Double pixelSizeX, Double pixelSizeY, Integer width, Integer height, Double orientation, Double easting, Double northing, Double referencePixelX, Double referencePixelY) {
        return ImageGeometry.createTargetGeometry(ImageGeometry.createMapBoundary(sourceProduct, targetCrs), sourceProduct.getSceneRasterWidth(), sourceProduct.getSceneRasterHeight(), targetCrs, pixelSizeX, pixelSizeY, width, height, orientation, easting, northing, referencePixelX, referencePixelY);
    }

    private static ImageGeometry createTargetGeometry(Rectangle2D mapBoundary, int sourceWidth, int sourceHeight, CoordinateReferenceSystem targetCrs, Double pixelSizeX, Double pixelSizeY, Integer width, Integer height, Double orientation, Double easting, Double northing, Double referencePixelX, Double referencePixelY) {
        ImageGeometry ig = new ImageGeometry();
        ig.mapCrs = targetCrs;
        ig.orientation = orientation == null ? 0.0 : orientation;
        double mapW = mapBoundary.getWidth();
        double mapH = mapBoundary.getHeight();
        if (pixelSizeX == null || pixelSizeY == null) {
            double pixelSize = Math.min(mapW / (double)sourceWidth, mapH / (double)sourceHeight);
            if (MathUtils.equalValues(pixelSize, 0.0)) {
                pixelSize = 1.0;
            }
            ig.pixelSizeX = pixelSize;
            ig.pixelSizeY = pixelSize;
        } else {
            ig.pixelSizeX = pixelSizeX;
            ig.pixelSizeY = pixelSizeY;
        }
        ig.width = width == null ? 1 + (int)Math.floor(mapW / ig.pixelSizeX) : width;
        ig.height = height == null ? 1 + (int)Math.floor(mapH / ig.pixelSizeY) : height;
        if (referencePixelX == null || referencePixelY == null) {
            ig.referencePixelX = 0.5 * (double)ig.width;
            ig.referencePixelY = 0.5 * (double)ig.height;
        } else {
            ig.referencePixelX = referencePixelX;
            ig.referencePixelY = referencePixelY;
        }
        if (easting == null || northing == null) {
            ig.easting = mapBoundary.getX() + ig.referencePixelX * ig.pixelSizeX;
            ig.northing = mapBoundary.getY() + mapBoundary.getHeight() - ig.referencePixelY * ig.pixelSizeY;
        } else {
            ig.easting = easting;
            ig.northing = northing;
        }
        return ig;
    }

    public static ImageGeometry createCollocationTargetGeometry(Product targetProduct, Product collocationProduct) {
        GeoCoding geoCoding = collocationProduct.getSceneGeoCoding();
        AffineTransform modelTransform = Product.findImageToModelTransform(geoCoding);
        double pixelSizeX = modelTransform.getScaleX();
        double pixelSizeY = modelTransform.getScaleY();
        int width = collocationProduct.getSceneRasterWidth();
        int height = collocationProduct.getSceneRasterHeight();
        double easting = modelTransform.getTranslateX();
        double northing = modelTransform.getTranslateY();
        double referencePixelY = 0.0;
        double referencePixelX = 0.0;
        return ImageGeometry.createTargetGeometry(targetProduct, collocationProduct.getSceneCRS(), (Double)pixelSizeX, (Double)pixelSizeY, (Integer)width, (Integer)height, null, (Double)easting, (Double)northing, (Double)0.0, (Double)0.0);
    }

    private static Rectangle2D createMapBoundary(RasterDataNode rdn, CoordinateReferenceSystem targetCrs) {
        try {
            GeoCoding geoCoding = rdn.getGeoCoding();
            int sourceW = rdn.getRasterWidth();
            int sourceH = rdn.getRasterHeight();
            return ImageGeometry.createMapBoundary(geoCoding, sourceW, sourceH, targetCrs);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    static Rectangle2D createMapBoundary(Product product, CoordinateReferenceSystem targetCrs) {
        try {
            GeoCoding sceneGeoCoding = product.getSceneGeoCoding();
            int sourceW = product.getSceneRasterWidth();
            int sourceH = product.getSceneRasterHeight();
            return ImageGeometry.createMapBoundary(sceneGeoCoding, sourceW, sourceH, targetCrs);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static Rectangle2D createMapBoundary(GeoCoding geoCoding, int sourceW, int sourceH, CoordinateReferenceSystem targetCrs) throws TransformException, FactoryException {
        CoordinateReferenceSystem sourceCrs = geoCoding.getImageCRS();
        XRectangle2D rect = XRectangle2D.createFromExtremums((double)0.0, (double)0.0, (double)sourceW, (double)sourceH);
        int pointsPerSide = Math.max(sourceH, sourceW) / 10;
        pointsPerSide = Math.max(9, pointsPerSide);
        ReferencedEnvelope sourceEnvelope = new ReferencedEnvelope((Rectangle2D)rect, sourceCrs);
        ReferencedEnvelope targetEnvelope = sourceEnvelope.transform(targetCrs, true, pointsPerSide);
        double minX = targetEnvelope.getMinX();
        double width = targetEnvelope.getWidth();
        if (geoCoding.isCrossingMeridianAt180()) {
            minX = -180.0;
            width = 360.0;
        }
        return new Rectangle2D.Double(minX, targetEnvelope.getMinY(), width, targetEnvelope.getHeight());
    }

    static AffineTransform createImageToMapTransform(double referencePixelX, double referencePixelY, double easting, double northing, double pixelSizeX, double pixelSizeY, double orientation) {
        AffineTransform i2m = new AffineTransform();
        i2m.translate(easting, northing);
        i2m.scale(pixelSizeX, pixelSizeY);
        i2m.rotate(Math.toRadians(-orientation));
        i2m.translate(-referencePixelX, -referencePixelY);
        return i2m;
    }
}

