/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.util.GeoUtils;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.math.Range;

public class Graticule {
    private static final double ONE_MINUTE = 0.016666666666666666;
    private static final double TEN_MINUTES = 0.16666666666666666;
    private final GeneralPath[] _linePaths;
    private final TextGlyph[] _textGlyphsNorth;
    private final TextGlyph[] _textGlyphsSouth;
    private final TextGlyph[] _textGlyphsWest;
    private final TextGlyph[] _textGlyphsEast;
    private final TextGlyph[] _textGlyphsLatCorners;
    private final TextGlyph[] _textGlyphsLonCorners;
    private final PixelPos[] _tickPointsNorth;
    private final PixelPos[] _tickPointsSouth;
    private final PixelPos[] _tickPointsWest;
    private final PixelPos[] _tickPointsEast;
    public static int TOP_LEFT_CORNER_INDEX = 0;
    public static int TOP_RIGHT_CORNER_INDEX = 1;
    public static int BOTTOM_RIGHT_CORNER_INDEX = 2;
    public static int BOTTOM_LEFT_CORNER_INDEX = 3;

    private Graticule(GeneralPath[] paths, TextGlyph[] textGlyphsNorth, TextGlyph[] textGlyphsSouth, TextGlyph[] textGlyphsWest, TextGlyph[] textGlyphsEast, TextGlyph[] textGlyphsLatCorners, TextGlyph[] textGlyphsLonCorners, PixelPos[] tickPointsNorth, PixelPos[] tickPointsSouth, PixelPos[] tickPointsWest, PixelPos[] tickPointsEast) {
        this._linePaths = paths;
        this._textGlyphsNorth = textGlyphsNorth;
        this._textGlyphsSouth = textGlyphsSouth;
        this._textGlyphsWest = textGlyphsWest;
        this._textGlyphsEast = textGlyphsEast;
        this._textGlyphsLatCorners = textGlyphsLatCorners;
        this._textGlyphsLonCorners = textGlyphsLonCorners;
        this._tickPointsNorth = tickPointsNorth;
        this._tickPointsSouth = tickPointsSouth;
        this._tickPointsWest = tickPointsWest;
        this._tickPointsEast = tickPointsEast;
    }

    public GeneralPath[] getLinePaths() {
        return this._linePaths;
    }

    public TextGlyph[] getTextGlyphsNorth() {
        return this._textGlyphsNorth;
    }

    public TextGlyph[] getTextGlyphsSouth() {
        return this._textGlyphsSouth;
    }

    public TextGlyph[] getTextGlyphsWest() {
        return this._textGlyphsWest;
    }

    public TextGlyph[] getTextGlyphsEast() {
        return this._textGlyphsEast;
    }

    public TextGlyph[] getTextGlyphsLatCorners() {
        return this._textGlyphsLatCorners;
    }

    public TextGlyph[] getTextGlyphsLonCorners() {
        return this._textGlyphsLonCorners;
    }

    public PixelPos[] getTickPointsNorth() {
        return this._tickPointsNorth;
    }

    public PixelPos[] getTickPointsSouth() {
        return this._tickPointsSouth;
    }

    public PixelPos[] getTickPointsWest() {
        return this._tickPointsWest;
    }

    public PixelPos[] getTickPointsEast() {
        return this._tickPointsEast;
    }

    public static Graticule create(RasterDataNode raster, int desiredNumGridLines, double latMajorStep, double lonMajorStep, boolean formatCompass, boolean decimalFormat) {
        double ratio;
        Guardian.assertNotNull("product", raster);
        GeoCoding geoCoding = raster.getGeoCoding();
        if (geoCoding == null || raster.getRasterWidth() < 16 || raster.getRasterHeight() < 16) {
            return null;
        }
        if (desiredNumGridLines <= 1) {
            desiredNumGridLines = 2;
        }
        GeoPos geoDelta = Graticule.getGeoDelta(geoCoding, raster);
        if (latMajorStep == 0.0) {
            int height = raster.getRasterHeight();
            ratio = height / (desiredNumGridLines - 1);
            double tmpLatMajorStep = ratio * geoDelta.lat;
            latMajorStep = Graticule.getSensibleDegreeIncrement(tmpLatMajorStep);
        }
        if (lonMajorStep == 0.0) {
            int width = raster.getRasterWidth();
            ratio = width / (desiredNumGridLines - 1);
            double tmpLonMajorStep = ratio * geoDelta.lon;
            lonMajorStep = Graticule.getSensibleDegreeIncrement(tmpLonMajorStep);
        }
        int desiredMinorSteps = Graticule.getDesiredMinorSteps(raster);
        double ratioLatMinor = raster.getRasterHeight() / (desiredMinorSteps - 1);
        double latMinorStep = ratioLatMinor * geoDelta.lat;
        double ratioLonMinor = raster.getRasterHeight() / (desiredMinorSteps - 1);
        double lonMinorStep = ratioLonMinor * geoDelta.lon;
        int geoBoundaryStep = Graticule.getGeoBoundaryStep(geoCoding, raster);
        GeoPos[] geoBoundary = Graticule.createGeoBoundary(raster, geoBoundaryStep);
        Range[] ranges = Graticule.getRanges(geoBoundary);
        Range lonRange = ranges[0];
        Range latRange = ranges[1];
        List<List<Coord>> meridianList = Graticule.computeMeridianList(raster.getGeoCoding(), geoBoundary, lonMajorStep, latMinorStep, lonRange.getMin(), lonRange.getMax());
        List<List<Coord>> parallelList = Graticule.computeParallelList(raster.getGeoCoding(), geoBoundary, latMajorStep, lonMinorStep, latRange.getMin(), latRange.getMax());
        if (parallelList.size() > 0 && meridianList.size() > 0) {
            GeneralPath[] paths = Graticule.createPaths(parallelList, meridianList);
            TextGlyph[] textGlyphsNorth = Graticule.createTextGlyphs(parallelList, meridianList, TextLocation.NORTH, formatCompass, decimalFormat);
            TextGlyph[] textGlyphsSouth = Graticule.createTextGlyphs(parallelList, meridianList, TextLocation.SOUTH, formatCompass, decimalFormat);
            TextGlyph[] textGlyphsWest = Graticule.createTextGlyphs(parallelList, meridianList, TextLocation.WEST, formatCompass, decimalFormat);
            TextGlyph[] textGlyphsEast = Graticule.createTextGlyphs(parallelList, meridianList, TextLocation.EAST, formatCompass, decimalFormat);
            TextGlyph[] textGlyphsLatCorners = Graticule.createLatCornerTextGlyphs(raster, formatCompass, decimalFormat);
            TextGlyph[] textGlyphsLonCorners = Graticule.createLonCornerTextGlyphs(raster, formatCompass, decimalFormat);
            PixelPos[] tickPointsNorth = Graticule.createTickPoints(parallelList, meridianList, TextLocation.NORTH);
            PixelPos[] tickPointsSouth = Graticule.createTickPoints(parallelList, meridianList, TextLocation.SOUTH);
            PixelPos[] tickPointsWest = Graticule.createTickPoints(parallelList, meridianList, TextLocation.WEST);
            PixelPos[] tickPointsEast = Graticule.createTickPoints(parallelList, meridianList, TextLocation.EAST);
            return new Graticule(paths, textGlyphsNorth, textGlyphsSouth, textGlyphsWest, textGlyphsEast, textGlyphsLatCorners, textGlyphsLonCorners, tickPointsNorth, tickPointsSouth, tickPointsWest, tickPointsEast);
        }
        return new Graticule(null, null, null, null, null, null, null, null, null, null, null);
    }

    private static GeoPos[] createGeoBoundary(RasterDataNode raster, int geoBoundaryStep) {
        GeoPos[] geoBoundary = GeoUtils.createGeoBoundary(raster, null, geoBoundaryStep);
        GeoPos[] fullGeoBoundary = new GeoPos[geoBoundary.length + 1];
        System.arraycopy(geoBoundary, 0, fullGeoBoundary, 0, geoBoundary.length);
        fullGeoBoundary[fullGeoBoundary.length - 1] = geoBoundary[0];
        ProductUtils.normalizeGeoPolygon(fullGeoBoundary);
        return fullGeoBoundary;
    }

    static int getDesiredMinorSteps(RasterDataNode raster) {
        int desiredMinorSteps = (int)Math.min((double)raster.getRasterHeight() / 4.0, (double)raster.getRasterWidth() / 4.0);
        if (desiredMinorSteps > 200) {
            desiredMinorSteps = 200;
        } else if (desiredMinorSteps < 3) {
            desiredMinorSteps = 3;
        }
        return desiredMinorSteps;
    }

    static double getSensibleDegreeIncrement(double degreeIncrement) {
        if (degreeIncrement > 30.0) {
            return 30.0;
        }
        if (degreeIncrement >= 5.0) {
            return 5.0 * (double)Math.round(degreeIncrement / 5.0);
        }
        if (degreeIncrement >= 1.0) {
            return Math.round(degreeIncrement);
        }
        if (degreeIncrement >= 0.16666666666666666) {
            return (double)Math.round(6.0 * degreeIncrement) / 6.0;
        }
        if (degreeIncrement >= 0.016666666666666666) {
            return (double)Math.round(60.0 * degreeIncrement) / 60.0;
        }
        return 0.016666666666666666;
    }

    static int getGeoBoundaryStep(GeoCoding geoCoding, RasterDataNode raster) {
        double minDimensionLength = Math.min(raster.getRasterHeight(), raster.getRasterWidth());
        int step = (int)Math.floor(minDimensionLength / 50.0);
        if (step < 1) {
            step = 1;
        }
        if (geoCoding instanceof TiePointGeoCoding) {
            TiePointGeoCoding tiePointGeoCoding = (TiePointGeoCoding)geoCoding;
            step = Math.round((int)Math.min(tiePointGeoCoding.getLonGrid().getSubSamplingX(), tiePointGeoCoding.getLonGrid().getSubSamplingY()));
        }
        return step;
    }

    private static List<List<Coord>> computeParallelList(GeoCoding geoCoding, GeoPos[] geoBoundary, double latMajorStep, double lonMinorStep, double yMin, double yMax) {
        ArrayList<List<Coord>> parallelList = new ArrayList<List<Coord>>();
        ArrayList<GeoPos> intersectionList = new ArrayList<GeoPos>();
        for (double my = latMajorStep * Math.floor(yMin / latMajorStep); my <= yMax; my += latMajorStep) {
            intersectionList.clear();
            Graticule.computeParallelIntersections(geoBoundary, my, intersectionList);
            if (intersectionList.size() <= 0 || intersectionList.size() % 2 != 0) continue;
            GeoPos[] intersections = intersectionList.toArray(new GeoPos[0]);
            Arrays.sort(intersections, new GeoPosLonComparator());
            ArrayList<Coord> parallel = new ArrayList<Coord>();
            for (int i = 0; i < intersections.length; i += 2) {
                GeoPos int1 = intersections[i];
                GeoPos int2 = intersections[i + 1];
                double lat = int1.lat;
                double lon = int1.lon;
                int k = 0;
                while (k <= 1) {
                    GeoPos geoPos = new GeoPos(lat, Graticule.limitLon(lon));
                    PixelPos pixelPos = geoCoding.getPixelPos(geoPos, null);
                    if (pixelPos.isValid()) {
                        parallel.add(new Coord(geoPos, pixelPos));
                    }
                    if (!((lon += lonMinorStep) >= int2.lon)) continue;
                    lon = int2.lon;
                    ++k;
                }
            }
            parallelList.add(parallel);
        }
        return parallelList;
    }

    private static List<List<Coord>> computeMeridianList(GeoCoding geoCoding, GeoPos[] geoBoundary, double lonMajorStep, double latMinorStep, double xMin, double xMax) {
        ArrayList<List<Coord>> meridianList = new ArrayList<List<Coord>>();
        ArrayList<GeoPos> intersectionList = new ArrayList<GeoPos>();
        for (double mx = lonMajorStep * Math.floor(xMin / lonMajorStep); mx <= xMax; mx += lonMajorStep) {
            intersectionList.clear();
            Graticule.computeMeridianIntersections(geoBoundary, mx, intersectionList);
            if (intersectionList.size() <= 0 || intersectionList.size() % 2 != 0) continue;
            GeoPos[] intersections = intersectionList.toArray(new GeoPos[0]);
            Arrays.sort(intersections, new GeoPosLatComparator());
            ArrayList<Coord> meridian = new ArrayList<Coord>();
            for (int i = intersections.length - 2; i >= 0; i -= 2) {
                GeoPos int1 = intersections[i + 1];
                GeoPos int2 = intersections[i];
                double lat = int1.lat;
                double lon = int1.lon;
                int k = 0;
                while (k <= 1) {
                    GeoPos geoPos = new GeoPos(lat, Graticule.limitLon(lon));
                    PixelPos pixelPos = geoCoding.getPixelPos(geoPos, null);
                    if (pixelPos.isValid()) {
                        meridian.add(new Coord(geoPos, pixelPos));
                    }
                    if (!((lat -= latMinorStep) <= int2.lat)) continue;
                    lat = int2.lat;
                    ++k;
                }
            }
            meridianList.add(meridian);
        }
        return meridianList;
    }

    static void computeParallelIntersections(GeoPos[] geoBoundary, double lat, List<GeoPos> intersectionList) {
        GeoPos geoPos = geoBoundary[0];
        double lonBoundaryPrev = geoPos.lon;
        double latBoundaryPrev = geoPos.lat;
        for (int i = 1; i < geoBoundary.length; ++i) {
            double interpolationWeight;
            geoPos = geoBoundary[i];
            double lonBoundaryCurr = geoPos.lon;
            double latBoundaryCurr = geoPos.lat;
            if (latBoundaryCurr != latBoundaryPrev && (lat >= latBoundaryPrev && lat <= latBoundaryCurr || lat >= latBoundaryCurr && lat <= latBoundaryPrev) && (interpolationWeight = (lat - latBoundaryPrev) / (latBoundaryCurr - latBoundaryPrev)) >= 0.0 && interpolationWeight < 1.0) {
                double lon = lonBoundaryPrev + interpolationWeight * (lonBoundaryCurr - lonBoundaryPrev);
                intersectionList.add(new GeoPos(lat, lon));
            }
            lonBoundaryPrev = lonBoundaryCurr;
            latBoundaryPrev = latBoundaryCurr;
        }
    }

    static void computeMeridianIntersections(GeoPos[] geoBoundary, double lon, List<GeoPos> intersectionList) {
        GeoPos geoPos = geoBoundary[0];
        double lonBoundaryPrev = geoPos.lon;
        double latBoundaryPrev = geoPos.lat;
        for (int i = 1; i < geoBoundary.length; ++i) {
            double interpolationWeight;
            geoPos = geoBoundary[i];
            double lonBoundaryCurr = geoPos.lon;
            double latBoundaryCurr = geoPos.lat;
            if (lonBoundaryCurr != lonBoundaryPrev && (lon >= lonBoundaryPrev && lon <= lonBoundaryCurr || lon >= lonBoundaryCurr && lon <= lonBoundaryPrev) && (interpolationWeight = (lon - lonBoundaryPrev) / (lonBoundaryCurr - lonBoundaryPrev)) >= 0.0 && interpolationWeight < 1.0) {
                double lat = latBoundaryPrev + interpolationWeight * (latBoundaryCurr - latBoundaryPrev);
                intersectionList.add(new GeoPos(lat, lon));
            }
            lonBoundaryPrev = lonBoundaryCurr;
            latBoundaryPrev = latBoundaryCurr;
        }
    }

    private static GeneralPath[] createPaths(List<List<Coord>> parallelList, List<List<Coord>> meridianList) {
        ArrayList<GeneralPath> generalPathList = new ArrayList<GeneralPath>();
        Graticule.addToPath(parallelList, generalPathList);
        Graticule.addToPath(meridianList, generalPathList);
        return generalPathList.toArray(new GeneralPath[0]);
    }

    private static void addToPath(List<List<Coord>> lineList, List<GeneralPath> generalPathList) {
        for (List<Coord> coordList : lineList) {
            if (coordList.size() < 2) continue;
            GeneralPath generalPath = new GeneralPath();
            boolean restart = true;
            for (Coord coord : coordList) {
                PixelPos pixelPos = coord.pixelPos;
                if (pixelPos.isValid()) {
                    if (restart) {
                        generalPath.moveTo(pixelPos.x, pixelPos.y);
                    } else {
                        generalPath.lineTo(pixelPos.x, pixelPos.y);
                    }
                    restart = false;
                    continue;
                }
                restart = true;
            }
            generalPathList.add(generalPath);
        }
    }

    private static TextGlyph[] createLonCornerTextGlyphs(RasterDataNode raster, boolean formatCompass, boolean formatDecimal) {
        TextGlyph[] textGlyphs = new TextGlyph[4];
        GeoCoding geoCoding = raster.getGeoCoding();
        if (geoCoding != null && raster.getRasterHeight() >= 2 && raster.getRasterWidth() >= 2) {
            PixelPos pixelPos1 = new PixelPos(0.0, 0.0);
            PixelPos pixelPos2 = new PixelPos(0.0, 1.0);
            textGlyphs[Graticule.TOP_LEFT_CORNER_INDEX] = Graticule.getLonCornerTextGlyph(geoCoding, pixelPos1, pixelPos2, formatCompass, formatDecimal);
            pixelPos1 = new PixelPos(raster.getRasterWidth(), 0.0);
            pixelPos2 = new PixelPos(raster.getRasterWidth(), 1.0);
            textGlyphs[Graticule.TOP_RIGHT_CORNER_INDEX] = Graticule.getLonCornerTextGlyph(geoCoding, pixelPos1, pixelPos2, formatCompass, formatDecimal);
            pixelPos1 = new PixelPos(raster.getRasterWidth(), raster.getRasterHeight());
            pixelPos2 = new PixelPos(raster.getRasterWidth(), raster.getRasterHeight() - 1);
            textGlyphs[Graticule.BOTTOM_RIGHT_CORNER_INDEX] = Graticule.getLonCornerTextGlyph(geoCoding, pixelPos1, pixelPos2, formatCompass, formatDecimal);
            pixelPos1 = new PixelPos(0.0, raster.getRasterHeight());
            pixelPos2 = new PixelPos(0.0, raster.getRasterHeight() - 1);
            textGlyphs[Graticule.BOTTOM_LEFT_CORNER_INDEX] = Graticule.getLonCornerTextGlyph(geoCoding, pixelPos1, pixelPos2, formatCompass, formatDecimal);
        }
        return textGlyphs;
    }

    private static TextGlyph[] createLatCornerTextGlyphs(RasterDataNode raster, boolean formatCompass, boolean formatDecimal) {
        TextGlyph[] textGlyphs = new TextGlyph[4];
        GeoCoding geoCoding = raster.getGeoCoding();
        if (geoCoding != null && raster.getRasterHeight() >= 2 && raster.getRasterWidth() >= 2) {
            PixelPos pixelPos1 = new PixelPos(0.0, 0.0);
            PixelPos pixelPos2 = new PixelPos(1.0, 0.0);
            textGlyphs[Graticule.TOP_LEFT_CORNER_INDEX] = Graticule.getLatCornerTextGlyph(geoCoding, pixelPos1, pixelPos2, formatCompass, formatDecimal);
            pixelPos1 = new PixelPos(raster.getRasterWidth(), 0.0);
            pixelPos2 = new PixelPos(raster.getRasterWidth() - 1, 0.0);
            textGlyphs[Graticule.TOP_RIGHT_CORNER_INDEX] = Graticule.getLatCornerTextGlyph(geoCoding, pixelPos1, pixelPos2, formatCompass, formatDecimal);
            pixelPos1 = new PixelPos(raster.getRasterWidth(), raster.getRasterHeight());
            pixelPos2 = new PixelPos(raster.getRasterWidth() - 1, raster.getRasterHeight());
            textGlyphs[Graticule.BOTTOM_RIGHT_CORNER_INDEX] = Graticule.getLatCornerTextGlyph(geoCoding, pixelPos1, pixelPos2, formatCompass, formatDecimal);
            pixelPos1 = new PixelPos(0.0, raster.getRasterHeight());
            pixelPos2 = new PixelPos(1.0, raster.getRasterHeight());
            textGlyphs[Graticule.BOTTOM_LEFT_CORNER_INDEX] = Graticule.getLatCornerTextGlyph(geoCoding, pixelPos1, pixelPos2, formatCompass, formatDecimal);
        }
        return textGlyphs;
    }

    private static PixelPos[] createTickPoints(List<List<Coord>> latitudeGridLinePoints, List<List<Coord>> longitudeGridLinePoints, TextLocation textLocation) {
        ArrayList<PixelPos> pixelPoses = new ArrayList<PixelPos>();
        switch (textLocation) {
            case NORTH: {
                Graticule.createNorthernLongitudeTickPoints(longitudeGridLinePoints, pixelPoses);
                break;
            }
            case SOUTH: {
                Graticule.createSouthernLongitudeTickPoints(longitudeGridLinePoints, pixelPoses);
                break;
            }
            case WEST: {
                Graticule.createWesternLatitudeTickPoints(latitudeGridLinePoints, pixelPoses);
                break;
            }
            case EAST: {
                Graticule.createEasternLatitudeTickPoints(latitudeGridLinePoints, pixelPoses);
            }
        }
        return pixelPoses.toArray(new PixelPos[0]);
    }

    private static TextGlyph[] createTextGlyphs(List<List<Coord>> latitudeGridLinePoints, List<List<Coord>> longitudeGridLinePoints, TextLocation textLocation, boolean formatCompass, boolean formatDecimal) {
        ArrayList<TextGlyph> textGlyphs = new ArrayList<TextGlyph>();
        switch (textLocation) {
            case NORTH: {
                Graticule.createNorthernLongitudeTextGlyphs(longitudeGridLinePoints, textGlyphs, formatCompass, formatDecimal);
                break;
            }
            case SOUTH: {
                Graticule.createSouthernLongitudeTextGlyphs(longitudeGridLinePoints, textGlyphs, formatCompass, formatDecimal);
                break;
            }
            case WEST: {
                Graticule.createWesternLatitudeTextGlyphs(latitudeGridLinePoints, textGlyphs, formatCompass, formatDecimal);
                break;
            }
            case EAST: {
                Graticule.createEasternLatitudeTextGlyphs(latitudeGridLinePoints, textGlyphs, formatCompass, formatDecimal);
            }
        }
        return textGlyphs.toArray(new TextGlyph[0]);
    }

    private static void createWesternLatitudeTickPoints(List<List<Coord>> latitudeGridLinePoints, List<PixelPos> pixelPoses) {
        for (List<Coord> latitudeGridLinePoint : latitudeGridLinePoints) {
            if (latitudeGridLinePoint.size() < 2) continue;
            int first = 0;
            Coord coord = latitudeGridLinePoint.get(first);
            if (!coord.pixelPos.isValid()) continue;
            pixelPoses.add(coord.pixelPos);
        }
    }

    private static void createWesternLatitudeTextGlyphs(List<List<Coord>> latitudeGridLinePoints, List<TextGlyph> textGlyphs, boolean formatCompass, boolean formatDecimal) {
        for (List<Coord> latitudeGridLinePoint : latitudeGridLinePoints) {
            if (latitudeGridLinePoint.size() < 2) continue;
            int first = 0;
            int second = 1;
            Coord coord1 = latitudeGridLinePoint.get(first);
            Coord coord2 = latitudeGridLinePoint.get(second);
            PixelPos pixelPos2 = new PixelPos((float)(coord1.pixelPos.getX() + 1.0), (float)coord1.pixelPos.getY());
            coord2 = new Coord(coord1.geoPos, pixelPos2);
            if (!Graticule.isCoordPairValid(coord1, coord2)) continue;
            TextGlyph textGlyph = Graticule.createTextGlyph(coord1.geoPos.getLatString(formatCompass, formatDecimal), coord1, coord2);
            textGlyphs.add(textGlyph);
        }
    }

    private static void createEasternLatitudeTickPoints(List<List<Coord>> latitudeGridLinePoints, List<PixelPos> pixelPoses) {
        for (List<Coord> latitudeGridLinePoint : latitudeGridLinePoints) {
            if (latitudeGridLinePoint.size() < 2) continue;
            int last = latitudeGridLinePoint.size() - 1;
            Coord coord = latitudeGridLinePoint.get(last);
            if (!coord.pixelPos.isValid()) continue;
            pixelPoses.add(coord.pixelPos);
        }
    }

    private static void createEasternLatitudeTextGlyphs(List<List<Coord>> latitudeGridLinePoints, List<TextGlyph> textGlyphs, boolean formatCompass, boolean formatDecimal) {
        for (List<Coord> latitudeGridLinePoint : latitudeGridLinePoints) {
            if (latitudeGridLinePoint.size() < 2) continue;
            int last = latitudeGridLinePoint.size() - 1;
            int nextToLast = last - 1;
            Coord coord1 = latitudeGridLinePoint.get(last);
            Coord coord2 = latitudeGridLinePoint.get(nextToLast);
            PixelPos pixelPos2 = new PixelPos((float)(coord1.pixelPos.getX() - 1.0), (float)coord1.pixelPos.getY());
            coord2 = new Coord(coord1.geoPos, pixelPos2);
            if (!Graticule.isCoordPairValid(coord1, coord2)) continue;
            TextGlyph textGlyph = Graticule.createTextGlyph(coord1.geoPos.getLatString(formatCompass, formatDecimal), coord1, coord2);
            textGlyphs.add(textGlyph);
        }
    }

    private static void createNorthernLongitudeTickPoints(List<List<Coord>> longitudeGridLinePoints, List<PixelPos> pixelPoses) {
        for (List<Coord> longitudeGridLinePoint : longitudeGridLinePoints) {
            if (longitudeGridLinePoint.size() < 2) continue;
            int first = 0;
            Coord coord = longitudeGridLinePoint.get(first);
            if (!coord.pixelPos.isValid()) continue;
            pixelPoses.add(coord.pixelPos);
        }
    }

    private static void createNorthernLongitudeTextGlyphs(List<List<Coord>> longitudeGridLinePoints, List<TextGlyph> textGlyphs, boolean formatCompass, boolean formatDecimal) {
        for (List<Coord> longitudeGridLinePoint : longitudeGridLinePoints) {
            if (longitudeGridLinePoint.size() < 2) continue;
            int first = 0;
            int second = 1;
            Coord coord1 = longitudeGridLinePoint.get(first);
            Coord coord2 = longitudeGridLinePoint.get(second);
            PixelPos pixelPos2 = new PixelPos((float)coord1.pixelPos.getX(), (float)(coord1.pixelPos.getY() + 1.0));
            coord2 = new Coord(coord1.geoPos, pixelPos2);
            if (!Graticule.isCoordPairValid(coord1, coord2)) continue;
            TextGlyph textGlyph = Graticule.createTextGlyph(coord1.geoPos.getLonString(formatCompass, formatDecimal), coord1, coord2);
            textGlyphs.add(textGlyph);
        }
    }

    static void createSouthernLongitudeTickPoints(List<List<Coord>> longitudeGridLinePoints, List<PixelPos> pixelPoses) {
        for (List<Coord> longitudeGridLinePoint : longitudeGridLinePoints) {
            if (longitudeGridLinePoint.size() < 2) continue;
            int last = longitudeGridLinePoint.size() - 1;
            Coord coord = longitudeGridLinePoint.get(last);
            if (!coord.pixelPos.isValid()) continue;
            pixelPoses.add(coord.pixelPos);
        }
    }

    static void createSouthernLongitudeTextGlyphs(List<List<Coord>> longitudeGridLinePoints, List<TextGlyph> textGlyphs, boolean formatCompass, boolean formatDecimal) {
        for (List<Coord> longitudeGridLinePoint : longitudeGridLinePoints) {
            PixelPos pixelPos2;
            Coord coord2;
            int last;
            Coord coord1;
            if (longitudeGridLinePoint.size() < 2 || !Graticule.isCoordPairValid(coord1 = longitudeGridLinePoint.get(last = longitudeGridLinePoint.size() - 1), coord2 = new Coord(coord1.geoPos, pixelPos2 = new PixelPos((float)coord1.pixelPos.getX(), (float)(coord1.pixelPos.getY() - 1.0))))) continue;
            TextGlyph textGlyph = Graticule.createTextGlyph(coord1.geoPos.getLonString(formatCompass, formatDecimal), coord1, coord2);
            textGlyphs.add(textGlyph);
        }
    }

    static TextGlyph getLonCornerTextGlyph(GeoCoding geoCoding, PixelPos pixelPos1, PixelPos pixelPos2, boolean formatCompass, boolean formatDecimal) {
        GeoPos geoPos2;
        Coord coord2;
        if (geoCoding == null) {
            return null;
        }
        GeoPos geoPos1 = geoCoding.getGeoPos(pixelPos1, null);
        Coord coord1 = new Coord(geoPos1, pixelPos1);
        if (Graticule.isCoordPairValid(coord1, coord2 = new Coord(geoPos2 = geoCoding.getGeoPos(pixelPos2, null), pixelPos2))) {
            return Graticule.createTextGlyph(coord1.geoPos.getLonString(formatCompass, formatDecimal), coord1, coord2);
        }
        return null;
    }

    static TextGlyph getLatCornerTextGlyph(GeoCoding geoCoding, PixelPos pixelPos1, PixelPos pixelPos2, boolean formatCompass, boolean formatDecimal) {
        GeoPos geoPos2;
        Coord coord2;
        if (geoCoding == null) {
            return null;
        }
        GeoPos geoPos1 = geoCoding.getGeoPos(pixelPos1, null);
        Coord coord1 = new Coord(geoPos1, pixelPos1);
        if (Graticule.isCoordPairValid(coord1, coord2 = new Coord(geoPos2 = geoCoding.getGeoPos(pixelPos2, null), pixelPos2))) {
            return Graticule.createTextGlyph(coord1.geoPos.getLatString(formatCompass, formatDecimal), coord1, coord2);
        }
        return null;
    }

    static Range[] getRanges(GeoPos[] geoPositions) {
        double xMin = 1.0E10;
        double yMin = 1.0E10;
        double xMax = -1.0E10;
        double yMax = -1.0E10;
        for (GeoPos geoPos : geoPositions) {
            xMin = Math.min(xMin, geoPos.lon);
            yMin = Math.min(yMin, geoPos.lat);
            xMax = Math.max(xMax, geoPos.lon);
            yMax = Math.max(yMax, geoPos.lat);
        }
        Range[] ranges = new Range[]{new Range(xMin, xMax), new Range(yMin, yMax)};
        return ranges;
    }

    static GeoPos getGeoDelta(GeoCoding geoCoding, RasterDataNode dataNode) {
        double posX = 0.5 * (double)dataNode.getRasterWidth();
        double posy = 0.5 * (double)dataNode.getRasterHeight();
        PixelPos pixelPos_1 = new PixelPos(posX, posy);
        PixelPos pixelPos_2 = new PixelPos(posX + 1.0, posy + 1.0);
        GeoPos geoPos_1 = geoCoding.getGeoPos(pixelPos_1, null);
        GeoPos geoPos_2 = geoCoding.getGeoPos(pixelPos_2, null);
        double deltaLat = Math.abs(geoPos_2.lat - geoPos_1.lat);
        double deltaLon = Math.abs(geoPos_2.lon - geoPos_1.lon);
        if (deltaLon > 180.0) {
            deltaLon = Math.abs(deltaLon - 360.0);
        }
        return new GeoPos(deltaLat, deltaLon);
    }

    static boolean isCoordPairValid(Coord coord1, Coord coord2) {
        return coord1.pixelPos.isValid() && coord2.pixelPos.isValid();
    }

    static TextGlyph createTextGlyph(String text, Coord coord1, Coord coord2) {
        double angle = Math.atan2(coord2.pixelPos.y - coord1.pixelPos.y, coord2.pixelPos.x - coord1.pixelPos.x);
        return new TextGlyph(text, coord1.pixelPos.x, coord1.pixelPos.y, angle);
    }

    static double limitLon(double lon) {
        while (lon < -180.0) {
            lon += 360.0;
        }
        while (lon > 180.0) {
            lon -= 360.0;
        }
        return lon;
    }

    static abstract class GeoPosComparator
    implements Comparator<GeoPos> {
        GeoPosComparator() {
        }

        int getCompare(double delta) {
            if (delta < 0.0) {
                return -1;
            }
            if (delta > 0.0) {
                return 1;
            }
            return 0;
        }
    }

    static class GeoPosLonComparator
    extends GeoPosComparator {
        GeoPosLonComparator() {
        }

        @Override
        public int compare(GeoPos geoPos1, GeoPos geoPos2) {
            return this.getCompare(geoPos1.lon - geoPos2.lon);
        }
    }

    static class GeoPosLatComparator
    extends GeoPosComparator {
        GeoPosLatComparator() {
        }

        @Override
        public int compare(GeoPos geoPos1, GeoPos geoPos2) {
            return this.getCompare(geoPos1.lat - geoPos2.lat);
        }
    }

    static class Coord {
        GeoPos geoPos;
        PixelPos pixelPos;

        public Coord(GeoPos geoPos, PixelPos pixelPos) {
            this.geoPos = geoPos;
            this.pixelPos = pixelPos;
        }
    }

    public static class TextGlyph {
        private final String text;
        private final double x;
        private final double y;
        private final double angle;

        TextGlyph(String text, double x, double y, double angle) {
            this.text = text;
            this.x = x;
            this.y = y;
            this.angle = angle;
        }

        public String getText() {
            return this.text;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getAngle() {
            return this.angle;
        }
    }

    public static enum TextLocation {
        NORTH,
        SOUTH,
        WEST,
        EAST,
        TOP,
        BOTTOM,
        LEFT,
        RIGHT;

    }
}

