/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import org.esa.snap.core.util.math.MathUtils;

public class GeoPos {
    private static final double MIN_PER_DEG = 60.0;
    private static final double SEC_PER_DEG = 3600.0;
    public double lat;
    public double lon;

    public GeoPos() {
    }

    public GeoPos(GeoPos geoPos) {
        this(geoPos.lat, geoPos.lon);
    }

    public GeoPos(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    public void setLocation(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
    }

    public final boolean isValid() {
        return GeoPos.isLatValid(this.lat) && GeoPos.isLonValid(this.lon);
    }

    public static boolean areValid(GeoPos[] gepPositions) {
        for (GeoPos geoPos : gepPositions) {
            if (geoPos.isValid()) continue;
            return false;
        }
        return true;
    }

    public final void setInvalid() {
        this.lat = Double.NaN;
        this.lon = Double.NaN;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (!(obj instanceof GeoPos)) {
            return false;
        }
        GeoPos other = (GeoPos)obj;
        return other.lat == this.lat && other.lon == this.lon;
    }

    public int hashCode() {
        return (int)(Double.doubleToLongBits(this.lat) + Double.doubleToLongBits(this.lon));
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getLatString() + "," + this.getLonString() + "]";
    }

    public void normalize() {
        this.lon = GeoPos.normalizeLon(this.lon);
    }

    public static double normalizeLon(double lon) {
        if (lon < -360.0 || lon > 360.0) {
            lon %= 360.0;
        }
        if (lon < -180.0) {
            lon += 360.0;
        } else if (lon > 180.0) {
            lon -= 360.0;
        }
        return lon;
    }

    public String getLatString() {
        return GeoPos.getLatString(this.lat, true, false);
    }

    public String getLonString() {
        return GeoPos.getLonString(this.lon, true, false);
    }

    public static String getLatString(double lat) {
        return GeoPos.getLatString(lat, true, false);
    }

    public static String getLatString(double lat, boolean compassFormat, boolean decimalFormat) {
        if (GeoPos.isLatValid(lat)) {
            return GeoPos.getDegreeString(lat, false, compassFormat, decimalFormat);
        }
        return "Inv N (" + lat + ")";
    }

    public static String getLonString(double lon) {
        return GeoPos.getLonString(lon, true, false);
    }

    public static String getLonString(double lon, boolean compassFormat, boolean decimalFormat) {
        if (GeoPos.isLonValid(lon)) {
            return GeoPos.getDegreeString(lon, true, compassFormat, decimalFormat);
        }
        return "Inv E (" + lon + ")";
    }

    private static String getDegreeString(double value, boolean longitudial, boolean compassFormat, boolean decimalFormat) {
        int sign = value == 0.0 ? 0 : (value < 0.0 ? -1 : 1);
        double rest = Math.abs(value);
        int degree = MathUtils.floorInt(rest);
        int minutes = MathUtils.floorInt(60.0 * (rest -= (double)degree));
        int seconds = (int)Math.round(3600.0 * (rest -= (double)minutes / 60.0));
        rest -= (double)seconds / 3600.0;
        if (seconds == 60) {
            seconds = 0;
            if (++minutes == 60) {
                minutes = 0;
                ++degree;
            }
        }
        StringBuilder sb = new StringBuilder();
        if (!compassFormat && sign == -1) {
            sb.append("- ");
        }
        if (decimalFormat) {
            sb.append(Math.abs(value));
        } else {
            sb.append(degree);
            sb.append("\u00b0");
            if (minutes != 0 || seconds != 0) {
                if (minutes < 10) {
                    sb.append('0');
                }
                sb.append(minutes);
                sb.append('\'');
                if (seconds != 0) {
                    if (seconds < 10) {
                        sb.append('0');
                    }
                    sb.append(seconds);
                    sb.append('\"');
                }
            }
        }
        if (compassFormat) {
            if (sign == -1) {
                sb.append(' ');
                if (longitudial) {
                    sb.append('W');
                } else {
                    sb.append('S');
                }
            } else if (sign == 1) {
                sb.append(' ');
                if (longitudial) {
                    sb.append('E');
                } else {
                    sb.append('N');
                }
            }
        }
        return sb.toString();
    }

    private static boolean isLatValid(double lat) {
        return lat >= -90.0 && lat <= 90.0;
    }

    private static boolean isLonValid(double lon) {
        return !Double.isNaN(lon) && !Double.isInfinite(lon);
    }

    public String getLatString(boolean compassFormat, boolean decimalFormat) {
        return GeoPos.getLatString(this.lat, compassFormat, decimalFormat);
    }

    public String getLonString(boolean compassFormat, boolean decimalFormat) {
        return GeoPos.getLonString(this.lon, compassFormat, decimalFormat);
    }
}

