/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import org.esa.snap.core.dataio.persistence.Container;
import org.esa.snap.core.dataio.persistence.Property;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.dataop.maptransf.Datum;
import org.esa.snap.core.dataop.maptransf.Ellipsoid;

public class GeoCodingPersistenceHelper {
    public static final String NAME_COORDINATE_REF_SYS = "Coordinate_Reference_System";
    private static final String NAME_ELLIPSOID_MAJ_AXIS = "ELLIPSOID_MAJ_AXIS";
    private static final String NAME_ELLIPSOID_MIN_AXIS = "ELLIPSOID_MIN_AXIS";
    private static final String NAME_HORIZONTAL_CS = "Horizontal_CS";
    private static final String NAME_HORIZONTAL_CS_TYPE = "HORIZONTAL_CS_TYPE";
    private static final String NAME_GEOGRAPHIC_CS = "Geographic_CS";
    private static final String NAME_HORIZONTAL_DATUM = "Horizontal_Datum";
    private static final String NAME_HORIZONTAL_DATUM_NAME = "HORIZONTAL_DATUM_NAME";
    private static final String NAME_ELLIPSOID = "Ellipsoid";
    private static final String NAME_ELLIPSOID_NAME = "ELLIPSOID_NAME";
    private static final String NAME_ELLIPSOID_PARAMETERS = "Ellipsoid_Parameters";

    public static Container createDatumContainer(GeoCoding gc) {
        Datum datum = gc.getDatum();
        Ellipsoid ellipsoid = datum.getEllipsoid();
        Container ellipsoidParamsCont = new Container(NAME_ELLIPSOID_PARAMETERS);
        Container majAxisCont = new Container(NAME_ELLIPSOID_MAJ_AXIS);
        majAxisCont.add(new Property<String>("unit", "M"));
        majAxisCont.add(new Property<String>("value", String.valueOf(ellipsoid.getSemiMajor())));
        ellipsoidParamsCont.add(majAxisCont);
        Container minAxisCont = new Container(NAME_ELLIPSOID_MIN_AXIS);
        minAxisCont.add(new Property<String>("unit", "M"));
        minAxisCont.add(new Property<String>("value", String.valueOf(ellipsoid.getSemiMinor())));
        ellipsoidParamsCont.add(minAxisCont);
        Container ellipsoidCont = new Container(NAME_ELLIPSOID);
        ellipsoidCont.add(new Property<String>(NAME_ELLIPSOID_NAME, ellipsoid.getName()));
        ellipsoidCont.add(ellipsoidParamsCont);
        Container horizDatumCont = new Container(NAME_HORIZONTAL_DATUM);
        horizDatumCont.add(new Property<String>(NAME_HORIZONTAL_DATUM_NAME, datum.getName()));
        horizDatumCont.add(ellipsoidCont);
        Container horCsCont = new Container(NAME_HORIZONTAL_CS);
        horCsCont.add(new Property<String>(NAME_HORIZONTAL_CS_TYPE, "GEOGRAPHIC"));
        Container geographicCsCont = new Container(NAME_GEOGRAPHIC_CS);
        horCsCont.add(geographicCsCont);
        geographicCsCont.add(horizDatumCont);
        Container coordRefSysCont = new Container(NAME_COORDINATE_REF_SYS);
        coordRefSysCont.add(horCsCont);
        return coordRefSysCont;
    }

    public static Datum createDatum(Container crsCont) {
        Container horizontalDatumCont;
        Container gcsCont;
        Container hcsCont = crsCont.getContainer(NAME_HORIZONTAL_CS);
        if (hcsCont != null && (gcsCont = hcsCont.getContainer(NAME_GEOGRAPHIC_CS)) != null && (horizontalDatumCont = gcsCont.getContainer(NAME_HORIZONTAL_DATUM)) != null) {
            String datumName = horizontalDatumCont.getProperty(NAME_HORIZONTAL_DATUM_NAME).getValueString();
            Container ellipsoidCont = horizontalDatumCont.getContainer(NAME_ELLIPSOID);
            if (ellipsoidCont != null) {
                String ellipsoidName = ellipsoidCont.getProperty(NAME_ELLIPSOID_NAME).getValueString();
                Container ellipsoidParamCont = ellipsoidCont.getContainer(NAME_ELLIPSOID_PARAMETERS);
                if (ellipsoidParamCont != null) {
                    Container majorAxisCont = ellipsoidParamCont.getContainer(NAME_ELLIPSOID_MAJ_AXIS);
                    Container minorAxisCont = ellipsoidParamCont.getContainer(NAME_ELLIPSOID_MIN_AXIS);
                    if (majorAxisCont != null && minorAxisCont != null) {
                        double majorAxis = majorAxisCont.getProperty("value").getValueDouble();
                        double minorAxis = minorAxisCont.getProperty("value").getValueDouble();
                        Ellipsoid ellipsoid = new Ellipsoid(ellipsoidName, minorAxis, majorAxis);
                        return new Datum(datumName, ellipsoid, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
        return Datum.WGS_84;
    }
}

