/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import org.esa.snap.core.dataio.persistence.Container;
import org.esa.snap.core.dataio.persistence.Item;
import org.esa.snap.core.dataio.persistence.PersistenceConverter;
import org.esa.snap.core.dataio.persistence.Property;
import org.esa.snap.core.datamodel.ConvolutionFilterBandPersistenceConverter;
import org.esa.snap.core.datamodel.GeneralFilterBand;
import org.esa.snap.core.datamodel.Kernel;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.RasterDataNodePersistenceHelper;

public class GeneralFilterBandPersistenceConverter
extends PersistenceConverter<GeneralFilterBand> {
    public static final String ID_VERSION_1 = "GenFilterBand:1";
    public static final String ROOT_NAME_SPECTRAL_BAND_INFO = "Spectral_Band_Info";
    public static final String PROP_NAME_BAND_NAME = "BAND_NAME";
    static final String PROP_NAME_BAND_INDEX = "BAND_INDEX";
    static final String PROP_NAME_BAND_DESCRIPTION = "BAND_DESCRIPTION";
    static final String PROP_NAME_DATA_TYPE = "DATA_TYPE";
    static final String PROP_NAME_PHYSICAL_UNIT = "PHYSICAL_UNIT";
    static final String PROP_NAME_SOLAR_FLUX = "SOLAR_FLUX";
    static final String PROP_NAME_BAND_WAVELEN = "BAND_WAVELEN";
    static final String PROP_NAME_BANDWIDTH = "BANDWIDTH";
    static final String PROP_NAME_SCALING_FACTOR = "SCALING_FACTOR";
    static final String PROP_NAME_SCALING_OFFSET = "SCALING_OFFSET";
    static final String PROP_NAME_LOG_10_SCALED = "LOG10_SCALED";
    static final String PROP_NAME_NO_DATA_VALUE_USED = "NO_DATA_VALUE_USED";
    static final String PROP_NAME_NO_DATA_VALUE = "NO_DATA_VALUE";
    static final String NAME_FILTER_BAND_INFO = "Filter_Band_Info";
    static final String PROP_NAME_BAND_TYPE = "bandType";
    static final String VALUE_GENERAL_FILTER_BAND_TYPE = "GeneralFilterBand";
    static final String PROP_NAME_FILTER_SOURCE = "FILTER_SOURCE";
    static final String PROP_NAME_FILTER_OP_TYPE = "FILTER_OP_TYPE";
    static final String PROP_NAME_FILTER_ITERATION_COUNT = "ITERATION_COUNT";
    static final String NAME_FILTER_KERNEL = "Filter_Kernel";
    static final String PROP_NAME_KERNEL_WIDTH = "KERNEL_WIDTH";
    static final String PROP_NAME_KERNEL_HEIGHT = "KERNEL_HEIGHT";
    static final String PROP_NAME_KERNEL_X_ORIGIN = "KERNEL_X_ORIGIN";
    static final String PROP_NAME_KERNEL_Y_ORIGIN = "KERNEL_Y_ORIGIN";
    static final String PROP_NAME_KERNEL_FACTOR = "KERNEL_FACTOR";
    static final String PROP_NAME_KERNEL_DATA = "KERNEL_DATA";

    @Override
    public String getID() {
        return ID_VERSION_1;
    }

    @Override
    public Item encode(GeneralFilterBand gfb) {
        Container root = this.createRootContainer(ROOT_NAME_SPECTRAL_BAND_INFO);
        ConvolutionFilterBandPersistenceConverter.initRootContainer(gfb, root);
        Container filterBandInfo = new Container(NAME_FILTER_BAND_INFO);
        root.add(filterBandInfo);
        filterBandInfo.add(new Property<String>(PROP_NAME_BAND_TYPE, VALUE_GENERAL_FILTER_BAND_TYPE));
        filterBandInfo.add(new Property<String>(PROP_NAME_FILTER_SOURCE, gfb.getSource().getName()));
        filterBandInfo.add(new Property<String>(PROP_NAME_FILTER_OP_TYPE, gfb.getOpType().toString()));
        filterBandInfo.add(new Property<Integer>(PROP_NAME_FILTER_ITERATION_COUNT, gfb.getIterationCount()));
        filterBandInfo.add(ConvolutionFilterBandPersistenceConverter.convertKernelToContainer(gfb.getStructuringElement()));
        RasterDataNodePersistenceHelper.addAncillaryElements(root, gfb);
        RasterDataNodePersistenceHelper.addImageToModelTransformElement(root, gfb);
        return root;
    }

    @Override
    public GeneralFilterBand decodeImpl(Item item, Product product) {
        Container root = item.asContainer();
        Container filterInfo = root.getContainer(NAME_FILTER_BAND_INFO);
        Container kernelInfo = filterInfo.getContainer(NAME_FILTER_KERNEL);
        Kernel kernel = ConvolutionFilterBandPersistenceConverter.convertContainerToKernel(kernelInfo);
        String sourceName = filterInfo.getProperty(PROP_NAME_FILTER_SOURCE).getValueString();
        String opType = filterInfo.getProperty(PROP_NAME_FILTER_OP_TYPE).getValueString();
        int iterationCount = filterInfo.getProperty(PROP_NAME_FILTER_ITERATION_COUNT).getValueInt();
        String bandName = root.getProperty(PROP_NAME_BAND_NAME).getValueString();
        RasterDataNode sourceNode = product.getRasterDataNode(sourceName);
        GeneralFilterBand gfb = new GeneralFilterBand(bandName, sourceNode, GeneralFilterBand.OpType.valueOf(opType), kernel, iterationCount);
        gfb.setDescription(root.getProperty(PROP_NAME_BAND_DESCRIPTION).getValueString());
        gfb.setUnit(root.getProperty(PROP_NAME_PHYSICAL_UNIT).getValueString());
        gfb.setSolarFlux(root.getProperty(PROP_NAME_SOLAR_FLUX).getValueFloat().floatValue());
        gfb.setSpectralWavelength(root.getProperty(PROP_NAME_BAND_WAVELEN).getValueFloat().floatValue());
        gfb.setSpectralBandwidth(root.getProperty(PROP_NAME_BANDWIDTH).getValueFloat().floatValue());
        gfb.setScalingFactor(root.getProperty(PROP_NAME_SCALING_FACTOR).getValueDouble());
        gfb.setScalingOffset(root.getProperty(PROP_NAME_SCALING_OFFSET).getValueDouble());
        gfb.setLog10Scaled(root.getProperty(PROP_NAME_LOG_10_SCALED).getValueBoolean());
        gfb.setNoDataValueUsed(root.getProperty(PROP_NAME_NO_DATA_VALUE_USED).getValueBoolean());
        gfb.setNoDataValue(root.getProperty(PROP_NAME_NO_DATA_VALUE).getValueDouble());
        RasterDataNodePersistenceHelper.setAncillaryRelations(root, gfb);
        RasterDataNodePersistenceHelper.setAncillaryVariables(root, gfb, product);
        RasterDataNodePersistenceHelper.setImageToModelTransform(root, gfb);
        return gfb;
    }
}

