/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import java.util.logging.Level;
import org.esa.snap.core.dataio.persistence.Container;
import org.esa.snap.core.dataio.persistence.HistoricalDecoder;
import org.esa.snap.core.dataio.persistence.Item;
import org.esa.snap.core.dataio.persistence.Persistence;
import org.esa.snap.core.dataio.persistence.PersistenceConverter;
import org.esa.snap.core.dataio.persistence.PersistenceDecoder;
import org.esa.snap.core.dataio.persistence.PersistenceEncoder;
import org.esa.snap.core.dataio.persistence.Property;
import org.esa.snap.core.datamodel.GcpGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoCodingPersistenceHelper;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkGroup;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.dataop.maptransf.Datum;
import org.esa.snap.core.util.SystemUtils;

public class GcpGeoCodingPersistenceConverter
extends PersistenceConverter<GcpGeoCoding> {
    public static final String ID_VERSION_1 = "GcpGC:1";
    private static final String NAME_GCP_GEO_CODING = "GcpGeoCoding";
    private static final String NAME_GEOPOSITION = "Geoposition";
    private static final String NAME_GEOPOSITION_POINTS = "Geoposition_Points";
    private static final String NAME_INTERPOLATION_METHOD = "INTERPOLATION_METHOD";
    private static final String NAME_ORIGINAL_GEOCODING = "Original_Geocoding";

    @Override
    public String getID() {
        return ID_VERSION_1;
    }

    @Override
    public Item encode(GcpGeoCoding geoCoding) {
        Persistence persistence;
        PersistenceEncoder<GeoCoding> encoder;
        Container root = this.createRootContainer(NAME_GCP_GEO_CODING);
        root.add(GeoCodingPersistenceHelper.createDatumContainer(geoCoding));
        Container geoPosition = new Container(NAME_GEOPOSITION);
        root.add(geoPosition);
        Container geoPositionPoints = new Container(NAME_GEOPOSITION_POINTS);
        geoPosition.add(geoPositionPoints);
        geoPositionPoints.add(new Property<String>(NAME_INTERPOLATION_METHOD, geoCoding.getMethod().name()));
        GeoCoding originalGC = geoCoding.getOriginalGeoCoding();
        if (originalGC != null && !(originalGC instanceof GcpGeoCoding) && (encoder = (persistence = new Persistence()).getEncoder(originalGC)) != null) {
            Container originalGeocoding = new Container(NAME_ORIGINAL_GEOCODING);
            geoPositionPoints.add(originalGeocoding);
            Item originalEncoded = encoder.encode(originalGC);
            originalGeocoding.add(originalEncoded.asContainer());
        }
        return root;
    }

    @Override
    public GcpGeoCoding decodeImpl(Item item, Product product) {
        Container root = item.asContainer();
        Container CRS2 = root.getContainer("Coordinate_Reference_System");
        Datum datum = GeoCodingPersistenceHelper.createDatum(CRS2);
        Container geoPosition = root.getContainer(NAME_GEOPOSITION);
        Container geoPositionPoints = geoPosition.getContainer(NAME_GEOPOSITION_POINTS);
        GeoCoding originalGC = null;
        Container originalGCCont = geoPositionPoints.getContainer(NAME_ORIGINAL_GEOCODING);
        if (originalGCCont != null) {
            Container[] containers;
            for (Container container : containers = originalGCCont.getContainers()) {
                if (container == null) continue;
                PersistenceDecoder decoder = new Persistence().getDecoder(container);
                originalGC = (GeoCoding)decoder.decode(container, product);
                break;
            }
        }
        String interpName = geoPositionPoints.getProperty(NAME_INTERPOLATION_METHOD).getValueString();
        GcpGeoCoding.Method interpolationMethod = GcpGeoCoding.Method.valueOf(interpName);
        PlacemarkGroup gcpGroup = product.getGcpGroup();
        Placemark[] placemarks = (Placemark[])gcpGroup.toArray(new Placemark[gcpGroup.getNodeCount()]);
        GcpGeoCoding gcpGeoCoding = null;
        try {
            gcpGeoCoding = new GcpGeoCoding(interpolationMethod, placemarks, product.getSceneRasterWidth(), product.getSceneRasterHeight(), datum);
            if (originalGC != null) {
                gcpGeoCoding.setOriginalGeoCoding(originalGC);
            }
        }
        catch (Exception e) {
            SystemUtils.LOG.log(Level.WARNING, "Unable to create GcpGeoCoding.", e);
        }
        return gcpGeoCoding;
    }

    @Override
    public HistoricalDecoder[] getHistoricalDecoders() {
        return new HistoricalDecoder[0];
    }
}

