/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import java.util.Arrays;
import org.esa.snap.core.dataio.persistence.Attribute;
import org.esa.snap.core.dataio.persistence.Container;
import org.esa.snap.core.dataio.persistence.HistoricalDecoder;
import org.esa.snap.core.dataio.persistence.Item;
import org.esa.snap.core.dataio.persistence.PersistenceConverter;
import org.esa.snap.core.dataio.persistence.Property;
import org.esa.snap.core.datamodel.FXYGeoCoding;
import org.esa.snap.core.datamodel.GeoCodingPersistenceHelper;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.dataop.maptransf.Datum;
import org.esa.snap.core.util.math.FXYSum;

public class FXYGeoCodingPersistenceConverter
extends PersistenceConverter<FXYGeoCoding> {
    public static final String ID_VERSION_1 = "FXYGC:1";
    private static final String NAME_FXY_GEO_CODING = "FXYGeoCoding";
    private static final String NAME_GEOPOSITION = "Geoposition";
    private static final String NAME_GEOPOSITION_INSERT = "Geoposition_Insert";
    private static final String NAME_ULX_MAP = "ULXMAP";
    private static final String NAME_ULY_MAP = "ULYMAP";
    private static final String NAME_X_DIM = "XDIM";
    private static final String NAME_Y_DIM = "YDIM";
    private static final String NAME_SIMPLIFIED_LOCATION_MODEL = "Simplified_Location_Model";
    private static final String NAME_DIRECT_LOCATION_MODEL = "Direct_Location_Model";
    private static final String NAME_REVERSE_LOCATION_MODEL = "Reverse_Location_Model";
    private static final String NAME_LC_LIST = "lc_List";
    private static final String NAME_PC_LIST = "pc_List";
    private static final String NAME_IC_LIST = "ic_List";
    private static final String NAME_JC_LIST = "jc_List";
    private static final String ATTRIBUTE_NAME_ORDER = "order";

    @Override
    public String getID() {
        return ID_VERSION_1;
    }

    @Override
    public Item encode(FXYGeoCoding geoCoding) {
        Container root = this.createRootContainer(NAME_FXY_GEO_CODING);
        root.add(GeoCodingPersistenceHelper.createDatumContainer(geoCoding));
        Container GeoPosition = new Container(NAME_GEOPOSITION);
        root.add(GeoPosition);
        Container GeoPositionInsert = new Container(NAME_GEOPOSITION_INSERT);
        GeoPosition.add(GeoPositionInsert);
        GeoPositionInsert.add(new Property<Float>(NAME_ULX_MAP, Float.valueOf(geoCoding.getPixelOffsetX())));
        GeoPositionInsert.add(new Property<Float>(NAME_ULY_MAP, Float.valueOf(geoCoding.getPixelOffsetY())));
        GeoPositionInsert.add(new Property<Float>(NAME_X_DIM, Float.valueOf(geoCoding.getPixelSizeX())));
        GeoPositionInsert.add(new Property<Float>(NAME_Y_DIM, Float.valueOf(geoCoding.getPixelSizeY())));
        Container SimplifiedLocationModel = new Container(NAME_SIMPLIFIED_LOCATION_MODEL);
        GeoPosition.add(SimplifiedLocationModel);
        Container DirectLocationModel = new Container(NAME_DIRECT_LOCATION_MODEL);
        SimplifiedLocationModel.add(DirectLocationModel);
        DirectLocationModel.set(new Attribute<Integer>(ATTRIBUTE_NAME_ORDER, geoCoding.getLatFunction().getOrder()));
        DirectLocationModel.add(new Property<double[]>(NAME_LC_LIST, geoCoding.getLonFunction().getCoefficients()));
        DirectLocationModel.add(new Property<double[]>(NAME_PC_LIST, geoCoding.getLatFunction().getCoefficients()));
        int reverseOrder = geoCoding.getPixelXFunction().getOrder();
        Container ReverseLocationModel = new Container(NAME_REVERSE_LOCATION_MODEL);
        SimplifiedLocationModel.add(ReverseLocationModel);
        ReverseLocationModel.set(new Attribute<String>(ATTRIBUTE_NAME_ORDER, String.valueOf(reverseOrder)));
        ReverseLocationModel.add(new Property<double[]>(NAME_IC_LIST, geoCoding.getPixelXFunction().getCoefficients()));
        ReverseLocationModel.add(new Property<double[]>(NAME_JC_LIST, geoCoding.getPixelYFunction().getCoefficients()));
        return root;
    }

    @Override
    public FXYGeoCoding decodeImpl(Item item, Product product) {
        Container root = item.asContainer();
        Container CRS2 = root.getContainer("Coordinate_Reference_System");
        Datum datum = GeoCodingPersistenceHelper.createDatum(CRS2);
        Container geoPosition = root.getContainer(NAME_GEOPOSITION);
        Container geoPosInsert = geoPosition.getContainer(NAME_GEOPOSITION_INSERT);
        float ulX = geoPosInsert.getProperty(NAME_ULX_MAP).getValueFloat().floatValue();
        float ulY = geoPosInsert.getProperty(NAME_ULY_MAP).getValueFloat().floatValue();
        float xDim = geoPosInsert.getProperty(NAME_X_DIM).getValueFloat().floatValue();
        float yDim = geoPosInsert.getProperty(NAME_Y_DIM).getValueFloat().floatValue();
        Container simplifiedLocationModel = geoPosition.getContainer(NAME_SIMPLIFIED_LOCATION_MODEL);
        Container directLocationModel = simplifiedLocationModel.getContainer(NAME_DIRECT_LOCATION_MODEL);
        int dlmOrder = directLocationModel.getAttribute(ATTRIBUTE_NAME_ORDER).getValueInt();
        Double[] lambdaCoeffs = directLocationModel.getProperty(NAME_LC_LIST).getValueDoubles();
        Double[] phiCoeffs = directLocationModel.getProperty(NAME_PC_LIST).getValueDoubles();
        Container reverseLocationModel = simplifiedLocationModel.getContainer(NAME_REVERSE_LOCATION_MODEL);
        int rlmOrder = reverseLocationModel.getAttribute(ATTRIBUTE_NAME_ORDER).getValueInt();
        Double[] xCoeffs = reverseLocationModel.getProperty(NAME_IC_LIST).getValueDoubles();
        Double[] yCoeffs = reverseLocationModel.getProperty(NAME_JC_LIST).getValueDoubles();
        FXYSum lambdaSum = FXYSum.createFXYSum(dlmOrder, this.toPrimitive(lambdaCoeffs));
        FXYSum phiSum = FXYSum.createFXYSum(dlmOrder, this.toPrimitive(phiCoeffs));
        FXYSum xSum = FXYSum.createFXYSum(rlmOrder, this.toPrimitive(xCoeffs));
        FXYSum ySum = FXYSum.createFXYSum(rlmOrder, this.toPrimitive(yCoeffs));
        return new FXYGeoCoding(ulX, ulY, xDim, yDim, xSum, ySum, phiSum, lambdaSum, datum);
    }

    @Override
    public HistoricalDecoder[] getHistoricalDecoders() {
        return new HistoricalDecoder[0];
    }

    private double[] toPrimitive(Double[] doubles) {
        return Arrays.stream(doubles).mapToDouble(Double::doubleValue).toArray();
    }
}

