/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import org.esa.snap.core.dataio.dimap.spi.DimapHistoricalDecoder;
import org.esa.snap.core.dataio.persistence.Attribute;
import org.esa.snap.core.dataio.persistence.Container;
import org.esa.snap.core.dataio.persistence.HistoricalDecoder;
import org.esa.snap.core.dataio.persistence.Item;
import org.esa.snap.core.dataio.persistence.PersistenceConverter;
import org.esa.snap.core.dataio.persistence.Property;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ConvolutionFilterBand;
import org.esa.snap.core.datamodel.Kernel;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.RasterDataNodePersistenceHelper;
import org.esa.snap.core.util.StringUtils;

public class ConvolutionFilterBandPersistenceConverter
extends PersistenceConverter<ConvolutionFilterBand> {
    public static final String ID_VERSION_1 = "ConvFilterBand:1";
    public static final String ROOT_NAME_SPECTRAL_BAND_INFO = "Spectral_Band_Info";
    public static final String PROP_NAME_BAND_NAME = "BAND_NAME";
    static final String PROP_NAME_BAND_INDEX = "BAND_INDEX";
    static final String PROP_NAME_BAND_DESCRIPTION = "BAND_DESCRIPTION";
    static final String PROP_NAME_DATA_TYPE = "DATA_TYPE";
    static final String PROP_NAME_PHYSICAL_UNIT = "PHYSICAL_UNIT";
    static final String PROP_NAME_SOLAR_FLUX = "SOLAR_FLUX";
    static final String PROP_NAME_BAND_WAVELEN = "BAND_WAVELEN";
    static final String PROP_NAME_BANDWIDTH = "BANDWIDTH";
    static final String PROP_NAME_SCALING_FACTOR = "SCALING_FACTOR";
    static final String PROP_NAME_SCALING_OFFSET = "SCALING_OFFSET";
    static final String PROP_NAME_LOG_10_SCALED = "LOG10_SCALED";
    static final String PROP_NAME_NO_DATA_VALUE_USED = "NO_DATA_VALUE_USED";
    static final String PROP_NAME_NO_DATA_VALUE = "NO_DATA_VALUE";
    static final String NAME_FILTER_BAND_INFO = "Filter_Band_Info";
    static final String PROP_NAME_BAND_TYPE = "bandType";
    static final String VALUE_CONVOLUTION_FILTER_BAND = "ConvolutionFilterBand";
    static final String PROP_NAME_FILTER_SOURCE = "FILTER_SOURCE";
    static final String PROP_NAME_FILTER_ITERATION_COUNT = "ITERATION_COUNT";
    static final String NAME_FILTER_KERNEL = "Filter_Kernel";
    static final String PROP_NAME_KERNEL_WIDTH = "KERNEL_WIDTH";
    static final String PROP_NAME_KERNEL_HEIGHT = "KERNEL_HEIGHT";
    static final String PROP_NAME_KERNEL_X_ORIGIN = "KERNEL_X_ORIGIN";
    static final String PROP_NAME_KERNEL_Y_ORIGIN = "KERNEL_Y_ORIGIN";
    static final String PROP_NAME_KERNEL_FACTOR = "KERNEL_FACTOR";
    static final String PROP_NAME_KERNEL_DATA = "KERNEL_DATA";

    protected static void initRootContainer(Band gfb, Container root) {
        root.add(new Property<String>(PROP_NAME_BAND_INDEX, String.valueOf(gfb.getProduct().getBandIndex(gfb.getName()))));
        root.add(new Property<String>(PROP_NAME_BAND_NAME, gfb.getName()));
        root.add(new Property<String>(PROP_NAME_BAND_DESCRIPTION, gfb.getDescription()));
        root.add(new Property<String>(PROP_NAME_DATA_TYPE, ProductData.getTypeString(gfb.getDataType())));
        root.add(new Property<String>(PROP_NAME_PHYSICAL_UNIT, gfb.getUnit()));
        root.add(new Property<String>(PROP_NAME_SOLAR_FLUX, String.valueOf(gfb.getSolarFlux())));
        root.add(new Property<String>(PROP_NAME_BAND_WAVELEN, String.valueOf(gfb.getSpectralWavelength())));
        root.add(new Property<String>(PROP_NAME_BANDWIDTH, String.valueOf(gfb.getSpectralBandwidth())));
        root.add(new Property<String>(PROP_NAME_SCALING_FACTOR, String.valueOf(gfb.getScalingFactor())));
        root.add(new Property<String>(PROP_NAME_SCALING_OFFSET, String.valueOf(gfb.getScalingOffset())));
        root.add(new Property<String>(PROP_NAME_LOG_10_SCALED, String.valueOf(gfb.isLog10Scaled())));
        root.add(new Property<String>(PROP_NAME_NO_DATA_VALUE_USED, String.valueOf(gfb.isNoDataValueUsed())));
        root.add(new Property<String>(PROP_NAME_NO_DATA_VALUE, String.valueOf(gfb.getNoDataValue())));
    }

    @Override
    public String getID() {
        return ID_VERSION_1;
    }

    @Override
    public Item encode(ConvolutionFilterBand cfb) {
        Container root = this.createRootContainer(ROOT_NAME_SPECTRAL_BAND_INFO);
        ConvolutionFilterBandPersistenceConverter.initRootContainer(cfb, root);
        Container filterBandInfo = new Container(NAME_FILTER_BAND_INFO);
        root.add(filterBandInfo);
        filterBandInfo.add(new Property<String>(PROP_NAME_BAND_TYPE, VALUE_CONVOLUTION_FILTER_BAND));
        filterBandInfo.add(new Property<String>(PROP_NAME_FILTER_SOURCE, cfb.getSource().getName()));
        filterBandInfo.add(new Property<Integer>(PROP_NAME_FILTER_ITERATION_COUNT, cfb.getIterationCount()));
        filterBandInfo.add(ConvolutionFilterBandPersistenceConverter.convertKernelToContainer(cfb.getKernel()));
        RasterDataNodePersistenceHelper.addAncillaryElements(root, cfb);
        RasterDataNodePersistenceHelper.addImageToModelTransformElement(root, cfb);
        return root;
    }

    @Override
    public ConvolutionFilterBand decodeImpl(Item item, Product product) {
        Container root = item.asContainer();
        Container filterInfo = root.getContainer(NAME_FILTER_BAND_INFO);
        Container kernelInfo = filterInfo.getContainer(NAME_FILTER_KERNEL);
        Kernel kernel = ConvolutionFilterBandPersistenceConverter.convertContainerToKernel(kernelInfo);
        String sourceName = filterInfo.getProperty(PROP_NAME_FILTER_SOURCE).getValueString();
        Property<?> iterCountProp = filterInfo.getProperty(PROP_NAME_FILTER_ITERATION_COUNT);
        int iterationCount = iterCountProp != null ? iterCountProp.getValueInt() : 1;
        String bandName = root.getProperty(PROP_NAME_BAND_NAME).getValueString();
        RasterDataNode sourceNode = product.getRasterDataNode(sourceName);
        ConvolutionFilterBand cfb = new ConvolutionFilterBand(bandName, sourceNode, kernel, iterationCount);
        cfb.setDescription(root.getProperty(PROP_NAME_BAND_DESCRIPTION).getValueString());
        cfb.setUnit(root.getProperty(PROP_NAME_PHYSICAL_UNIT).getValueString());
        cfb.setSolarFlux(root.getProperty(PROP_NAME_SOLAR_FLUX).getValueFloat().floatValue());
        cfb.setSpectralWavelength(root.getProperty(PROP_NAME_BAND_WAVELEN).getValueFloat().floatValue());
        cfb.setSpectralBandwidth(root.getProperty(PROP_NAME_BANDWIDTH).getValueFloat().floatValue());
        cfb.setScalingFactor(root.getProperty(PROP_NAME_SCALING_FACTOR).getValueDouble());
        cfb.setScalingOffset(root.getProperty(PROP_NAME_SCALING_OFFSET).getValueDouble());
        cfb.setLog10Scaled(root.getProperty(PROP_NAME_LOG_10_SCALED).getValueBoolean());
        cfb.setNoDataValueUsed(root.getProperty(PROP_NAME_NO_DATA_VALUE_USED).getValueBoolean());
        cfb.setNoDataValue(root.getProperty(PROP_NAME_NO_DATA_VALUE).getValueDouble());
        RasterDataNodePersistenceHelper.setAncillaryRelations(root, cfb);
        RasterDataNodePersistenceHelper.setAncillaryVariables(root, cfb, product);
        RasterDataNodePersistenceHelper.setImageToModelTransform(root, cfb);
        return cfb;
    }

    @Override
    public HistoricalDecoder[] getHistoricalDecoders() {
        return new HistoricalDecoder[]{new HistoricalDecoder0()};
    }

    static Kernel convertContainerToKernel(Container kernelInfo) {
        String kernelDataString = kernelInfo.getProperty(PROP_NAME_KERNEL_DATA).getValueString();
        double[] data = StringUtils.toDoubleArray(kernelDataString, ",");
        int width = kernelInfo.getProperty(PROP_NAME_KERNEL_WIDTH).getValueInt();
        int height = kernelInfo.getProperty(PROP_NAME_KERNEL_HEIGHT).getValueInt();
        String xOriginText = kernelInfo.getProperty(PROP_NAME_KERNEL_X_ORIGIN).getValueString();
        int xOrigin = (width - 1) / 2;
        if (xOriginText != null) {
            xOrigin = Integer.parseInt(xOriginText);
        }
        String yOriginText = kernelInfo.getProperty(PROP_NAME_KERNEL_Y_ORIGIN).getValueString();
        int yOrigin = (height - 1) / 2;
        if (yOriginText != null) {
            yOrigin = Integer.parseInt(yOriginText);
        }
        String factorText = kernelInfo.getProperty(PROP_NAME_KERNEL_FACTOR).getValueString();
        double factor = 1.0;
        if (factorText != null) {
            factor = Double.parseDouble(factorText);
        }
        return new Kernel(width, height, xOrigin, yOrigin, factor, data);
    }

    static Container convertKernelToContainer(Kernel kernel) {
        Container filterKernel = new Container(NAME_FILTER_KERNEL);
        filterKernel.add(new Property<String>(PROP_NAME_KERNEL_WIDTH, String.valueOf(kernel.getWidth())));
        filterKernel.add(new Property<String>(PROP_NAME_KERNEL_HEIGHT, String.valueOf(kernel.getHeight())));
        filterKernel.add(new Property<String>(PROP_NAME_KERNEL_X_ORIGIN, String.valueOf(kernel.getXOrigin())));
        filterKernel.add(new Property<String>(PROP_NAME_KERNEL_Y_ORIGIN, String.valueOf(kernel.getYOrigin())));
        filterKernel.add(new Property<String>(PROP_NAME_KERNEL_FACTOR, String.valueOf(kernel.getFactor())));
        filterKernel.add(new Property<String>(PROP_NAME_KERNEL_DATA, ConvolutionFilterBandPersistenceConverter.toCsv(kernel.getKernelData(null))));
        return filterKernel;
    }

    static String toCsv(double[] data) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            double v = data[i];
            if (i > 0) {
                sb.append(',');
            }
            if (v == (double)((int)v)) {
                sb.append((int)v);
                continue;
            }
            sb.append(v);
        }
        return sb.toString();
    }

    private static class HistoricalDecoder0
    extends DimapHistoricalDecoder {
        private HistoricalDecoder0() {
        }

        @Override
        public boolean canDecode(Item item) {
            if (item != null) {
                Attribute<?> bandTypeAttr;
                Container container;
                Container filterBandInfoCont;
                String itemName = item.getName();
                if (item.isContainer() && itemName.equals(ConvolutionFilterBandPersistenceConverter.ROOT_NAME_SPECTRAL_BAND_INFO) && (filterBandInfoCont = (container = item.asContainer()).getContainer(ConvolutionFilterBandPersistenceConverter.NAME_FILTER_BAND_INFO)) != null && (bandTypeAttr = filterBandInfoCont.getAttribute(ConvolutionFilterBandPersistenceConverter.PROP_NAME_BAND_TYPE)) != null) {
                    return bandTypeAttr.getValueString().equals(ConvolutionFilterBandPersistenceConverter.VALUE_CONVOLUTION_FILTER_BAND);
                }
            }
            return false;
        }

        @Override
        public Item decode(Item item, Product product) {
            Container rootContainer = item.asContainer();
            Container filterBandCont = rootContainer.getContainer(ConvolutionFilterBandPersistenceConverter.NAME_FILTER_BAND_INFO);
            Attribute<?> attribute = filterBandCont.removeAttribute(ConvolutionFilterBandPersistenceConverter.PROP_NAME_BAND_TYPE);
            filterBandCont.add(new Property<String>(attribute.getName(), attribute.getValueString()));
            return rootContainer;
        }
    }
}

