/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import javax.media.jai.KernelJAI;
import javax.media.jai.operator.ConvolveDescriptor;
import org.esa.snap.core.datamodel.FilterBand;
import org.esa.snap.core.datamodel.Kernel;
import org.esa.snap.core.datamodel.RasterDataNode;

public class ConvolutionFilterBand
extends FilterBand {
    private final Kernel kernel;
    private final int iterationCount;

    public ConvolutionFilterBand(String name, RasterDataNode source, Kernel kernel, int iterationCount) {
        this(name, source, new Dimension(source.getRasterWidth(), source.getRasterHeight()), kernel, iterationCount);
    }

    public ConvolutionFilterBand(String name, RasterDataNode source, Dimension filterBandSize, Kernel kernel, int iterationCount) {
        super(name, source.getGeophysicalDataType() == 31 ? 31 : 30, filterBandSize.width, filterBandSize.height, source);
        this.kernel = kernel;
        this.iterationCount = iterationCount;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    @Override
    protected RenderedImage createSourceLevelImage(RenderedImage sourceImage, int level, RenderingHints rh) {
        KernelJAI jaiKernel = this.createJaiKernel();
        RenderedImage targetImage = sourceImage;
        for (int i = 0; i < this.iterationCount; ++i) {
            targetImage = ConvolveDescriptor.create((RenderedImage)targetImage, (KernelJAI)jaiKernel, (RenderingHints)rh);
        }
        return targetImage;
    }

    private KernelJAI createJaiKernel() {
        double[] data = this.kernel.getKernelData(null);
        float[] scaledData = new float[data.length];
        double factor = this.kernel.getFactor();
        for (int i = 0; i < data.length; ++i) {
            scaledData[i] = (float)(data[i] * factor);
        }
        return new KernelJAI(this.kernel.getWidth(), this.kernel.getHeight(), this.kernel.getXOrigin(), this.kernel.getYOrigin(), scaledData);
    }
}

