/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import com.bc.ceres.core.Assert;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import org.esa.snap.core.datamodel.Scaling;
import org.esa.snap.core.util.DefaultPropertyMap;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.math.LogLinearTransform;
import org.esa.snap.core.util.math.MathUtils;

public class ColorPaletteDef
implements Cloneable {
    private static final String _PROPERTY_KEY_NUM_POINTS = "numPoints";
    private static final String _PROPERTY_KEY_COLOR = "color";
    private static final String _PROPERTY_KEY_SAMPLE = "sample";
    private static final String _PROPERTY_KEY_AUTODISTRIBUTE = "autoDistribute";
    private static final String _PROPERTY_KEY_IS_LOG_SCALED = "isLogScaled";
    private Vector<Point> points;
    private int numColors;
    private boolean discrete;
    private boolean autoDistribute;
    private boolean isLogScaled;
    private double sourceFileMin;
    private double sourceFileMax;

    public ColorPaletteDef(double minSample, double maxSample) {
        this(new Point[]{new Point(minSample, Color.BLACK), new Point(maxSample, Color.WHITE)}, 256);
    }

    public ColorPaletteDef(double minSample, double centerSample, double maxSample) {
        this(new Point[]{new Point(minSample, Color.BLACK), new Point(centerSample, Color.GRAY), new Point(maxSample, Color.WHITE)}, 256);
    }

    public ColorPaletteDef(Point[] points) {
        this(points, 256);
    }

    public ColorPaletteDef(Point[] points, int numColors) {
        Guardian.assertGreaterThan("numColors", numColors, 1L);
        Guardian.assertNotNull("points", points);
        Guardian.assertGreaterThan("points.length", points.length, 1L);
        this.numColors = numColors;
        this.points = new Vector(points.length);
        this.points.addAll(Arrays.asList(points));
        this.discrete = false;
    }

    public boolean isDiscrete() {
        return this.discrete;
    }

    public void setDiscrete(boolean discrete) {
        this.discrete = discrete;
    }

    public int getNumColors() {
        return this.numColors;
    }

    public void setNumColors(int numColors) {
        this.numColors = numColors;
    }

    public int getNumPoints() {
        return this.points.size();
    }

    public void setNumPoints(int numPoints) {
        while (this.getNumPoints() < numPoints) {
            this.addPoint(new Point(this.getMaxDisplaySample() + 1.0, Color.BLACK));
        }
        while (this.getNumPoints() > numPoints) {
            this.removePointAt(this.getNumPoints() - 1);
        }
    }

    public boolean isFullyOpaque() {
        for (Point point : this.points) {
            if (point.getColor().getAlpha() == 255) continue;
            return false;
        }
        return true;
    }

    public boolean isAutoDistribute() {
        return this.autoDistribute;
    }

    public void setAutoDistribute(boolean autoDistribute) {
        this.autoDistribute = autoDistribute;
    }

    public Point getPointAt(int index) {
        return this.points.get(index);
    }

    public Point getFirstPoint() {
        return this.points.firstElement();
    }

    public Point getLastPoint() {
        return this.points.lastElement();
    }

    public double getMinDisplaySample() {
        return this.getFirstPoint().getSample();
    }

    public double getMaxDisplaySample() {
        return this.getLastPoint().getSample();
    }

    public void insertPointAfter(int index, Point point) {
        this.points.insertElementAt(point, index + 1);
    }

    public boolean createPointAfter(int index, Scaling scaling) {
        Point point1 = this.getPointAt(index);
        Point point2 = null;
        if (index < this.points.indexOf(this.points.lastElement())) {
            point2 = this.getPointAt(index + 1);
        }
        if (point2 != null) {
            double max = Math.max(point1.getSample(), point2.getSample());
            double min = Math.min(point1.getSample(), point2.getSample());
            double middle = scaling.scale(0.5 * (scaling.scaleInverse(min) + scaling.scaleInverse(max)));
            Point newPoint = new Point(middle, ColorPaletteDef.getCenterColor(point1.getColor(), point2.getColor()));
            this.insertPointAfter(index, newPoint);
            return true;
        }
        return false;
    }

    public static Color getCenterColor(Color c1, Color c2) {
        return new Color(0.5f * (float)(c1.getRed() + c2.getRed()) / 255.0f, 0.5f * (float)(c1.getGreen() + c2.getGreen()) / 255.0f, 0.5f * (float)(c1.getBlue() + c2.getBlue()) / 255.0f, 0.5f * (float)(c1.getAlpha() + c2.getAlpha()) / 255.0f);
    }

    public void removePointAt(int index) {
        this.check2PointsMinimum();
        this.points.remove(index);
    }

    public void addPoint(Point point) {
        this.points.add(point);
    }

    public Point[] getPoints() {
        Point[] points = new Point[this.getNumPoints()];
        for (int i = 0; i < this.getNumPoints(); ++i) {
            points[i] = this.getPointAt(i);
        }
        return points;
    }

    public void setPoints(Point[] points) {
        Assert.notNull((Object)points);
        Assert.argument((points.length >= 2 ? 1 : 0) != 0, (String)"points.length >= 2");
        this.points.clear();
        this.points.addAll(Arrays.asList(points));
    }

    public Iterator getIterator() {
        return this.points.iterator();
    }

    public final Object clone() {
        try {
            ColorPaletteDef def = (ColorPaletteDef)super.clone();
            Vector<Point> pointVector = new Vector<Point>();
            pointVector.setSize(this.points.size());
            for (int i = 0; i < this.points.size(); ++i) {
                Point point = this.points.get(i);
                pointVector.set(i, point.createClone());
            }
            def.points = pointVector;
            def.numColors = this.numColors;
            def.discrete = this.discrete;
            def.autoDistribute = this.autoDistribute;
            def.isLogScaled = this.isLogScaled;
            return def;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public ColorPaletteDef createDeepCopy() {
        return (ColorPaletteDef)this.clone();
    }

    public static ColorPaletteDef loadColorPaletteDef(File file) throws IOException {
        return ColorPaletteDef.loadColorPaletteDef(file.toPath());
    }

    public static ColorPaletteDef loadColorPaletteDef(Path path) throws IOException {
        DefaultPropertyMap propertyMap = new DefaultPropertyMap();
        propertyMap.load(path);
        int numPoints = propertyMap.getPropertyInt(_PROPERTY_KEY_NUM_POINTS);
        if (numPoints < 2) {
            throw new IOException("The selected file contains less than\ntwo colour points.");
        }
        Point[] points = new Point[numPoints];
        double lastSample = 0.0;
        for (int i = 0; i < points.length; ++i) {
            Point point = new Point();
            Color color = propertyMap.getPropertyColor(_PROPERTY_KEY_COLOR + i);
            double sample = propertyMap.getPropertyDouble(_PROPERTY_KEY_SAMPLE + i);
            if (i > 0 && sample < lastSample) {
                sample = lastSample + 1.0;
            }
            point.setColor(color);
            point.setSample(sample);
            point.setLabel(path.getFileName().toString());
            points[i] = point;
            lastSample = sample;
        }
        ColorPaletteDef paletteDef = new ColorPaletteDef(points, 256);
        paletteDef.setAutoDistribute(propertyMap.getPropertyBool(_PROPERTY_KEY_AUTODISTRIBUTE, false));
        paletteDef.setLogScaled(propertyMap.getPropertyBool(_PROPERTY_KEY_IS_LOG_SCALED, false));
        paletteDef.setSourceFileMin(paletteDef.getMinDisplaySample());
        paletteDef.setSourceFileMax(paletteDef.getMaxDisplaySample());
        return paletteDef;
    }

    public static ColorPaletteDef loadCpt(File file) throws IOException {
        Object values;
        if (file == null) {
            throw new IOException("Null file in loadCpt");
        }
        if (!file.exists()) {
            throw new IOException("File='" + file.getName() + "'does not exist");
        }
        String label = file.getName();
        Point lastPoint = null;
        ArrayList<Point> pointsArrayList = new ArrayList<Point>();
        ArrayList<String> lines = ColorPaletteDef.readFileIntoArrayList(file);
        for (String line : lines) {
            if ((line = line.trim()).startsWith("#") || (values = line.split("\\s+")) == null || ((String[])values).length != 8) continue;
            Point firstPoint = ColorPaletteDef.string2Point(label, (String)values[0], (String)values[1], (String)values[2], (String)values[3]);
            if (firstPoint != null) {
                pointsArrayList.add(firstPoint);
            }
            lastPoint = ColorPaletteDef.string2Point(label, (String)values[4], (String)values[5], (String)values[6], (String)values[7]);
        }
        if (lastPoint != null) {
            pointsArrayList.add(lastPoint);
        }
        if (pointsArrayList == null || pointsArrayList.size() < 2) {
            throw new IOException("The selected file contains less than\ntwo color points.");
        }
        Point[] points = new Point[pointsArrayList.size()];
        int i = 0;
        values = pointsArrayList.iterator();
        while (values.hasNext()) {
            Point point;
            points[i] = point = (Point)values.next();
            ++i;
        }
        ColorPaletteDef paletteDef = new ColorPaletteDef(points, 256);
        paletteDef.setAutoDistribute(false);
        paletteDef.setLogScaled(false);
        paletteDef.setSourceFileMin(paletteDef.getMinDisplaySample());
        paletteDef.setSourceFileMax(paletteDef.getMaxDisplaySample());
        return paletteDef;
    }

    public static Color string2Color(String redString, String greenString, String blueString) {
        Color color;
        int blue;
        int green;
        int red;
        if (redString != null && redString.length() > 0 && greenString != null && greenString.length() > 0 && blueString != null && blueString.length() > 0) {
            redString = redString.trim();
            greenString = greenString.trim();
            blueString = blueString.trim();
            try {
                red = Integer.parseInt(redString);
                green = Integer.parseInt(greenString);
                blue = Integer.parseInt(blueString);
            }
            catch (NumberFormatException e) {
                return null;
            }
        } else {
            return null;
        }
        try {
            color = new Color(red, green, blue);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return color;
    }

    private static Point string2Point(String label, String sampleStr, String redStr, String greenStr, String blueStr) {
        boolean valid = true;
        Point point = new Point();
        double sample = 0.0;
        if (sampleStr != null && sampleStr.length() > 0) {
            sampleStr = sampleStr.trim();
            try {
                sample = Double.parseDouble(sampleStr);
            }
            catch (NumberFormatException e) {
                valid = false;
            }
        } else {
            valid = false;
        }
        Color color = ColorPaletteDef.string2Color(redStr, greenStr, blueStr);
        if (valid && color != null) {
            point = new Point();
            point.setColor(color);
            point.setSample(sample);
            point.setLabel(label);
            return point;
        }
        return null;
    }

    public static ArrayList<String> readFileIntoArrayList(File file) throws IOException {
        ArrayList<String> fileContents = new ArrayList<String>();
        BufferedReader moFile = null;
        try {
            String lineData;
            moFile = new BufferedReader(new FileReader(file));
            while ((lineData = moFile.readLine()) != null) {
                fileContents.add(lineData);
            }
        }
        catch (IOException e) {
            throw new IOException("Error reading file='" + file.getName() + "' in loadCpt");
        }
        finally {
            try {
                moFile.close();
            }
            catch (Exception exception) {}
        }
        return fileContents;
    }

    public static void storeColorPaletteDef(ColorPaletteDef colorPaletteDef, File file) throws IOException {
        Point[] points = colorPaletteDef.getPoints();
        DefaultPropertyMap propertyMap = new DefaultPropertyMap();
        int numPoints = points.length;
        propertyMap.setPropertyInt(_PROPERTY_KEY_NUM_POINTS, numPoints);
        propertyMap.setPropertyBool(_PROPERTY_KEY_AUTODISTRIBUTE, colorPaletteDef.isAutoDistribute());
        propertyMap.setPropertyBool(_PROPERTY_KEY_IS_LOG_SCALED, colorPaletteDef.isLogScaled());
        for (int i = 0; i < numPoints; ++i) {
            propertyMap.setPropertyColor(_PROPERTY_KEY_COLOR + i, points[i].getColor());
            propertyMap.setPropertyDouble(_PROPERTY_KEY_SAMPLE + i, points[i].getSample());
        }
        propertyMap.store(file.toPath(), "SNAP Colour Palette Definition File");
    }

    public static void storePal(ColorPaletteDef colorPaletteDef, File file) throws IOException {
        ArrayList<String> fileContents = new ArrayList<String>();
        String DELIMITER = " ";
        double min = colorPaletteDef.getMinDisplaySample();
        double max = colorPaletteDef.getMaxDisplaySample();
        for (int i = 0; i < 256; ++i) {
            double weight = (double)i / 255.0;
            double sample = colorPaletteDef.isLogScaled() ? LogLinearTransform.getLogarithmicValueUsingLinearWeight(weight, min, max) : weight * (max - min) + min;
            Color color = colorPaletteDef.computeColor(sample);
            fileContents.add(ColorPaletteDef.getCptColorEntry(color, DELIMITER));
        }
        ColorPaletteDef.printStringArrayListToFile(file, "Generic 256 Point RGB Color Palette", fileContents);
    }

    public static void storeCpt(ColorPaletteDef colorPaletteDef, File file) throws IOException {
        ArrayList<String> cptFileContents = new ArrayList<String>();
        String DELIMITER = " \t";
        String DELIMITER_BIG = " \t\t";
        Point[] points = colorPaletteDef.getPoints();
        int numPoints = points.length;
        boolean discrete = colorPaletteDef.isDiscrete();
        int numEntries = discrete ? numPoints : numPoints - 1;
        for (int i = 0; i < numEntries; ++i) {
            double nextValue;
            String currLine = null;
            double currValue = colorPaletteDef.getPointAt(i).getSample();
            String currValueString = Double.toString(currValue);
            String nextValueString = null;
            Color currColor = colorPaletteDef.getPointAt(i).getColor();
            String currColorString = ColorPaletteDef.getCptColorEntry(currColor, DELIMITER);
            if (discrete) {
                if (i == numPoints - 1) {
                    if (i - 1 >= 0) {
                        double delta = colorPaletteDef.getPointAt(i).getSample() - colorPaletteDef.getPointAt(i - 1).getSample();
                        nextValue = colorPaletteDef.getPointAt(i).getSample() + delta;
                        nextValueString = Double.toString(nextValue);
                    }
                } else {
                    nextValue = colorPaletteDef.getPointAt(i + 1).getSample();
                    nextValueString = Double.toString(nextValue);
                }
                if (nextValueString != null) {
                    currLine = "  " + currValueString + DELIMITER + currColorString + DELIMITER_BIG + nextValueString + DELIMITER + currColorString;
                }
            } else {
                nextValue = colorPaletteDef.getPointAt(i + 1).getSample();
                nextValueString = Double.toString(nextValue);
                Color nextColor = colorPaletteDef.getPointAt(i + 1).getColor();
                String nextColorString = ColorPaletteDef.getCptColorEntry(nextColor, DELIMITER);
                currLine = "  " + currValueString + DELIMITER + currColorString + DELIMITER_BIG + nextValueString + DELIMITER + nextColorString;
            }
            if (currLine == null) continue;
            cptFileContents.add(currLine);
        }
        ColorPaletteDef.printStringArrayListToFile(file, "CPT Format Color Palette", cptFileContents);
    }

    private static String getCptColorEntry(Color color, String DELIMITER) {
        String colorRed = Integer.toString(color.getRed());
        String colorGreen = Integer.toString(color.getGreen());
        String colorBlue = Integer.toString(color.getBlue());
        String colorString = colorRed + DELIMITER + colorGreen + DELIMITER + colorBlue;
        return colorString;
    }

    private static void printStringArrayListToFile(File file, String header, ArrayList<String> contentsArrayList) {
        BufferedWriter bos = null;
        try {
            bos = new BufferedWriter(new FileWriter(file));
            bos.write("#" + header);
            bos.newLine();
            for (String currLine : contentsArrayList) {
                bos.write(currLine);
                bos.newLine();
            }
            bos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void check2PointsMinimum() {
        if (this.getNumPoints() == 2) {
            throw new IllegalStateException("gradation curve must at least have 2 points");
        }
    }

    public void dispose() {
        if (this.points != null) {
            this.points.removeAllElements();
            this.points = null;
        }
    }

    public Color[] getColors() {
        Color[] colors = new Color[this.points.size()];
        for (int i = 0; i < this.points.size(); ++i) {
            colors[i] = this.points.get(i).getColor();
        }
        return colors;
    }

    private Color computeColor(double sample) {
        for (int i = 0; i < this.getNumPoints() - 1; ++i) {
            Point p1 = this.getPointAt(i);
            Point p2 = this.getPointAt(i + 1);
            double sample1 = p1.getSample();
            double sample2 = p2.getSample();
            Color color1 = p1.getColor();
            Color color2 = p2.getColor();
            if (!(sample >= sample1) || !(sample <= sample2)) continue;
            if (this.discrete) {
                return color1;
            }
            return this.computeColor(sample, sample1, sample2, color1, color2);
        }
        return Color.BLACK;
    }

    private Color computeColor(double sample, double sample1, double sample2, Color color1, Color color2) {
        double f = (sample - sample1) / (sample2 - sample1);
        double r1 = color1.getRed();
        double r2 = color2.getRed();
        double g1 = color1.getGreen();
        double g2 = color2.getGreen();
        double b1 = color1.getBlue();
        double b2 = color2.getBlue();
        double a1 = color1.getAlpha();
        double a2 = color2.getAlpha();
        int red = (int)MathUtils.roundAndCrop(r1 + f * (r2 - r1), 0L, 255L);
        int green = (int)MathUtils.roundAndCrop(g1 + f * (g2 - g1), 0L, 255L);
        int blue = (int)MathUtils.roundAndCrop(b1 + f * (b2 - b1), 0L, 255L);
        int alpha = (int)MathUtils.roundAndCrop(a1 + f * (a2 - a1), 0L, 255L);
        return new Color(red, green, blue, alpha);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColorPaletteDef that = (ColorPaletteDef)o;
        if (this.autoDistribute != that.autoDistribute) {
            return false;
        }
        if (this.isLogScaled != that.isLogScaled) {
            return false;
        }
        if (this.discrete != that.discrete) {
            return false;
        }
        if (this.numColors != that.numColors) {
            return false;
        }
        return this.points.equals(that.points);
    }

    public int hashCode() {
        int result = this.points.hashCode();
        result = 31 * result + this.numColors;
        result = 31 * result + (this.discrete ? 1 : 0);
        result = 31 * result + (this.autoDistribute ? 1 : 0);
        result = 31 * result + (this.isLogScaled ? 1 : 0);
        return result;
    }

    public boolean isLogScaled() {
        return this.isLogScaled;
    }

    public void setLogScaled(boolean logScaled) {
        this.isLogScaled = logScaled;
    }

    public double getSourceFileMin() {
        return this.sourceFileMin;
    }

    public void setSourceFileMin(double sourceFileMin) {
        this.sourceFileMin = sourceFileMin;
    }

    public double getSourceFileMax() {
        return this.sourceFileMax;
    }

    public void setSourceFileMax(double sourceFileMax) {
        this.sourceFileMax = sourceFileMax;
    }

    public static class Point
    implements Cloneable {
        private double sample;
        private Color color;
        private String label;

        public Point() {
            this(0.0, Color.black);
        }

        public Point(double sample, Color color) {
            this(sample, color, "");
        }

        public Point(double sample, Color color, String label) {
            this.sample = sample;
            this.color = color;
            this.label = label;
        }

        public double getSample() {
            return this.sample;
        }

        public void setSample(double sample) {
            this.sample = sample;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public final Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public Point createClone() {
            return (Point)this.clone();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Point point = (Point)o;
            if (Double.compare(point.sample, this.sample) != 0) {
                return false;
            }
            if (this.color != null ? !this.color.equals(point.color) : point.color != null) {
                return false;
            }
            return !(this.label != null ? !this.label.equals(point.label) : point.label != null);
        }

        public int hashCode() {
            long temp = Double.doubleToLongBits(this.sample);
            int result = (int)(temp ^ temp >>> 32);
            result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
            result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
            return result;
        }
    }
}

