/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import org.esa.snap.core.dataio.persistence.Container;
import org.esa.snap.core.dataio.persistence.HistoricalDecoder;
import org.esa.snap.core.dataio.persistence.Item;
import org.esa.snap.core.dataio.persistence.Persistence;
import org.esa.snap.core.dataio.persistence.PersistenceConverter;
import org.esa.snap.core.dataio.persistence.PersistenceDecoder;
import org.esa.snap.core.dataio.persistence.PersistenceEncoder;
import org.esa.snap.core.dataio.persistence.Property;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.BasicPixelGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.PixelGeoCoding;
import org.esa.snap.core.datamodel.PixelGeoCoding2;
import org.esa.snap.core.datamodel.Product;

public class BasicPixelGeoCodingPersistenceConverter
extends PersistenceConverter<BasicPixelGeoCoding> {
    private static final String NAME_PIXEL_GEO_CODING = "PixelGeoCoding";
    private static final String NAME_PIXEL_GEO_CODING_2 = "PixelGeoCoding2";
    private static final String NAME_LATITUDE_BAND = "LATITUDE_BAND";
    private static final String NAME_LONGITUDE_BAND = "LONGITUDE_BAND";
    private static final String NAME_VALID_MASK_EXPRESSION = "VALID_MASK_EXPRESSION";
    private static final String NAME_SEARCH_RADIUS = "SEARCH_RADIUS";
    private static final String NAME_PIXEL_POSITION_ESTIMATOR = "Pixel_Position_Estimator";
    public static final String ID_VERSION_1 = "BasicPixelGC:1";

    @Override
    public String getID() {
        return ID_VERSION_1;
    }

    @Override
    public Item encode(BasicPixelGeoCoding pixelGeoCoding) {
        String latBandName = pixelGeoCoding.getLatBand().getName();
        String lonBandName = pixelGeoCoding.getLonBand().getName();
        String validMask = pixelGeoCoding.getValidMask();
        int searchRadius = pixelGeoCoding.getSearchRadius();
        GeoCoding posEstimator = pixelGeoCoding.getPixelPosEstimator();
        Container rootContainer = pixelGeoCoding instanceof PixelGeoCoding ? this.createRootContainer(NAME_PIXEL_GEO_CODING) : this.createRootContainer(NAME_PIXEL_GEO_CODING_2);
        rootContainer.add(new Property<String>(NAME_LATITUDE_BAND, latBandName));
        rootContainer.add(new Property<String>(NAME_LONGITUDE_BAND, lonBandName));
        if (validMask != null && !validMask.trim().isEmpty()) {
            rootContainer.add(new Property<String>(NAME_VALID_MASK_EXPRESSION, validMask));
        }
        rootContainer.add(new Property<Integer>(NAME_SEARCH_RADIUS, searchRadius));
        if (posEstimator != null) {
            PersistenceEncoder<GeoCoding> encoder = new Persistence().getEncoder(posEstimator);
            Item encodedEstimator = encoder.encode(posEstimator);
            Container estimatorContainer = new Container(NAME_PIXEL_POSITION_ESTIMATOR);
            rootContainer.add(estimatorContainer);
            if (encodedEstimator.isContainer()) {
                estimatorContainer.add((Container)encodedEstimator);
            } else {
                estimatorContainer.add((Property)encodedEstimator);
            }
        }
        return rootContainer;
    }

    @Override
    public BasicPixelGeoCoding decodeImpl(Item item, Product product) {
        String codingName;
        String valueString;
        Container rootContainer = item.asContainer();
        String latBandName = rootContainer.getProperty(NAME_LATITUDE_BAND).getValueString();
        String lonBandName = rootContainer.getProperty(NAME_LONGITUDE_BAND).getValueString();
        Band latBand = product.getBand(latBandName);
        Band lonBand = product.getBand(lonBandName);
        int searchRadius = rootContainer.getProperty(NAME_SEARCH_RADIUS).getValueInt();
        if (searchRadius == 0) {
            searchRadius = 6;
        }
        String validMask = null;
        Property<?> validMaskProp = rootContainer.getProperty(NAME_VALID_MASK_EXPRESSION);
        if (validMaskProp != null && (valueString = validMaskProp.getValueString()) != null && valueString.trim().length() > 0) {
            validMask = valueString.trim();
        }
        Container posEstimatorContainer = rootContainer.getContainer(NAME_PIXEL_POSITION_ESTIMATOR);
        GeoCoding estimator = null;
        if (posEstimatorContainer != null) {
            Container estimGC = posEstimatorContainer.getContainers()[0];
            PersistenceDecoder decoder = new Persistence().getDecoder(estimGC);
            estimator = (GeoCoding)decoder.decode(estimGC, product);
        }
        if (NAME_PIXEL_GEO_CODING.equals(codingName = rootContainer.getName())) {
            return new PixelGeoCoding(latBand, lonBand, validMask, searchRadius, estimator);
        }
        if (NAME_PIXEL_GEO_CODING_2.equals(codingName)) {
            return new PixelGeoCoding2(latBand, lonBand, validMask, searchRadius, estimator);
        }
        return null;
    }

    @Override
    public HistoricalDecoder[] getHistoricalDecoders() {
        return new HistoricalDecoder[0];
    }
}

