/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import com.bc.ceres.binding.PropertyContainer;
import java.awt.Color;
import org.esa.snap.core.dataio.persistence.Container;
import org.esa.snap.core.dataio.persistence.HistoricalDecoder;
import org.esa.snap.core.dataio.persistence.Item;
import org.esa.snap.core.dataio.persistence.PersistenceConverter;
import org.esa.snap.core.dataio.persistence.Property;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNodePersistenceHelper;

public abstract class AbstractMaskPersistenceConverter
extends PersistenceConverter<Mask> {
    private static final String NAME_MASK = "Mask";
    private static final String NAME_NAME = "NAME";
    private static final String NAME_MASK_RASTER_WIDTH = "MASK_RASTER_WIDTH";
    private static final String NAME_MASK_RASTER_HEIGHT = "MASK_RASTER_HEIGHT";
    private static final String NAME_DESCRIPTION = "DESCRIPTION";
    private static final String NAME_TRANSPARENCY = "TRANSPARENCY";
    private static final String NAME_TYPE = "type";
    private static final String NAME_COLOR = "COLOR";
    private static final String NAME_RED = "red";
    private static final String NAME_GREEN = "green";
    private static final String NAME_BLUE = "blue";
    private static final String NAME_ALPHA = "alpha";

    @Override
    protected Mask decodeImpl(Item item, Product product) {
        int height;
        int width;
        Container root = item.asContainer();
        String name = root.getProperty(NAME_NAME).getValueString();
        if (root.getProperty(NAME_MASK_RASTER_WIDTH) != null && root.getProperty(NAME_MASK_RASTER_HEIGHT) != null) {
            width = root.getProperty(NAME_MASK_RASTER_WIDTH).getValueInt();
            height = root.getProperty(NAME_MASK_RASTER_HEIGHT).getValueInt();
        } else {
            width = product.getSceneRasterWidth();
            height = product.getSceneRasterHeight();
        }
        Mask mask = new Mask(name, width, height, this.createImageType());
        mask.setDescription(root.getProperty(NAME_DESCRIPTION).getValueString());
        mask.setImageTransparency(root.getProperty(NAME_TRANSPARENCY).getValueDouble());
        this.setImageColor(root, mask);
        RasterDataNodePersistenceHelper.setImageToModelTransform(root, mask);
        RasterDataNodePersistenceHelper.setAncillaryRelations(root, mask);
        RasterDataNodePersistenceHelper.setAncillaryVariables(root, mask, product);
        this.configureMask(mask, root, product);
        return mask;
    }

    @Override
    public Item encode(Mask mask) {
        Container root = this.createRootContainer(NAME_MASK);
        root.add(new Property<String>(NAME_TYPE, mask.getImageType().getName()));
        root.add(new Property<String>(NAME_NAME, mask.getName()));
        root.add(new Property<Integer>(NAME_MASK_RASTER_WIDTH, mask.getRasterWidth()));
        root.add(new Property<Integer>(NAME_MASK_RASTER_HEIGHT, mask.getRasterHeight()));
        root.add(new Property<String>(NAME_DESCRIPTION, mask.getDescription()));
        RasterDataNodePersistenceHelper.addAncillaryElements(root, mask);
        this.addImageConfigElements(root, mask);
        RasterDataNodePersistenceHelper.addImageToModelTransformElement(root, mask);
        this.configureContainer(root, mask);
        return root;
    }

    @Override
    public HistoricalDecoder[] getHistoricalDecoders() {
        return new HistoricalDecoder[0];
    }

    private void setImageColor(Container container, Mask mask) {
        Container colorContainer = container.getContainer(NAME_COLOR);
        int r = colorContainer.getProperty(NAME_RED).getValueInt();
        int g = colorContainer.getProperty(NAME_GREEN).getValueInt();
        int b = colorContainer.getProperty(NAME_BLUE).getValueInt();
        int a = colorContainer.getProperty(NAME_ALPHA).getValueInt();
        mask.setImageColor(new Color(r, g, b, a));
    }

    private void addImageConfigElements(Container root, Mask mask) {
        Container colorContainer = new Container(NAME_COLOR);
        PropertyContainer config = mask.getImageConfig();
        Color color = (Color)config.getValue("color");
        colorContainer.add(new Property<Integer>(NAME_RED, color.getRed()));
        colorContainer.add(new Property<Integer>(NAME_GREEN, color.getGreen()));
        colorContainer.add(new Property<Integer>(NAME_BLUE, color.getBlue()));
        colorContainer.add(new Property<Integer>(NAME_ALPHA, color.getAlpha()));
        root.add(colorContainer);
        root.add(new Property<Double>(NAME_TRANSPARENCY, mask.getImageTransparency()));
    }

    protected abstract Mask.ImageType createImageType();

    protected abstract void configureMask(Mask var1, Container var2, Product var3);

    protected abstract void configureContainer(Container var1, Mask var2);
}

