/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import com.bc.ceres.core.Assert;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Scene;
import org.esa.snap.core.transform.GeoCodingMathTransform;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultDerivedCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.MathTransform;

public abstract class AbstractGeoCoding
implements GeoCoding {
    private CoordinateReferenceSystem imageCRS;
    private CoordinateReferenceSystem mapCRS;
    private CoordinateReferenceSystem geoCRS;
    private volatile MathTransform image2Map;

    protected AbstractGeoCoding() {
        this((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    protected AbstractGeoCoding(CoordinateReferenceSystem geoCRS) {
        this.setGeoCRS(geoCRS);
        this.setMapCRS(geoCRS);
        this.setImageCRS((CoordinateReferenceSystem)AbstractGeoCoding.createImageCRS(this.getMapCRS(), (MathTransform)new GeoCodingMathTransform(this)));
    }

    public abstract boolean transferGeoCoding(Scene var1, Scene var2, ProductSubsetDef var3);

    @Override
    public CoordinateReferenceSystem getImageCRS() {
        return this.imageCRS;
    }

    protected final void setImageCRS(CoordinateReferenceSystem imageCRS) {
        Assert.notNull((Object)imageCRS, (String)"imageCRS");
        this.imageCRS = imageCRS;
    }

    @Override
    public CoordinateReferenceSystem getMapCRS() {
        return this.mapCRS;
    }

    protected final void setMapCRS(CoordinateReferenceSystem mapCRS) {
        Assert.notNull((Object)mapCRS, (String)"mapCRS");
        this.mapCRS = mapCRS;
    }

    @Override
    public CoordinateReferenceSystem getGeoCRS() {
        return this.geoCRS;
    }

    public final void setGeoCRS(CoordinateReferenceSystem geoCRS) {
        Assert.notNull((Object)geoCRS, (String)"geoCRS");
        this.geoCRS = geoCRS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MathTransform getImageToMapTransform() {
        if (this.image2Map == null) {
            AbstractGeoCoding abstractGeoCoding = this;
            synchronized (abstractGeoCoding) {
                if (this.image2Map == null) {
                    try {
                        this.image2Map = CRS.findMathTransform((CoordinateReferenceSystem)this.imageCRS, (CoordinateReferenceSystem)this.mapCRS);
                    }
                    catch (FactoryException e) {
                        throw new IllegalArgumentException("Not able to find a math transformation from image to map CRS.", e);
                    }
                }
            }
        }
        return this.image2Map;
    }

    @Override
    public GeoCoding clone() {
        throw new IllegalStateException("not implemented");
    }

    @Override
    public boolean canClone() {
        return false;
    }

    protected static DefaultDerivedCRS createImageCRS(CoordinateReferenceSystem baseCRS, MathTransform baseToDerivedTransform) {
        return new DefaultDerivedCRS("Image CS based on " + baseCRS.getName(), baseCRS, baseToDerivedTransform, (CoordinateSystem)DefaultCartesianCS.DISPLAY);
    }
}

