/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.rgb;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.BandSelectDescriptor;
import javax.media.jai.operator.FileLoadDescriptor;
import javax.media.jai.operator.FormatDescriptor;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.rgb.ImageProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RGBImageProfile;
import org.esa.snap.core.datamodel.RGBImageProfileManager;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.jai.SingleBandedSampleModel;

public class ImageProductReader
extends AbstractProductReader {
    public static final float[] RGB_WAVELENGTHS = new float[]{700.0f, 546.1f, 435.8f};
    public static final String[] RGBA_BAND_NAMES = new String[]{"red", "green", "blue", "alpha"};
    public static final String GRAY_BAND_NAME = "gray";
    private static boolean profilesRegistered;
    private RenderedOp sourceImage;

    public ImageProductReader(ImageProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
        if (!profilesRegistered) {
            profilesRegistered = true;
            RGBImageProfileManager.getInstance().addProfile(new RGBImageProfile("RGBA", RGBA_BAND_NAMES));
            RGBImageProfileManager.getInstance().addProfile(new RGBImageProfile("RGB", new String[]{RGBA_BAND_NAMES[0], RGBA_BAND_NAMES[1], RGBA_BAND_NAMES[2]}));
        }
    }

    @Override
    protected Product readProductNodesImpl() throws IOException {
        File file = ImageProductReaderPlugIn.getFile(this.getInput());
        this.sourceImage = FileLoadDescriptor.create((String)file.getPath(), null, (Boolean)true, null);
        ColorModel colorModel = this.sourceImage.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        SampleModel sampleModel = this.sourceImage.getSampleModel();
        Product product = new Product(FileUtils.getFilenameWithoutExtension(file), "IMAGE", this.sourceImage.getWidth(), this.sourceImage.getHeight());
        product.setFileLocation(file);
        product.setDescription(String.format("Image (%s, %s)", colorSpace.getClass().getSimpleName(), sampleModel.getClass().getSimpleName()));
        int numBands = this.sourceImage.getNumBands();
        for (int i = 0; i < numBands; ++i) {
            RenderedOp bandImage = this.getBandSourceImage(i);
            if (i == 0) {
                product.setPreferredTileSize(bandImage.getTileWidth(), bandImage.getTileHeight());
            }
            Object bandName = numBands == 1 ? GRAY_BAND_NAME : (numBands == 3 || numBands == 4 ? RGBA_BAND_NAMES[i] : "b" + (i + 1));
            Band band = product.addBand((String)bandName, ImageManager.getProductDataType(bandImage.getSampleModel().getDataType()));
            band.setSourceImage((RenderedImage)bandImage);
            band.setUnit("dl");
            band.setDescription("Image component #" + (i + 1));
            if (numBands != 3 && numBands != 4 || i >= 3) continue;
            band.setSpectralBandIndex(i);
            band.setSpectralWavelength(RGB_WAVELENGTHS[i]);
        }
        if (numBands == 3 || numBands == 4) {
            product.addBand(GRAY_BAND_NAME, String.format("0.3 * %s + 0.59 * %s + 0.11 * %s", RGBA_BAND_NAMES[0], RGBA_BAND_NAMES[1], RGBA_BAND_NAMES[2]), 30);
        }
        if (numBands == 4) {
            String validPixelExpression = String.format("%s > 0", RGBA_BAND_NAMES[3]);
            for (int i = 0; i < 3; ++i) {
                product.getBandAt(i).setValidPixelExpression(validPixelExpression);
            }
            product.getBand(GRAY_BAND_NAME).setValidPixelExpression(validPixelExpression);
        }
        return product;
    }

    private RenderedOp getBandSourceImage(int i) {
        boolean noSourceImageTiling;
        RenderedOp bandImage = BandSelectDescriptor.create((RenderedImage)this.sourceImage, (int[])new int[]{i}, null);
        int tileWidth = bandImage.getTileWidth();
        int tileHeight = bandImage.getTileHeight();
        ImageLayout imageLayout = new ImageLayout();
        boolean bl = noSourceImageTiling = tileWidth == bandImage.getWidth() && tileHeight == bandImage.getHeight();
        if (noSourceImageTiling) {
            tileWidth = Math.min(bandImage.getWidth(), 512);
            tileHeight = Math.min(bandImage.getHeight(), 512);
            imageLayout.setTileWidth(tileWidth);
            imageLayout.setTileHeight(tileHeight);
        }
        imageLayout.setSampleModel((SampleModel)((Object)new SingleBandedSampleModel(bandImage.getSampleModel().getDataType(), tileWidth, tileHeight)));
        bandImage = FormatDescriptor.create((RenderedImage)bandImage, (Integer)bandImage.getSampleModel().getDataType(), (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout));
        return bandImage;
    }

    @Override
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.sourceImage.dispose();
    }
}

