/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.persistence;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.esa.snap.core.dataio.persistence.Item;

public abstract class ValueItem<E>
extends Item {
    private final E value;

    protected ValueItem(String name, E value) {
        super(name);
        this.value = value;
    }

    public E getValue() {
        return this.value;
    }

    public String getValueString() {
        return String.valueOf(this.value);
    }

    public String[] getValueStrings() {
        if (this.value != null && this.value.getClass().isArray()) {
            Object[] v = (Object[])this.value;
            return (String[])Arrays.stream(v).map(String::valueOf).toArray(String[]::new);
        }
        String str = this.getValueString();
        String delimiter = "\", \"";
        if (str.contains("\", \"")) {
            str = str.startsWith("\"") ? str.substring(1) : str;
            str = str.endsWith("\"") ? str.substring(0, str.length() - 1) : str;
            return StringUtils.splitByWholeSeparator((String)str, (String)"\", \"");
        }
        return new String[]{str};
    }

    public Double getValueDouble() {
        return ValueItem.getaDouble(this.value);
    }

    public Double[] getValueDoubles() {
        if (this.value != null && this.value.getClass().isArray()) {
            if ("double".equals(this.value.getClass().getComponentType().getName())) {
                double[] doubles = (double[])this.value;
                Double[] Doubles = new Double[doubles.length];
                for (int i = 0; i < doubles.length; ++i) {
                    Doubles[i] = doubles[i];
                }
                return Doubles;
            }
            Object[] v = (Object[])this.value;
            return (Double[])Arrays.stream(v).map(ValueItem::getaDouble).toArray(Double[]::new);
        }
        if (this.value instanceof List) {
            List list = (List)this.value;
            Stream<Double> stream = list.stream().map(ValueItem::getaDouble);
            return (Double[])stream.toArray(Double[]::new);
        }
        if (this.value != null && this.value instanceof String) {
            String str = (String)this.value;
            String[] strings = org.esa.snap.core.util.StringUtils.csvToArray(str);
            return (Double[])Arrays.stream(strings).map(ValueItem::getaDouble).toArray(Double[]::new);
        }
        return new Double[]{ValueItem.getaDouble(this.value)};
    }

    public Float getValueFloat() {
        return ValueItem.getaFloat(this.value);
    }

    public Float[] getValueFloats() {
        Double[] doubles = this.getValueDoubles();
        if (doubles != null) {
            return (Float[])Arrays.stream(doubles).map(aDouble -> aDouble != null ? Float.valueOf(aDouble.floatValue()) : null).toArray(Float[]::new);
        }
        return new Float[]{ValueItem.getaFloat(this.value)};
    }

    public Long getValueLong() {
        return ValueItem.getaLong(this.value);
    }

    public Long[] getValueLongs() {
        if (this.value != null && this.value.getClass().isArray()) {
            Object[] v = (Object[])this.value;
            return (Long[])Arrays.stream(v).map(ValueItem::getaLong).toArray(Long[]::new);
        }
        if (this.value instanceof List) {
            List list = (List)this.value;
            Stream<Long> stream = list.stream().map(ValueItem::getaLong);
            return (Long[])stream.toArray(Long[]::new);
        }
        if (this.value != null && this.value instanceof String) {
            String str = (String)this.value;
            String[] strings = org.esa.snap.core.util.StringUtils.csvToArray(str);
            return (Long[])Arrays.stream(strings).map(ValueItem::getaLong).toArray(Long[]::new);
        }
        return new Long[]{ValueItem.getaLong(this.value)};
    }

    public Integer getValueInt() {
        return ValueItem.getAnInteger(this.value);
    }

    public Integer[] getValueInts() {
        if (this.value != null && this.value.getClass().isArray()) {
            Object[] v = (Object[])this.value;
            return (Integer[])Arrays.stream(v).map(ValueItem::getAnInteger).toArray(Integer[]::new);
        }
        return (Integer[])Arrays.stream(this.getValueLongs()).map(aLong -> aLong != null ? Integer.valueOf(aLong.intValue()) : null).toArray(Integer[]::new);
    }

    public Short getValueShort() {
        return ValueItem.getaShort(this.value);
    }

    public Short[] getValueShorts() {
        if (this.value != null && this.value.getClass().isArray()) {
            Object[] v = (Object[])this.value;
            return (Short[])Arrays.stream(v).map(ValueItem::getaShort).toArray(Short[]::new);
        }
        return (Short[])Arrays.stream(this.getValueLongs()).map(aLong -> aLong != null ? Short.valueOf(aLong.shortValue()) : null).toArray(Short[]::new);
    }

    public Byte getValueByte() {
        return ValueItem.getaByte(this.value);
    }

    public Byte[] getValueBytes() {
        if (this.value != null && this.value.getClass().isArray()) {
            Object[] v = (Object[])this.value;
            return (Byte[])Arrays.stream(v).map(ValueItem::getaByte).toArray(Byte[]::new);
        }
        return (Byte[])Arrays.stream(this.getValueLongs()).map(aLong -> aLong != null ? Byte.valueOf(aLong.byteValue()) : null).toArray(Byte[]::new);
    }

    public Boolean getValueBoolean() {
        return ValueItem.getaBoolean(this.value);
    }

    public Boolean[] getValueBooleans() {
        if (this.value != null && this.value.getClass().isArray()) {
            Object[] v = (Object[])this.value;
            return (Boolean[])Arrays.stream(v).map(ValueItem::getaBoolean).toArray(Boolean[]::new);
        }
        if (this.value != null && this.value instanceof String) {
            String str = (String)this.value;
            String[] strings = org.esa.snap.core.util.StringUtils.csvToArray(str);
            return (Boolean[])Arrays.stream(strings).map(ValueItem::getaBoolean).toArray(Boolean[]::new);
        }
        return new Boolean[]{ValueItem.getaBoolean(this.value)};
    }

    public E get() {
        return this.value;
    }

    static Double getaDouble(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if ("null".equalsIgnoreCase(str.trim())) {
                return null;
            }
            return Double.parseDouble(str);
        }
        return Double.NaN;
    }

    static Float getaFloat(Object value) {
        Double d = ValueItem.getaDouble(value);
        if (d != null) {
            return Float.valueOf(d.floatValue());
        }
        return null;
    }

    static Long getaLong(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if ("null".equalsIgnoreCase(str.trim())) {
                return null;
            }
            return Long.parseLong(str.trim());
        }
        return null;
    }

    static Integer getAnInteger(Object value) {
        Long aLong = ValueItem.getaLong(value);
        if (aLong != null) {
            return aLong.intValue();
        }
        return null;
    }

    static Short getaShort(Object value) {
        Long aLong = ValueItem.getaLong(value);
        if (aLong != null) {
            return aLong.shortValue();
        }
        return null;
    }

    static Byte getaByte(Object value) {
        Long aLong = ValueItem.getaLong(value);
        if (aLong != null) {
            return aLong.byteValue();
        }
        return null;
    }

    static Boolean getaBoolean(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String str = (String)value;
            if ("null".equalsIgnoreCase(str.trim())) {
                return null;
            }
            return Boolean.parseBoolean(str);
        }
        return null;
    }
}

