/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.persistence;

import java.util.LinkedHashMap;
import org.esa.snap.core.dataio.persistence.Attribute;
import org.esa.snap.core.dataio.persistence.AttributeContainer;
import org.esa.snap.core.dataio.persistence.ValueItem;

public class Property<E>
extends ValueItem<E>
implements AttributeContainer {
    private final LinkedHashMap<String, Attribute<?>> attributes = new LinkedHashMap();

    public Property(String name, E value) {
        super(name, value);
    }

    @Override
    public boolean isProperty() {
        return true;
    }

    @Override
    public Property<?> asProperty() {
        return this;
    }

    @Override
    public Attribute<?>[] getAttributes() {
        return this.attributes.values().toArray(new Attribute[0]);
    }

    @Override
    public Attribute<?> getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Attribute<?> removeAttribute(String name) {
        return (Attribute)this.attributes.remove(name);
    }

    @Override
    public void set(Attribute<?> attribute) {
        if (attribute == null) {
            return;
        }
        String name = attribute.getName();
        this.attributes.remove(name);
        this.attributes.put(name, attribute);
    }
}

