/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.persistence;

import org.esa.snap.core.dataio.persistence.HistoricalDecoder;
import org.esa.snap.core.dataio.persistence.Item;
import org.esa.snap.core.dataio.persistence.Property;
import org.esa.snap.core.datamodel.Product;

public interface PersistenceDecoder<T> {
    public static final String KEY_PERSISTENCE_ID = "___persistence_id___";

    public String getID();

    public T decode(Item var1, Product var2);

    public HistoricalDecoder[] getHistoricalDecoders();

    default public boolean canDecode(Item item) {
        if (this.isCurrentVersion(item)) {
            return true;
        }
        HistoricalDecoder[] decoders = this.getHistoricalDecoders();
        for (int i = decoders.length - 1; i >= 0; --i) {
            HistoricalDecoder decoder = decoders[i];
            if (!decoder.canDecode(item)) continue;
            return true;
        }
        return false;
    }

    default public boolean isCurrentVersion(Item item) {
        if (item == null || !item.isContainer()) {
            return false;
        }
        Property<?> property = item.asContainer().getProperty(KEY_PERSISTENCE_ID);
        if (property == null) {
            return false;
        }
        return this.getID().equals(property.getValueString());
    }
}

