/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.persistence;

import org.esa.snap.core.dataio.persistence.Container;
import org.esa.snap.core.dataio.persistence.HistoricalDecoder;
import org.esa.snap.core.dataio.persistence.Item;
import org.esa.snap.core.dataio.persistence.PersistenceDecoder;
import org.esa.snap.core.dataio.persistence.PersistenceEncoder;
import org.esa.snap.core.dataio.persistence.Property;
import org.esa.snap.core.datamodel.Product;

public abstract class PersistenceConverter<T>
implements PersistenceEncoder<T>,
PersistenceDecoder<T> {
    @Override
    public T decode(Item item, Product product) {
        if (!this.isCurrentVersion(item)) {
            item = this.convertToCurrentVersion(item, product);
        }
        return this.decodeImpl(item, product);
    }

    protected abstract T decodeImpl(Item var1, Product var2);

    protected Item convertToCurrentVersion(Item item, Product product) {
        int i;
        HistoricalDecoder[] decoders = this.getHistoricalDecoders();
        int startIndex = -1;
        for (i = decoders.length - 1; i >= 0; --i) {
            if (!decoders[i].canDecode(item)) continue;
            startIndex = i;
            break;
        }
        if (startIndex == -1) {
            throw new IllegalStateException("Unable to decode item.");
        }
        for (i = startIndex; i < decoders.length; ++i) {
            item = (Item)decoders[i].decode(item, product);
        }
        return item;
    }

    protected final Container createRootContainer(String name) {
        Container rootContainer = new Container(name);
        rootContainer.add(new Property<String>("___persistence_id___", this.getID()));
        return rootContainer;
    }

    @Override
    public HistoricalDecoder[] getHistoricalDecoders() {
        return new HistoricalDecoder[0];
    }
}

