/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.persistence;

import java.util.Iterator;
import org.esa.snap.core.dataio.persistence.Item;
import org.esa.snap.core.dataio.persistence.PersistenceConverter;
import org.esa.snap.core.dataio.persistence.PersistenceDecoder;
import org.esa.snap.core.dataio.persistence.PersistenceEncoder;
import org.esa.snap.core.dataio.persistence.PersistenceSpi;
import org.esa.snap.core.dataio.persistence.PersistenceSpiRegistry;

public class Persistence {
    private final PersistenceSpiRegistry spiRegistry;

    public Persistence() {
        this(PersistenceSpiRegistry.getInstance());
    }

    Persistence(PersistenceSpiRegistry spiRegistry) {
        this.spiRegistry = spiRegistry;
    }

    public <T> PersistenceDecoder<T> getDecoder(Item item) {
        return this.getRegisteredConverter(item);
    }

    public <T> PersistenceEncoder<T> getEncoder(Object object) {
        return this.getRegisteredConverter(object);
    }

    private <T> PersistenceConverter<T> getRegisteredConverter(Object object) {
        Iterator<PersistenceSpi> serviceProviders = this.spiRegistry.getPersistenceSpis();
        while (serviceProviders.hasNext()) {
            PersistenceSpi persistenceSpi = serviceProviders.next();
            if (!Persistence.checkUsability(persistenceSpi, object)) continue;
            return persistenceSpi.createConverter();
        }
        return null;
    }

    private static boolean checkUsability(PersistenceSpi persistenceSpi, Object object) {
        if (object instanceof Item) {
            return persistenceSpi.canDecode((Item)object);
        }
        return persistenceSpi.canEncode(object);
    }
}

