/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.persistence;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.esa.snap.core.dataio.persistence.Attribute;
import org.esa.snap.core.dataio.persistence.Container;
import org.esa.snap.core.dataio.persistence.Item;
import org.esa.snap.core.dataio.persistence.MarkupLanguageSupport;
import org.esa.snap.core.dataio.persistence.Property;

public class JsonLanguageSupport
implements MarkupLanguageSupport<Map<String, Object>> {
    public static final String IS_PROPERTY = "_@%$_is_property";
    public static final String VALUE = "value";
    public static final String ATT_PREFIX = "_$ATT$_";

    @Override
    public <T> T translateToLanguageObject(Item item) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (item.isProperty()) {
            this.addProperty(map, item.asProperty());
        } else {
            this.addContainer(map, item.asContainer());
        }
        return (T)map;
    }

    @Override
    public Item translateToItem(Map<String, Object> objects) {
        if (objects.entrySet().size() != 1) {
            throw new IllegalArgumentException("The map must contain only one entry, which corresponds to the language representation of one object.");
        }
        Map.Entry<String, Object> entry = objects.entrySet().iterator().next();
        return this.createItem(entry.getKey(), entry.getValue());
    }

    private void addContainer(Map<String, Object> map, Container container) {
        Container[] containers;
        Property<?>[] properties;
        LinkedHashMap<String, Object> newContainerMap = new LinkedHashMap<String, Object>();
        String name = container.getName();
        if (map.containsKey(name)) {
            Object o = map.get(name);
            if (o instanceof List) {
                List mapList = (List)o;
                mapList.add(newContainerMap);
            } else {
                ArrayList list = new ArrayList();
                list.add((Map)o);
                list.add(newContainerMap);
                map.put(name, list);
            }
        } else {
            map.put(name, newContainerMap);
        }
        Attribute<?>[] attributes = container.getAttributes();
        for (Attribute<?> attribute : attributes) {
            this.addAttribute(newContainerMap, attribute);
        }
        for (Property<?> property : properties = container.getProperties()) {
            this.addProperty(newContainerMap, property);
        }
        for (Container cont : containers = container.getContainers()) {
            this.addContainer(newContainerMap, cont);
        }
    }

    private void addProperty(Map<String, Object> map, Property<?> property) {
        Attribute<?>[] attributes = property.getAttributes();
        if (attributes.length == 0) {
            map.put(property.getName(), property.getValue());
        } else {
            LinkedHashMap<String, Object> mapProp = new LinkedHashMap<String, Object>();
            map.put(property.getName(), mapProp);
            mapProp.put(IS_PROPERTY, true);
            for (Attribute<?> attribute : attributes) {
                this.addAttribute(mapProp, attribute);
            }
            mapProp.put(VALUE, property.getValue());
        }
    }

    private void addAttribute(Map<String, Object> map, Attribute<?> attribute) {
        map.put(ATT_PREFIX + attribute.getName(), attribute.getValue());
    }

    private Item createItem(String name, Object value) {
        if (value instanceof Map) {
            Map map = (Map)value;
            if (map.containsKey(IS_PROPERTY)) {
                return this.createPropertyContainingAttributes(name, map);
            }
            return this.createContainer(name, map);
        }
        return new Property<Object>(name, value);
    }

    private Container createContainer(String name, Map<String, Object> map) {
        Container container = new Container(name);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key.startsWith(ATT_PREFIX)) {
                container.set(new Attribute<Object>(this.getAttName(key), value));
                continue;
            }
            if (value instanceof Map) {
                container.add(this.createContainer(key, (Map)value));
                continue;
            }
            container.add(new Property<Object>(key, value));
        }
        return container;
    }

    private Property<?> createPropertyContainingAttributes(String name, Map<String, Object> map) {
        Property<Object> property = new Property<Object>(name, map.get(VALUE));
        for (String key : map.keySet()) {
            if (!key.startsWith(ATT_PREFIX)) continue;
            String attName = this.getAttName(key);
            Object attValue = map.get(key);
            property.set(new Attribute<Object>(attName, attValue));
        }
        return property;
    }

    private String getAttName(String attName) {
        return attName.substring(ATT_PREFIX.length());
    }
}

