/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.persistence;

import java.util.List;
import org.esa.snap.core.dataio.persistence.Attribute;
import org.esa.snap.core.dataio.persistence.AttributeContainer;
import org.esa.snap.core.dataio.persistence.Container;
import org.esa.snap.core.dataio.persistence.Item;
import org.esa.snap.core.dataio.persistence.MarkupLanguageSupport;
import org.esa.snap.core.dataio.persistence.Property;
import org.esa.snap.core.util.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class JdomLanguageSupport
implements MarkupLanguageSupport<Element> {
    private static final String ATTR___THE_UNCHANGED_NAME = "ATTR___THE_UNCHANGED_NAME";

    @Override
    public Element translateToLanguageObject(Item item) {
        if (item.isProperty()) {
            Property<?> p = item.asProperty();
            return this.createPropertyElem(p);
        }
        if (item.isContainer()) {
            Container c = item.asContainer();
            return this.createContainerElem(c);
        }
        throw new IllegalArgumentException("Item must be type of Container or type of Property");
    }

    @Override
    public Item translateToItem(Element languageObject) {
        if (languageObject.getChildren().size() == 0) {
            return this.createProperty(languageObject);
        }
        return this.createContainer(languageObject);
    }

    private Property<?> createProperty(Element element) {
        String name = JdomLanguageSupport.fetchNameFrom(element);
        String value = element.getValue();
        Property<String> property = new Property<String>(name, value);
        this.addAttributes(property, element.getAttributes());
        Property<String> item = property;
        return item;
    }

    private Container createContainer(Element element) {
        String name = JdomLanguageSupport.fetchNameFrom(element);
        Container container = new Container(name);
        this.addAttributes(container, element.getAttributes());
        this.addChildren(container, element.getChildren());
        return container;
    }

    private void addChildren(Container container, List<Element> children) {
        for (Element child : children) {
            if (child.getChildren().size() == 0) {
                container.add(this.createProperty(child));
                continue;
            }
            container.add(this.createContainer(child));
        }
    }

    private void addAttributes(AttributeContainer attCon, List<org.jdom2.Attribute> attributes) {
        for (org.jdom2.Attribute jdomA : attributes) {
            String name = jdomA.getName();
            if (ATTR___THE_UNCHANGED_NAME.equals(name)) continue;
            Attribute<String> attribute = new Attribute<String>(name, jdomA.getValue());
            attCon.set(attribute);
        }
    }

    private Element createContainerElem(Container c) {
        Element element = JdomLanguageSupport.createElementWitValidName(c.getName());
        this.addJdomAttributes(element, c.getAttributes());
        this.addChildElems(element, c.getContainers());
        this.addPropertieyElems(element, c.getProperties());
        return element;
    }

    private Element createPropertyElem(Property<?> p) {
        Element element = JdomLanguageSupport.createElementWitValidName(p.getName());
        Object value = p.getValue();
        if (value == null || !value.getClass().isArray()) {
            element.setText(String.valueOf(value));
        } else if (value.getClass().equals(String[].class)) {
            element.setText("\"" + StringUtils.arrayToString(value, "\", \"") + "\"");
        } else {
            element.setText(StringUtils.arrayToString(value, ", "));
        }
        this.addJdomAttributes(element, p.getAttributes());
        return element;
    }

    private void addJdomAttributes(Element element, Attribute<?>[] attributes) {
        for (Attribute<?> attribute : attributes) {
            element.setAttribute(attribute.getName(), attribute.getValueString());
        }
    }

    private void addPropertieyElems(Element element, Property<?>[] properties) {
        for (Property<?> property : properties) {
            element.addContent((Content)this.createPropertyElem(property));
        }
    }

    private void addChildElems(Element element, Container[] containers) {
        for (Container container : containers) {
            element.addContent((Content)this.createContainerElem(container));
        }
    }

    static Element createElementWitValidName(String name) {
        String validXmlName = JdomLanguageSupport.ensureValidName(name);
        Element element = new Element(validXmlName);
        if (!validXmlName.equals(name)) {
            element.setAttribute(ATTR___THE_UNCHANGED_NAME, name);
        }
        return element;
    }

    static String fetchNameFrom(Element element) {
        org.jdom2.Attribute unmodifiedName = element.getAttribute(ATTR___THE_UNCHANGED_NAME);
        if (unmodifiedName != null) {
            return unmodifiedName.getValue();
        }
        return element.getName();
    }

    static String ensureValidName(String name) {
        if (name == null) {
            return null;
        }
        return name.trim().replace(" ", "_");
    }
}

