/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.persistence;

import java.util.LinkedHashMap;
import org.esa.snap.core.dataio.persistence.Attribute;
import org.esa.snap.core.dataio.persistence.AttributeContainer;
import org.esa.snap.core.dataio.persistence.Item;
import org.esa.snap.core.dataio.persistence.Property;

public class Container
extends Item
implements AttributeContainer {
    private final LinkedHashMap<String, Attribute<?>> attributes = new LinkedHashMap();
    private final LinkedHashMap<String, Property<?>> properties = new LinkedHashMap();
    private final LinkedHashMap<String, Container> containers = new LinkedHashMap();

    public Container(String name) {
        super(name);
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public Container asContainer() {
        return this;
    }

    @Override
    public Attribute<?>[] getAttributes() {
        return this.attributes.values().toArray(new Attribute[0]);
    }

    @Override
    public Attribute<?> getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Attribute<?> removeAttribute(String name) {
        return (Attribute)this.attributes.remove(name);
    }

    @Override
    public void set(Attribute<?> attribute) {
        if (attribute == null) {
            return;
        }
        String name = attribute.getName();
        this.attributes.remove(name);
        this.attributes.put(name, attribute);
    }

    public Property<?>[] getProperties() {
        return this.properties.values().toArray(new Property[0]);
    }

    public Property<?> getProperty(String name) {
        return this.properties.get(name);
    }

    public Property<?> removeProperty(String name) {
        return (Property)this.properties.remove(name);
    }

    public void add(Property<?> property) {
        if (property == null) {
            return;
        }
        String name = property.getName();
        if (this.properties.containsKey(name)) {
            throw new IllegalArgumentException("Already contains a property with the name '" + name + "'.");
        }
        this.properties.put(name, property);
    }

    public Container[] getContainers() {
        return this.containers.values().toArray(new Container[0]);
    }

    public Container getContainer(String name) {
        return this.containers.get(name);
    }

    public Container removeContainer(String name) {
        return (Container)this.containers.remove(name);
    }

    public void add(Container container) {
        if (container == null) {
            return;
        }
        String name = container.getName();
        if (this.containers.containsKey(name)) {
            throw new IllegalArgumentException("Already contains a container with the name '" + name + "'.");
        }
        this.containers.put(name, container);
    }
}

