/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.geometry;

import com.bc.ceres.binding.Converter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.esa.snap.core.dataio.geometry.VectorDataNodeIO;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.converters.JavaTypeConverter;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class VectorDataNodeWriter {
    private static long id = System.nanoTime();

    public void write(VectorDataNode vectorDataNode, File file) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            this.writeNodeProperties(vectorDataNode, writer);
            this.writeFeatures((FeatureCollection<SimpleFeatureType, SimpleFeature>)vectorDataNode.getFeatureCollection(), writer);
        }
    }

    public void writeFeatures(FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection, Writer writer) throws IOException {
        SimpleFeatureType simpleFeatureType = (SimpleFeatureType)featureCollection.getSchema();
        this.writeFeatureType(simpleFeatureType, writer);
        this.writeFeatures0(featureCollection, writer);
    }

    public void writeProperties(Map<String, String> properties, Writer writer) throws IOException {
        Set<Map.Entry<String, String>> entries = properties.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            writer.write("#" + entry.getKey() + "=" + entry.getValue() + "\n");
        }
    }

    void writeNodeProperties(VectorDataNode vectorDataNode, Writer writer) throws IOException {
        String defaultCSS;
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        Map userData = vectorDataNode.getFeatureType().getUserData();
        Set entries = userData.entrySet();
        for (Map.Entry entry : entries) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            properties.put(entry.getKey().toString(), entry.getValue().toString());
        }
        String description = vectorDataNode.getDescription();
        if (StringUtils.isNotNullAndNotEmpty(description)) {
            properties.put("description", description);
        }
        if (StringUtils.isNotNullAndNotEmpty(defaultCSS = vectorDataNode.getDefaultStyleCss())) {
            properties.put("defaultCSS", defaultCSS);
        }
        this.writeProperties(properties, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFeatures0(FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection, Writer writer) throws IOException {
        Converter[] converters = VectorDataNodeIO.getConverters((SimpleFeatureType)featureCollection.getSchema());
        try (FeatureIterator features = featureCollection.features();){
            while (features.hasNext()) {
                SimpleFeature simpleFeature = (SimpleFeature)features.next();
                String fid = simpleFeature.getID();
                if (fid == null || fid.isEmpty()) {
                    fid = String.format("FID%s", Long.toHexString(id++));
                }
                writer.write(fid);
                List attributes = simpleFeature.getAttributes();
                for (int i = 0; i < attributes.size(); ++i) {
                    Object value = attributes.get(i);
                    String text = "[null]";
                    if (value != null) {
                        Converter converter = converters[i];
                        text = converter.format(value);
                        text = VectorDataNodeIO.encodeTabString(text);
                    }
                    writer.write(9);
                    writer.write(text);
                }
                writer.write(10);
            }
        }
    }

    private void writeFeatureType(SimpleFeatureType simpleFeatureType, Writer writer) throws IOException {
        writer.write(simpleFeatureType.getTypeName());
        List attributeDescriptors = simpleFeatureType.getAttributeDescriptors();
        JavaTypeConverter typeConverter = new JavaTypeConverter();
        for (AttributeDescriptor attributeDescriptor : attributeDescriptors) {
            Class binding = attributeDescriptor.getType().getBinding();
            String name = attributeDescriptor.getLocalName();
            String type = typeConverter.format(binding);
            writer.write(9);
            writer.write(name);
            writer.write(58);
            writer.write(type);
        }
        writer.write(10);
    }
}

