/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.geocoding.util;

import java.util.Arrays;

public class SplineInterpolator {
    static double getSecondDerivative(double[] y) {
        double u = y[2] - 2.0 * y[1] + y[0];
        return 3.0 * u;
    }

    public static double interpolate(double[] y, double deriv, double x_int) {
        double derivLo;
        double derivHi;
        int xLo;
        int xHi;
        if (x_int > 1.0) {
            xHi = 2;
            xLo = 1;
            derivHi = 0.0;
            derivLo = deriv;
        } else {
            xHi = 1;
            xLo = 0;
            derivHi = deriv;
            derivLo = 0.0;
        }
        double a = (double)xHi - x_int;
        double b = x_int - (double)xLo;
        return a * y[xLo] + b * y[xHi] + ((a * a * a - a) * derivLo + (b * b * b - b) * derivHi) / 6.0;
    }

    public static double interpolate2d(double[] data, double[] derivatives, double x, double y) {
        double[] z_int = new double[]{SplineInterpolator.interpolate(Arrays.copyOfRange(data, 0, 3), derivatives[0], x), SplineInterpolator.interpolate(Arrays.copyOfRange(data, 3, 6), derivatives[1], x), SplineInterpolator.interpolate(Arrays.copyOfRange(data, 6, 9), derivatives[2], x)};
        double secondDerivative = SplineInterpolator.getSecondDerivative(z_int);
        return SplineInterpolator.interpolate(z_int, secondDerivative, y);
    }

    public static double interpolate2d(double[][] data, double x, double y) {
        double secondDerivative;
        double[] z_int = new double[3];
        for (int i = 0; i < 3; ++i) {
            secondDerivative = SplineInterpolator.getSecondDerivative(data[i]);
            z_int[i] = SplineInterpolator.interpolate(data[i], secondDerivative, x);
        }
        secondDerivative = SplineInterpolator.getSecondDerivative(z_int);
        return SplineInterpolator.interpolate(z_int, secondDerivative, y);
    }

    static double[] getSecondDerivatives(double[] x, double[] y) {
        int len = y.length;
        double[] y2 = new double[len];
        double[] u = new double[len - 1];
        for (int i = 1; i < len - 1; ++i) {
            double sig = (x[i] - x[i - 1]) / (x[i + 1] - x[i - 1]);
            double p = sig * y2[i - 1] + 2.0;
            y2[i] = (sig - 1.0) / p;
            u[i] = (y[i + 1] - y[i]) / (x[i + 1] - x[i]) - (y[i] - y[i - 1]) / (x[i] - x[i - 1]);
            u[i] = 6.0 * u[i] / (x[i + 1] - x[i - 1]) - sig * u[i - 1] / p;
        }
        double qn = 0.0;
        double un = 0.0;
        y2[len - 1] = (0.0 - 0.0 * u[len - 2]) / (0.0 * y2[len - 2] + 1.0);
        for (int k = len - 2; k > 0; --k) {
            y2[k] = y2[k] * y2[k + 1] + u[k];
        }
        return y2;
    }

    public static double interpolate(double[] x, double[] y, double[] deriv, double x_int) {
        int len = x.length;
        int klo = 0;
        int khi = len - 1;
        while (khi - klo > 1) {
            int k = klo + khi >> 1;
            if (x[k] > x_int) {
                khi = k;
                continue;
            }
            klo = k;
        }
        double h = x[khi] - x[klo];
        double a = (x[khi] - x_int) / h;
        double b = (x_int - x[klo]) / h;
        return a * y[klo] + b * y[khi] + ((a * a * a - a) * deriv[klo] + (b * b * b - b) * deriv[khi]) * (h * h) / 6.0;
    }
}

