/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.geocoding.util;

import org.esa.snap.core.util.math.DistanceMeasure;
import org.opengis.referencing.datum.Ellipsoid;

public class EllipsoidDistance
implements DistanceMeasure {
    private final double lon_rad;
    private final double lat_rad;
    private final double a;
    private final double f;

    public EllipsoidDistance(double lon, double lat, Ellipsoid ellipsoid) {
        this.lon_rad = Math.toRadians(lon);
        this.lat_rad = Math.toRadians(lat);
        this.a = ellipsoid.getSemiMajorAxis();
        this.f = 1.0 / ellipsoid.getInverseFlattening();
    }

    @Override
    public double distance(double lon, double lat) {
        double sin_f_sq;
        double cos_g_sq;
        double C;
        double sin_l_sq;
        double cos_f_sq;
        double lon_rad = Math.toRadians(lon);
        double lat_rad = Math.toRadians(lat);
        double F = 0.5 * (this.lat_rad + lat_rad);
        double G = 0.5 * (this.lat_rad - lat_rad);
        double l = 0.5 * (this.lon_rad - lon_rad);
        double sin_f = Math.sin(F);
        double cos_f = Math.cos(F);
        double sin_g = Math.sin(G);
        double cos_g = Math.cos(G);
        double sin_l = Math.sin(l);
        double sin_q_sq = sin_g * sin_g;
        double cos_l = Math.cos(l);
        double cos_l_sq = cos_l * cos_l;
        double S = sin_q_sq * cos_l_sq + (cos_f_sq = cos_f * cos_f) * (sin_l_sq = sin_l * sin_l);
        double omega = Math.atan(Math.sqrt(S / (C = (cos_g_sq = cos_g * cos_g) * cos_l_sq + (sin_f_sq = sin_f * sin_f) * sin_l_sq)));
        if (omega == 0.0) {
            return 0.0;
        }
        double D2 = 2.0 * omega * this.a;
        double three_R = 3.0 * Math.sqrt(S * C) / omega;
        double H_1 = (three_R - 1.0) / (2.0 * C);
        double H_2 = (three_R + 1.0) / (2.0 * S);
        return D2 * (1.0 + this.f * (H_1 * sin_f_sq * cos_g_sq - H_2 * cos_f_sq * sin_q_sq));
    }
}

