/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.geocoding.util;

import org.esa.snap.core.dataio.geocoding.util.InterpolationContext;
import org.esa.snap.core.dataio.geocoding.util.XYInterpolator;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.util.math.DistanceMeasure;

abstract class DistanceWeightingInterpolator
implements XYInterpolator {
    DistanceWeightingInterpolator() {
    }

    abstract DistanceMeasure getDistanceMeasure(double var1, double var3);

    abstract double getMinDistance();

    @Override
    public PixelPos interpolate(GeoPos geoPos, PixelPos pixelPos, InterpolationContext context) {
        DistanceMeasure distance = this.getDistanceMeasure(geoPos.lon, geoPos.lat);
        double minDistance = this.getMinDistance();
        double[] distances = new double[4];
        for (int i = 0; i < 4; ++i) {
            distances[i] = distance.distance(context.lons[i], context.lats[i]);
            if (distances[i] < minDistance) {
                return new PixelPos(context.x[i], context.y[i]);
            }
            distances[i] = 1.0 / distances[i];
        }
        double inv_sum = 0.0;
        double x_sum = 0.0;
        double y_sum = 0.0;
        for (int i = 0; i < 4; ++i) {
            inv_sum += distances[i];
            x_sum += (double)context.x[i] * distances[i];
            y_sum += (double)context.y[i] * distances[i];
        }
        inv_sum = 1.0 / inv_sum;
        return new PixelPos(x_sum * inv_sum, y_sum * inv_sum);
    }
}

