/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.geocoding.util;

import org.esa.snap.core.util.math.FXYSum;

public class Approximation {
    private final FXYSum fX;
    private final FXYSum fY;
    private final double centerLat;
    private final double centerLon;
    private final double minSquareDistance;

    public Approximation(FXYSum fX, FXYSum fY, double centerLat, double centerLon, double minSquareDistance) {
        this.fX = fX;
        this.fY = fY;
        this.centerLat = centerLat;
        this.centerLon = centerLon;
        this.minSquareDistance = minSquareDistance;
    }

    public final FXYSum getFX() {
        return this.fX;
    }

    public final FXYSum getFY() {
        return this.fY;
    }

    public double getCenterLat() {
        return this.centerLat;
    }

    public double getCenterLon() {
        return this.centerLon;
    }

    public double getMinSquareDistance() {
        return this.minSquareDistance;
    }

    public final double getSquareDistance(double lat, double lon) {
        double dx = lon - this.centerLon;
        double dy = lat - this.centerLat;
        return dx * dx + dy * dy;
    }
}

