/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.geocoding.inverse;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.prefs.Preferences;
import org.esa.snap.core.dataio.geocoding.GeoRaster;
import org.esa.snap.core.dataio.geocoding.InverseCoding;
import org.esa.snap.core.dataio.geocoding.inverse.InversePlugin;
import org.esa.snap.core.dataio.geocoding.util.Approximation;
import org.esa.snap.core.dataio.geocoding.util.RasterUtils;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.math.FXYSum;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.runtime.Config;

public class TiePointInverse
implements InverseCoding {
    public static final String KEY = "INV_TIE_POINT";
    private static final String SYSPROP_TIE_POINT_INVERSE_HIGH_PRECISION = "snap.tiePointGeoCoding.maxPrecision";
    private static final int MAX_NUM_POINTS_PER_TILE = 1000;
    private static final double GEOLOCATION_MARGIN = 1.0E-5;
    static boolean highPrecisionInverse = false;
    private TiePointGrid lonGrid;
    private TiePointGrid latGrid;
    private Approximation[] approximations;
    private Boundaries boundaries;
    private int rasterWidth;
    private int rasterHeight;

    static Approximation getBestApproximation(Approximation[] approximations, double lat, double lon) {
        Approximation approximation = null;
        double minSquareDistance = Double.MAX_VALUE;
        for (Approximation approx : approximations) {
            double squareDistance;
            if (approx == null || !((squareDistance = approx.getSquareDistance(lat, lon)) < minSquareDistance) || !(squareDistance < approx.getMinSquareDistance())) continue;
            minSquareDistance = squareDistance;
            approximation = approx;
        }
        return approximation;
    }

    static Approximation findRenormalizedApproximation(Approximation[] approximations, double lat, double renormalizedLon, double distance) {
        double renormalizedDistance;
        Approximation renormalizedApproximation = TiePointInverse.getBestApproximation(approximations, lat, renormalizedLon);
        if (renormalizedApproximation != null && (renormalizedDistance = renormalizedApproximation.getSquareDistance(lat, renormalizedLon)) < distance) {
            return renormalizedApproximation;
        }
        return null;
    }

    static double normalizeLat(double lat) {
        if (lat < -90.0 || lat > 90.0) {
            return Double.NaN;
        }
        return lat;
    }

    static double normalizeLon(double lon, double normalizedLonMin, double normalizedLonMax) {
        if (lon < -180.0 || lon > 180.0) {
            return Double.NaN;
        }
        double normalizedLon = lon;
        if (normalizedLon < normalizedLonMin) {
            normalizedLon += 360.0;
        }
        if (normalizedLon < normalizedLonMin || normalizedLon > normalizedLonMax) {
            return Double.NaN;
        }
        return normalizedLon;
    }

    static Approximation[] getApproximations(TiePointGrid lonGrid, TiePointGrid latGrid) {
        int numPoints = latGrid.getGridData().getNumElems();
        int numTiles = (int)Math.ceil((double)numPoints / 10.0);
        int width = latGrid.getGridWidth();
        int height = latGrid.getGridHeight();
        double subSamplingX = latGrid.getSubSamplingX();
        double subSamplingY = latGrid.getSubSamplingY();
        int numTilesI = 1;
        int numTilesJ = 1;
        for (numTiles = Math.min(Math.max(1, numTiles), 300); numTiles > 1; --numTiles) {
            Dimension tileDim = MathUtils.fitDimension(numTiles, (double)width * subSamplingX, (double)height * subSamplingY);
            int newNumTilesI = tileDim.width;
            int newNumTilesJ = tileDim.height;
            int newNumTiles = newNumTilesI * newNumTilesJ;
            if (numPoints / newNumTiles < 10) continue;
            numTiles = newNumTiles;
            numTilesI = newNumTilesI;
            numTilesJ = newNumTilesJ;
            break;
        }
        Approximation[] approximations = new Approximation[numTiles];
        Rectangle[] rectangles = MathUtils.subdivideRectangle(width, height, numTilesI, numTilesJ, 1);
        for (int i = 0; i < rectangles.length; ++i) {
            Approximation approximation;
            approximations[i] = approximation = TiePointInverse.createApproximation(lonGrid, latGrid, rectangles[i]);
        }
        return approximations;
    }

    static Approximation createApproximation(TiePointGrid normalizedLonGrid, TiePointGrid latGrid, Rectangle subsetRect) {
        double[][] data = TiePointInverse.createWarpPoints(normalizedLonGrid, latGrid, subsetRect);
        double sumLat = 0.0;
        double sumLon = 0.0;
        for (double[] point : data) {
            sumLat += point[0];
            sumLon += point[1];
        }
        double centerLon = sumLon / (double)data.length;
        double centerLat = sumLat / (double)data.length;
        double maxSquareDistance = TiePointInverse.getMaxSquareDistance(data, centerLat, centerLon);
        for (int i = 0; i < data.length; ++i) {
            data[i][0] = TiePointInverse.rescaleLatitude(data[i][0]);
            data[i][1] = TiePointInverse.rescaleLongitude(data[i][1], centerLon);
        }
        int[] xIndices = new int[]{0, 1, 2};
        int[] yIndices = new int[]{0, 1, 3};
        FXYSum fX = TiePointInverse.getBestPolynomial(data, xIndices);
        FXYSum fY = TiePointInverse.getBestPolynomial(data, yIndices);
        if (fX == null || fY == null) {
            return null;
        }
        return new Approximation(fX, fY, centerLat, centerLon, maxSquareDistance * 1.1);
    }

    static FXYSum getBestPolynomial(double[][] data, int[] indices) {
        FXYSum[] potentialPolynomials = new FXYSum[]{new FXYSum.Linear(), new FXYSum.BiLinear(), new FXYSum.Quadric(), new FXYSum.BiQuadric(), new FXYSum.Cubic(), new FXYSum.BiCubic(), new FXYSum(FXYSum.FXY_4TH, 4), new FXYSum(FXYSum.FXY_BI_4TH, 8)};
        double rmseMin = Double.MAX_VALUE;
        int index = -1;
        for (int i = 0; i < potentialPolynomials.length; ++i) {
            FXYSum potentialPolynomial = potentialPolynomials[i];
            int order = potentialPolynomial.getOrder();
            int numPointsRequired = order >= 0 ? (order + 2) * (order + 1) / 2 : 2 * potentialPolynomial.getNumTerms();
            if (data.length < numPointsRequired) continue;
            try {
                double maxError;
                potentialPolynomial.approximate(data, indices);
                double rmse = potentialPolynomial.getRootMeanSquareError();
                if (!(rmse < rmseMin)) continue;
                index = i;
                rmseMin = rmse;
                if (highPrecisionInverse || !((maxError = potentialPolynomial.getMaxError()) < 0.25)) continue;
                break;
            }
            catch (ArithmeticException e) {
                Debug.trace("Polynomial cannot be constructed due to a numerically singular or degenerate matrix:");
                Debug.trace(e);
            }
        }
        return index >= 0 ? potentialPolynomials[index] : null;
    }

    static double rescaleLatitude(double lat) {
        return lat / 90.0;
    }

    static double rescaleLongitude(double lon, double centerLon) {
        return (lon - centerLon) / 90.0;
    }

    static double getMaxSquareDistance(double[][] data, double centerLat, double centerLon) {
        double maxSquareDistance = 0.0;
        for (double[] point : data) {
            double dLat = point[0] - centerLat;
            double dLon = point[1] - centerLon;
            double squareDistance = dLat * dLat + dLon * dLon;
            if (!(squareDistance > maxSquareDistance)) continue;
            maxSquareDistance = squareDistance;
        }
        return maxSquareDistance;
    }

    static double[][] createWarpPoints(TiePointGrid lonGrid, TiePointGrid latGrid, Rectangle subsetRect) {
        int sw = subsetRect.width;
        int sh = subsetRect.height;
        int[] warpParameters = TiePointInverse.determineWarpParameters(sw, sh);
        int numU = warpParameters[0];
        int numV = warpParameters[1];
        int stepI = warpParameters[2];
        int stepJ = warpParameters[3];
        int m = numU * numV;
        double[][] data = new double[m][4];
        int i1 = subsetRect.x;
        int i2 = i1 + sw - 1;
        int j1 = subsetRect.y;
        int j2 = j1 + sh - 1;
        int w = latGrid.getGridWidth();
        int k = 0;
        for (int v = 0; v < numV; ++v) {
            int j = j1 + v * stepJ;
            if (j > j2) {
                j = j2;
            }
            for (int u = 0; u < numU; ++u) {
                int i = i1 + u * stepI;
                if (i > i2) {
                    i = i2;
                }
                data[k][0] = latGrid.getGridData().getElemDoubleAt(j * w + i);
                data[k][1] = lonGrid.getGridData().getElemDoubleAt(j * w + i);
                data[k][2] = latGrid.getOffsetX() + (double)i * latGrid.getSubSamplingX();
                data[k][3] = latGrid.getOffsetY() + (double)j * latGrid.getSubSamplingY();
                ++k;
            }
        }
        return data;
    }

    static int[] determineWarpParameters(int sw, int sh) {
        boolean adjustStepI;
        int numU = sw;
        int numV = sh;
        int stepI = 1;
        int stepJ = 1;
        boolean bl = adjustStepI = numU >= numV;
        while (numU * numV > 1000) {
            if (adjustStepI) {
                numU = sw / ++stepI;
                while (numU * stepI < sw) {
                    ++numU;
                }
            } else {
                numV = sh / ++stepJ;
                while (numV * stepJ < sh) {
                    ++numV;
                }
            }
            adjustStepI = numU >= numV;
        }
        return new int[]{numU, numV, stepI, stepJ};
    }

    static Boundaries initLatLonMinMax(float[] lonPoints, float[] latPoints) {
        int n;
        Boundaries boundaries = new Boundaries();
        boundaries.normalizedLonMin = Double.MAX_VALUE;
        boundaries.normalizedLonMax = -1.7976931348623157E308;
        float[] fArray = lonPoints;
        int n2 = fArray.length;
        for (n = 0; n < n2; ++n) {
            double lonPoint = fArray[n];
            boundaries.normalizedLonMin = Math.min(boundaries.normalizedLonMin, lonPoint);
            boundaries.normalizedLonMax = Math.max(boundaries.normalizedLonMax, lonPoint);
        }
        boundaries.normalizedLonMin -= 1.0E-5;
        boundaries.normalizedLonMax += 1.0E-5;
        boundaries.latMin = Double.MAX_VALUE;
        boundaries.latMax = -1.7976931348623157E308;
        fArray = latPoints;
        n2 = fArray.length;
        for (n = 0; n < n2; ++n) {
            double latPoint = fArray[n];
            boundaries.latMin = Math.min(boundaries.latMin, latPoint);
            boundaries.latMax = Math.max(boundaries.latMax, latPoint);
        }
        boundaries.overlapStart = boundaries.normalizedLonMin;
        if (boundaries.overlapStart < -180.0) {
            boundaries.overlapStart += 360.0;
        }
        boundaries.overlapEnd = boundaries.normalizedLonMax;
        if (boundaries.overlapEnd > 180.0) {
            boundaries.overlapEnd -= 360.0;
        }
        return boundaries;
    }

    static TiePointGrid normalizeLonGrid(TiePointGrid lonGrid) {
        int width = lonGrid.getGridWidth();
        int height = lonGrid.getGridHeight();
        float[] longitudes = lonGrid.getTiePoints();
        int numValues = longitudes.length;
        float[] normalizedLongitudes = new float[numValues];
        System.arraycopy(longitudes, 0, normalizedLongitudes, 0, numValues);
        boolean westNormalized = false;
        boolean eastNormalized = false;
        for (int y = 0; y < height; ++y) {
            int lineOffset = y * width;
            for (int x = 0; x < width; ++x) {
                int index = x + lineOffset;
                double p2 = normalizedLongitudes[index];
                double p1 = x == 0 && y == 0 ? (double)normalizedLongitudes[index] : (x == 0 ? (double)normalizedLongitudes[x + (y - 1) * width] : (double)normalizedLongitudes[index - 1]);
                double lonDelta = p2 - p1;
                if (lonDelta > 180.0) {
                    westNormalized = true;
                    normalizedLongitudes[index] = (float)(p2 -= 360.0);
                    continue;
                }
                if (!(lonDelta < -180.0)) continue;
                eastNormalized = true;
                normalizedLongitudes[index] = (float)(p2 += 360.0);
            }
        }
        if (westNormalized) {
            int i = 0;
            while (i < numValues) {
                int n = i++;
                normalizedLongitudes[n] = normalizedLongitudes[n] + 360.0f;
            }
        }
        if (eastNormalized || westNormalized) {
            return new TiePointGrid(lonGrid.getName(), lonGrid.getGridWidth(), lonGrid.getGridHeight(), lonGrid.getOffsetX(), lonGrid.getOffsetY(), lonGrid.getSubSamplingX(), lonGrid.getSubSamplingY(), normalizedLongitudes);
        }
        return lonGrid;
    }

    @Override
    public PixelPos getPixelPos(GeoPos geoPos, PixelPos pixelPos) {
        double squareDistance;
        double tempLon;
        Approximation renormalizedApproximation;
        if (pixelPos == null) {
            pixelPos = new PixelPos();
        }
        pixelPos.setInvalid();
        if (!geoPos.isValid()) {
            return pixelPos;
        }
        double lat = TiePointInverse.normalizeLat(geoPos.lat);
        double lon = TiePointInverse.normalizeLon(geoPos.lon, this.boundaries.normalizedLonMin, this.boundaries.normalizedLonMax);
        Approximation approximation = TiePointInverse.getBestApproximation(this.approximations, lat, lon);
        if (lon >= this.boundaries.overlapStart && lon <= this.boundaries.overlapEnd && (renormalizedApproximation = TiePointInverse.findRenormalizedApproximation(this.approximations, lat, tempLon = lon + 360.0, squareDistance = approximation != null ? approximation.getSquareDistance(lat, lon) : Double.MAX_VALUE)) != null) {
            approximation = renormalizedApproximation;
            lon = tempLon;
        }
        if (approximation == null) {
            return pixelPos;
        }
        lat = TiePointInverse.rescaleLatitude(lat);
        lon = TiePointInverse.rescaleLongitude(lon, approximation.getCenterLon());
        pixelPos.x = approximation.getFX().computeZ(lat, lon);
        pixelPos.y = approximation.getFY().computeZ(lat, lon);
        if (pixelPos.x < 0.0 || pixelPos.x > (double)this.rasterWidth || pixelPos.y < 0.0 || pixelPos.y > (double)this.rasterHeight) {
            pixelPos.setInvalid();
        }
        return pixelPos;
    }

    @Override
    public void initialize(GeoRaster geoRaster, boolean containsAntiMeridian, PixelPos[] poleLocations) {
        this.lonGrid = new TiePointGrid("lon", geoRaster.getRasterWidth(), geoRaster.getRasterHeight(), geoRaster.getOffsetX(), geoRaster.getOffsetY(), geoRaster.getSubsamplingX(), geoRaster.getSubsamplingY(), RasterUtils.toFloat(geoRaster.getLongitudes()));
        this.rasterWidth = geoRaster.getSceneWidth();
        this.rasterHeight = geoRaster.getSceneHeight();
        this.latGrid = new TiePointGrid("lat", geoRaster.getRasterWidth(), geoRaster.getRasterHeight(), geoRaster.getOffsetX(), geoRaster.getOffsetY(), geoRaster.getSubsamplingX(), geoRaster.getSubsamplingY(), RasterUtils.toFloat(geoRaster.getLatitudes()));
        if (containsAntiMeridian) {
            this.lonGrid = TiePointInverse.normalizeLonGrid(this.lonGrid);
        }
        Preferences preferences = Config.instance().preferences();
        highPrecisionInverse = preferences.getBoolean(SYSPROP_TIE_POINT_INVERSE_HIGH_PRECISION, false);
        this.boundaries = TiePointInverse.initLatLonMinMax(this.lonGrid.getTiePoints(), this.latGrid.getTiePoints());
        this.approximations = TiePointInverse.getApproximations(this.lonGrid, this.latGrid);
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public void dispose() {
        if (this.latGrid != null) {
            this.latGrid.dispose();
            this.latGrid = null;
        }
        if (this.lonGrid != null) {
            this.lonGrid.dispose();
            this.lonGrid = null;
        }
    }

    @Override
    public InverseCoding clone() {
        TiePointInverse clone = new TiePointInverse();
        clone.lonGrid = this.lonGrid.cloneTiePointGrid();
        clone.latGrid = this.latGrid.cloneTiePointGrid();
        clone.rasterWidth = this.rasterWidth;
        clone.rasterHeight = this.rasterHeight;
        clone.boundaries = this.boundaries;
        clone.approximations = this.approximations;
        return clone;
    }

    public static class Plugin
    implements InversePlugin {
        @Override
        public InverseCoding create() {
            return new TiePointInverse();
        }
    }

    static class Boundaries {
        double normalizedLonMin;
        double normalizedLonMax;
        double latMin;
        double latMax;
        double overlapStart;
        double overlapEnd;

        Boundaries() {
        }
    }
}

