/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.geocoding.forward;

import org.esa.snap.core.dataio.geocoding.ForwardCoding;
import org.esa.snap.core.dataio.geocoding.GeoRaster;
import org.esa.snap.core.dataio.geocoding.forward.ForwardPlugin;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.util.math.MathUtils;

public class PixelInterpolatingForward
implements ForwardCoding {
    public static final String KEY = "FWD_PIXEL_INTERPOLATING";
    private int sceneWidth;
    private int sceneHeight;
    private double[] longitudes;
    private double[] latitudes;
    private LonInterpolator lonInterpolator;

    @Override
    public GeoPos getGeoPos(PixelPos pixelPos, GeoPos geoPos) {
        if (geoPos == null) {
            geoPos = new GeoPos();
        }
        geoPos.setInvalid();
        if (!pixelPos.isValid()) {
            return geoPos;
        }
        double x = pixelPos.getX();
        double y = pixelPos.getY();
        if (x < 0.0 || x > (double)this.sceneWidth || y < 0.0 || y > (double)this.sceneHeight) {
            return geoPos;
        }
        int x0 = (int)Math.floor(x);
        if (x0 == this.sceneWidth) {
            --x0;
            x -= 1.0;
        }
        int y0 = (int)Math.floor(y);
        if (y == (double)this.sceneHeight) {
            --y0;
            y -= 1.0;
        }
        double delta = x - (double)x0;
        if (x0 > 0 && delta < 0.5 || x0 == this.sceneWidth - 1) {
            --x0;
        }
        delta = y - (double)y0;
        if (y0 > 0 && delta < 0.5 || y0 == this.sceneHeight - 1) {
            --y0;
        }
        double wx = x - ((double)x0 + 0.5);
        double wy = y - ((double)y0 + 0.5);
        InterpolationContext context = this.getInterpolationContext(this.longitudes, x0, y0);
        double lon = this.lonInterpolator.interpolate(wx, wy, context);
        context = this.getInterpolationContext(this.latitudes, x0, y0);
        double lat = MathUtils.interpolate2D(wx, wy, context.d00, context.d10, context.d01, context.d11);
        geoPos.lon = lon;
        geoPos.lat = lat;
        return geoPos;
    }

    @Override
    public void initialize(GeoRaster geoRaster, boolean containsAntiMeridian, PixelPos[] poleLocations) {
        this.sceneWidth = geoRaster.getSceneWidth();
        this.sceneHeight = geoRaster.getSceneHeight();
        this.longitudes = geoRaster.getLongitudes();
        this.latitudes = geoRaster.getLatitudes();
        this.lonInterpolator = containsAntiMeridian ? new AntiMeridianLonInterpolator() : new StandardLonInterpolator();
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public void dispose() {
        this.longitudes = null;
        this.latitudes = null;
    }

    @Override
    public ForwardCoding clone() {
        PixelInterpolatingForward clone = new PixelInterpolatingForward();
        clone.longitudes = this.longitudes;
        clone.latitudes = this.latitudes;
        clone.sceneWidth = this.sceneWidth;
        clone.sceneHeight = this.sceneHeight;
        clone.lonInterpolator = this.lonInterpolator;
        return clone;
    }

    private InterpolationContext getInterpolationContext(double[] data, int x0, int y0) {
        InterpolationContext context = new InterpolationContext();
        context.d00 = data[y0 * this.sceneWidth + x0];
        context.d10 = data[y0 * this.sceneWidth + x0 + 1];
        context.d01 = data[(y0 + 1) * this.sceneWidth + x0];
        context.d11 = data[(y0 + 1) * this.sceneWidth + x0 + 1];
        return context;
    }

    public static class Plugin
    implements ForwardPlugin {
        @Override
        public ForwardCoding create() {
            return new PixelInterpolatingForward();
        }
    }

    static class AntiMeridianLonInterpolator
    implements LonInterpolator {
        private static final double OFFSET = 360.0;
        private static final double THRESH = 180.0;

        AntiMeridianLonInterpolator() {
        }

        @Override
        public double interpolate(double wx, double wy, InterpolationContext context) {
            double lon;
            boolean containsAntiMeridian = false;
            if (Math.abs(context.d10 - context.d00) > 180.0) {
                containsAntiMeridian = true;
            } else if (Math.abs(context.d11 - context.d01) > 180.0) {
                containsAntiMeridian = true;
            } else if (Math.abs(context.d11 - context.d10) > 180.0) {
                containsAntiMeridian = true;
            } else if (Math.abs(context.d01 - context.d00) > 180.0) {
                containsAntiMeridian = true;
            }
            if (containsAntiMeridian) {
                if (context.d00 < 0.0) {
                    context.d00 += 360.0;
                }
                if (context.d10 < 0.0) {
                    context.d10 += 360.0;
                }
                if (context.d01 < 0.0) {
                    context.d01 += 360.0;
                }
                if (context.d11 < 0.0) {
                    context.d11 += 360.0;
                }
            }
            if ((lon = MathUtils.interpolate2D(wx, wy, context.d00, context.d10, context.d01, context.d11)) > 180.0) {
                lon -= 360.0;
            }
            return lon;
        }
    }

    static class StandardLonInterpolator
    implements LonInterpolator {
        StandardLonInterpolator() {
        }

        @Override
        public double interpolate(double wx, double wy, InterpolationContext context) {
            return MathUtils.interpolate2D(wx, wy, context.d00, context.d10, context.d01, context.d11);
        }
    }

    static interface LonInterpolator {
        public double interpolate(double var1, double var3, InterpolationContext var5);
    }

    private static class InterpolationContext {
        double d00;
        double d10;
        double d01;
        double d11;

        private InterpolationContext() {
        }
    }
}

