/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.geocoding;

import java.util.HashMap;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeListenerAdapter;
import org.esa.snap.core.datamodel.RasterDataNode;

public class DataHolder {
    private final HashMap<Product, HashMap<RasterDataNode, double[]>> dataReference = new HashMap();

    private DataHolder() {
    }

    public static DataHolder getInstance() {
        return Holder.INSTANCE;
    }

    public HashMap<RasterDataNode, double[]> getDataMap(Product product) {
        if (!this.dataReference.containsKey((Object)product)) {
            product.addProductNodeListener(new ProductNodeListenerAdapter(){

                @Override
                public void nodeDisposing(ProductNodeEvent event) {
                    DataHolder.this.freeDataFor(event.getSourceNode());
                }
            });
            this.dataReference.put(product, new HashMap());
        }
        return this.dataReference.get((Object)product);
    }

    private void freeDataFor(ProductNode sourceNode) {
        HashMap<RasterDataNode, double[]> dataMap = this.dataReference.remove((Object)sourceNode);
        if (dataMap != null) {
            dataMap.clear();
        }
    }

    private static class Holder {
        private static final DataHolder INSTANCE = new DataHolder();

        private Holder() {
        }
    }
}

