/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.geocoding;

import java.io.IOException;
import java.util.HashMap;
import java.util.prefs.Preferences;
import java.util.stream.IntStream;
import org.esa.snap.core.dataio.dimap.spi.DimapHistoricalDecoder;
import org.esa.snap.core.dataio.geocoding.ComponentFactory;
import org.esa.snap.core.dataio.geocoding.ComponentGeoCoding;
import org.esa.snap.core.dataio.geocoding.DataHolder;
import org.esa.snap.core.dataio.geocoding.ForwardCoding;
import org.esa.snap.core.dataio.geocoding.GeoChecks;
import org.esa.snap.core.dataio.geocoding.GeoRaster;
import org.esa.snap.core.dataio.geocoding.InverseCoding;
import org.esa.snap.core.dataio.geocoding.util.RasterUtils;
import org.esa.snap.core.dataio.persistence.Container;
import org.esa.snap.core.dataio.persistence.HistoricalDecoder;
import org.esa.snap.core.dataio.persistence.Item;
import org.esa.snap.core.dataio.persistence.PersistenceConverter;
import org.esa.snap.core.dataio.persistence.Property;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.runtime.Config;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ComponentGeoCodingPersistenceConverter
extends PersistenceConverter<ComponentGeoCoding> {
    public static final String NAME_COMPONENT_GEO_CODING = "ComponentGeoCoding";
    public static final String NAME_FORWARD_CODING_KEY = "ForwardCodingKey";
    public static final String NAME_INVERSE_CODING_KEY = "InverseCodingKey";
    public static final String NAME_GEO_CHECKS = "GeoChecks";
    public static final String NAME_GEO_CRS = "GeoCRS";
    public static final String NAME_LON_VARIABLE_NAME = "LonVariableName";
    public static final String NAME_LAT_VARIABLE_NAME = "LatVariableName";
    public static final String NAME_RASTER_RESOLUTION_KM = "RasterResolutionKm";
    public static final String NAME_OFFSET_X = "OffsetX";
    public static final String NAME_OFFSET_Y = "OffsetY";
    public static final String NAME_SUBSAMPLING_X = "SubsamplingX";
    public static final String NAME_SUBSAMPLING_Y = "SubsamplingY";
    public static final String ID_VERSION_1 = "ComponentGC:1";

    @Override
    public String getID() {
        return ID_VERSION_1;
    }

    @Override
    public ComponentGeoCoding decodeImpl(Item item, Product product) {
        GeoRaster geoRaster;
        boolean resolutionKmInvalid;
        if (item == null || !item.isContainer() || !NAME_COMPONENT_GEO_CODING.equals(item.getName())) {
            SystemUtils.LOG.warning("For decoding a container with name 'ComponentGeoCoding' is expected.");
            return null;
        }
        Container container = item.asContainer();
        String forwardKey = container.getProperty(NAME_FORWARD_CODING_KEY).getValueString();
        String inverseKey = container.getProperty(NAME_INVERSE_CODING_KEY).getValueString();
        String geoChecksName = container.getProperty(NAME_GEO_CHECKS).getValueString();
        String geoCrsWKT = container.getProperty(NAME_GEO_CRS).getValueString();
        String lonVarName = container.getProperty(NAME_LON_VARIABLE_NAME).getValueString();
        String latVarName = container.getProperty(NAME_LAT_VARIABLE_NAME).getValueString();
        String resolutionKmStr = container.getProperty(NAME_RASTER_RESOLUTION_KM).getValueString();
        boolean forwardInvalid = forwardKey == null;
        boolean inverseInvalid = inverseKey == null;
        boolean geoChecksInvalid = geoChecksName == null;
        boolean geoCrsWKTInvalid = geoCrsWKT == null;
        boolean lonVarNameInvalid = lonVarName == null;
        boolean latVarNameInvalid = latVarName == null;
        boolean bl = resolutionKmInvalid = resolutionKmStr == null;
        if (forwardInvalid) {
            SystemUtils.LOG.warning("Property with name 'ForwardCodingKey' expected in container item 'ComponentGeoCoding'.");
        }
        if (inverseInvalid) {
            SystemUtils.LOG.warning("Property with name 'InverseCodingKey' expected in container item 'ComponentGeoCoding'.");
        }
        if (geoChecksInvalid) {
            SystemUtils.LOG.warning("Property with name 'GeoChecks' expected in container item 'ComponentGeoCoding'.");
        }
        if (geoCrsWKTInvalid) {
            SystemUtils.LOG.warning("Property with name 'GeoCRS' expected in container item 'ComponentGeoCoding'.");
        }
        if (lonVarNameInvalid) {
            SystemUtils.LOG.warning("Property with name 'LonVariableName' expected in container item 'ComponentGeoCoding'.");
        }
        if (latVarNameInvalid) {
            SystemUtils.LOG.warning("Property with name 'LatVariableName' expected in container item 'ComponentGeoCoding'.");
        }
        if (resolutionKmInvalid) {
            SystemUtils.LOG.warning("Property with name 'RasterResolutionKm' expected in container item 'ComponentGeoCoding'.");
        }
        Double resolutionInKm = null;
        try {
            resolutionInKm = Double.parseDouble(resolutionKmStr);
        }
        catch (NumberFormatException e) {
            SystemUtils.LOG.warning(e.getMessage());
            SystemUtils.LOG.warning("The value '" + resolutionKmStr + "' of property 'RasterResolutionKm' cannot be parsed to double.");
        }
        boolean invalidValueGeoChecks = false;
        try {
            GeoChecks.valueOf(geoChecksName);
        }
        catch (IllegalArgumentException e) {
            invalidValueGeoChecks = true;
            SystemUtils.LOG.warning(e.getMessage());
            SystemUtils.LOG.warning("The value '" + geoChecksName + "' of property 'GeoChecks' is not valid.");
        }
        CoordinateReferenceSystem geoCRS = null;
        try {
            geoCRS = CRS.parseWKT((String)geoCrsWKT);
        }
        catch (FactoryException e) {
            SystemUtils.LOG.warning(e.getMessage());
            SystemUtils.LOG.warning("The WKT value '" + geoCrsWKT + "' of property 'GeoCRS' is not valid.");
        }
        String msg_unable_to_create = "Unable to create ComponentGeoCoding.";
        if (forwardInvalid || inverseInvalid || geoChecksInvalid || lonVarNameInvalid || latVarNameInvalid || resolutionKmInvalid || resolutionInKm == null || geoChecksName == null || invalidValueGeoChecks || geoCRS == null) {
            SystemUtils.LOG.warning("Unable to create ComponentGeoCoding.");
            return null;
        }
        RasterDataNode lonRaster = product.getRasterDataNode(lonVarName);
        RasterDataNode latRaster = product.getRasterDataNode(latVarName);
        if (lonRaster == null || latRaster == null) {
            if (lonRaster == null) {
                SystemUtils.LOG.warning("Unable to find expected longitude raster '" + lonVarName + "' in product.");
            }
            if (latRaster == null) {
                SystemUtils.LOG.warning("Unable to find expected latitude raster '" + latVarName + "' in product.");
            }
            SystemUtils.LOG.warning("Unable to create ComponentGeoCoding.");
            return null;
        }
        HashMap<RasterDataNode, double[]> dataMap = DataHolder.getInstance().getDataMap(product);
        if (lonRaster instanceof TiePointGrid) {
            double[] latitudes;
            double[] longitudes;
            int sceneWidth = product.getSceneRasterWidth();
            int sceneHeight = product.getSceneRasterHeight();
            TiePointGrid lonTPG = (TiePointGrid)lonRaster;
            TiePointGrid latTPG = (TiePointGrid)latRaster;
            int gridWidth = lonTPG.getGridWidth();
            int gridHeight = lonTPG.getGridHeight();
            if (dataMap.containsKey(lonRaster)) {
                longitudes = dataMap.get(lonRaster);
                latitudes = dataMap.get(latRaster);
            } else {
                float[] lons = (float[])lonTPG.getGridData().getElems();
                longitudes = IntStream.range(0, lons.length).mapToDouble(i -> lons[i]).toArray();
                dataMap.put(lonRaster, longitudes);
                float[] lats = (float[])latTPG.getGridData().getElems();
                latitudes = IntStream.range(0, lats.length).mapToDouble(i -> lats[i]).toArray();
                dataMap.put(latRaster, latitudes);
            }
            double offsetX = lonTPG.getOffsetX();
            double offsetY = lonTPG.getOffsetY();
            double subsamplingX = lonTPG.getSubSamplingX();
            double subsamplingY = lonTPG.getSubSamplingY();
            geoRaster = new GeoRaster(longitudes, latitudes, lonVarName, latVarName, gridWidth, gridHeight, sceneWidth, sceneHeight, resolutionInKm, offsetX, offsetY, subsamplingX, subsamplingY);
        } else {
            double[] latitudes;
            double[] longitudes;
            int rasterWidth = lonRaster.getRasterWidth();
            int rasterHeight = lonRaster.getRasterHeight();
            if (dataMap.containsKey(lonRaster)) {
                longitudes = dataMap.get(lonRaster);
                latitudes = dataMap.get(latRaster);
            } else {
                try {
                    longitudes = RasterUtils.loadGeoData(lonRaster);
                    dataMap.put(lonRaster, longitudes);
                    latitudes = RasterUtils.loadGeoData(latRaster);
                    dataMap.put(latRaster, latitudes);
                }
                catch (IOException e) {
                    SystemUtils.LOG.warning("error loading geo-data: " + e.getMessage());
                    return null;
                }
            }
            geoRaster = new GeoRaster(longitudes, latitudes, lonVarName, latVarName, rasterWidth, rasterHeight, resolutionInKm);
        }
        Preferences snapPreferences = Config.instance((String)"snap").preferences();
        boolean isFractionalEnabled = snapPreferences.getBoolean("snap.pixelGeoCoding.fractionAccuracy", false);
        if (isFractionalEnabled && "FWD_PIXEL".equals(forwardKey)) {
            forwardKey = "FWD_PIXEL_INTERPOLATING";
        }
        if (isFractionalEnabled && "INV_PIXEL_QUAD_TREE".equals(inverseKey)) {
            inverseKey = "INV_PIXEL_QUAD_TREE_INTERPOLATING";
        }
        if (isFractionalEnabled && "INV_PIXEL_GEO_INDEX".equals(inverseKey)) {
            inverseKey = "INV_PIXEL_GEO_INDEX_INTERPOLATING";
        }
        ForwardCoding forwardCoding = ComponentFactory.getForward(forwardKey);
        InverseCoding inverseCoding = ComponentFactory.getInverse(inverseKey);
        ComponentGeoCoding geoCoding = new ComponentGeoCoding(geoRaster, forwardCoding, inverseCoding, GeoChecks.valueOf(geoChecksName), geoCRS);
        geoCoding.initialize();
        return geoCoding;
    }

    @Override
    public Item encode(ComponentGeoCoding geoCoding) {
        String forwardKey = geoCoding.getForwardCoding().getKey();
        String inverseKey = geoCoding.getInverseCoding().getKey();
        GeoChecks geoChecks = geoCoding.getGeoChecks();
        CoordinateReferenceSystem geoCRS = geoCoding.getGeoCRS();
        GeoRaster geoRaster = geoCoding.getGeoRaster();
        String lonVarName = geoRaster.getLonVariableName();
        String latVarName = geoRaster.getLatVariableName();
        double resolutionKm = geoRaster.getRasterResolutionInKm();
        double offsetX = geoRaster.getOffsetX();
        double offsetY = geoRaster.getOffsetY();
        double subsamplingX = geoRaster.getSubsamplingX();
        double subsamplingY = geoRaster.getSubsamplingY();
        Container codingMain = this.createRootContainer(NAME_COMPONENT_GEO_CODING);
        codingMain.add(new Property<String>(NAME_FORWARD_CODING_KEY, forwardKey));
        codingMain.add(new Property<String>(NAME_INVERSE_CODING_KEY, inverseKey));
        codingMain.add(new Property<String>(NAME_GEO_CHECKS, geoChecks.name()));
        codingMain.add(new Property<String>(NAME_GEO_CRS, geoCRS.toWKT()));
        codingMain.add(new Property<String>(NAME_LON_VARIABLE_NAME, lonVarName));
        codingMain.add(new Property<String>(NAME_LAT_VARIABLE_NAME, latVarName));
        codingMain.add(new Property<Double>(NAME_RASTER_RESOLUTION_KM, resolutionKm));
        codingMain.add(new Property<Double>(NAME_OFFSET_X, offsetX));
        codingMain.add(new Property<Double>(NAME_OFFSET_Y, offsetY));
        codingMain.add(new Property<Double>(NAME_SUBSAMPLING_X, subsamplingX));
        codingMain.add(new Property<Double>(NAME_SUBSAMPLING_Y, subsamplingY));
        return codingMain;
    }

    @Override
    public HistoricalDecoder[] getHistoricalDecoders() {
        return new HistoricalDecoder[]{new HistoricalDecoder0()};
    }

    private static class HistoricalDecoder0
    extends DimapHistoricalDecoder {
        private HistoricalDecoder0() {
        }

        @Override
        public boolean canDecode(Item item) {
            return item != null && item.isContainer() && ComponentGeoCodingPersistenceConverter.NAME_COMPONENT_GEO_CODING.equals(item.getName());
        }

        @Override
        public Item decode(Item item, Product product) {
            Container container = item.asContainer();
            container.add(new Property<String>("___persistence_id___", ComponentGeoCodingPersistenceConverter.ID_VERSION_1));
            return container;
        }
    }
}

