/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.geocoding;

import java.util.HashMap;
import org.esa.snap.core.dataio.geocoding.ForwardCoding;
import org.esa.snap.core.dataio.geocoding.InverseCoding;
import org.esa.snap.core.dataio.geocoding.forward.ForwardPlugin;
import org.esa.snap.core.dataio.geocoding.forward.PixelForward;
import org.esa.snap.core.dataio.geocoding.forward.PixelInterpolatingForward;
import org.esa.snap.core.dataio.geocoding.forward.TiePointBilinearForward;
import org.esa.snap.core.dataio.geocoding.forward.TiePointSplineForward;
import org.esa.snap.core.dataio.geocoding.inverse.InversePlugin;
import org.esa.snap.core.dataio.geocoding.inverse.PixelGeoIndexInverse;
import org.esa.snap.core.dataio.geocoding.inverse.PixelQuadTreeInverse;
import org.esa.snap.core.dataio.geocoding.inverse.TiePointInverse;

public class ComponentFactory {
    private static final HashMap<String, ForwardPlugin> forwardPlugins = new HashMap();
    private static final HashMap<String, InversePlugin> inversePlugins = new HashMap();

    public static ForwardCoding getForward(String key) {
        ForwardPlugin forwardPlugin = forwardPlugins.get(key);
        if (forwardPlugin == null) {
            throw new IllegalArgumentException("unknown forward coding: " + key);
        }
        return forwardPlugin.create();
    }

    public static InverseCoding getInverse(String key) {
        InversePlugin inversePlugin = inversePlugins.get(key);
        if (inversePlugin == null) {
            throw new IllegalArgumentException("unknown inverse coding: " + key);
        }
        return inversePlugin.create();
    }

    static {
        forwardPlugins.put("FWD_PIXEL", new PixelForward.Plugin());
        forwardPlugins.put("FWD_PIXEL_INTERPOLATING", new PixelInterpolatingForward.Plugin());
        forwardPlugins.put("FWD_TIE_POINT_BILINEAR", new TiePointBilinearForward.Plugin());
        forwardPlugins.put("FWD_TIE_POINT_SPLINE", new TiePointSplineForward.Plugin());
        inversePlugins.put("INV_PIXEL_QUAD_TREE", new PixelQuadTreeInverse.Plugin(false));
        inversePlugins.put("INV_PIXEL_QUAD_TREE_INTERPOLATING", new PixelQuadTreeInverse.Plugin(true));
        inversePlugins.put("INV_PIXEL_GEO_INDEX", new PixelGeoIndexInverse.Plugin(false));
        inversePlugins.put("INV_PIXEL_GEO_INDEX_INTERPOLATING", new PixelGeoIndexInverse.Plugin(true));
        inversePlugins.put("INV_TIE_POINT", new TiePointInverse.Plugin());
    }
}

