/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.dimap.spi;

import com.bc.ceres.binding.PropertyContainer;
import org.esa.snap.core.dataio.dimap.spi.MaskPersistable;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeListenerAdapter;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.jdom2.Content;
import org.jdom2.Element;

class VectorDataMaskPersistable
extends MaskPersistable {
    VectorDataMaskPersistable() {
    }

    @Override
    protected Mask.ImageType createImageType() {
        return Mask.VectorDataType.INSTANCE;
    }

    @Override
    protected void configureMask(Mask mask, Element element, final Product product) {
        final PropertyContainer imageConfig = mask.getImageConfig();
        String propertyName = "vectorData";
        final String vectorDataNodeName = VectorDataMaskPersistable.getChildAttributeValue(element, "VECTOR_DATA_NODE", "value");
        VectorDataNode vectorDataNode = product.getVectorDataGroup().get(vectorDataNodeName);
        if (vectorDataNode == null) {
            product.addProductNodeListener(new ProductNodeListenerAdapter(){

                @Override
                public void nodeAdded(ProductNodeEvent event) {
                    ProductNode sourceNode = event.getSourceNode();
                    String sourceNodeName = sourceNode.getName();
                    if (!vectorDataNodeName.equals(sourceNodeName)) {
                        return;
                    }
                    if (!(sourceNode instanceof VectorDataNode)) {
                        return;
                    }
                    product.removeProductNodeListener(this);
                    imageConfig.setValue("vectorData", (Object)sourceNode);
                }
            });
        } else {
            imageConfig.setValue("vectorData", (Object)vectorDataNode);
        }
    }

    @Override
    protected void configureElement(Element root, Mask mask) {
        VectorDataNode vectorDataNode = (VectorDataNode)((Object)mask.getImageConfig().getValue("vectorData"));
        root.addContent((Content)VectorDataMaskPersistable.createValueAttributeElement("VECTOR_DATA_NODE", vectorDataNode.getName()));
    }
}

