/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.dimap;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;
import org.esa.snap.core.dataio.AbstractProductWriter;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductWriterPlugIn;
import org.esa.snap.core.dataio.cache.VariableCache;
import org.esa.snap.core.dataio.cache.WriteCache;
import org.esa.snap.core.dataio.dimap.DimapHeaderWriter;
import org.esa.snap.core.dataio.dimap.DimapProductReader;
import org.esa.snap.core.dataio.dimap.EnviHeader;
import org.esa.snap.core.dataio.geometry.VectorDataNodeWriter;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FilterBand;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.runtime.Config;

public class DimapProductWriter
extends AbstractProductWriter {
    private static final String SYSPROP_USE_CACHE = "snap.dataio.writer.dimap.useCache";
    private File outputDir;
    private File outputFile;
    private Map<Band, ImageOutputStream> bandOutputStreams;
    private File dataOutputDir;
    private boolean incremental = true;
    private Set<WriterExtender> writerExtenders;
    private boolean useCache;
    private WriteCache writeCache;

    public DimapProductWriter(ProductWriterPlugIn writerPlugIn) {
        super(writerPlugIn);
        Preferences preferences = Config.instance().preferences();
        this.useCache = preferences.getBoolean(SYSPROP_USE_CACHE, true);
        if (this.useCache) {
            this.writeCache = new WriteCache();
        }
    }

    private static void checkSourceRegionInsideBandRegion(int sourceWidth, long sourceBandWidth, int sourceHeight, long sourceBandHeight, int sourceOffsetX, int sourceOffsetY) {
        Guardian.assertWithinRange("sourceWidth", sourceWidth, 1L, sourceBandWidth);
        Guardian.assertWithinRange("sourceHeight", sourceHeight, 1L, sourceBandHeight);
        Guardian.assertWithinRange("sourceOffsetX", sourceOffsetX, 0L, sourceBandWidth - (long)sourceWidth);
        Guardian.assertWithinRange("sourceOffsetY", sourceOffsetY, 0L, sourceBandHeight - (long)sourceHeight);
    }

    static boolean isFullRaster(int sourceWidth, int sourceHeight, int rasterWidth, int rasterHeight) {
        return sourceWidth == rasterWidth && sourceHeight == rasterHeight;
    }

    private static void checkBufferSize(int sourceWidth, int sourceHeight, ProductData sourceBuffer) {
        int expectedBufferSize = sourceWidth * sourceHeight;
        int actualBufferSize = sourceBuffer.getNumElems();
        Guardian.assertEquals("sourceWidth * sourceHeight", actualBufferSize, expectedBufferSize);
    }

    private static void createPhysicalImageFile(Band band, File file) throws IOException {
        DimapProductWriter.createPhysicalFile(file, DimapProductWriter.getImageFileSize(band));
    }

    private static void createPhysicalImageFile(TiePointGrid tiePointGrid, File file) throws IOException {
        DimapProductWriter.createPhysicalFile(file, DimapProductWriter.getImageFileSize(tiePointGrid));
    }

    private static long getImageFileSize(Band band) {
        return (long)ProductData.getElemSize(band.getDataType()) * (long)band.getRasterWidth() * (long)band.getRasterHeight();
    }

    private static long getImageFileSize(TiePointGrid tpg) {
        return (long)ProductData.getElemSize(tpg.getDataType()) * (long)tpg.getGridWidth() * (long)tpg.getGridHeight();
    }

    private static String createEnviHeaderFilename(Band band) {
        return band.getName() + ".hdr";
    }

    private static String createImageFilename(Band band) {
        return band.getName() + ".img";
    }

    private static void createPhysicalFile(File file, long fileSize) throws IOException {
        File parentDir = file.getParentFile();
        if (parentDir != null) {
            parentDir.mkdirs();
        }
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");){
            randomAccessFile.setLength(fileSize);
        }
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public Map<Band, ImageOutputStream> getBandOutputStreams() {
        return this.bandOutputStreams;
    }

    @Override
    protected void writeProductNodesImpl() throws IOException {
        Object output = this.getOutput();
        File outputFile = null;
        if (output instanceof String) {
            outputFile = new File((String)output);
        } else if (output instanceof File) {
            outputFile = (File)output;
        }
        Debug.assertNotNull(outputFile);
        this.initDirs(outputFile);
        this.ensureNamingConvention();
        if (this.writerExtenders != null) {
            for (WriterExtender dimapWriterExtender : this.writerExtenders) {
                File parentFile = outputFile.getParentFile();
                if (parentFile == null) {
                    throw new IllegalStateException("Could not retrieve the parent directory of '" + outputFile.getAbsolutePath() + "'.");
                }
                dimapWriterExtender.intendToWriteDimapHeaderTo(parentFile, this.getSourceProduct());
            }
        }
        this.writeDimapDocument();
        this.writeVectorData();
        this.writeTiePointGrids();
        this.getSourceProduct().setProductWriter(this);
        this.deleteRemovedNodes();
    }

    public void initDirs(File outputFile) throws IOException {
        this.outputFile = FileUtils.ensureExtension(outputFile, ".dim");
        Debug.assertNotNull(this.outputFile);
        this.outputDir = this.outputFile.getParentFile();
        if (this.outputDir == null) {
            this.outputDir = new File(".");
        }
        this.dataOutputDir = this.createDataOutputDir();
        this.dataOutputDir.mkdirs();
        if (!this.dataOutputDir.exists()) {
            throw new IOException("failed to create data output directory: " + this.dataOutputDir.getPath());
        }
    }

    private File createDataOutputDir() {
        return new File(this.outputDir, FileUtils.getFilenameWithoutExtension(this.outputFile) + ".data");
    }

    private void ensureNamingConvention() {
        if (this.outputFile != null) {
            this.getSourceProduct().setName(FileUtils.getFilenameWithoutExtension(this.outputFile));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeBandRasterData(Band sourceBand, int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, ProductData sourceBuffer, ProgressMonitor pm) throws IOException {
        Guardian.assertNotNull("sourceBand", sourceBand);
        Guardian.assertNotNull("sourceBuffer", sourceBuffer);
        DimapProductWriter.checkBufferSize(sourceWidth, sourceHeight, sourceBuffer);
        int sourceBandWidth = sourceBand.getRasterWidth();
        int sourceBandHeight = sourceBand.getRasterHeight();
        DimapProductWriter.checkSourceRegionInsideBandRegion(sourceWidth, sourceBandWidth, sourceHeight, sourceBandHeight, sourceOffsetX, sourceOffsetY);
        ImageOutputStream outputStream = this.getOrCreateImageOutputStream(sourceBand);
        boolean fullRaster = DimapProductWriter.isFullRaster(sourceWidth, sourceHeight, sourceBandWidth, sourceBandHeight);
        if (this.useCache && !fullRaster) {
            VariableCache variableCache = this.writeCache.get(sourceBand);
            try {
                pm.beginTask("Writing band '" + sourceBand.getName() + "'...", 1);
                boolean canWrite = variableCache.update(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceBuffer);
                if (canWrite) {
                    ImageOutputStream imageOutputStream = outputStream;
                    synchronized (imageOutputStream) {
                        variableCache.writeCompletedBlocks(outputStream);
                    }
                }
                pm.worked(1);
            }
            finally {
                pm.done();
            }
        }
        long outputPos = (long)sourceOffsetY * (long)sourceBandWidth + (long)sourceOffsetX;
        pm.beginTask("Writing band '" + sourceBand.getName() + "'...", sourceHeight);
        try {
            ImageOutputStream imageOutputStream = outputStream;
            synchronized (imageOutputStream) {
                for (int sourcePos = 0; sourcePos < sourceHeight * sourceWidth; sourcePos += sourceWidth) {
                    sourceBuffer.writeTo(sourcePos, sourceWidth, outputStream, outputPos);
                    outputPos += (long)sourceBandWidth;
                    pm.worked(1);
                    if (pm.isCanceled()) break;
                }
            }
        }
        finally {
            pm.done();
        }
    }

    @Override
    public void deleteOutput() throws IOException {
        this.flush();
        this.close();
        if (this.outputFile != null && this.outputFile.exists() && this.outputFile.isFile()) {
            this.outputFile.delete();
        }
        if (this.dataOutputDir != null && this.dataOutputDir.exists() && this.dataOutputDir.isDirectory()) {
            FileUtils.deleteTree(this.dataOutputDir);
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.bandOutputStreams == null) {
            return;
        }
        if (this.useCache) {
            this.writeCache.flush(this.bandOutputStreams);
        }
        for (ImageOutputStream imageOutputStream : this.bandOutputStreams.values()) {
            imageOutputStream.flush();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.flush();
        if (this.bandOutputStreams == null) {
            return;
        }
        for (ImageOutputStream imageOutputStream : this.bandOutputStreams.values()) {
            imageOutputStream.close();
        }
        this.bandOutputStreams.clear();
        this.bandOutputStreams = null;
        if (this.writerExtenders != null) {
            this.writerExtenders.clear();
            this.writerExtenders = null;
        }
    }

    private void writeDimapDocument() throws IOException {
        DimapHeaderWriter writer = new DimapHeaderWriter(this.getSourceProduct(), this.getOutputFile(), this.dataOutputDir.getName());
        writer.writeHeader();
        writer.close();
    }

    private File getOutputFile() {
        return this.outputFile;
    }

    private void writeTiePointGrids() throws IOException {
        for (int i = 0; i < this.getSourceProduct().getNumTiePointGrids(); ++i) {
            TiePointGrid tiePointGrid = this.getSourceProduct().getTiePointGridAt(i);
            this.writeTiePointGrid(tiePointGrid);
        }
    }

    private void writeTiePointGrid(TiePointGrid tiePointGrid) throws IOException {
        this.ensureExistingTiePointGridDir();
        ImageOutputStream outputStream = this.createImageOutputStream(tiePointGrid);
        tiePointGrid.getGridData().writeTo(outputStream);
        outputStream.close();
    }

    private void ensureExistingTiePointGridDir() {
        File tiePointGridDir = new File(this.dataOutputDir, "tie_point_grids");
        tiePointGridDir.mkdirs();
    }

    private synchronized ImageOutputStream getOrCreateImageOutputStream(Band band) throws IOException {
        if (this.bandOutputStreams == null) {
            this.bandOutputStreams = new HashMap<Band, ImageOutputStream>();
        }
        if (!this.bandOutputStreams.containsKey(band)) {
            ImageOutputStream outputStream = this.createImageOutputStream(band);
            this.bandOutputStreams.put(band, outputStream);
        }
        return this.bandOutputStreams.get(band);
    }

    private File getValidImageFile(Band band) throws IOException {
        this.writeEnviHeader(band);
        File file = this.getImageFile(band);
        if (file.exists()) {
            if (file.length() != DimapProductWriter.getImageFileSize(band)) {
                DimapProductWriter.createPhysicalImageFile(band, file);
            }
        } else {
            DimapProductWriter.createPhysicalImageFile(band, file);
        }
        return file;
    }

    private File getValidImageFile(TiePointGrid tiePointGrid) throws IOException {
        this.writeEnviHeader(tiePointGrid);
        File file = this.getImageFile(tiePointGrid);
        DimapProductWriter.createPhysicalImageFile(tiePointGrid, file);
        return file;
    }

    private void writeEnviHeader(Band band) throws IOException {
        EnviHeader.createPhysicalFile(this.getEnviHeaderFile(band), band, band.getRasterWidth(), band.getRasterHeight());
    }

    private void writeEnviHeader(TiePointGrid tiePointGrid) throws IOException {
        EnviHeader.createPhysicalFile(this.getEnviHeaderFile(tiePointGrid), tiePointGrid, tiePointGrid.getGridWidth(), tiePointGrid.getGridHeight());
    }

    private ImageOutputStream createImageOutputStream(Band band) throws IOException {
        return new FileImageOutputStream(this.getValidImageFile(band));
    }

    private ImageOutputStream createImageOutputStream(TiePointGrid tiePointGrid) throws IOException {
        return new FileImageOutputStream(this.getValidImageFile(tiePointGrid));
    }

    private File getEnviHeaderFile(Band band) {
        return new File(this.dataOutputDir, DimapProductWriter.createEnviHeaderFilename(band));
    }

    private File getEnviHeaderFile(TiePointGrid tiePointGrid) {
        return new File(new File(this.dataOutputDir, "tie_point_grids"), tiePointGrid.getName() + ".hdr");
    }

    private File getImageFile(Band band) {
        return new File(this.dataOutputDir, DimapProductWriter.createImageFilename(band));
    }

    private File getImageFile(TiePointGrid tiePointGrid) {
        return new File(new File(this.dataOutputDir, "tie_point_grids"), tiePointGrid.getName() + ".img");
    }

    @Override
    public boolean shouldWrite(ProductNode node) {
        if (this.writerExtenders != null) {
            for (WriterExtender dimapWriterWriterExtender : this.writerExtenders) {
                boolean shouldWrite = dimapWriterWriterExtender.vetoableShouldWrite(node);
                if (shouldWrite) continue;
                return false;
            }
        }
        if (node instanceof RasterDataNode && ((RasterDataNode)node).isSynthetic()) {
            return false;
        }
        if (node instanceof VirtualBand) {
            return false;
        }
        if (node instanceof FilterBand) {
            return false;
        }
        if (node.isModified()) {
            return true;
        }
        if (!this.isIncrementalMode()) {
            return true;
        }
        if (!(node instanceof Band)) {
            return true;
        }
        File imageFile = this.getImageFile((Band)node);
        return imageFile == null || !imageFile.exists();
    }

    @Override
    public boolean isIncrementalMode() {
        return this.incremental;
    }

    @Override
    public void setIncrementalMode(boolean enabled) {
        this.incremental = enabled;
    }

    private void deleteRemovedNodes() throws IOException {
        ProductNode[] removedNodes;
        Product product = this.getSourceProduct();
        ProductReader productReader = product.getProductReader();
        if (productReader instanceof DimapProductReader && (removedNodes = product.getRemovedChildNodes()).length > 0) {
            productReader.close();
            for (ProductNode removedNode : removedNodes) {
                removedNode.removeFromFile(this);
            }
        }
    }

    @Override
    public void removeBand(Band band) {
        if (band != null) {
            String headerFilename = DimapProductWriter.createEnviHeaderFilename(band);
            String imageFilename = DimapProductWriter.createImageFilename(band);
            File[] files = null;
            if (this.dataOutputDir != null && this.dataOutputDir.exists()) {
                files = this.dataOutputDir.listFiles();
            }
            if (files == null) {
                return;
            }
            for (File file : files) {
                String name = file.getName();
                if (!file.isFile() || !name.equals(headerFilename) && !name.equals(imageFilename)) continue;
                file.delete();
            }
        }
    }

    private void writeVectorData() {
        Product product = this.getSourceProduct();
        ProductNodeGroup<VectorDataNode> vectorDataGroup = product.getVectorDataGroup();
        File vectorDataDir = new File(this.dataOutputDir, "vector_data");
        if (vectorDataDir.exists()) {
            File[] files;
            for (File file : files = vectorDataDir.listFiles()) {
                file.delete();
            }
        }
        if (vectorDataGroup.getNodeCount() > 0) {
            vectorDataDir.mkdirs();
            for (int i = 0; i < vectorDataGroup.getNodeCount(); ++i) {
                VectorDataNode vectorDataNode = vectorDataGroup.get(i);
                this.writeVectorData(vectorDataDir, vectorDataNode);
            }
        }
    }

    private void writeVectorData(File vectorDataDir, VectorDataNode vectorDataNode) {
        try {
            VectorDataNodeWriter vectorDataNodeWriter = new VectorDataNodeWriter();
            vectorDataNodeWriter.write(vectorDataNode, new File(vectorDataDir, vectorDataNode.getName() + ".csv"));
        }
        catch (IOException e) {
            SystemUtils.LOG.throwing("DimapProductWriter", "writeVectorData", e);
        }
    }

    public void addExtender(WriterExtender writerExtender) {
        if (this.writerExtenders == null) {
            this.writerExtenders = new HashSet<WriterExtender>();
        }
        if (writerExtender != null) {
            this.writerExtenders.add(writerExtender);
        }
    }

    public static abstract class WriterExtender {
        public abstract boolean vetoableShouldWrite(ProductNode var1);

        public abstract void intendToWriteDimapHeaderTo(File var1, Product var2);
    }
}

