/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.dimap;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.dataio.dimap.DimapProductHelpers;
import org.esa.snap.core.dataio.geometry.VectorDataNodeReader;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.BasicPixelGeoCoding;
import org.esa.snap.core.datamodel.FilterBand;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoCodingFactory;
import org.esa.snap.core.datamodel.GeometryDescriptor;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.PlacemarkDescriptorRegistry;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.FeatureUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.jdom2.Document;
import org.jdom2.input.DOMBuilder;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DimapProductReader
extends AbstractProductReader {
    private Product product;
    private File inputDir;
    private File inputFile;
    private Map<Band, ImageInputStream> bandInputStreams;
    private Map<TiePointGrid, TpgDomInfo> tiePointGridInfoMap;
    private Map<Band, File> bandDataFiles;
    private Set<ReaderExtender> readerExtenders;

    public DimapProductReader(ProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
    }

    public Product getProduct() {
        return this.product;
    }

    public File getInputDir() {
        return this.inputDir;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    @Override
    protected Product readProductNodesImpl() throws IOException {
        Product product = this.processProduct(null);
        if (this.readerExtenders != null) {
            for (ReaderExtender readerExtender : this.readerExtenders) {
                readerExtender.completeProductNodesReading(product);
            }
        }
        return product;
    }

    public void bindProduct(Object input, Product existingProduct) throws IOException {
        Assert.notNull((Object)input, (String)"input");
        Assert.notNull((Object)((Object)existingProduct), (String)"existingProduct");
        this.setInput(input);
        this.processProduct(existingProduct);
    }

    protected Product processProduct(Product existingProduct) throws IOException {
        this.initInput();
        Document dom = this.readDom();
        this.product = existingProduct == null ? DimapProductHelpers.createProduct(dom, "BEAM-DIMAP", null) : existingProduct;
        this.product.setProductReader(this);
        if (existingProduct == null) {
            this.tiePointGridInfoMap = this.readTiePointGrids(dom);
        }
        this.bindBandsToFiles(dom);
        if (existingProduct == null) {
            this.readVectorData((CoordinateReferenceSystem)Product.DEFAULT_IMAGE_CRS, true);
            DimapProductHelpers.addGcps(dom, this.product);
            DimapProductHelpers.addPins(dom, this.product);
            this.initGeoCodings(dom);
            this.readVectorData(this.product.getSceneCRS(), false);
            DimapProductHelpers.addMaskUsages(dom, this.product);
        }
        this.product.setFileLocation(this.inputFile);
        this.product.setModified(false);
        return this.product;
    }

    private void initGeoCodings(Document dom) {
        GeoCoding[] geoCodings = DimapProductHelpers.createGeoCoding(dom, this.product);
        if (geoCodings != null) {
            if (geoCodings.length == 1) {
                this.product.setSceneGeoCoding(geoCodings[0]);
            } else if (geoCodings.length == this.product.getNumBands()) {
                for (int i = 0; i < geoCodings.length; ++i) {
                    Band band = this.product.getBandAt(i);
                    if (this.product.getSceneRasterWidth() == band.getRasterWidth() && this.product.getSceneRasterHeight() == band.getRasterHeight()) {
                        this.product.setSceneGeoCoding(geoCodings[i]);
                    }
                    band.setGeoCoding(geoCodings[i]);
                }
            }
        } else {
            Band lonBand = this.product.getBand("longitude");
            Band latBand = this.product.getBand("latitude");
            if (latBand != null && lonBand != null) {
                BasicPixelGeoCoding geoCoding = GeoCodingFactory.createPixelGeoCoding(latBand, lonBand, null, 6);
                this.product.setSceneGeoCoding(geoCoding);
            }
        }
    }

    private void bindBandsToFiles(Document dom) {
        Band[] bands;
        this.bandDataFiles = DimapProductHelpers.getBandDataFiles(dom, this.product, this.getInputDir());
        for (Band band : bands = this.product.getBands()) {
            File dataFile;
            if (band instanceof VirtualBand || band instanceof FilterBand || (dataFile = this.bandDataFiles.get(band)) != null && dataFile.canRead()) continue;
            SystemUtils.LOG.warning("DimapProductReader: Unable to read file '" + dataFile + "' referenced by '" + band.getName() + "'.");
            SystemUtils.LOG.warning("DimapProductReader: Removed band '" + band.getName() + "' from product '" + this.product.getFileLocation() + "'.");
        }
    }

    private Map<TiePointGrid, TpgDomInfo> readTiePointGrids(Document jDomDocument) {
        String[] tiePointGridNames = this.product.getTiePointGridNames();
        HashMap<TiePointGrid, TpgDomInfo> tpgInfoMap = new HashMap<TiePointGrid, TpgDomInfo>();
        for (String tiePointGridName : tiePointGridNames) {
            TiePointGrid tiePointGrid = this.product.getTiePointGrid(tiePointGridName);
            String dataFile = DimapProductHelpers.getTiePointDataFile(jDomDocument, tiePointGrid.getName());
            int dataType = DimapProductHelpers.getTiePointDataType(jDomDocument.getRootElement(), tiePointGrid.getName());
            dataFile = FileUtils.exchangeExtension(dataFile, ".img");
            File inputFile = new File(this.inputDir, dataFile);
            tpgInfoMap.put(tiePointGrid, new TpgDomInfo(inputFile, dataType));
        }
        return tpgInfoMap;
    }

    private Document readDom() throws IOException {
        Document dom;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Debug.trace("DimapProductReader: about to open file '" + this.inputFile + "'...");
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.inputFile), 262144);
            dom = new DOMBuilder().build(builder.parse(is));
            ((InputStream)is).close();
        }
        catch (Exception e) {
            throw new IOException("Failed to read DIMAP XML header.", e);
        }
        return dom;
    }

    private void initInput() {
        if (this.getInput() instanceof String) {
            this.inputFile = new File((String)this.getInput());
        } else if (this.getInput() instanceof File) {
            this.inputFile = (File)this.getInput();
        } else {
            throw new IllegalArgumentException("unsupported input source: " + this.getInput());
        }
        Debug.assertNotNull(this.inputFile);
        this.inputDir = this.inputFile.getParentFile();
        if (this.inputDir == null) {
            this.inputDir = new File(".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        File dataFile = this.bandDataFiles.get(destBand);
        pm.beginTask("Reading band '" + destBand.getName() + "'...", sourceHeight);
        try {
            try (FileImageInputStream inputStream = new FileImageInputStream(dataFile);){
                int destPos = 0;
                int type = destBuffer.getType();
                boolean longType = 13 == type;
                ProductData line = ProductData.createInstance(type, sourceWidth);
                for (int sourceY = sourceOffsetY; sourceY < sourceOffsetY + sourceHeight && !pm.isCanceled(); sourceY += sourceStepY) {
                    long sourcePosY = (long)sourceY * (long)destBand.getRasterWidth();
                    long inputPos = sourcePosY + (long)sourceOffsetX;
                    destPos = DimapProductReader.readLineRasterDataImpl(sourceStepX, sourceWidth, destPos, destWidth, destBuffer, inputStream, longType, line, inputPos);
                }
                pm.worked(1);
            }
            catch (IOException e) {
                throw new IOException("DimapProductReader: Unable to read file '" + dataFile + "' referenced by '" + destBand.getName() + "'.", e);
            }
        }
        finally {
            pm.done();
        }
    }

    @Override
    public void readTiePointGridRasterData(TiePointGrid tpg, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        TpgDomInfo domInfo = this.tiePointGridInfoMap.get(tpg);
        try (FileImageInputStream inputStream = new FileImageInputStream(domInfo.inputFile);){
            int gridWidth = tpg.getGridWidth();
            float[] fullData = new float[gridWidth * tpg.getGridHeight()];
            inputStream.seek(0L);
            if (domInfo.dataType == 30) {
                inputStream.readFully(fullData, 0, fullData.length);
            } else {
                double[] doubles = new double[fullData.length];
                inputStream.readFully(doubles, 0, doubles.length);
                int i = 0;
                for (double d : doubles) {
                    fullData[i++] = (float)d;
                }
            }
            float[] destData = (float[])destBuffer.getElems();
            if (destData.length == fullData.length) {
                System.arraycopy(fullData, 0, destData, 0, fullData.length);
            } else {
                for (int y1 = 0; y1 < destHeight; ++y1) {
                    int srcPos = gridWidth * (destOffsetY + y1) + destOffsetX;
                    System.arraycopy(fullData, srcPos, destData, y1 * destWidth, destWidth);
                }
            }
            if (tpg.getDiscontinuity() == -1) {
                tpg.setDiscontinuity(TiePointGrid.getDiscontinuity(destData));
            }
        }
        catch (Exception e) {
            throw new IOException(MessageFormat.format("I/O error while reading tie-point grid ''{0}''.", tpg.getName()), e);
        }
    }

    private static int readLineRasterDataImpl(int sourceStepX, int sourceWidth, int destPos, int destWidth, ProductData destBuffer, ImageInputStream inputStream, boolean longType, ProductData line, long inputPos) throws IOException {
        if (sourceStepX == 1) {
            destBuffer.readFrom(destPos, destWidth, inputStream, inputPos);
            destPos += destWidth;
        } else {
            line.readFrom(0, sourceWidth, inputStream, inputPos);
            for (int lineX = 0; lineX < sourceWidth; lineX += sourceStepX) {
                if (longType) {
                    destBuffer.setElemLongAt(destPos, line.getElemLongAt(lineX));
                } else {
                    destBuffer.setElemDoubleAt(destPos, line.getElemDoubleAt(lineX));
                }
                ++destPos;
            }
        }
        return destPos;
    }

    @Override
    public boolean isSubsetReadingFullySupported() {
        return true;
    }

    @Override
    public void close() throws IOException {
        if (this.bandInputStreams == null) {
            return;
        }
        for (ImageInputStream imageInputStream : this.bandInputStreams.values()) {
            imageInputStream.close();
        }
        this.bandInputStreams.clear();
        this.bandInputStreams = null;
        if (this.readerExtenders != null) {
            this.readerExtenders.clear();
            this.readerExtenders = null;
        }
        super.close();
    }

    private void readVectorData(CoordinateReferenceSystem modelCrs, boolean onlyGCPs) {
        String dataDirName = FileUtils.getFilenameWithoutExtension(this.inputFile) + ".data";
        File dataDir = new File(this.inputDir, dataDirName);
        File vectorDataDir = new File(dataDir, "vector_data");
        if (vectorDataDir.exists()) {
            File[] vectorFiles;
            for (File vectorFile : vectorFiles = this.getVectorDataFiles(vectorDataDir, onlyGCPs)) {
                this.addVectorDataToProduct(vectorFile, modelCrs);
            }
        }
    }

    private void addVectorDataToProduct(File vectorFile, final CoordinateReferenceSystem modelCrs) {
        try (FileReader reader = new FileReader(vectorFile);){
            FeatureUtils.FeatureCrsProvider crsProvider = new FeatureUtils.FeatureCrsProvider(){

                @Override
                public CoordinateReferenceSystem getFeatureCrs(Product product) {
                    return modelCrs;
                }

                @Override
                public boolean clipToProductBounds() {
                    return false;
                }
            };
            OptimalPlacemarkDescriptorProvider descriptorProvider = new OptimalPlacemarkDescriptorProvider();
            VectorDataNode vectorDataNode = VectorDataNodeReader.read(vectorFile.getName(), reader, this.product, crsProvider, descriptorProvider, modelCrs, '\t', ProgressMonitor.NULL);
            if (vectorDataNode != null) {
                ProductNodeGroup<VectorDataNode> vectorDataGroup = this.product.getVectorDataGroup();
                VectorDataNode existing = vectorDataGroup.get(vectorDataNode.getName());
                if (existing != null) {
                    vectorDataGroup.remove(existing);
                }
                vectorDataGroup.add(vectorDataNode);
            }
        }
        catch (IOException e) {
            SystemUtils.LOG.log(Level.SEVERE, "Error reading '" + vectorFile + "'", e);
        }
    }

    private File[] getVectorDataFiles(File vectorDataDir, boolean onlyGCPs) {
        return vectorDataDir.listFiles((dir, name) -> {
            if (name.endsWith(".csv")) {
                if (onlyGCPs) {
                    return name.equals("ground_control_points.csv");
                }
                return true;
            }
            return false;
        });
    }

    public void addExtender(ReaderExtender extender) {
        if (extender == null) {
            return;
        }
        if (this.readerExtenders == null) {
            this.readerExtenders = new HashSet<ReaderExtender>();
        }
        this.readerExtenders.add(extender);
    }

    public static abstract class ReaderExtender {
        public abstract void completeProductNodesReading(Product var1);
    }

    private static class OptimalPlacemarkDescriptorProvider
    implements VectorDataNodeReader.PlacemarkDescriptorProvider {
        private OptimalPlacemarkDescriptorProvider() {
        }

        @Override
        public PlacemarkDescriptor getPlacemarkDescriptor(SimpleFeatureType simpleFeatureType) {
            String placemarkDescriptorClass;
            PlacemarkDescriptor placemarkDescriptor;
            PlacemarkDescriptorRegistry placemarkDescriptorRegistry = PlacemarkDescriptorRegistry.getInstance();
            if (simpleFeatureType.getUserData().containsKey("placemarkDescriptor") && (placemarkDescriptor = placemarkDescriptorRegistry.getPlacemarkDescriptor(placemarkDescriptorClass = simpleFeatureType.getUserData().get("placemarkDescriptor").toString())) != null) {
                return placemarkDescriptor;
            }
            PlacemarkDescriptor placemarkDescriptor2 = placemarkDescriptorRegistry.getPlacemarkDescriptor(simpleFeatureType);
            if (placemarkDescriptor2 != null) {
                return placemarkDescriptor2;
            }
            return placemarkDescriptorRegistry.getPlacemarkDescriptor(GeometryDescriptor.class);
        }
    }

    private static class TpgDomInfo {
        final File inputFile;
        final int dataType;

        private TpgDomInfo(File inputFile, int dataType) {
            this.inputFile = inputFile;
            this.dataType = dataType;
        }
    }
}

