/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.Histogram;
import org.esa.snap.core.dataio.AbstractProductBuilder;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.Stx;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.runtime.Config;

public class ProductSubsetBuilder
extends AbstractProductBuilder {
    private static boolean prefetchTiles = false;

    public ProductSubsetBuilder() {
        this(false);
    }

    public ProductSubsetBuilder(boolean sourceProductOwner) {
        super(sourceProductOwner);
        prefetchTiles = Config.instance((String)"snap").preferences().getBoolean("snap.jai.prefetchTiles", true);
    }

    public static Product createProductSubset(Product sourceProduct, ProductSubsetDef subsetDef, String name, String desc) throws IOException {
        return ProductSubsetBuilder.createProductSubset(sourceProduct, false, subsetDef, name, desc);
    }

    public static Product createProductSubset(Product sourceProduct, boolean sourceProductOwner, ProductSubsetDef subsetDef, String name, String desc) throws IOException {
        ProductSubsetBuilder productSubsetBuilder = new ProductSubsetBuilder(sourceProductOwner);
        return productSubsetBuilder.readProductNodes(sourceProduct, subsetDef, name, desc);
    }

    private static void updateMetadata(Product sourceProduct, Product targetProduct, ProductSubsetDef subsetDef) throws IOException {
        try {
            TiePointGrid srTPG;
            MetadataAttribute totalSize;
            boolean isSARProduct;
            MetadataAttribute offsetY;
            MetadataAttribute offsetX;
            MetadataAttribute width;
            MetadataElement srcRoot = sourceProduct.getMetadataRoot();
            MetadataElement srcAbsRoot = srcRoot.getElement("Abstracted_Metadata");
            if (srcAbsRoot == null) {
                return;
            }
            MetadataElement trgRoot = targetProduct.getMetadataRoot();
            MetadataElement trgAbsRoot = trgRoot.getElement("Abstracted_Metadata");
            if (trgAbsRoot == null) {
                trgAbsRoot = new MetadataElement("Abstracted_Metadata");
                trgRoot.addElement(trgAbsRoot);
                ProductUtils.copyMetadata(srcAbsRoot, trgAbsRoot);
            }
            Rectangle region = subsetDef.getRegion();
            MetadataAttribute height = trgAbsRoot.getAttribute("num_output_lines");
            if (height != null) {
                height.getData().setElemUInt(targetProduct.getSceneRasterHeight());
            }
            if ((width = trgAbsRoot.getAttribute("num_samples_per_line")) != null) {
                width.getData().setElemUInt(targetProduct.getSceneRasterWidth());
            }
            if ((offsetX = trgAbsRoot.getAttribute("subset_offset_x")) != null && region != null) {
                offsetX.getData().setElemUInt(region.x);
            }
            if ((offsetY = trgAbsRoot.getAttribute("subset_offset_y")) != null && region != null) {
                offsetY.getData().setElemUInt(region.y);
            }
            boolean bl = isSARProduct = trgAbsRoot.getAttributeDouble("radar_frequency", 99999.0) != 99999.0;
            if (!isSARProduct) {
                return;
            }
            boolean nearRangeOnLeft = ProductSubsetBuilder.isNearRangeOnLeft(targetProduct);
            int sourceImageHeight = sourceProduct.getSceneRasterHeight();
            double srcFirstLineTime = ProductData.UTC.parse(srcAbsRoot.getAttributeString("first_line_time")).getMJD();
            double srcLastLineTime = ProductData.UTC.parse(srcAbsRoot.getAttributeString("last_line_time")).getMJD();
            double lineTimeInterval = (srcLastLineTime - srcFirstLineTime) / (double)(sourceImageHeight - 1);
            if (region != null) {
                MetadataAttribute lastLineTime;
                int regionY = region.y;
                double regionHeight = region.getHeight();
                double newFirstLineTime = srcFirstLineTime + lineTimeInterval * (double)regionY;
                double newLastLineTime = newFirstLineTime + lineTimeInterval * (regionHeight - 1.0);
                MetadataAttribute firstLineTime = trgAbsRoot.getAttribute("first_line_time");
                if (firstLineTime != null) {
                    firstLineTime.getData().setElems(new ProductData.UTC(newFirstLineTime).getArray());
                }
                if ((lastLineTime = trgAbsRoot.getAttribute("last_line_time")) != null) {
                    lastLineTime.getData().setElems(new ProductData.UTC(newLastLineTime).getArray());
                }
            }
            if ((totalSize = trgAbsRoot.getAttribute("total_size")) != null) {
                totalSize.getData().setElemUInt(targetProduct.getRawStorageSize());
            }
            if (nearRangeOnLeft) {
                ProductSubsetBuilder.setLatLongMetadata(targetProduct, trgAbsRoot, "first_near_lat", "first_near_long", 0.5f, 0.5f);
                ProductSubsetBuilder.setLatLongMetadata(targetProduct, trgAbsRoot, "first_far_lat", "first_far_long", (float)(targetProduct.getSceneRasterWidth() - 1) + 0.5f, 0.5f);
                ProductSubsetBuilder.setLatLongMetadata(targetProduct, trgAbsRoot, "last_near_lat", "last_near_long", 0.5f, (float)(targetProduct.getSceneRasterHeight() - 1) + 0.5f);
                ProductSubsetBuilder.setLatLongMetadata(targetProduct, trgAbsRoot, "last_far_lat", "last_far_long", (float)(targetProduct.getSceneRasterWidth() - 1) + 0.5f, (float)(targetProduct.getSceneRasterHeight() - 1) + 0.5f);
            } else {
                ProductSubsetBuilder.setLatLongMetadata(targetProduct, trgAbsRoot, "first_near_lat", "first_near_long", (float)(targetProduct.getSceneRasterWidth() - 1) + 0.5f, 0.5f);
                ProductSubsetBuilder.setLatLongMetadata(targetProduct, trgAbsRoot, "first_far_lat", "first_far_long", 0.5f, 0.5f);
                ProductSubsetBuilder.setLatLongMetadata(targetProduct, trgAbsRoot, "last_near_lat", "last_near_long", (float)(targetProduct.getSceneRasterWidth() - 1) + 0.5f, (float)(targetProduct.getSceneRasterHeight() - 1) + 0.5f);
                ProductSubsetBuilder.setLatLongMetadata(targetProduct, trgAbsRoot, "last_far_lat", "last_far_long", 0.5f, (float)(targetProduct.getSceneRasterHeight() - 1) + 0.5f);
            }
            MetadataAttribute slantRange = trgAbsRoot.getAttribute("slant_range_to_first_pixel");
            if (slantRange != null && (srTPG = targetProduct.getTiePointGrid("slant_range_time")) != null && region != null) {
                boolean srgrFlag;
                boolean bl2 = srgrFlag = srcAbsRoot.getAttributeInt("srgr_flag") != 0;
                if (srgrFlag) {
                    double slantRangeTime = nearRangeOnLeft ? srTPG.getPixelDouble(region.x, region.y) / 1.0E9 : srTPG.getPixelDouble(targetProduct.getSceneRasterWidth() - region.x - 1, region.y) / 1.0E9;
                    double halfLightSpeed = 1.49896229E8;
                    double slantRangeDist = slantRangeTime * 1.49896229E8;
                    slantRange.getData().setElemDouble(slantRangeDist);
                } else {
                    double slantRangeToFirstPixel = srcAbsRoot.getAttributeDouble("slant_range_to_first_pixel");
                    double rangeSpacing = srcAbsRoot.getAttributeDouble("RANGE_SPACING", 0.0);
                    double slantRangeDist = nearRangeOnLeft ? slantRangeToFirstPixel + (double)region.x * rangeSpacing : slantRangeToFirstPixel + (double)(targetProduct.getSceneRasterWidth() - region.x - 1) * rangeSpacing;
                    slantRange.getData().setElemDouble(slantRangeDist);
                }
            }
            ProductSubsetBuilder.setSubsetSRGRCoefficients(sourceProduct, targetProduct, subsetDef, trgAbsRoot, nearRangeOnLeft);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static boolean isNearRangeOnLeft(Product product) {
        TiePointGrid incidenceAngle = product.getTiePointGrid("incident_angle");
        if (incidenceAngle != null) {
            double incidenceAngleToLastPixel;
            double incidenceAngleToFirstPixel = incidenceAngle.getPixelDouble(0, 0);
            return incidenceAngleToFirstPixel < (incidenceAngleToLastPixel = incidenceAngle.getPixelDouble(product.getSceneRasterWidth() - 1, 0));
        }
        return true;
    }

    private static void setSubsetSRGRCoefficients(Product sourceProduct, Product targetProduct, ProductSubsetDef subsetDef, MetadataElement absRoot, boolean nearRangeOnLeft) {
        MetadataElement SRGRCoefficientsElem = absRoot.getElement("SRGR_Coefficients");
        if (SRGRCoefficientsElem != null) {
            double rangeSpacing = absRoot.getAttributeDouble("RANGE_SPACING", 0.0);
            double colIndex = subsetDef.getRegion() == null ? 0.0 : subsetDef.getRegion().getX();
            for (MetadataElement srgrList : SRGRCoefficientsElem.getElements()) {
                double ground_range_origin_subset;
                double grO = srgrList.getAttributeDouble("ground_range_origin", 0.0);
                if (nearRangeOnLeft) {
                    ground_range_origin_subset = grO + colIndex * rangeSpacing;
                } else {
                    double colIndexFromRight = (double)sourceProduct.getSceneRasterWidth() - colIndex - (double)targetProduct.getSceneRasterWidth();
                    ground_range_origin_subset = grO + colIndexFromRight * rangeSpacing;
                }
                srgrList.setAttributeDouble("ground_range_origin", ground_range_origin_subset);
            }
        }
    }

    private static void setLatLongMetadata(Product product, MetadataElement absRoot, String tagLat, String tagLon, float x, float y) {
        MetadataAttribute lon;
        PixelPos pixelPos = new PixelPos(x, y);
        GeoPos geoPos = new GeoPos();
        if (product.getSceneGeoCoding() == null) {
            return;
        }
        product.getSceneGeoCoding().getGeoPos(pixelPos, geoPos);
        MetadataAttribute lat = absRoot.getAttribute(tagLat);
        if (lat != null) {
            lat.getData().setElemDouble(geoPos.getLat());
        }
        if ((lon = absRoot.getAttribute(tagLon)) != null) {
            lon.getData().setElemDouble(geoPos.getLon());
        }
    }

    @Override
    protected Product readProductNodesImpl() throws IOException {
        if (!(this.getInput() instanceof Product)) {
            throw new IllegalArgumentException("unsupported input source: " + this.getInput());
        }
        this.sourceProduct = (Product)((Object)this.getInput());
        Debug.assertNotNull((Object)this.sourceProduct);
        this.sceneRasterWidth = this.sourceProduct.getSceneRasterWidth();
        this.sceneRasterHeight = this.sourceProduct.getSceneRasterHeight();
        if (this.getSubsetDef() != null) {
            Dimension s = this.getSubsetDef().getSceneRasterSize(this.sceneRasterWidth, this.sceneRasterHeight);
            this.sceneRasterWidth = s.width;
            this.sceneRasterHeight = s.height;
        }
        Product targetProduct = this.createProduct();
        ProductSubsetBuilder.updateMetadata(this.sourceProduct, targetProduct, this.getSubsetDef());
        return targetProduct;
    }

    @Override
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        Band sourceBand = (Band)this.bandMap.get(destBand);
        if (sourceBand.getRasterData() != null) {
            if (sourceBand.getRasterWidth() == destWidth && sourceBand.getRasterHeight() == destHeight) {
                this.copyBandRasterDataFully(sourceBand, destBuffer, destWidth, destHeight);
            } else {
                this.copyBandRasterDataSubSampling(sourceBand, sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, destBuffer, destWidth);
            }
        } else if (sourceWidth == destWidth && sourceHeight == destHeight) {
            this.readBandRasterDataRegion(sourceBand, sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, destBuffer, pm);
        } else {
            Rectangle destRect = new Rectangle(destOffsetX, destOffsetY, destWidth, destHeight);
            ProductSubsetBuilder.readBandRasterDataSubsampled(sourceBand, destBuffer, destRect, sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY);
        }
    }

    private static void readBandRasterDataSubsampled(Band band, ProductData destData, Rectangle destRect, int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY) throws IOException {
        AbstractProductReader reader;
        if (band.getProductReader() instanceof AbstractProductReader && band.isProductReaderDirectlyUsable() && (reader = (AbstractProductReader)band.getProductReader()).isSubsetReadingFullySupported()) {
            reader.readBandRasterDataImpl(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, band, destRect.x, destRect.y, destRect.width, destRect.height, destData, ProgressMonitor.NULL);
            return;
        }
        MultiLevelImage sourceImage = band.getSourceImage();
        Point[] tileIndices = sourceImage.getTileIndices(new Rectangle(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight));
        if (prefetchTiles) {
            sourceImage.prefetchTiles(tileIndices);
        }
        HashMap<Rectangle, ProductData> tileMap = new HashMap<Rectangle, ProductData>();
        for (Point tileIndex : tileIndices) {
            Rectangle tileRect = sourceImage.getTileRect(tileIndex.x, tileIndex.y);
            if (tileRect.isEmpty()) continue;
            ProductData tileData = ProductData.createInstance(band.getDataType(), tileRect.width * tileRect.height);
            band.readRasterData(tileRect.x, tileRect.y, tileRect.width, tileRect.height, tileData, ProgressMonitor.NULL);
            tileMap.put(tileRect, tileData);
        }
        for (int y = 0; y < destRect.height; ++y) {
            int currentSrcYOffset = sourceOffsetY + y * sourceStepY;
            int currentDestYOffset = y * destRect.width;
            for (int x = 0; x < destRect.width; ++x) {
                double value = ProductSubsetBuilder.getSourceValue(band, tileMap, sourceOffsetX + x * sourceStepX, currentSrcYOffset);
                destData.setElemDoubleAt(currentDestYOffset + x, value);
            }
        }
    }

    private static double getSourceValue(Band band, HashMap<Rectangle, ProductData> tileMap, int sourceX, int sourceY) {
        MultiLevelImage img = band.getSourceImage();
        Rectangle tileRect = img.getTileRect(img.XToTileX(sourceX), img.YToTileY(sourceY));
        ProductData productData = tileMap.get(tileRect);
        int currentX = sourceX - tileRect.x;
        int currentY = sourceY - tileRect.y;
        return productData.getElemDoubleAt(currentY * tileRect.width + currentX);
    }

    private void copyBandRasterDataFully(Band sourceBand, ProductData destBuffer, int destWidth, int destHeight) {
        ProductSubsetBuilder.copyData(sourceBand.getRasterData(), 0, destBuffer, 0, destWidth * destHeight);
    }

    private void readBandRasterDataRegion(Band sourceBand, int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        sourceBand.readRasterData(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, destBuffer, pm);
    }

    private void copyBandRasterDataSubSampling(Band sourceBand, int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, ProductData destBuffer, int destWidth) {
        int sourceMinY = sourceOffsetY;
        int sourceMaxY = sourceOffsetY + sourceHeight - 1;
        int destPos = 0;
        for (int sourceY = sourceMinY; sourceY <= sourceMaxY; sourceY += sourceStepY) {
            if (sourceStepX == 1) {
                ProductSubsetBuilder.copyData(sourceBand.getRasterData(), sourceY * sourceBand.getRasterWidth() + sourceOffsetX, destBuffer, destPos, destWidth);
            } else {
                ProductSubsetBuilder.copyLine(sourceBand.getRasterData(), sourceY * sourceBand.getRasterWidth() + sourceOffsetX, sourceWidth, sourceStepX, destBuffer, destPos);
            }
            destPos += destWidth;
        }
    }

    private static void copyData(ProductData sourceBuffer, int sourcePos, ProductData destBuffer, int destPos, int destLength) {
        System.arraycopy(sourceBuffer.getElems(), sourcePos, destBuffer.getElems(), destPos, destLength);
    }

    private static void copyLine(ProductData sourceBuffer, int sourceOffsetPos, int sourceWidth, int sourceStepX, ProductData destBuffer, int destOffsetPos) {
        int sourceMinX = sourceOffsetPos;
        int sourceMaxX = sourceOffsetPos + sourceWidth - 1;
        if (destBuffer.getElems() instanceof byte[]) {
            byte[] destArray = (byte[])destBuffer.getElems();
            byte[] sourceArray = (byte[])sourceBuffer.getElems();
            for (int sourceX = sourceMinX; sourceX <= sourceMaxX; sourceX += sourceStepX) {
                destArray[destOffsetPos] = sourceArray[sourceX];
                ++destOffsetPos;
            }
        } else if (destBuffer.getElems() instanceof short[]) {
            short[] destArray = (short[])destBuffer.getElems();
            short[] sourceArray = (short[])sourceBuffer.getElems();
            for (int sourceX = sourceMinX; sourceX <= sourceMaxX; sourceX += sourceStepX) {
                destArray[destOffsetPos] = sourceArray[sourceX];
                ++destOffsetPos;
            }
        } else if (destBuffer.getElems() instanceof int[]) {
            int[] destArray = (int[])destBuffer.getElems();
            int[] sourceArray = (int[])sourceBuffer.getElems();
            for (int sourceX = sourceMinX; sourceX <= sourceMaxX; sourceX += sourceStepX) {
                destArray[destOffsetPos] = sourceArray[sourceX];
                ++destOffsetPos;
            }
        } else if (destBuffer.getElems() instanceof float[]) {
            float[] destArray = (float[])destBuffer.getElems();
            float[] sourceArray = (float[])sourceBuffer.getElems();
            for (int sourceX = sourceMinX; sourceX <= sourceMaxX; sourceX += sourceStepX) {
                destArray[destOffsetPos] = sourceArray[sourceX];
                ++destOffsetPos;
            }
        } else if (destBuffer.getElems() instanceof double[]) {
            double[] destArray = (double[])destBuffer.getElems();
            double[] sourceArray = (double[])sourceBuffer.getElems();
            for (int sourceX = sourceMinX; sourceX <= sourceMaxX; sourceX += sourceStepX) {
                destArray[destOffsetPos] = sourceArray[sourceX];
                ++destOffsetPos;
            }
        } else {
            Debug.assertTrue(false, "illegal product data type");
            throw new IllegalStateException("illegal product data type");
        }
    }

    private Product createProduct() {
        Product sourceProduct = this.getSourceProduct();
        Debug.assertNotNull((Object)sourceProduct);
        Debug.assertTrue(this.getSceneRasterWidth() > 0);
        Debug.assertTrue(this.getSceneRasterHeight() > 0);
        String newProductName = this.newProductName == null || this.newProductName.length() == 0 ? sourceProduct.getName() : this.newProductName;
        Product product = new Product(newProductName, sourceProduct.getProductType(), this.getSceneRasterWidth(), this.getSceneRasterHeight(), this);
        product.setPointingFactory(sourceProduct.getPointingFactory());
        if (this.newProductDesc == null || this.newProductDesc.length() == 0) {
            product.setDescription(sourceProduct.getDescription());
        } else {
            product.setDescription(this.newProductDesc);
        }
        if (!this.isMetadataIgnored()) {
            ProductUtils.copyMetadata(sourceProduct, product);
        }
        this.addTiePointGridsToProduct(product);
        this.addBandsToProduct(product);
        ProductUtils.copyMasks(sourceProduct, product);
        this.addFlagCodingsToProduct(product);
        this.addGeoCodingToProduct(product);
        this.copyAcceptedIndexCodings(product);
        ProductUtils.copyVectorData(sourceProduct, product);
        ProductUtils.copyOverlayMasks(sourceProduct, product);
        ProductUtils.copyPreferredTileSize(sourceProduct, product);
        this.setSceneRasterStartAndStopTime(product);
        this.addSubsetInfoMetadata(product);
        if (sourceProduct.getQuicklookBandName() != null && product.getQuicklookBandName() == null && product.containsBand(sourceProduct.getQuicklookBandName())) {
            product.setQuicklookBandName(sourceProduct.getQuicklookBandName());
        }
        product.setAutoGrouping(sourceProduct.getAutoGrouping());
        return product;
    }

    private void setSceneRasterStartAndStopTime(Product product) {
        Product sourceProduct = this.getSourceProduct();
        ProductData.UTC startTime = sourceProduct.getStartTime();
        ProductData.UTC stopTime = sourceProduct.getEndTime();
        ProductSubsetDef subsetDef = this.getSubsetDef();
        if (startTime != null && stopTime != null && subsetDef != null && subsetDef.getRegion() != null) {
            double height = sourceProduct.getSceneRasterHeight();
            Rectangle region = subsetDef.getRegion();
            double regionY = region.getY();
            double regionHeight = region.getHeight();
            double dStart = startTime.getMJD();
            double dStop = stopTime.getMJD();
            double vPerLine = (dStop - dStart) / (height - 1.0);
            double newStart = vPerLine * regionY + dStart;
            double newStop = vPerLine * (regionHeight - 1.0) + newStart;
            product.setStartTime(new ProductData.UTC(newStart));
            product.setEndTime(new ProductData.UTC(newStop));
        } else {
            product.setStartTime(startTime);
            product.setEndTime(stopTime);
        }
    }

    private void addSubsetInfoMetadata(Product product) {
        if (this.getSubsetDef() != null) {
            String[] nodeNames;
            ProductSubsetDef subsetDef = this.getSubsetDef();
            Product sourceProduct = this.getSourceProduct();
            String nameSubsetinfo = "SubsetInfo";
            MetadataElement subsetElem = new MetadataElement(nameSubsetinfo);
            ProductSubsetBuilder.addAttribString("SourceProduct.name", sourceProduct.getName(), subsetElem);
            subsetElem.setAttributeInt("SubSampling.x", subsetDef.getSubSamplingX());
            subsetElem.setAttributeInt("SubSampling.y", subsetDef.getSubSamplingY());
            if (subsetDef.getRegion() != null) {
                Rectangle region = subsetDef.getRegion();
                subsetElem.setAttributeInt("SubRegion.x", region.x);
                subsetElem.setAttributeInt("SubRegion.y", region.y);
                subsetElem.setAttributeInt("SubRegion.width", region.width);
                subsetElem.setAttributeInt("SubRegion.height", region.height);
            }
            if ((nodeNames = subsetDef.getNodeNames()) != null) {
                for (int i = 0; i < nodeNames.length; ++i) {
                    ProductSubsetBuilder.addAttribString("ProductNodeName." + (i + 1), nodeNames[i], subsetElem);
                }
            }
            ProductUtils.addElementToHistory(product, subsetElem);
        }
    }

    protected void addBandsToProduct(Product product) {
        Debug.assertNotNull((Object)this.getSourceProduct());
        Debug.assertNotNull((Object)product);
        for (int i = 0; i < this.getSourceProduct().getNumBands(); ++i) {
            Band destBand;
            Band sourceBand = this.getSourceProduct().getBandAt(i);
            String bandName = sourceBand.getName();
            if (!this.isNodeAccepted(bandName)) continue;
            boolean treatVirtualBandsAsRealBands = false;
            if (this.getSubsetDef() != null && this.getSubsetDef().getTreatVirtualBandsAsRealBands()) {
                treatVirtualBandsAsRealBands = true;
            }
            if (!treatVirtualBandsAsRealBands && sourceBand instanceof VirtualBand) {
                VirtualBand virtualSource = (VirtualBand)sourceBand;
                if (this.getSubsetDef() == null) {
                    destBand = new VirtualBand(bandName, sourceBand.getDataType(), this.getSceneRasterWidth(), this.getSceneRasterHeight(), virtualSource.getExpression());
                } else {
                    Dimension dim = this.getSubsetDef().getSceneRasterSize(sourceBand.getRasterWidth(), sourceBand.getRasterHeight(), sourceBand.getName());
                    destBand = new VirtualBand(bandName, sourceBand.getDataType(), dim.width, dim.height, virtualSource.getExpression());
                }
            } else if (this.getSubsetDef() == null) {
                destBand = new Band(bandName, sourceBand.getDataType(), this.getSceneRasterWidth(), this.getSceneRasterHeight());
            } else {
                Dimension dim = this.getSubsetDef().getSceneRasterSize(sourceBand.getRasterWidth(), sourceBand.getRasterHeight(), sourceBand.getName());
                destBand = new Band(bandName, sourceBand.getDataType(), dim.width, dim.height);
            }
            if (sourceBand.getUnit() != null) {
                destBand.setUnit(sourceBand.getUnit());
            }
            if (sourceBand.getDescription() != null) {
                destBand.setDescription(sourceBand.getDescription());
            }
            destBand.setScalingFactor(sourceBand.getScalingFactor());
            destBand.setScalingOffset(sourceBand.getScalingOffset());
            destBand.setLog10Scaled(sourceBand.isLog10Scaled());
            destBand.setSpectralBandIndex(sourceBand.getSpectralBandIndex());
            destBand.setSpectralWavelength(sourceBand.getSpectralWavelength());
            destBand.setSpectralBandwidth(sourceBand.getSpectralBandwidth());
            destBand.setSolarFlux(sourceBand.getSolarFlux());
            if (sourceBand.isNoDataValueSet()) {
                destBand.setNoDataValue(sourceBand.getNoDataValue());
            }
            destBand.setNoDataValueUsed(sourceBand.isNoDataValueUsed());
            destBand.setValidPixelExpression(sourceBand.getValidPixelExpression());
            FlagCoding sourceFlagCoding = sourceBand.getFlagCoding();
            IndexCoding sourceIndexCoding = sourceBand.getIndexCoding();
            if (sourceFlagCoding != null) {
                String flagCodingName = sourceFlagCoding.getName();
                FlagCoding destFlagCoding = product.getFlagCodingGroup().get(flagCodingName);
                if (destFlagCoding == null) {
                    destFlagCoding = ProductUtils.copyFlagCoding(sourceFlagCoding, product);
                }
                destBand.setSampleCoding(destFlagCoding);
            } else if (sourceIndexCoding != null) {
                String indexCodingName = sourceIndexCoding.getName();
                IndexCoding destIndexCoding = product.getIndexCodingGroup().get(indexCodingName);
                if (destIndexCoding == null) {
                    destIndexCoding = ProductUtils.copyIndexCoding(sourceIndexCoding, product);
                }
                destBand.setSampleCoding(destIndexCoding);
            } else {
                destBand.setSampleCoding(null);
            }
            if (this.isFullScene(this.getSubsetDef(), sourceBand) && sourceBand.isStxSet()) {
                this.copyStx(sourceBand, destBand);
            }
            product.addBand(destBand);
            this.bandMap.put(destBand, sourceBand);
        }
        for (Map.Entry entry : this.bandMap.entrySet()) {
            this.copyImageInfo((RasterDataNode)entry.getValue(), (RasterDataNode)entry.getKey());
        }
    }

    protected void addTiePointGridsToProduct(Product product) {
        String lonGridName;
        String latGridName;
        GeoCoding geoCoding = this.getSourceProduct().getSceneGeoCoding();
        if (geoCoding instanceof TiePointGeoCoding) {
            TiePointGeoCoding tiePointGeoCoding = (TiePointGeoCoding)geoCoding;
            TiePointGrid latGrid = tiePointGeoCoding.getLatGrid();
            TiePointGrid lonGrid = tiePointGeoCoding.getLonGrid();
            latGridName = latGrid.getName();
            lonGridName = lonGrid.getName();
        } else {
            latGridName = null;
            lonGridName = null;
        }
        for (int i = 0; i < this.getSourceProduct().getNumTiePointGrids(); ++i) {
            TiePointGrid sourceTiePointGrid = this.getSourceProduct().getTiePointGridAt(i);
            String gridName = sourceTiePointGrid.getName();
            if (!this.isNodeAccepted(gridName) && !gridName.equals(latGridName) && !gridName.equals(lonGridName)) continue;
            TiePointGrid tiePointGrid = TiePointGrid.createSubset(sourceTiePointGrid, this.getSubsetDef());
            if (this.isFullScene(this.getSubsetDef(), tiePointGrid) && sourceTiePointGrid.isStxSet()) {
                this.copyStx(sourceTiePointGrid, tiePointGrid);
            }
            product.addTiePointGrid(tiePointGrid);
            this.copyImageInfo(sourceTiePointGrid, tiePointGrid);
        }
    }

    private void copyStx(RasterDataNode sourceRaster, RasterDataNode targetRaster) {
        Stx sourceStx = sourceRaster.getStx();
        Histogram sourceHistogram = sourceStx.getHistogram();
        Histogram targetHistogram = new Histogram(sourceStx.getHistogramBinCount(), sourceHistogram.getLowValue(0), sourceHistogram.getHighValue(0), 1);
        System.arraycopy(sourceHistogram.getBins(0), 0, targetHistogram.getBins(0), 0, sourceStx.getHistogramBinCount());
        Stx targetStx = new Stx(sourceStx.getMinimum(), sourceStx.getMaximum(), sourceStx.getMean(), sourceStx.getStandardDeviation(), sourceStx.getCoefficientOfVariation(), sourceStx.getEquivalentNumberOfLooks(), sourceStx.isLogHistogram(), sourceStx.isIntHistogram(), targetHistogram, sourceStx.getResolutionLevel());
        targetRaster.setStx(targetStx);
    }

    private void copyImageInfo(RasterDataNode sourceRaster, RasterDataNode targetRaster) {
        if (sourceRaster.getImageInfo() != null) {
            ImageInfo imageInfo = sourceRaster.getImageInfo().createDeepCopy();
            targetRaster.setImageInfo(imageInfo);
        }
    }

    private boolean isFullScene(ProductSubsetDef subsetDef, RasterDataNode rasterDataNode) {
        if (subsetDef == null) {
            return true;
        }
        Rectangle sourceRegion = new Rectangle(0, 0, this.sourceProduct.getSceneRasterWidth(), this.getSceneRasterHeight());
        if (subsetDef.getRegionMap() == null) {
            return subsetDef.getRegion() == null || subsetDef.getRegion().equals(sourceRegion) && subsetDef.getSubSamplingX() == 1 && subsetDef.getSubSamplingY() == 1;
        }
        return subsetDef.getRegionMap().get(rasterDataNode.getName()) == null || subsetDef.getRegionMap().get(rasterDataNode.getName()).equals(sourceRegion) && subsetDef.getSubSamplingX() == 1 && subsetDef.getSubSamplingY() == 1;
    }

    protected void addGeoCodingToProduct(Product product) {
        if (!this.getSourceProduct().transferGeoCodingTo(product, this.getSubsetDef())) {
            Debug.trace("GeoCoding could not be transferred.");
        }
        if (this.getSubsetDef() != null && this.getSubsetDef().getRegionMap() != null) {
            for (RasterDataNode rasterDataNode : product.getRasterDataNodes()) {
                if ((double)rasterDataNode.getRasterWidth() != product.getSceneRasterSize().getWidth() || (double)rasterDataNode.getRasterHeight() != product.getSceneRasterSize().getHeight() || rasterDataNode.getGeoCoding() == null) continue;
                ProductUtils.copyGeoCoding(rasterDataNode, product);
            }
        }
    }

    private void copyAcceptedIndexCodings(Product product) {
        for (Band srcBand : product.getBands()) {
            if (!srcBand.isIndexBand() || !this.isNodeAccepted(srcBand.getName())) continue;
            IndexCoding sourceIndexCoding = srcBand.getIndexCoding();
            IndexCoding destIndexCoding = new IndexCoding(sourceIndexCoding.getName());
            destIndexCoding.setDescription(sourceIndexCoding.getDescription());
            this.cloneIndexes(sourceIndexCoding, destIndexCoding);
            product.getIndexCodingGroup().add(destIndexCoding);
        }
    }
}

