/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.TileCache;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.EncodeQualification;
import org.esa.snap.core.dataio.ProductIOException;
import org.esa.snap.core.dataio.ProductIOPlugInManager;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.dataio.ProductWriter;
import org.esa.snap.core.dataio.ProductWriterPlugIn;
import org.esa.snap.core.dataio.dimap.DimapProductWriter;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.image.LevelImageSupport;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.StopWatch;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.runtime.Config;
import org.esa.snap.runtime.EngineConfig;

public class ProductIO {
    public static final String DEFAULT_FORMAT_NAME = "BEAM-DIMAP";
    public static final String SYSTEM_PROPERTY_CONCURRENT = "snap.productio.concurrent";
    public static final boolean DEFAULT_WRITE_RASTER_CONCURRENT = true;

    public static ProductReader getProductReader(String formatName) {
        ProductIOPlugInManager registry = ProductIOPlugInManager.getInstance();
        Iterator<ProductReaderPlugIn> it = registry.getReaderPlugIns(formatName);
        if (it.hasNext()) {
            ProductReaderPlugIn plugIn = it.next();
            return plugIn.createReaderInstance();
        }
        return null;
    }

    public static String[] getProductWriterExtensions(String formatName) {
        ProductIOPlugInManager registry = ProductIOPlugInManager.getInstance();
        Iterator<ProductWriterPlugIn> it = registry.getWriterPlugIns(formatName);
        if (it.hasNext()) {
            ProductWriterPlugIn plugIn = it.next();
            return plugIn.getDefaultFileExtensions();
        }
        return null;
    }

    public static ProductWriter getProductWriter(String formatName) {
        ProductIOPlugInManager registry = ProductIOPlugInManager.getInstance();
        Iterator<ProductWriterPlugIn> it = registry.getWriterPlugIns(formatName);
        if (it.hasNext()) {
            ProductWriterPlugIn plugIn = it.next();
            return plugIn.createWriterInstance();
        }
        return null;
    }

    public static Product readProduct(File file, String ... formatNames) throws IOException {
        Guardian.assertNotNull("file", file);
        if (!file.exists()) {
            throw new FileNotFoundException("File not found: " + file.getPath());
        }
        ProductIOPlugInManager registry = ProductIOPlugInManager.getInstance();
        for (String formatName : formatNames) {
            ProductReader productReader;
            ProductReaderPlugIn selectedPlugIn = null;
            if (formatName != null) {
                Iterator<ProductReaderPlugIn> it = registry.getReaderPlugIns(formatName);
                while (it.hasNext()) {
                    ProductReaderPlugIn plugIn = it.next();
                    DecodeQualification decodeQualification = plugIn.getDecodeQualification(file);
                    if (decodeQualification == DecodeQualification.INTENDED) {
                        selectedPlugIn = plugIn;
                        break;
                    }
                    if (decodeQualification != DecodeQualification.SUITABLE) continue;
                    selectedPlugIn = plugIn;
                }
            }
            if (selectedPlugIn == null || (productReader = selectedPlugIn.createReaderInstance()) == null) continue;
            return productReader.readProductNodes(file, null);
        }
        return ProductIO.readProductImpl(file, null);
    }

    public static Product readProduct(String filePath) throws IOException {
        return ProductIO.readProductImpl(new File(filePath), null);
    }

    public static Product readProduct(File file) throws IOException {
        return ProductIO.readProductImpl(file, null);
    }

    public static Product readProduct(File file, ProductSubsetDef subsetDef) throws IOException {
        return ProductIO.readProductImpl(file, subsetDef);
    }

    private static Product readProductImpl(File file, ProductSubsetDef subsetDef) throws IOException {
        Guardian.assertNotNull("file", file);
        if (!file.exists()) {
            throw new FileNotFoundException("File not found: " + file.getPath());
        }
        ProductReader productReader = ProductIO.getProductReaderForInput(file);
        if (productReader != null) {
            return productReader.readProductNodes(file, subsetDef);
        }
        return null;
    }

    public static ProductReader getProductReaderForInput(Object input) {
        long startTimeTotal = System.currentTimeMillis();
        Logger logger = EngineConfig.instance().logger();
        logger.fine("Searching reader plugin for '" + input + "'");
        ProductIOPlugInManager registry = ProductIOPlugInManager.getInstance();
        Iterator<ProductReaderPlugIn> it = registry.getAllReaderPlugIns();
        Object selectedPlugIn = null;
        while (it.hasNext()) {
            ProductReaderPlugIn plugIn = it.next();
            try {
                long startTime = System.currentTimeMillis();
                DecodeQualification decodeQualification = plugIn.getDecodeQualification(input);
                long endTime = System.currentTimeMillis();
                logger.fine(String.format("Checking reader plugin %s (took %d ms)", plugIn.getClass().getName(), endTime - startTime));
                if (decodeQualification == DecodeQualification.INTENDED) {
                    selectedPlugIn = plugIn;
                    break;
                }
                if (decodeQualification != DecodeQualification.SUITABLE) continue;
                selectedPlugIn = plugIn;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error attempting to read " + input + " with plugin reader " + plugIn.toString(), e);
            }
        }
        long endTimeTotal = System.currentTimeMillis();
        logger.fine(String.format("Searching reader plugin took %d ms", endTimeTotal - startTimeTotal));
        if (selectedPlugIn != null) {
            logger.fine("Selected " + selectedPlugIn.getClass().getName());
            return selectedPlugIn.createReaderInstance();
        }
        logger.fine("No suitable reader plugin found");
        return null;
    }

    public static void writeProduct(Product product, String filePath, String formatName) throws IOException {
        ProductIO.writeProduct(product, new File(filePath), formatName, false, ProgressMonitor.NULL);
    }

    public static void writeProduct(Product product, String filePath, String formatName, ProgressMonitor pm) throws IOException {
        ProductIO.writeProduct(product, new File(filePath), formatName, false, pm);
    }

    public static void writeProduct(Product product, File file, String formatName, boolean incremental) throws IOException {
        ProductIO.writeProduct(product, file, formatName, incremental, ProgressMonitor.NULL);
    }

    public static void writeProduct(Product product, File file, String formatName, boolean incremental, ProgressMonitor pm) throws IOException {
        ProductWriter productWriter;
        Guardian.assertNotNull("product", (Object)product);
        Guardian.assertNotNull("file", file);
        if (formatName == null) {
            formatName = DEFAULT_FORMAT_NAME;
        }
        if ((productWriter = ProductIO.getProductWriter(formatName)) == null) {
            throw new ProductIOException("No product writer for the '" + formatName + "' format available.");
        }
        EncodeQualification encodeQualification = productWriter.getWriterPlugIn().getEncodeQualification(product);
        if (encodeQualification.getPreservation() == EncodeQualification.Preservation.UNABLE) {
            throw new ProductIOException("Product writer is unable to write product:\n" + encodeQualification.getInfoString());
        }
        productWriter.setIncrementalMode(incremental);
        ProductIO.writeProduct(product, file, productWriter, pm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeProduct(Product product, File file, ProductWriter productWriter, ProgressMonitor pm) throws IOException {
        ProductWriter productWriterOld = product.getProductWriter();
        product.setProductWriter(productWriter);
        IOException ioException = null;
        try {
            long s = System.currentTimeMillis();
            productWriter.writeProductNodes(product, file);
            long e = System.currentTimeMillis();
            long t1 = e - s;
            SystemUtils.LOG.fine("write product nodes to " + file.getAbsolutePath() + " took " + StopWatch.getTimeString(t1));
            s = System.currentTimeMillis();
            ProductIO.writeAllBands(product, pm);
            e = System.currentTimeMillis();
            long t2 = e - s;
            s = System.currentTimeMillis();
            if (productWriter instanceof DimapProductWriter && product.isModified()) {
                productWriter.writeProductNodes(product, file);
            }
            e = System.currentTimeMillis();
            long t3 = e - s;
            SystemUtils.LOG.fine("write all bands of product " + file.getAbsolutePath() + " took " + StopWatch.getTimeString(t2));
            SystemUtils.LOG.fine("Write entire product " + file.getAbsolutePath() + " took " + StopWatch.getTimeString(t1 + t2 + t3));
        }
        catch (IOException e) {
            ioException = e;
        }
        finally {
            block14: {
                try {
                    productWriter.flush();
                    productWriter.close();
                }
                catch (IOException e) {
                    if (ioException != null) break block14;
                    ioException = e;
                }
            }
            product.setProductWriter(productWriterOld);
            product.setFileLocation(file);
        }
        if (ioException != null) {
            throw ioException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeAllBands(Product product, ProgressMonitor pm) throws IOException {
        ProductWriter productWriter = product.getProductWriter();
        boolean concurrent = Config.instance((String)"snap").load().preferences().getBoolean(SYSTEM_PROPERTY_CONCURRENT, true);
        ArrayList<Band> bandsToWrite = new ArrayList<Band>();
        for (int i = 0; i < product.getNumBands(); ++i) {
            Band band = product.getBandAt(i);
            if (!productWriter.shouldWrite(band)) continue;
            bandsToWrite.add(band);
        }
        if (!bandsToWrite.isEmpty()) {
            pm.beginTask("Writing bands of product '" + product.getName() + "'...", bandsToWrite.size());
            try {
                if (concurrent) {
                    ProductIO.writeBandsConcurrent(pm, bandsToWrite);
                } else {
                    ProductIO.writeBandsSequentially(pm, bandsToWrite);
                }
            }
            finally {
                pm.done();
            }
        }
    }

    private static void writeBandsConcurrent(ProgressMonitor pm, ArrayList<Band> bandsToWrite) throws IOException {
        int numBands = bandsToWrite.size();
        CountDownLatch bandsCountDown = new CountDownLatch(numBands);
        int numThreads = Config.instance().load().preferences().getInt("snap.parallelism", Runtime.getRuntime().availableProcessors());
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        ArrayList<IOException> ioExceptionCollector = new ArrayList<IOException>();
        for (Band band : bandsToWrite) {
            if (pm.isCanceled()) {
                bandsCountDown.countDown();
                break;
            }
            pm.setSubTaskName("Writing band '" + band.getName() + "'");
            ProgressMonitor subPM = SubProgressMonitor.create((ProgressMonitor)pm, (int)1);
            ProductIO.writeRasterDataFully(subPM, band, executor, bandsCountDown, ioExceptionCollector);
        }
        while (bandsCountDown.getCount() > 0L) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                EngineConfig.instance().logger().log(Level.WARNING, "Method ProductIO.writeAllBands(...)' unexpected termination", e);
            }
        }
        executor.shutdown();
        for (IOException e : ioExceptionCollector) {
            SystemUtils.LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        if (ioExceptionCollector.size() > 0) {
            throw (IOException)ioExceptionCollector.get(0);
        }
    }

    private static void writeBandsSequentially(ProgressMonitor pm, ArrayList<Band> bandsToWrite) throws IOException {
        for (Band band : bandsToWrite) {
            if (pm.isCanceled()) break;
            pm.setSubTaskName("Writing band '" + band.getName() + "'");
            ProgressMonitor subPM = SubProgressMonitor.createSynchronized((ProgressMonitor)pm, (int)1);
            ProductIO.writeRasterDataFully(subPM, band, null, null, null);
        }
    }

    private ProductIO() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeRasterDataFully(ProgressMonitor pm, Band band, ExecutorService executor, CountDownLatch bandsCountDown, List<IOException> ioExceptionCollector) throws IOException {
        if (band.hasRasterData()) {
            try {
                band.writeRasterData(0, 0, band.getRasterWidth(), band.getRasterHeight(), band.getRasterData(), pm);
                band.removeCachedImageData();
            }
            finally {
                pm.done();
                if (bandsCountDown != null) {
                    bandsCountDown.countDown();
                }
            }
        }
        MultiLevelImage sourceImage = band.getSourceImage();
        Point[] tileIndices = sourceImage.getTileIndices(new Rectangle(0, 0, sourceImage.getWidth(), sourceImage.getHeight()));
        int numTiles = tileIndices.length;
        pm.beginTask("Writing raster data...", numTiles);
        if (executor != null) {
            Finisher finisher = new Finisher(pm, bandsCountDown, numTiles);
            for (Point tileIndex : tileIndices) {
                executor.execute(() -> ProductIO.lambda$writeRasterDataFully$0(pm, (PlanarImage)sourceImage, tileIndex, band, ioExceptionCollector, finisher));
            }
        } else {
            for (Point tileIndex : tileIndices) {
                if (!pm.isCanceled()) {
                    ProductIO.writeTile((PlanarImage)sourceImage, tileIndex, band);
                    pm.worked(1);
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeTile(PlanarImage sourceImage, Point tileIndex, Band band) throws IOException {
        Rectangle rect = sourceImage.getTileRect(tileIndex.x, tileIndex.y);
        if (!rect.isEmpty()) {
            Raster data = sourceImage.getData(rect);
            ProductData rasterData = band.createCompatibleRasterData(rect.width, rect.height);
            data.getDataElements(rect.x, rect.y, rect.width, rect.height, rasterData.getElems());
            try {
                band.writeRasterData(rect.x, rect.y, rect.width, rect.height, rasterData, ProgressMonitor.NULL);
            }
            finally {
                rasterData.dispose();
                ProductIO.removeCachedTile(sourceImage, tileIndex);
            }
        }
    }

    private static void removeCachedTile(PlanarImage sourceImage, Point tileIndex) {
        OpImage opImage;
        TileCache tileCache;
        if (sourceImage instanceof OpImage && (tileCache = (opImage = (OpImage)sourceImage).getTileCache()) != null) {
            tileCache.remove((RenderedImage)sourceImage, tileIndex.x, tileIndex.y);
        }
    }

    public static void readLevelBandRasterData(AbstractProductReader reader, Band destBand, LevelImageSupport lvlSupport, Rectangle destRect, ProductData destBuffer) throws IOException {
        Rectangle srcRect = lvlSupport.getSourceRectangle(destRect);
        int scale = (int)lvlSupport.getScale();
        reader.readBandRasterDataImpl(srcRect.x, srcRect.y, srcRect.width, srcRect.height, scale, scale, destBand, destRect.x, destRect.y, destRect.width, destRect.height, destBuffer, ProgressMonitor.NULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$writeRasterDataFully$0(ProgressMonitor pm, PlanarImage sourceImage, Point tileIndex, Band band, List ioExceptionCollector, Finisher finisher) {
        try {
            if (pm.isCanceled()) {
                return;
            }
            ProductIO.writeTile(sourceImage, tileIndex, band);
        }
        catch (IOException e) {
            ioExceptionCollector.add(e);
            pm.setCanceled(true);
        }
        finally {
            try {
                finisher.worked();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    private static class Finisher {
        private final ProgressMonitor pm;
        private final CountDownLatch bandsCountDown;
        private final int work;
        private int counter;

        public Finisher(ProgressMonitor pm, CountDownLatch bandsCountDown, int counter) {
            this.pm = pm;
            this.bandsCountDown = bandsCountDown;
            this.work = counter;
        }

        public synchronized void worked() {
            try {
                this.pm.worked(1);
            }
            finally {
                ++this.counter;
                if (this.counter == this.work) {
                    this.bandsCountDown.countDown();
                    this.pm.done();
                }
            }
        }
    }
}

