/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.nbexec;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Launcher {
    private static final String CLUSTERS_EXT = ".clusters";
    private final String[] args;
    private final Map<String, String> configuration;
    int patchCount = 0;

    public static void main(String[] args) {
        new Launcher(args).run();
    }

    private Launcher(String[] args) {
        this.args = args;
        this.configuration = new HashMap<String, String>();
    }

    private void run() {
        Path restartExeFile;
        Stream<Path> etcFiles;
        Path installationDir = Paths.get("", new String[0]).toAbsolutePath();
        Path etcDir = installationDir.resolve("etc");
        Path platformDir = installationDir.resolve("platform");
        if (!Files.isDirectory(etcDir, new LinkOption[0]) || !Files.isDirectory(platformDir, new LinkOption[0])) {
            throw new IllegalStateException("Not a valid installation directory: " + installationDir);
        }
        LinkedList<String> argList = new LinkedList<String>(Arrays.asList(this.args));
        String clusterDirs = this.parseArg(argList, "--clusters");
        String brandingToken = this.parseArg(argList, "--branding");
        String userDir = this.parseArg(argList, "--userdir");
        String cacheDir = this.parseArg(argList, "--cachedir");
        Set<Patch> patches = this.parseClusterPatches(argList);
        try {
            etcFiles = Files.list(etcDir);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        List clustersFiles = etcFiles.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().endsWith(CLUSTERS_EXT)).collect(Collectors.toList());
        if (clustersFiles.isEmpty()) {
            throw new IllegalStateException(String.format("no '*.clusters' file found in '%s'", etcDir));
        }
        if (clustersFiles.size() > 1) {
            throw new IllegalStateException(String.format("multiple '*.clusters' files found in '%s'", etcDir));
        }
        Path clustersFile = (Path)clustersFiles.get(0);
        String clustersFileName = clustersFile.getFileName().toString();
        String appName = clustersFileName.substring(0, clustersFileName.length() - CLUSTERS_EXT.length());
        Path confFile = etcDir.resolve(appName + ".conf");
        this.configuration.putAll(System.getenv());
        this.setConfigurationVariableIfNotSet("APPNAME", appName);
        this.setConfigurationVariableIfNotSet("HOME", System.getProperty("user.home"));
        if (Files.isRegularFile(confFile, new LinkOption[0])) {
            this.loadConf(confFile);
        }
        LinkedList<String> defaultOptionList = new LinkedList();
        String defaultOptions = this.getVar("default_options");
        String defaultClusterDirs = null;
        String defaultBrandingToken = null;
        String defaultUserDir = null;
        String defaultCacheDir = null;
        if (defaultOptions != null) {
            defaultOptionList = this.parseOptions(defaultOptions);
            defaultClusterDirs = this.parseArg(defaultOptionList, "--clusters");
            defaultBrandingToken = this.parseArg(defaultOptionList, "--branding");
            defaultUserDir = this.parseArg(defaultOptionList, "--userdir");
            defaultCacheDir = this.parseArg(defaultOptionList, "--cachedir");
        }
        if (defaultUserDir == null && (defaultUserDir = "Darwin".equals(System.getProperty("os.name")) ? this.getVar("default_mac_userdir") : this.getVar("default_userdir")) == null) {
            defaultUserDir = installationDir.resolve("..").resolve("userdir").toString();
        }
        if (clusterDirs == null) {
            clusterDirs = defaultClusterDirs;
        }
        if (userDir == null) {
            userDir = defaultUserDir;
        }
        if (defaultCacheDir == null) {
            defaultCacheDir = Launcher.path(userDir, "var", "cache");
        }
        if (brandingToken == null) {
            brandingToken = defaultBrandingToken;
        }
        if (cacheDir == null) {
            cacheDir = defaultCacheDir;
        }
        List<String> clusterList = Launcher.readLines(clustersFile);
        clusterList = Launcher.toAbsolutePaths(clusterList);
        String extraClusterPaths = this.getVar("extra_clusters");
        if (extraClusterPaths != null) {
            clusterList.add(extraClusterPaths);
        }
        if (clusterDirs != null) {
            clusterList.addAll(Launcher.toAbsolutePaths(Arrays.asList(clusterDirs.split(File.pathSeparator))));
        }
        String clusterPaths = Launcher.toPathsString(clusterList);
        ArrayList<URL> classPathList = new ArrayList<URL>();
        this.buildClasspath(userDir, classPathList);
        this.buildClasspath(platformDir.toString(), classPathList);
        if ("true".equals(this.getVar("KDE_FULL_SESSION"))) {
            this.setSystemPropertyIfNotSet("netbeans.running.environment", "kde");
        } else if (this.getVar("GNOME_DESKTOP_SESSION_ID") != null) {
            this.setSystemPropertyIfNotSet("netbeans.running.environment", "gnome");
        }
        if (this.getVar("DEFAULT_USERDIR_ROOT") != null) {
            this.setSystemPropertyIfNotSet("netbeans.default_userdir_root", this.getVar("DEFAULT_USERDIR_ROOT"));
        }
        this.setSystemPropertyIfNotSet("netbeans.home", platformDir.toString());
        this.setSystemPropertyIfNotSet("netbeans.dirs", clusterPaths);
        this.setSystemPropertyIfNotSet("netbeans.logger.console", "true");
        this.setSystemPropertyIfNotSet("com.apple.mrj.application.apple.menu.about.name", brandingToken);
        List<String> remainingDefaultOptions = this.parseJavaOptions(defaultOptionList, false);
        List<String> remainingArgs = this.parseJavaOptions(argList, true);
        this.setPatchModules(clusterList, patches);
        ArrayList<String> newArgList = new ArrayList<String>();
        newArgList.add("--branding");
        newArgList.add(brandingToken);
        newArgList.add("--userdir");
        newArgList.add(userDir);
        newArgList.add("--cachedir");
        newArgList.add(cacheDir);
        newArgList.addAll(remainingArgs);
        newArgList.addAll(remainingDefaultOptions);
        Path restartMarkerFile = Paths.get(userDir, "var", "restart");
        try {
            Files.deleteIfExists(restartMarkerFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String _userDir = userDir;
        try {
            Optional<Path> restartFileResult = Files.list(installationDir.resolve("bin")).filter(Files::isExecutable).filter(p -> p.getFileName().toString().startsWith("restart.")).findFirst();
            restartExeFile = restartFileResult.get();
        }
        catch (Exception e) {
            restartExeFile = null;
        }
        Path _restartExeFile = restartExeFile;
        if (_restartExeFile != null) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                if (Files.exists(restartMarkerFile, new LinkOption[0])) {
                    String processName = ManagementFactory.getRuntimeMXBean().getName();
                    Logger.getLogger("").info("Shut down: " + processName);
                    String pid = processName.split("@")[0];
                    try {
                        new ProcessBuilder(new String[0]).command(_restartExeFile.toString(), pid).start();
                    }
                    catch (IOException e) {
                        Logger.getLogger("").log(Level.SEVERE, "Failed to restart: " + _restartExeFile.toString(), e);
                    }
                }
            }));
        }
        Launcher.runMain(classPathList, newArgList);
    }

    private Set<Patch> parseClusterPatches(LinkedList<String> argList) {
        String patchPatterns;
        LinkedHashSet<Patch> patches = new LinkedHashSet<Patch>();
        patches.add(Patch.parse("../../../$/target/classes"));
        while ((patchPatterns = this.parseArg(argList, "--patches")) != null) {
            String[] patterns;
            for (String pattern : patterns = patchPatterns.split(File.pathSeparator)) {
                patches.add(Patch.parse(pattern));
            }
        }
        return patches;
    }

    private List<String> parseJavaOptions(List<String> defaultOptionList, boolean fail) {
        ArrayList<String> remainingDefaultOptions = new ArrayList<String>();
        for (String option : defaultOptionList) {
            if (option.startsWith("-J")) {
                if (option.startsWith("-J-D")) {
                    String kv = option.substring(4);
                    int i = kv.indexOf("=");
                    if (i <= 0) continue;
                    this.setSystemPropertyIfNotSet(kv.substring(0, i), kv.substring(i + 1));
                    continue;
                }
                String msg = String.format("configured option '%s' will be ignored, because the JVM is already running", option);
                if (fail) {
                    throw new IllegalArgumentException(msg);
                }
                this.warn(msg);
                continue;
            }
            remainingDefaultOptions.add(option);
        }
        return remainingDefaultOptions;
    }

    private void setPatchModules(List<String> clusterList, Set<Patch> patches) {
        String JAR_EXT = ".jar";
        ArrayList<String> moduleNames = new ArrayList<String>();
        for (String clusterDir : clusterList) {
            Path clusterModulesDir = Paths.get(clusterDir, new String[0]).resolve("modules");
            try {
                Files.list(clusterModulesDir).forEach(path -> {
                    String fileName = path.getFileName().toString();
                    if (fileName.endsWith(JAR_EXT)) {
                        String moduleName = fileName.substring(0, fileName.length() - JAR_EXT.length());
                        moduleNames.add(moduleName);
                    }
                });
            }
            catch (IOException e) {
                this.warn("failed to list entries of " + clusterModulesDir);
            }
        }
        for (Patch patch : patches) {
            this.patchCount = 0;
            Path parentSourceDir = patch.dir;
            if (Files.isDirectory(parentSourceDir, new LinkOption[0])) {
                try {
                    List moduleSourceDirs = Files.list(parentSourceDir).filter(moduleSourceDir -> Files.isDirectory(moduleSourceDir, new LinkOption[0])).collect(Collectors.toList());
                    for (Path moduleSourceDir2 : moduleSourceDirs) {
                        this.addPatchForModuleSourceDir(moduleSourceDir2, moduleNames, patch);
                    }
                }
                catch (IOException e) {
                    this.warn("failed to list entries of " + parentSourceDir);
                }
                if (this.patchCount == 0 && parentSourceDir.getFileName() != null) {
                    this.addPatchForModuleSourceDir(parentSourceDir, moduleNames, patch);
                }
            }
            if (this.patchCount == 0) {
                this.warn("no module patches found for pattern " + patch);
                continue;
            }
            this.info(this.patchCount + " module patch(es) found for pattern " + patch);
        }
    }

    private boolean addPatchForModuleSourceDir(Path moduleSourceDir, List<String> moduleNames, Patch patch) {
        Path modulePatchDir;
        String moduleSourceName = moduleSourceDir.getFileName().toString();
        if (!moduleSourceName.startsWith(".") && Files.isDirectory(modulePatchDir = moduleSourceDir.resolve(patch.subPath), new LinkOption[0])) {
            for (String moduleName : moduleNames) {
                if (!moduleName.endsWith(moduleSourceName)) continue;
                this.addPatch(moduleName, modulePatchDir);
                return true;
            }
            for (String moduleName : moduleNames) {
                if (!moduleName.contains(moduleSourceName)) continue;
                this.addPatch(moduleName, modulePatchDir);
                return true;
            }
        }
        return false;
    }

    private void addPatch(String moduleName, Path classesDir) {
        String propertyName = "netbeans.patches." + moduleName.replace("-", ".");
        this.setSystemPropertyIfNotSet(propertyName, classesDir.toString());
        ++this.patchCount;
    }

    private List<String> parseOptions(String defaultOptions) {
        boolean firstArgQuoted;
        LinkedList<String> defaultOptionList = new LinkedList<String>();
        StreamTokenizer st = new StreamTokenizer(new StringReader(defaultOptions));
        st.resetSyntax();
        st.wordChars(33, 255);
        st.whitespaceChars(0, 32);
        st.quoteChar(34);
        st.quoteChar(39);
        try {
            int tt = st.nextToken();
            boolean bl = firstArgQuoted = tt == 39 || tt == 34;
            if (tt != -1) {
                do {
                    if (st.sval == null) continue;
                    defaultOptionList.add(st.sval);
                } while ((tt = st.nextToken()) != -1);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (defaultOptionList.size() == 1 && firstArgQuoted) {
            return this.parseOptions(defaultOptionList.get(0));
        }
        return defaultOptionList;
    }

    private static void runMain(List<URL> classPathList, List<String> argList) {
        URLClassLoader classLoader = new URLClassLoader(classPathList.toArray(new URL[classPathList.size()]));
        try {
            Class<?> nbMainClass = classLoader.loadClass("org.netbeans.Main");
            Method nbMainMethod = nbMainClass.getDeclaredMethod("main", String[].class);
            nbMainMethod.invoke(null, new Object[]{argList.toArray(new String[argList.size()])});
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private void buildClasspath(String base, List<URL> classPathList) {
        this.appendToClasspath(Launcher.path(base, "lib", "patches"), classPathList);
        this.appendToClasspath(Launcher.path(base, "lib"), classPathList);
        this.appendToClasspath(Launcher.path(base, "locale", "locale"), classPathList);
    }

    private void appendToClasspath(String path, List<URL> classPathList) {
        try {
            Files.list(Paths.get(path, new String[0])).forEach(file -> {
                String s;
                if (Files.isDirectory(file, new LinkOption[0])) {
                    this.appendToClasspath(file.toString(), classPathList);
                } else if (Files.isRegularFile(file, new LinkOption[0]) && ((s = file.getFileName().toString().toLowerCase()).endsWith(".jar") || s.endsWith(".zip"))) {
                    try {
                        URL url = file.toUri().toURL();
                        classPathList.add(url);
                        this.info("added to application classpath: " + file);
                    }
                    catch (MalformedURLException e) {
                        throw new IllegalStateException(e);
                    }
                }
            });
        }
        catch (IOException e) {
            this.warn("failed to list entries of " + path);
        }
    }

    private void setConfigurationVariableIfNotSet(String varName, String varValue) {
        if (!this.configuration.containsKey(varName)) {
            this.configuration.put(varName, varValue);
        }
    }

    private void setSystemPropertyIfNotSet(String name, String value) {
        String oldValue = System.getProperty(name);
        if (oldValue == null) {
            this.info("setting system property: " + name + " = " + value);
            System.setProperty(name, value);
        } else {
            this.warn("not overriding existing system property: " + name + " = " + oldValue + "(new value: " + value + ")");
        }
    }

    private static String toPathsString(List<String> paths) {
        StringBuilder sb = new StringBuilder();
        for (String path : paths) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(path);
        }
        return sb.toString();
    }

    private static List<String> toAbsolutePaths(List<String> paths) {
        return paths.stream().map(path -> Paths.get(path, new String[0]).toAbsolutePath().toString()).collect(Collectors.toList());
    }

    private static List<String> readLines(Path path) {
        try {
            return Files.readAllLines(path);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    private String parseArg(List<String> argList, String name) {
        String value = null;
        int i = argList.indexOf(name);
        if (i >= 0 && i + 1 < argList.size()) {
            value = argList.get(i + 1);
            argList.remove(i);
            argList.remove(i);
        }
        return value;
    }

    private String getVar(String name) {
        String value = this.configuration.get(name);
        if (value != null) {
            return Launcher.resolveString(value, this.configuration);
        }
        return null;
    }

    private void loadConf(Path path) {
        this.info("reading configuration from " + path);
        try {
            Properties properties = new Properties();
            try (BufferedReader reader = Files.newBufferedReader(path);){
                properties.load(reader);
            }
            Set<String> propertyNames = properties.stringPropertyNames();
            for (String propertyName : propertyNames) {
                String propertyValue = properties.getProperty(propertyName);
                if (propertyValue.startsWith("\"") && propertyValue.endsWith("\"")) {
                    propertyValue = propertyValue.substring(1, propertyValue.length() - 1);
                }
                this.configuration.put(propertyName, propertyValue);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void info(String msg) {
        System.out.printf("INFO: %s: %s%n", this.getClass(), msg);
    }

    private void warn(String msg) {
        System.err.printf("WARNING: %s: %s%n", this.getClass(), msg);
    }

    private static String resolveString(String text, Map<String, String> variables) {
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            text = text.replace("$" + entry.getKey(), entry.getValue());
            text = text.replace("${" + entry.getKey() + "}", entry.getValue());
        }
        return text;
    }

    private static String path(String first, String ... more) {
        return Paths.get(first, more).toString();
    }

    public static class Patch {
        public static final char WILDCARD_CHAR = '$';
        private final Path dir;
        private final String subPath;

        public static Patch parse(String pattern) {
            int wcPos = pattern.indexOf(36);
            if (wcPos >= 0) {
                String subPath = pattern.substring(wcPos + 1);
                if (subPath.startsWith(File.separator) || subPath.startsWith("/")) {
                    subPath = subPath.substring(1);
                }
                if (subPath.indexOf(36) > 0) {
                    throw new IllegalArgumentException(String.format("patch pattern must contain a single wildcard '%s': %s", Character.valueOf('$'), pattern));
                }
                return new Patch(Paths.get(pattern.substring(0, wcPos), new String[0]).toAbsolutePath().normalize(), subPath);
            }
            throw new IllegalArgumentException(String.format("patch pattern must contain wildcard '%s': %s", Character.valueOf('$'), pattern));
        }

        private Patch(Path dir, String subPath) {
            this.dir = dir;
            this.subPath = subPath;
        }

        public Path getDir() {
            return this.dir;
        }

        public String getSubPath() {
            return this.subPath;
        }

        public String toString() {
            if (this.subPath.isEmpty()) {
                return this.dir + File.separator + "$";
            }
            return this.dir + File.separator + "$" + File.separator + this.subPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Patch patch = (Patch)o;
            return this.dir.equals(patch.dir) && this.subPath.equals(patch.subPath);
        }

        public int hashCode() {
            int result = this.dir.hashCode();
            result = 31 * result + this.subPath.hashCode();
            return result;
        }
    }
}

