/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.resource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class Resource {
    private final String path;
    private boolean isXml;
    private String content;
    private SortedMap<String, String> map;
    private final Resource origin;

    public Resource(String path, Resource origin) {
        this.path = path;
        this.origin = origin;
    }

    private void init() {
        this.content = this.read();
        if (Resource.isXml(this.content)) {
            this.map = new TreeMap<String, String>();
            this.isXml = true;
        } else {
            this.map = Resource.readProperties(this.content);
            this.isXml = false;
        }
    }

    protected abstract String read();

    public String getPath() {
        return this.path;
    }

    public Resource getOrigin() {
        return this.origin;
    }

    public boolean isXml() {
        if (this.content == null) {
            this.init();
        }
        return this.isXml;
    }

    public String getContent() {
        if (this.content == null) {
            this.init();
        }
        return this.content;
    }

    public SortedMap<String, String> getMap() {
        if (this.content == null) {
            this.init();
        }
        return this.map;
    }

    public String toString() {
        return this.getContent();
    }

    static SortedMap<String, String> readProperties(String text) {
        try {
            Properties properties = new Properties();
            properties.load(new StringReader(text));
            TreeMap<String, String> map = new TreeMap<String, String>();
            for (String name : properties.stringPropertyNames()) {
                map.put(name, properties.getProperty(name));
            }
            return map;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    static boolean isXml(String textContent) {
        String t = textContent.trim();
        return t.startsWith("<?xml ") || t.startsWith("<?XML ") || t.startsWith("<") && t.endsWith(">");
    }

    public static String readText(Reader reader) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(reader);
        StringBuilder text = new StringBuilder();
        while ((line = br.readLine()) != null) {
            text.append(line);
            text.append("\n");
        }
        return text.toString().trim();
    }
}

