/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.metadata;

import com.bc.ceres.resource.ReaderResource;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public class XPathHandler {
    public String run(String xpath, Object document) {
        try {
            Document doc = XPathHandler.transformToDocument(document);
            return XPathFactory.newInstance().newXPath().evaluate(xpath, doc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String extractXml(String xpath, Object document) throws XPathExpressionException {
        try {
            Document doc = XPathHandler.transformToDocument(document);
            Node node = (Node)XPathFactory.newInstance().newXPath().evaluate(xpath, doc, XPathConstants.NODE);
            Document newXmlDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Node copyNode = newXmlDocument.importNode(node, true);
            newXmlDocument.appendChild(copyNode);
            return XPathHandler.printXmlDocument(newXmlDocument);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Document transformToDocument(Object document) {
        try {
            String docString;
            if (document instanceof ReaderResource) {
                docString = ((ReaderResource)document).getContent();
            } else if (document instanceof String) {
                docString = (String)document;
            } else if (document instanceof Element) {
                DOMSource domSource = new DOMSource((Element)document);
                StringWriter writer = new StringWriter();
                StreamResult result = new StreamResult(writer);
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                Properties properties = new Properties();
                properties.setProperty("method", "xml");
                properties.setProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperties(properties);
                transformer.transform(domSource, result);
                docString = writer.toString();
            } else {
                return null;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(docString.getBytes());
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String printXmlDocument(Document document) {
        DOMImplementationLS domImplementationLS = (DOMImplementationLS)((Object)document.getImplementation());
        LSSerializer lsSerializer = domImplementationLS.createLSSerializer();
        String string = lsSerializer.writeToString(document);
        String textDoc = string.replaceFirst("<\\?xml.*\\?>", "");
        return textDoc.trim();
    }
}

