/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.metadata;

import com.bc.ceres.core.Assert;
import com.bc.ceres.metadata.MetadataResourceResolver;
import com.bc.ceres.metadata.SimpleFileSystem;
import com.bc.ceres.resource.ReaderResource;
import com.bc.ceres.resource.Resource;
import com.bc.ceres.resource.ResourceEngine;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import org.apache.velocity.VelocityContext;

public class MetadataResourceEngine {
    private final ResourceEngine resourceEngine;
    private final MetadataResourceResolver metadataResourceResolver;
    private final SimpleFileSystem simpleFileSystem;

    public MetadataResourceEngine(SimpleFileSystem simpleFileSystem) {
        this(simpleFileSystem, new MetadataResourceResolver(simpleFileSystem));
    }

    public MetadataResourceEngine(SimpleFileSystem simpleFileSystem, MetadataResourceResolver metadataResourceResolver) {
        Assert.notNull((Object)simpleFileSystem, (String)"simpleFileSystem");
        Assert.notNull((Object)metadataResourceResolver, (String)"metadataResourceResolver");
        this.resourceEngine = new ResourceEngine();
        this.simpleFileSystem = simpleFileSystem;
        this.metadataResourceResolver = metadataResourceResolver;
    }

    public VelocityContext getVelocityContext() {
        return this.resourceEngine.getVelocityContext();
    }

    public Resource readResource(String name, String path) throws IOException {
        Reader reader = this.simpleFileSystem.createReader(path);
        return this.resourceEngine.processAndAddResource(name, new ReaderResource(path, reader));
    }

    public void readRelatedResource(String sourceId, String sourcePath) throws IOException {
        SortedMap<String, String> sourceNames = this.metadataResourceResolver.getSourceMetadataPaths(sourcePath);
        HashMap<String, Resource> resourceMap = new HashMap<String, Resource>();
        for (Map.Entry<String, String> sourceEntries : sourceNames.entrySet()) {
            String metadataBaseName = sourceEntries.getKey();
            String path = sourceEntries.getValue();
            Reader reader = this.simpleFileSystem.createReader(path);
            ReaderResource resource = new ReaderResource(path, reader);
            Resource processedResource = this.resourceEngine.processResource(resource);
            resourceMap.put(metadataBaseName.replace(".", "_"), processedResource);
        }
        this.getVelocityMapSafe("sourceMetadata").put(sourceId, resourceMap);
    }

    private Map<String, Map> getVelocityMapSafe(String name) {
        HashMap<String, Map> map;
        Object mapObject = this.resourceEngine.getVelocityContext().get(name);
        if (mapObject instanceof Map) {
            map = (HashMap<String, Map>)mapObject;
        } else {
            map = new HashMap<String, Map>();
            this.resourceEngine.getVelocityContext().put(name, map);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRelatedResource(String templatePath, String targetPath) throws IOException {
        MetadataResourceResolver.TargetResourceInfo targetResourceInfo = this.metadataResourceResolver.getTargetName(templatePath, targetPath);
        VelocityContext velocityContext = this.resourceEngine.getVelocityContext();
        velocityContext.put("templateName", (Object)targetResourceInfo.templateName);
        velocityContext.put("templateBaseName", (Object)targetResourceInfo.templateBaseName);
        Reader templateReader = this.simpleFileSystem.createReader(templatePath);
        Resource processedResource = this.resourceEngine.processResource(new ReaderResource(templatePath, templateReader));
        Writer writer = this.simpleFileSystem.createWriter(targetResourceInfo.targetName);
        try {
            writer.write(processedResource.getContent());
        }
        finally {
            templateReader.close();
            writer.close();
        }
    }
}

