/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.vfs.ui.file.chooser;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.lang3.SystemUtils;
import org.esa.snap.vfs.NioFile;
import org.esa.snap.vfs.NioPaths;
import org.esa.snap.vfs.preferences.model.VFSRemoteFileRepository;
import org.esa.snap.vfs.remote.AbstractRemoteFileSystem;
import org.esa.snap.vfs.ui.file.chooser.VirtualFileSystemHelper;

public class VirtualFileSystemView
extends FileSystemView {
    private static final String NEW_FOLDER_STRING = "New_Folder";
    private static final String NEW_FOLDER_NEXT_STRING = "New_Folder_({0})";
    private static final ImageIcon vfsRootIcon;
    private static final ImageIcon vfsDirectoryIcon;
    private static final ImageIcon vfsFileIcon;
    private static final Logger logger;
    private final FileSystemView defaultFileSystemView;
    private final Map<String, VirtualFileSystemHelper> vfsFileSystemViews;

    protected VirtualFileSystemView(FileSystemView defaultFileSystemView, List<VFSRemoteFileRepository> vfsRepositories) {
        this.defaultFileSystemView = defaultFileSystemView;
        this.vfsFileSystemViews = new HashMap<String, VirtualFileSystemHelper>();
        for (VFSRemoteFileRepository vfsRemoteFileRepository : vfsRepositories) {
            try {
                VirtualFileSystemHelper vfsFileSystemView = new VirtualFileSystemHelper(vfsRemoteFileRepository);
                String key = vfsFileSystemView.getRoot().toString();
                this.vfsFileSystemViews.put(key, vfsFileSystemView);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Unable to initialize " + vfsRemoteFileRepository.getName() + " VFS. Details: " + ex.getMessage(), ex);
            }
        }
    }

    private static boolean isVirtualRoot(Path path) {
        FileSystem fileSystem = path.getFileSystem();
        if (fileSystem instanceof AbstractRemoteFileSystem) {
            AbstractRemoteFileSystem remoteFileSystem = (AbstractRemoteFileSystem)fileSystem;
            return remoteFileSystem.getRoot().equals((Object)path);
        }
        return false;
    }

    private static ImageIcon loadImageIcon(String imagePath) {
        URL imageURL = VirtualFileSystemView.class.getResource(imagePath);
        return imageURL == null ? null : new ImageIcon(imageURL);
    }

    protected void notifyUser(String title, String message) {
        logger.log(Level.FINE, () -> title + ": " + message);
    }

    private void notifyVFSError(Exception e) {
        Throwable error = e;
        while (error.getCause() != null) {
            error = e.getCause();
        }
        if (error instanceof ConnectException || error instanceof UnknownHostException) {
            this.notifyUser("VFS connection failure", "Unable to contact the VFS service.\nPlease check the connection or the Remote File Repository Address.");
        } else if (error instanceof IOException) {
            String report = error.getMessage().replaceAll("(.*)response code (.*)", "$2");
            this.notifyUser("VFS access failure", "The VFS service reported \"" + report + "\" error.\nPlease check the Remote File Repository Configurations.");
        } else {
            this.notifyUser("VFS error", error.getMessage());
        }
    }

    @Override
    public File getChild(File parent, String fileName) {
        if (this.isVirtualFileItem(parent)) {
            File[] children;
            Path path = parent.toPath();
            for (File child : children = this.getVirtualFiles(path, false)) {
                if (!child.getName().equals(fileName)) continue;
                return child;
            }
            return new NioFile(path.resolve(fileName).normalize());
        }
        return this.defaultFileSystemView.getChild(parent, fileName);
    }

    @Override
    public boolean isFileSystem(File file) {
        if (this.isVirtualFileItem(file)) {
            return this.isFileSystem(file.toPath());
        }
        return this.defaultFileSystemView.isFileSystem(file);
    }

    @Override
    public File createNewFolder(File containingDir) throws IOException {
        if (this.isVirtualFileItem(containingDir)) {
            File newFolder = this.createFileObject(containingDir, NEW_FOLDER_STRING);
            int i = 1;
            while (Files.exists(newFolder.toPath(), new LinkOption[0])) {
                newFolder = this.createFileObject(containingDir, MessageFormat.format(NEW_FOLDER_NEXT_STRING, i++));
            }
            Files.createDirectory(newFolder.toPath(), new FileAttribute[0]);
            return newFolder;
        }
        return this.defaultFileSystemView.createNewFolder(containingDir);
    }

    @Override
    public boolean isRoot(File file) {
        if (this.isVirtualFileItem(file)) {
            return VirtualFileSystemView.isVirtualRoot(file.toPath());
        }
        return this.defaultFileSystemView.isRoot(file);
    }

    private File[] getOSRoots() {
        File[] osRoots = this.defaultFileSystemView.getRoots();
        if (SystemUtils.IS_OS_WINDOWS) {
            try {
                Class<?> nativeOsFileClass = Class.forName("sun.awt.shell.ShellFolder");
                osRoots = (File[])nativeOsFileClass.getMethod("get", String.class).invoke(null, "fileChooserComboBoxFolders");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return osRoots;
    }

    @Override
    public File[] getRoots() {
        File[] defaultRoots = this.getOSRoots();
        Collection<VirtualFileSystemHelper> virtualFileSystemViews = this.vfsFileSystemViews.values();
        File[] roots = new File[defaultRoots.length + virtualFileSystemViews.size()];
        System.arraycopy(defaultRoots, 0, roots, 0, defaultRoots.length);
        Iterator<VirtualFileSystemHelper> it = virtualFileSystemViews.iterator();
        int index = defaultRoots.length;
        while (it.hasNext()) {
            VirtualFileSystemHelper value = it.next();
            Path rootPath = value.getRoot();
            roots[index++] = new NioFile(rootPath);
        }
        return roots;
    }

    @Override
    public File[] getFiles(File dir, boolean useFileHiding) {
        if (this.isVirtualFileItem(dir)) {
            return this.getVirtualFiles(dir.toPath(), useFileHiding);
        }
        File[] localFiles = this.defaultFileSystemView.getFiles(dir, useFileHiding);
        return this.fixPaths(localFiles, useFileHiding);
    }

    @Override
    public File getParentDirectory(File dir) {
        if (dir == null) {
            return null;
        }
        if (this.isVirtualFileItem(dir)) {
            File ppsf;
            if (!Files.exists(dir.toPath(), new LinkOption[0])) {
                return null;
            }
            Path parentPath = dir.toPath().getParent();
            if (parentPath == null) {
                return null;
            }
            if (!this.isFileSystem(parentPath)) {
                return parentPath.toFile();
            }
            Path p = parentPath;
            if (!Files.exists(p, new LinkOption[0]) && !this.isFileSystem(ppsf = parentPath.getParent().toFile())) {
                p = this.createFileSystemRoot(p.toFile()).toPath();
            }
            return p.toFile();
        }
        return this.defaultFileSystemView.getParentDirectory(dir);
    }

    @Override
    public File getHomeDirectory() {
        return this.defaultFileSystemView.getHomeDirectory();
    }

    @Override
    public File getDefaultDirectory() {
        return this.defaultFileSystemView.getDefaultDirectory();
    }

    @Override
    public boolean isHiddenFile(File file) {
        return this.defaultFileSystemView.isHiddenFile(file);
    }

    @Override
    public boolean isFileSystemRoot(File dir) {
        if (this.isVirtualFileItem(dir)) {
            return VirtualFileSystemView.isVirtualRoot(dir.toPath());
        }
        return this.defaultFileSystemView.isFileSystemRoot(dir);
    }

    @Override
    public boolean isDrive(File dir) {
        if (this.isVirtualFileItem(dir)) {
            return false;
        }
        return this.defaultFileSystemView.isDrive(dir);
    }

    @Override
    public boolean isFloppyDrive(File dir) {
        if (this.isVirtualFileItem(dir)) {
            return false;
        }
        return this.defaultFileSystemView.isFloppyDrive(dir);
    }

    @Override
    public boolean isComputerNode(File dir) {
        if (this.isVirtualFileItem(dir)) {
            return false;
        }
        return this.defaultFileSystemView.isComputerNode(dir);
    }

    @Override
    public File createFileObject(String path) {
        Path filePath = NioPaths.get((String)path, (String[])new String[0]);
        return filePath.toFile();
    }

    @Override
    public File createFileObject(File dir, String filename) {
        Path filePath = dir.toPath().resolve(filename);
        return filePath.toFile();
    }

    @Override
    protected File createFileSystemRoot(File file) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Icon getSystemIcon(File file) {
        if (this.isVirtualFileItem(file)) {
            AbstractRemoteFileSystem remoteFileSystem = (AbstractRemoteFileSystem)file.toPath().getFileSystem();
            if (remoteFileSystem.getRoot().equals((Object)file.toPath())) {
                return vfsRootIcon;
            }
            if (Files.isDirectory(file.toPath(), new LinkOption[0])) {
                return vfsDirectoryIcon;
            }
            return vfsFileIcon;
        }
        return this.defaultFileSystemView.getSystemIcon(file);
    }

    @Override
    public String getSystemDisplayName(File file) {
        if (this.isVirtualFileItem(file)) {
            return file.toPath().getFileName().toString();
        }
        return this.defaultFileSystemView.getSystemDisplayName(file);
    }

    @Override
    public String getSystemTypeDescription(File file) {
        if (this.isVirtualFileItem(file)) {
            return null;
        }
        return this.defaultFileSystemView.getSystemTypeDescription(file);
    }

    @Override
    public Boolean isTraversable(File file) {
        if (this.isVirtualFileItem(file)) {
            return this.isFileSystemRoot(file) || this.isComputerNode(file) || file.isDirectory();
        }
        return this.defaultFileSystemView.isTraversable(file);
    }

    private File[] fixPaths(File[] filesPaths, boolean useFileHiding) {
        ArrayList<File> files = new ArrayList<File>();
        for (File filePath : filesPaths) {
            if (useFileHiding && this.isHiddenFile(filePath)) continue;
            String windowsShareStartPath = "\\\\";
            if (filePath.getPath().startsWith(windowsShareStartPath)) {
                String[] fParts = filePath.getPath().split(windowsShareStartPath);
                if (fParts.length == 4) {
                    String host = fParts[2];
                    String share = fParts[3];
                    filePath = NioPaths.get((String)(windowsShareStartPath + host + "\\" + share), (String[])new String[0]).toFile();
                }
            } else {
                filePath = new File(filePath.getPath());
            }
            if (!filePath.exists()) continue;
            files.add(filePath);
        }
        return files.toArray(new File[0]);
    }

    private boolean isVirtualFileItem(File file) {
        String scheme = file.toURI().getScheme();
        for (VirtualFileSystemHelper vfsFileSystemView : this.vfsFileSystemViews.values()) {
            URI uriRoot = vfsFileSystemView.getRoot().toUri();
            if (!uriRoot.getScheme().equals(scheme)) continue;
            return true;
        }
        return false;
    }

    private boolean isFileSystem(Path path) {
        return !Files.isSymbolicLink(path) || !Files.isDirectory(path, new LinkOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File[] getVirtualFiles(Path dirPath, boolean useFileHiding) {
        String pathName = dirPath.toString();
        DirectoryStream<Path> stream = null;
        try {
            VirtualFileSystemHelper vfsFileSystemView = this.vfsFileSystemViews.get(pathName);
            if (vfsFileSystemView != null) {
                File[] fileArray = vfsFileSystemView.getRootDirectories();
                return fileArray;
            }
            ArrayList<File> files = new ArrayList<File>();
            if (!VirtualFileSystemView.isVirtualRoot(dirPath) && Files.isDirectory(dirPath, new LinkOption[0])) {
                DirectoryStream.Filter<Path> filter = entry -> !useFileHiding || !Files.isHidden(entry);
                stream = Files.newDirectoryStream(dirPath, filter);
                for (Path path : stream) {
                    files.add(path.toFile());
                }
                File[] fileArray = files.toArray(new File[0]);
                return fileArray;
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Unable to get files. Details: " + ex.getMessage(), ex);
            this.notifyVFSError(ex);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "Unable to close the stream. Details: " + ex.getMessage(), ex);
                }
            }
        }
        return new File[0];
    }

    static {
        logger = Logger.getLogger(VirtualFileSystemView.class.getName());
        vfsRootIcon = VirtualFileSystemView.loadImageIcon("icons/vfs_root-23x16.png");
        vfsDirectoryIcon = VirtualFileSystemView.loadImageIcon("icons/vfs_folder-23x16.png");
        vfsFileIcon = VirtualFileSystemView.loadImageIcon("icons/vfs_file-23x16.png");
    }
}

