/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.vfs.ui.file.chooser;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.esa.snap.vfs.NioFile;
import org.esa.snap.vfs.VFS;
import org.esa.snap.vfs.preferences.model.VFSRemoteFileRepository;
import org.esa.snap.vfs.remote.AbstractRemoteFileSystem;
import org.esa.snap.vfs.remote.AbstractRemoteFileSystemProvider;

public class VirtualFileSystemHelper {
    private final AbstractRemoteFileSystem fileSystem;

    public VirtualFileSystemHelper(VFSRemoteFileRepository vfsRemoteFileRepository) throws URISyntaxException {
        AbstractRemoteFileSystemProvider fileSystemProvider = (AbstractRemoteFileSystemProvider)VFS.getInstance().getFileSystemProviderByScheme(vfsRemoteFileRepository.getScheme());
        URI uri = new URI(vfsRemoteFileRepository.getScheme(), vfsRemoteFileRepository.getRoot(), null);
        Map env = Collections.emptyMap();
        this.fileSystem = fileSystemProvider.getFileSystemOrCreate(uri, env);
    }

    public Path getRoot() {
        return this.fileSystem.getRoot();
    }

    public File[] getRootDirectories() {
        ArrayList<VFSFileSystemRoot> roots = new ArrayList<VFSFileSystemRoot>();
        for (Path p : this.fileSystem.getRootDirectories()) {
            roots.add(new VFSFileSystemRoot(p));
        }
        return roots.toArray(new File[0]);
    }

    private static class VFSFileSystemRoot
    extends NioFile {
        private VFSFileSystemRoot(Path p) {
            super(p);
        }

        public boolean isDirectory() {
            return true;
        }

        public boolean isAbsolute() {
            return false;
        }

        public boolean exists() {
            return true;
        }

        public String getName() {
            String name = super.getName();
            if (name.isEmpty()) {
                name = super.getPath();
            }
            return name;
        }

        public String getPath() {
            return super.getPath();
        }
    }
}

